/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.RoaringDocIdSet;

public class CachingWrapperQuery
extends Query
implements Accountable {
    private Query query;
    private final QueryCachingPolicy policy;
    private final Map<Object, DocIdSet> cache = Collections.synchronizedMap(new WeakHashMap());
    int hitCount;
    int missCount;

    public CachingWrapperQuery(Query query, QueryCachingPolicy policy) {
        this.query = query;
        this.policy = policy;
    }

    public CachingWrapperQuery(Query query) {
        this(query, QueryCachingPolicy.CacheOnLargeSegments.DEFAULT);
    }

    @Override
    public CachingWrapperQuery clone() {
        CachingWrapperQuery clone = (CachingWrapperQuery)super.clone();
        clone.query = this.query.clone();
        return clone;
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public float getBoost() {
        return this.query.getBoost();
    }

    @Override
    public void setBoost(float b) {
        this.query.setBoost(b);
    }

    protected DocIdSet cacheImpl(DocIdSetIterator iterator, LeafReader reader) throws IOException {
        return new RoaringDocIdSet.Builder(reader.maxDoc()).add(iterator).build();
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.query.rewrite(reader);
        if (this.query == rewritten) {
            return this;
        }
        CachingWrapperQuery clone = this.clone();
        clone.query = rewritten;
        return clone;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        final Weight weight = this.query.createWeight(searcher, needsScores);
        if (needsScores) {
            return weight;
        }
        this.policy.onUse(weight.getQuery());
        return new ConstantScoreWeight(weight.getQuery()){

            @Override
            Scorer scorer(LeafReaderContext context, final Bits acceptDocs, float score) throws IOException {
                DocIdSetIterator disi;
                TwoPhaseIterator twoPhaseView;
                LeafReader reader = context.reader();
                Object key = reader.getCoreCacheKey();
                DocIdSet docIdSet = (DocIdSet)CachingWrapperQuery.this.cache.get(key);
                if (docIdSet != null) {
                    ++CachingWrapperQuery.this.hitCount;
                } else if (CachingWrapperQuery.this.policy.shouldCache(CachingWrapperQuery.this.query, context)) {
                    ++CachingWrapperQuery.this.missCount;
                    Scorer scorer = weight.scorer(context, null);
                    docIdSet = scorer == null ? DocIdSet.EMPTY : CachingWrapperQuery.this.cacheImpl(scorer, context.reader());
                    CachingWrapperQuery.this.cache.put(key, docIdSet);
                } else {
                    return weight.scorer(context, acceptDocs);
                }
                assert (docIdSet != null);
                if (docIdSet == DocIdSet.EMPTY) {
                    return null;
                }
                DocIdSetIterator approximation = docIdSet.iterator();
                if (approximation == null) {
                    return null;
                }
                if (acceptDocs == null) {
                    twoPhaseView = null;
                    disi = approximation;
                } else {
                    twoPhaseView = new TwoPhaseIterator(approximation){

                        @Override
                        public boolean matches() throws IOException {
                            int doc = this.approximation.docID();
                            return acceptDocs.get(doc);
                        }
                    };
                    disi = TwoPhaseIterator.asDocIdSetIterator(twoPhaseView);
                }
                return new Scorer(weight){

                    @Override
                    public TwoPhaseIterator asTwoPhaseIterator() {
                        return twoPhaseView;
                    }

                    @Override
                    public float score() throws IOException {
                        return 0.0f;
                    }

                    @Override
                    public int freq() throws IOException {
                        return 1;
                    }

                    @Override
                    public int docID() {
                        return disi.docID();
                    }

                    @Override
                    public int nextDoc() throws IOException {
                        return disi.nextDoc();
                    }

                    @Override
                    public int advance(int target) throws IOException {
                        return disi.advance(target);
                    }

                    @Override
                    public long cost() {
                        return disi.cost();
                    }
                };
            }
        };
    }

    @Override
    public String toString(String field) {
        return this.getClass().getSimpleName() + "(" + this.query.toString(field) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CachingWrapperQuery other = (CachingWrapperQuery)o;
        return this.query.equals(other.query);
    }

    @Override
    public int hashCode() {
        return this.query.hashCode() ^ this.getClass().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long ramBytesUsed() {
        ArrayList<DocIdSet> docIdSets;
        Map<Object, DocIdSet> map = this.cache;
        synchronized (map) {
            docIdSets = new ArrayList<DocIdSet>(this.cache.values());
        }
        long total = 0L;
        for (DocIdSet dis : docIdSets) {
            total += dis.ramBytesUsed();
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Accountable> getChildResources() {
        Map<Object, DocIdSet> map = this.cache;
        synchronized (map) {
            return Accountables.namedAccountables("segment", this.cache);
        }
    }
}

