/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.index.FieldTermIterator;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RAMFile;
import org.apache.lucene.store.RAMInputStream;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;

class PrefixCodedTerms
implements Accountable {
    final RAMFile buffer;
    private long delGen;

    private PrefixCodedTerms(RAMFile buffer) {
        this.buffer = buffer;
    }

    @Override
    public long ramBytesUsed() {
        return this.buffer.ramBytesUsed();
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    public void setDelGen(long delGen) {
        this.delGen = delGen;
    }

    public TermIterator iterator() {
        return new TermIterator(this.delGen, this.buffer);
    }

    public static class TermIterator
    implements FieldTermIterator {
        final IndexInput input;
        final BytesRefBuilder builder = new BytesRefBuilder();
        final BytesRef bytes = this.builder.get();
        final long end;
        final long delGen;
        String field = "";

        public TermIterator(long delGen, RAMFile buffer) {
            try {
                this.input = new RAMInputStream("MergedPrefixCodedTermsIterator", buffer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.end = this.input.length();
            this.delGen = delGen;
        }

        @Override
        public boolean next() {
            if (this.input.getFilePointer() < this.end) {
                try {
                    boolean newField;
                    int code = this.input.readVInt();
                    boolean bl = newField = (code & 1) != 0;
                    if (newField) {
                        this.field = this.input.readString();
                    }
                    int prefix = code >>> 1;
                    int suffix = this.input.readVInt();
                    this.readTermBytes(prefix, suffix);
                    return newField;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.field = null;
            return true;
        }

        private void readTermBytes(int prefix, int suffix) throws IOException {
            this.builder.grow(prefix + suffix);
            this.input.readBytes(this.builder.bytes(), prefix, suffix);
            this.builder.setLength(prefix + suffix);
        }

        @Override
        public BytesRef term() {
            return this.bytes;
        }

        @Override
        public String field() {
            return this.field;
        }

        @Override
        public long delGen() {
            return this.delGen;
        }
    }

    public static class Builder {
        private RAMFile buffer = new RAMFile();
        private RAMOutputStream output = new RAMOutputStream(this.buffer, false);
        private Term lastTerm = new Term("");
        private BytesRefBuilder lastTermBytes = new BytesRefBuilder();

        public void add(Term term) {
            assert (this.lastTerm.equals(new Term("")) || term.compareTo(this.lastTerm) > 0);
            try {
                int prefix = this.sharedPrefix(this.lastTerm.bytes, term.bytes);
                int suffix = term.bytes.length - prefix;
                if (term.field.equals(this.lastTerm.field)) {
                    this.output.writeVInt(prefix << 1);
                } else {
                    this.output.writeVInt(prefix << 1 | 1);
                    this.output.writeString(term.field);
                }
                this.output.writeVInt(suffix);
                this.output.writeBytes(term.bytes.bytes, term.bytes.offset + prefix, suffix);
                this.lastTermBytes.copyBytes(term.bytes);
                this.lastTerm.bytes = this.lastTermBytes.get();
                this.lastTerm.field = term.field;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public PrefixCodedTerms finish() {
            try {
                this.output.close();
                return new PrefixCodedTerms(this.buffer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private int sharedPrefix(BytesRef term1, BytesRef term2) {
            int pos1 = 0;
            int pos1End = pos1 + Math.min(term1.length, term2.length);
            int pos2 = 0;
            while (pos1 < pos1End) {
                if (term1.bytes[term1.offset + pos1] != term2.bytes[term2.offset + pos2]) {
                    return pos1;
                }
                ++pos1;
                ++pos2;
            }
            return pos1;
        }
    }
}

