/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.List;
import org.apache.lucene.index.FieldTermIterator;
import org.apache.lucene.index.PrefixCodedTerms;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;

class MergedPrefixCodedTermsIterator
implements FieldTermIterator {
    final TermMergeQueue termQueue;
    final FieldMergeQueue fieldQueue;
    String field;

    public MergedPrefixCodedTermsIterator(List<PrefixCodedTerms> termsList) {
        this.fieldQueue = new FieldMergeQueue(termsList.size());
        for (PrefixCodedTerms terms : termsList) {
            PrefixCodedTerms.TermIterator iter = terms.iterator();
            iter.next();
            if (iter.field == null) continue;
            this.fieldQueue.add(iter);
        }
        this.termQueue = new TermMergeQueue(termsList.size());
    }

    @Override
    public boolean next() {
        if (this.termQueue.size() == 0) {
            if (this.fieldQueue.size() == 0) {
                this.field = null;
                return true;
            }
            PrefixCodedTerms.TermIterator top = (PrefixCodedTerms.TermIterator)this.fieldQueue.pop();
            this.termQueue.add(top);
            assert (top.field() != null);
            while (this.fieldQueue.size() != 0 && ((PrefixCodedTerms.TermIterator)this.fieldQueue.top()).field.equals(top.field)) {
                this.termQueue.add(this.fieldQueue.pop());
            }
            this.field = top.field;
            return true;
        }
        PrefixCodedTerms.TermIterator top = (PrefixCodedTerms.TermIterator)this.termQueue.top();
        if (top.next()) {
            this.termQueue.pop();
            if (top.field() != null) {
                this.fieldQueue.add(top);
            }
        } else {
            this.termQueue.updateTop();
        }
        if (this.termQueue.size() != 0) {
            return false;
        }
        return this.next();
    }

    @Override
    public BytesRef term() {
        return ((PrefixCodedTerms.TermIterator)this.termQueue.top()).bytes;
    }

    @Override
    public String field() {
        return this.field;
    }

    @Override
    public long delGen() {
        return ((PrefixCodedTerms.TermIterator)this.termQueue.top()).delGen();
    }

    private static class FieldMergeQueue
    extends PriorityQueue<PrefixCodedTerms.TermIterator> {
        FieldMergeQueue(int size) {
            super(size);
        }

        @Override
        protected boolean lessThan(PrefixCodedTerms.TermIterator a, PrefixCodedTerms.TermIterator b) {
            return a.field.compareTo(b.field) < 0;
        }
    }

    private static class TermMergeQueue
    extends PriorityQueue<PrefixCodedTerms.TermIterator> {
        TermMergeQueue(int size) {
            super(size);
        }

        @Override
        protected boolean lessThan(PrefixCodedTerms.TermIterator a, PrefixCodedTerms.TermIterator b) {
            int cmp = a.bytes.compareTo(b.bytes);
            if (cmp < 0) {
                return true;
            }
            if (cmp > 0) {
                return false;
            }
            return a.delGen() > b.delGen();
        }
    }
}

