/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.MappingMultiPostingsEnum;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.MultiPostingsEnum;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.MultiTermsEnum;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;

public class MappedMultiFields
extends FilterLeafReader.FilterFields {
    final MergeState mergeState;

    public MappedMultiFields(MergeState mergeState, MultiFields multiFields) {
        super(multiFields);
        this.mergeState = mergeState;
    }

    @Override
    public Terms terms(String field) throws IOException {
        MultiTerms terms = (MultiTerms)this.in.terms(field);
        if (terms == null) {
            return null;
        }
        return new MappedMultiTerms(this.mergeState, terms);
    }

    private static class MappedMultiTermsEnum
    extends FilterLeafReader.FilterTermsEnum {
        final MergeState mergeState;

        public MappedMultiTermsEnum(MergeState mergeState, MultiTermsEnum multiTermsEnum) {
            super(multiTermsEnum);
            this.mergeState = mergeState;
        }

        @Override
        public int docFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long totalTermFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public PostingsEnum postings(Bits liveDocs, PostingsEnum reuse, int flags) throws IOException {
            if (liveDocs != null) {
                throw new IllegalArgumentException("liveDocs must be null");
            }
            MappingMultiPostingsEnum mappingDocsAndPositionsEnum = reuse instanceof MappingMultiPostingsEnum ? (MappingMultiPostingsEnum)reuse : new MappingMultiPostingsEnum(this.mergeState);
            MultiPostingsEnum docsAndPositionsEnum = (MultiPostingsEnum)this.in.postings(liveDocs, mappingDocsAndPositionsEnum.multiDocsAndPositionsEnum, flags);
            mappingDocsAndPositionsEnum.reset(docsAndPositionsEnum);
            return mappingDocsAndPositionsEnum;
        }
    }

    private static class MappedMultiTerms
    extends FilterLeafReader.FilterTerms {
        final MergeState mergeState;

        public MappedMultiTerms(MergeState mergeState, MultiTerms multiTerms) {
            super(multiTerms);
            this.mergeState = mergeState;
        }

        @Override
        public TermsEnum iterator(TermsEnum reuse) throws IOException {
            return new MappedMultiTermsEnum(this.mergeState, (MultiTermsEnum)this.in.iterator(reuse));
        }

        @Override
        public long size() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getSumTotalTermFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getSumDocFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getDocCount() throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

