/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.CoalescedUpdates;
import org.apache.lucene.index.DocValuesFieldUpdates;
import org.apache.lucene.index.DocValuesUpdate;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FrozenBufferedUpdates;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.ReadersAndUpdates;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.PriorityQueue;

class BufferedUpdatesStream
implements Accountable {
    private final List<FrozenBufferedUpdates> updates = new ArrayList<FrozenBufferedUpdates>();
    private long nextGen = 1L;
    private BytesRef lastDeleteTerm;
    private final InfoStream infoStream;
    private final AtomicLong bytesUsed = new AtomicLong();
    private final AtomicInteger numTerms = new AtomicInteger();
    private static final Comparator<SegmentCommitInfo> sortSegInfoByDelGen = new Comparator<SegmentCommitInfo>(){

        @Override
        public int compare(SegmentCommitInfo si1, SegmentCommitInfo si2) {
            return Long.compare(si1.getBufferedDeletesGen(), si2.getBufferedDeletesGen());
        }
    };

    public BufferedUpdatesStream(InfoStream infoStream) {
        this.infoStream = infoStream;
    }

    public synchronized long push(FrozenBufferedUpdates packet) {
        packet.setDelGen(this.nextGen++);
        assert (packet.any());
        assert (this.checkDeleteStats());
        assert (packet.delGen() < this.nextGen);
        assert (this.updates.isEmpty() || this.updates.get(this.updates.size() - 1).delGen() < packet.delGen()) : "Delete packets must be in order";
        this.updates.add(packet);
        this.numTerms.addAndGet(packet.numTermDeletes);
        this.bytesUsed.addAndGet(packet.bytesUsed);
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", "push deletes " + packet + " segmentPrivate?=" + packet.isSegmentPrivate + " delGen=" + packet.delGen() + " packetCount=" + this.updates.size() + " totBytesUsed=" + this.bytesUsed.get());
        }
        assert (this.checkDeleteStats());
        return packet.delGen();
    }

    public synchronized void clear() {
        this.updates.clear();
        this.nextGen = 1L;
        this.numTerms.set(0);
        this.bytesUsed.set(0L);
    }

    public boolean any() {
        return this.bytesUsed.get() != 0L;
    }

    public int numTerms() {
        return this.numTerms.get();
    }

    @Override
    public long ramBytesUsed() {
        return this.bytesUsed.get();
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public synchronized ApplyDeletesResult applyDeletesAndUpdates(IndexWriter.ReaderPool pool, List<SegmentCommitInfo> infos) throws IOException {
        block29: {
            block30: {
                t0 = System.currentTimeMillis();
                gen = this.nextGen++;
                if (infos.size() == 0) {
                    return new ApplyDeletesResult(false, gen, null);
                }
                segStates = null;
                totDelCount = 0L;
                totTermVisitedCount = 0L;
                success = false;
                result = null;
                if (this.infoStream.isEnabled("BD")) {
                    this.infoStream.message("BD", String.format(Locale.ROOT, "applyDeletes: open segment readers took %d msec", new Object[]{System.currentTimeMillis() - t0}));
                }
                if (!BufferedUpdatesStream.$assertionsDisabled && !this.checkDeleteStats()) {
                    throw new AssertionError();
                }
                if (this.any()) break block29;
                if (this.infoStream.isEnabled("BD")) {
                    this.infoStream.message("BD", "applyDeletes: no segments; skipping");
                }
                var14_10 = new ApplyDeletesResult(false, gen, null);
                if (segStates == null) break block30;
                result = this.closeSegmentStates(pool, segStates, success, gen);
            }
            return var14_10;
        }
        try {
            if (this.infoStream.isEnabled("BD")) {
                this.infoStream.message("BD", "applyDeletes: infos=" + infos + " packetCount=" + this.updates.size());
            }
            infos = this.sortByDelGen(infos);
            coalescedUpdates = null;
            infosIDX = infos.size() - 1;
            delIDX = this.updates.size() - 1;
            while (infosIDX >= 0) {
                packet = delIDX >= 0 ? this.updates.get(delIDX) : null;
                info = infos.get(infosIDX);
                segGen = info.getBufferedDeletesGen();
                if (packet != null && segGen < packet.delGen()) {
                    if (!packet.isSegmentPrivate && packet.any()) {
                        if (coalescedUpdates == null) {
                            coalescedUpdates = new CoalescedUpdates();
                        }
                        coalescedUpdates.update(packet);
                    }
                    --delIDX;
                    continue;
                }
                if (packet != null && segGen == packet.delGen()) {
                    if (!BufferedUpdatesStream.$assertionsDisabled && !packet.isSegmentPrivate) {
                        throw new AssertionError((Object)("Packet and Segments deletegen can only match on a segment private del packet gen=" + segGen));
                    }
                    if (segStates == null) {
                        segStates = this.openSegmentStates(pool, infos);
                    }
                    segState = segStates[infosIDX];
                    if (!BufferedUpdatesStream.$assertionsDisabled && !pool.infoIsLive(info)) {
                        throw new AssertionError();
                    }
                    delCount = 0;
                    dvUpdates = new DocValuesFieldUpdates.Container();
                    if (coalescedUpdates != null) {
                        delCount = (int)((long)delCount + BufferedUpdatesStream.applyQueryDeletes(coalescedUpdates.queriesIterable(), segState));
                        this.applyDocValuesUpdates(coalescedUpdates.numericDVUpdates, segState, dvUpdates);
                        this.applyDocValuesUpdates(coalescedUpdates.binaryDVUpdates, segState, dvUpdates);
                    }
                    delCount = (int)((long)delCount + BufferedUpdatesStream.applyQueryDeletes(packet.queriesIterable(), segState));
                    this.applyDocValuesUpdates(Arrays.asList(packet.numericDVUpdates), segState, dvUpdates);
                    this.applyDocValuesUpdates(Arrays.asList(packet.binaryDVUpdates), segState, dvUpdates);
                    if (dvUpdates.any()) {
                        segState.rld.writeFieldUpdates(info.info.dir, dvUpdates);
                    }
                    totDelCount += (long)delCount;
                    --delIDX;
                    --infosIDX;
                    continue;
                }
                if (coalescedUpdates != null) {
                    if (segStates == null) {
                        segStates = this.openSegmentStates(pool, infos);
                    }
                    segState = segStates[infosIDX];
                    if (!BufferedUpdatesStream.$assertionsDisabled && !pool.infoIsLive(info)) {
                        throw new AssertionError();
                    }
                    delCount = 0;
                    delCount = (int)((long)delCount + BufferedUpdatesStream.applyQueryDeletes(coalescedUpdates.queriesIterable(), segState));
                    dvUpdates = new DocValuesFieldUpdates.Container();
                    this.applyDocValuesUpdates(coalescedUpdates.numericDVUpdates, segState, dvUpdates);
                    this.applyDocValuesUpdates(coalescedUpdates.binaryDVUpdates, segState, dvUpdates);
                    if (dvUpdates.any()) {
                        segState.rld.writeFieldUpdates(info.info.dir, dvUpdates);
                    }
                    totDelCount += (long)delCount;
                }
                --infosIDX;
            }
            if (coalescedUpdates != null && coalescedUpdates.totalTermCount != 0) {
                if (segStates == null) {
                    segStates = this.openSegmentStates(pool, infos);
                }
                totTermVisitedCount += this.applyTermDeletes(coalescedUpdates, segStates);
            }
            if (!BufferedUpdatesStream.$assertionsDisabled && !this.checkDeleteStats()) {
                throw new AssertionError();
            }
            success = true;
            ** if (segStates == null) goto lbl-1000
        }
        catch (Throwable var24_20) {
            if (segStates != null) {
                result = this.closeSegmentStates(pool, segStates, success, gen);
            }
            throw var24_20;
        }
lbl-1000:
        // 1 sources

        {
            result = this.closeSegmentStates(pool, segStates, success, gen);
        }
lbl-1000:
        // 2 sources

        {
        }
        if (result == null) {
            result = new ApplyDeletesResult(false, gen, null);
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", String.format(Locale.ROOT, "applyDeletes took %d msec for %d segments, %d newly deleted docs (query deletes), %d visited terms, allDeleted=%s", new Object[]{System.currentTimeMillis() - t0, infos.size(), totDelCount, totTermVisitedCount, result.allDeleted}));
        }
        return result;
    }

    private List<SegmentCommitInfo> sortByDelGen(List<SegmentCommitInfo> infos) {
        infos = new ArrayList<SegmentCommitInfo>(infos);
        Collections.sort(infos, sortSegInfoByDelGen);
        return infos;
    }

    synchronized long getNextGen() {
        return this.nextGen++;
    }

    public synchronized void prune(SegmentInfos segmentInfos) {
        assert (this.checkDeleteStats());
        long minGen = Long.MAX_VALUE;
        for (SegmentCommitInfo info : segmentInfos) {
            minGen = Math.min(info.getBufferedDeletesGen(), minGen);
        }
        if (this.infoStream.isEnabled("BD")) {
            Directory dir = segmentInfos.size() > 0 ? segmentInfos.info((int)0).info.dir : null;
            this.infoStream.message("BD", "prune sis=" + segmentInfos + " minGen=" + minGen + " packetCount=" + this.updates.size());
        }
        int limit = this.updates.size();
        for (int delIDX = 0; delIDX < limit; ++delIDX) {
            if (this.updates.get(delIDX).delGen() < minGen) continue;
            this.prune(delIDX);
            assert (this.checkDeleteStats());
            return;
        }
        this.prune(limit);
        assert (!this.any());
        assert (this.checkDeleteStats());
    }

    private synchronized void prune(int count) {
        if (count > 0) {
            if (this.infoStream.isEnabled("BD")) {
                this.infoStream.message("BD", "pruneDeletes: prune " + count + " packets; " + (this.updates.size() - count) + " packets remain");
            }
            for (int delIDX = 0; delIDX < count; ++delIDX) {
                FrozenBufferedUpdates packet = this.updates.get(delIDX);
                this.numTerms.addAndGet(-packet.numTermDeletes);
                assert (this.numTerms.get() >= 0);
                this.bytesUsed.addAndGet(-packet.bytesUsed);
                assert (this.bytesUsed.get() >= 0L);
            }
            this.updates.subList(0, count).clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentState[] openSegmentStates(IndexWriter.ReaderPool pool, List<SegmentCommitInfo> infos) throws IOException {
        int numReaders = infos.size();
        SegmentState[] segStates = new SegmentState[numReaders];
        boolean success = false;
        try {
            for (int i = 0; i < numReaders; ++i) {
                segStates[i] = new SegmentState(pool, infos.get(i));
            }
            success = true;
        }
        finally {
            if (!success) {
                for (int j = 0; j < numReaders; ++j) {
                    if (segStates[j] == null) continue;
                    try {
                        segStates[j].finish(pool);
                        continue;
                    }
                    catch (Throwable th) {}
                }
            }
        }
        return segStates;
    }

    private ApplyDeletesResult closeSegmentStates(IndexWriter.ReaderPool pool, SegmentState[] segStates, boolean success, long gen) throws IOException {
        int numReaders = segStates.length;
        Throwable firstExc = null;
        ArrayList<SegmentCommitInfo> allDeleted = null;
        long totDelCount = 0L;
        for (int j = 0; j < numReaders; ++j) {
            SegmentState segState = segStates[j];
            if (success) {
                totDelCount += (long)(segState.rld.getPendingDeleteCount() - segState.startDelCount);
                segState.reader.getSegmentInfo().setBufferedDeletesGen(gen);
                int fullDelCount = segState.rld.info.getDelCount() + segState.rld.getPendingDeleteCount();
                assert (fullDelCount <= segState.rld.info.info.maxDoc());
                if (fullDelCount == segState.rld.info.info.maxDoc()) {
                    if (allDeleted == null) {
                        allDeleted = new ArrayList<SegmentCommitInfo>();
                    }
                    allDeleted.add(segState.reader.getSegmentInfo());
                }
            }
            try {
                segStates[j].finish(pool);
                continue;
            }
            catch (Throwable th) {
                if (firstExc == null) continue;
                firstExc = th;
            }
        }
        if (success) {
            IOUtils.reThrow(firstExc);
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", "applyDeletes: " + totDelCount + " new deleted documents");
        }
        return new ApplyDeletesResult(totDelCount > 0L, gen, allDeleted);
    }

    /*
     * Unable to fully structure code
     */
    private synchronized long applyTermDeletes(CoalescedUpdates updates, SegmentState[] segStates) throws IOException {
        startNS = System.nanoTime();
        numReaders = segStates.length;
        delTermVisitedCount = 0L;
        segTermVisitedCount = 0L;
        iter = updates.termIterator();
        field = null;
        queue = null;
        block0: while (true) {
            if (newField = iter.next()) {
                field = iter.field();
                if (field == null) break;
                queue = new SegmentQueue(numReaders);
                segTermCount = 0L;
                for (i = 0; i < numReaders; ++i) {
                    state = segStates[i];
                    terms = state.reader.fields().terms(field);
                    if (terms == null) continue;
                    segTermCount += terms.size();
                    state.termsEnum = terms.iterator(state.termsEnum);
                    state.term = state.termsEnum.next();
                    if (state.term == null) continue;
                    queue.add(state);
                }
                if (!BufferedUpdatesStream.$assertionsDisabled && !this.checkDeleteTerm(null)) {
                    throw new AssertionError();
                }
            }
            term = iter.term();
            if (!BufferedUpdatesStream.$assertionsDisabled && !this.checkDeleteTerm(term)) {
                throw new AssertionError();
            }
            ++delTermVisitedCount;
            delGen = iter.delGen();
            while (true) {
                if (queue.size() == 0) continue block0;
                state = (SegmentState)queue.top();
                ++segTermVisitedCount;
                cmp = term.compareTo(state.term);
                if (cmp >= 0) ** break;
                continue block0;
                if (cmp != 0 && (status = state.termsEnum.seekCeil(term)) != TermsEnum.SeekStatus.FOUND) {
                    if (status == TermsEnum.SeekStatus.NOT_FOUND) {
                        state.term = state.termsEnum.term();
                        queue.updateTop();
                        continue;
                    }
                    queue.pop();
                    continue;
                }
                if (!BufferedUpdatesStream.$assertionsDisabled && state.delGen == delGen) {
                    throw new AssertionError();
                }
                if (state.delGen < delGen) {
                    state.postingsEnum = state.termsEnum.postings(state.rld.getLiveDocs(), state.postingsEnum, 0);
                    if (!BufferedUpdatesStream.$assertionsDisabled && state.postingsEnum == null) {
                        throw new AssertionError();
                    }
                    while ((docID = state.postingsEnum.nextDoc()) != 0x7FFFFFFF) {
                        if (!state.any) {
                            state.rld.initWritableLiveDocs();
                            state.any = true;
                        }
                        state.rld.delete(docID);
                    }
                }
                state.term = state.termsEnum.next();
                if (state.term == null) {
                    queue.pop();
                    continue;
                }
                queue.updateTop();
            }
            break;
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", String.format(Locale.ROOT, "applyTermDeletes took %.1f msec for %d segments and %d packets; %d del terms visited; %d seg terms visited", new Object[]{(double)(System.nanoTime() - startNS) / 1000000.0, numReaders, updates.terms.size(), delTermVisitedCount, segTermVisitedCount}));
        }
        return delTermVisitedCount;
    }

    private synchronized void applyDocValuesUpdates(Iterable<? extends DocValuesUpdate> updates, SegmentState segState, DocValuesFieldUpdates.Container dvUpdatesContainer) throws IOException {
        Fields fields = segState.reader.fields();
        String currentField = null;
        TermsEnum termsEnum = null;
        PostingsEnum postingsEnum = null;
        for (DocValuesUpdate docValuesUpdate : updates) {
            int doc;
            Term term = docValuesUpdate.term;
            int limit = docValuesUpdate.docIDUpto;
            if (!term.field().equals(currentField)) {
                currentField = term.field();
                Terms terms = fields.terms(currentField);
                termsEnum = terms != null ? terms.iterator(termsEnum) : null;
            }
            if (termsEnum == null || !termsEnum.seekExact(term.bytes())) continue;
            postingsEnum = termsEnum.postings(segState.rld.getLiveDocs(), postingsEnum, 0);
            DocValuesFieldUpdates dvUpdates = dvUpdatesContainer.getUpdates(docValuesUpdate.field, docValuesUpdate.type);
            if (dvUpdates == null) {
                dvUpdates = dvUpdatesContainer.newUpdates(docValuesUpdate.field, docValuesUpdate.type, segState.reader.maxDoc());
            }
            while ((doc = postingsEnum.nextDoc()) != Integer.MAX_VALUE && doc < limit) {
                dvUpdates.add(doc, docValuesUpdate.value);
            }
        }
    }

    private static long applyQueryDeletes(Iterable<QueryAndLimit> queriesIter, SegmentState segState) throws IOException {
        long delCount = 0L;
        LeafReaderContext readerContext = segState.reader.getContext();
        for (QueryAndLimit ent : queriesIter) {
            int doc;
            DocIdSetIterator it;
            Query query = ent.query;
            int limit = ent.limit;
            DocIdSet docs = new QueryWrapperFilter(query).getDocIdSet(readerContext, segState.reader.getLiveDocs());
            if (docs == null || (it = docs.iterator()) == null) continue;
            while ((doc = it.nextDoc()) < limit) {
                if (!segState.any) {
                    segState.rld.initWritableLiveDocs();
                    segState.any = true;
                }
                if (!segState.rld.delete(doc)) continue;
                ++delCount;
            }
        }
        return delCount;
    }

    private boolean checkDeleteTerm(BytesRef term) {
        if (term != null) assert (this.lastDeleteTerm == null || term.compareTo(this.lastDeleteTerm) >= 0) : "lastTerm=" + this.lastDeleteTerm + " vs term=" + term;
        this.lastDeleteTerm = term == null ? null : BytesRef.deepCopyOf(term);
        return true;
    }

    private boolean checkDeleteStats() {
        int numTerms2 = 0;
        long bytesUsed2 = 0L;
        for (FrozenBufferedUpdates packet : this.updates) {
            numTerms2 += packet.numTermDeletes;
            bytesUsed2 += (long)packet.bytesUsed;
        }
        assert (numTerms2 == this.numTerms.get()) : "numTerms2=" + numTerms2 + " vs " + this.numTerms.get();
        assert (bytesUsed2 == this.bytesUsed.get()) : "bytesUsed2=" + bytesUsed2 + " vs " + this.bytesUsed;
        return true;
    }

    public static class QueryAndLimit {
        public final Query query;
        public final int limit;

        public QueryAndLimit(Query query, int limit) {
            this.query = query;
            this.limit = limit;
        }
    }

    static class SegmentQueue
    extends PriorityQueue<SegmentState> {
        public SegmentQueue(int size) {
            super(size);
        }

        @Override
        protected boolean lessThan(SegmentState a, SegmentState b) {
            return a.term.compareTo(b.term) < 0;
        }
    }

    static class SegmentState {
        final long delGen;
        final ReadersAndUpdates rld;
        final SegmentReader reader;
        final int startDelCount;
        TermsEnum termsEnum;
        PostingsEnum postingsEnum;
        BytesRef term;
        boolean any;

        public SegmentState(IndexWriter.ReaderPool pool, SegmentCommitInfo info) throws IOException {
            this.rld = pool.get(info, true);
            this.startDelCount = this.rld.getPendingDeleteCount();
            this.reader = this.rld.getReader(IOContext.READ);
            this.delGen = info.getBufferedDeletesGen();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish(IndexWriter.ReaderPool pool) throws IOException {
            try {
                this.rld.release(this.reader);
            }
            finally {
                pool.release(this.rld);
            }
        }
    }

    public static class ApplyDeletesResult {
        public final boolean anyDeletes;
        public final long gen;
        public final List<SegmentCommitInfo> allDeleted;

        ApplyDeletesResult(boolean anyDeletes, long gen, List<SegmentCommitInfo> allDeleted) {
            this.anyDeletes = anyDeletes;
            this.gen = gen;
            this.allDeleted = allDeleted;
        }
    }
}

