/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.transport;

import org.apache.commons.lang.NotImplementedException;
import org.apache.thrift.transport.AutoExpandingBuffer;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class AutoExpandingBufferReadTransport
extends TTransport {
    private final AutoExpandingBuffer buf;
    private int pos = 0;
    private int limit = 0;

    public AutoExpandingBufferReadTransport(int initialCapacity, double overgrowthCoefficient) {
        this.buf = new AutoExpandingBuffer(initialCapacity, overgrowthCoefficient);
    }

    public void fill(TTransport inTrans, int length) throws TTransportException {
        this.buf.resizeIfNecessary(length);
        inTrans.readAll(this.buf.array(), 0, length);
        this.pos = 0;
        this.limit = length;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void open() throws TTransportException {
    }

    @Override
    public final int read(byte[] target, int off, int len) throws TTransportException {
        int amtToRead = Math.min(len, this.getBytesRemainingInBuffer());
        System.arraycopy(this.buf.array(), this.pos, target, off, amtToRead);
        this.consumeBuffer(amtToRead);
        return amtToRead;
    }

    @Override
    public void write(byte[] buf, int off, int len) throws TTransportException {
        throw new NotImplementedException();
    }

    @Override
    public final void consumeBuffer(int len) {
        this.pos += len;
    }

    @Override
    public final byte[] getBuffer() {
        return this.buf.array();
    }

    @Override
    public final int getBufferPosition() {
        return this.pos;
    }

    @Override
    public final int getBytesRemainingInBuffer() {
        return this.limit - this.pos;
    }
}

