/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.exceptions.InvalidResourceRequestException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SchedulerUtils {
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    public static final String RELEASED_CONTAINER = "Container released by application";
    public static final String LOST_CONTAINER = "Container released on a *lost* node";
    public static final String PREEMPTED_CONTAINER = "Container preempted by scheduler";
    public static final String COMPLETED_APPLICATION = "Container of a completed application";
    public static final String EXPIRED_CONTAINER = "Container expired since it was unused";
    public static final String UNRESERVED_CONTAINER = "Container reservation no longer required.";

    public static ContainerStatus createAbnormalContainerStatus(ContainerId containerId, String diagnostics) {
        return SchedulerUtils.createAbnormalContainerStatus(containerId, -100, diagnostics);
    }

    public static ContainerStatus createPreemptedContainerStatus(ContainerId containerId, String diagnostics) {
        return SchedulerUtils.createAbnormalContainerStatus(containerId, -102, diagnostics);
    }

    private static ContainerStatus createAbnormalContainerStatus(ContainerId containerId, int exitStatus, String diagnostics) {
        ContainerStatus containerStatus = (ContainerStatus)recordFactory.newRecordInstance(ContainerStatus.class);
        containerStatus.setContainerId(containerId);
        containerStatus.setDiagnostics(diagnostics);
        containerStatus.setExitStatus(exitStatus);
        containerStatus.setState(ContainerState.COMPLETE);
        return containerStatus;
    }

    public static void normalizeRequests(List<ResourceRequest> asks, ResourceCalculator resourceCalculator, Resource clusterResource, Resource minimumResource, Resource maximumResource) {
        for (ResourceRequest ask : asks) {
            SchedulerUtils.normalizeRequest(ask, resourceCalculator, clusterResource, minimumResource, maximumResource, minimumResource);
        }
    }

    public static void normalizeRequest(ResourceRequest ask, ResourceCalculator resourceCalculator, Resource clusterResource, Resource minimumResource, Resource maximumResource) {
        Resource normalized = Resources.normalize((ResourceCalculator)resourceCalculator, (Resource)ask.getCapability(), (Resource)minimumResource, (Resource)maximumResource, (Resource)minimumResource);
        ask.setCapability(normalized);
    }

    public static void updateResourceIfChanged(SchedulerNode node, RMNode rmNode, Resource clusterResource, Log log) {
        Resource oldAvailableResource = node.getAvailableResource();
        Resource newAvailableResource = Resources.subtract((Resource)rmNode.getTotalCapability(), (Resource)node.getUsedResource());
        if (!newAvailableResource.equals((Object)oldAvailableResource)) {
            Resource deltaResource = Resources.subtract((Resource)newAvailableResource, (Resource)oldAvailableResource);
            node.applyDeltaOnAvailableResource(deltaResource);
            Resources.addTo((Resource)clusterResource, (Resource)deltaResource);
            log.info((Object)("Resource change on node: " + rmNode.getNodeAddress() + " with delta: CPU: " + deltaResource.getMemory() + "core, Memory: " + deltaResource.getMemory() + "MB"));
        }
    }

    public static void normalizeRequests(List<ResourceRequest> asks, ResourceCalculator resourceCalculator, Resource clusterResource, Resource minimumResource, Resource maximumResource, Resource incrementResource) {
        for (ResourceRequest ask : asks) {
            SchedulerUtils.normalizeRequest(ask, resourceCalculator, clusterResource, minimumResource, maximumResource, incrementResource);
        }
    }

    public static void normalizeRequest(ResourceRequest ask, ResourceCalculator resourceCalculator, Resource clusterResource, Resource minimumResource, Resource maximumResource, Resource incrementResource) {
        Resource normalized = Resources.normalize((ResourceCalculator)resourceCalculator, (Resource)ask.getCapability(), (Resource)minimumResource, (Resource)maximumResource, (Resource)incrementResource);
        ask.setCapability(normalized);
    }

    public static void validateResourceRequest(ResourceRequest resReq, Resource maximumResource) throws InvalidResourceRequestException {
        if (resReq.getCapability().getMemory() < 0 || resReq.getCapability().getMemory() > maximumResource.getMemory()) {
            throw new InvalidResourceRequestException("Invalid resource request, requested memory < 0, or requested memory > max configured, requestedMemory=" + resReq.getCapability().getMemory() + ", maxMemory=" + maximumResource.getMemory());
        }
        if (resReq.getCapability().getVirtualCores() < 0 || resReq.getCapability().getVirtualCores() > maximumResource.getVirtualCores()) {
            throw new InvalidResourceRequestException("Invalid resource request, requested virtual cores < 0, or requested virtual cores > max configured, requestedVirtualCores=" + resReq.getCapability().getVirtualCores() + ", maxVirtualCores=" + maximumResource.getVirtualCores());
        }
    }
}

