/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.List;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;

public class Allocation {
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    final List<Container> containers;
    final Resource resourceLimit;
    final Set<ContainerId> strictContainers;
    final Set<ContainerId> fungibleContainers;
    final List<ResourceRequest> fungibleResources;

    public Allocation(List<Container> containers, Resource resourceLimit) {
        this(containers, resourceLimit, null, null, null);
    }

    public Allocation(List<Container> containers, Resource resourceLimit, Set<ContainerId> strictContainers) {
        this(containers, resourceLimit, strictContainers, null, null);
    }

    public Allocation(List<Container> containers, Resource resourceLimit, Set<ContainerId> strictContainers, Set<ContainerId> fungibleContainers, List<ResourceRequest> fungibleResources) {
        this.containers = containers;
        this.resourceLimit = resourceLimit;
        this.strictContainers = strictContainers;
        this.fungibleContainers = fungibleContainers;
        this.fungibleResources = fungibleResources;
    }

    public List<Container> getContainers() {
        return this.containers;
    }

    public Resource getResourceLimit() {
        return this.resourceLimit;
    }

    public Set<ContainerId> getStrictContainerPreemptions() {
        return this.strictContainers;
    }

    public Set<ContainerId> getContainerPreemptions() {
        return this.fungibleContainers;
    }

    public List<ResourceRequest> getResourcePreemptions() {
        return this.fungibleResources;
    }
}

