/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.SecretKey;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.security.client.ClientToAMTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEvent;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEventType;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.Recoverable;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppFailedAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppFinishedAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppRejectedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptContainerAcquiredEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptLaunchFailedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptNewSavedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptRegistrationEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptRejectedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptStatusupdateEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptUnregistrationEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptUpdateSavedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.server.webproxy.ProxyUriUtils;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

public class RMAppAttemptImpl
implements RMAppAttempt,
Recoverable {
    private static final Log LOG = LogFactory.getLog(RMAppAttemptImpl.class);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    public static final Priority AM_CONTAINER_PRIORITY = (Priority)recordFactory.newRecordInstance(Priority.class);
    private final StateMachine<RMAppAttemptState, RMAppAttemptEventType, RMAppAttemptEvent> stateMachine;
    private final RMContext rmContext;
    private final EventHandler eventHandler;
    private final YarnScheduler scheduler;
    private final ApplicationMasterService masterService;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final ApplicationAttemptId applicationAttemptId;
    private final ApplicationSubmissionContext submissionContext;
    private Token<AMRMTokenIdentifier> amrmToken = null;
    private SecretKey clientTokenMasterKey = null;
    private final Set<NodeId> ranNodes = new HashSet<NodeId>();
    private final List<ContainerStatus> justFinishedContainers = new ArrayList<ContainerStatus>();
    private Container masterContainer;
    private float progress = 0.0f;
    private String host = "N/A";
    private int rpcPort = -1;
    private String originalTrackingUrl = "N/A";
    private String proxiedTrackingUrl = "N/A";
    private long startTime = 0L;
    private FinalApplicationStatus finalStatus = null;
    private final StringBuilder diagnostics = new StringBuilder();
    private Configuration conf;
    private String user;
    private static final ExpiredTransition EXPIRED_TRANSITION;
    private RMAppAttemptEvent eventCausingFinalSaving;
    private RMAppAttemptState targetedFinalState;
    private RMAppAttemptState recoveredFinalState;
    private Object transitionTodo;
    private static final StateMachineFactory<RMAppAttemptImpl, RMAppAttemptState, RMAppAttemptEventType, RMAppAttemptEvent> stateMachineFactory;
    private static final List<ContainerId> EMPTY_CONTAINER_RELEASE_LIST;
    private static final List<ResourceRequest> EMPTY_CONTAINER_REQUEST_LIST;

    public RMAppAttemptImpl(ApplicationAttemptId appAttemptId, RMContext rmContext, YarnScheduler scheduler, ApplicationMasterService masterService, ApplicationSubmissionContext submissionContext, Configuration conf, String user) {
        this.conf = conf;
        this.applicationAttemptId = appAttemptId;
        this.rmContext = rmContext;
        this.eventHandler = rmContext.getDispatcher().getEventHandler();
        this.submissionContext = submissionContext;
        this.scheduler = scheduler;
        this.masterService = masterService;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.proxiedTrackingUrl = this.generateProxyUriWithScheme(null);
        this.stateMachine = stateMachineFactory.make((Object)this);
        this.user = user;
    }

    @Override
    public ApplicationAttemptId getAppAttemptId() {
        return this.applicationAttemptId;
    }

    @Override
    public ApplicationSubmissionContext getSubmissionContext() {
        return this.submissionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FinalApplicationStatus getFinalApplicationStatus() {
        this.readLock.lock();
        try {
            FinalApplicationStatus finalApplicationStatus = this.finalStatus;
            return finalApplicationStatus;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RMAppAttemptState getAppAttemptState() {
        this.readLock.lock();
        try {
            RMAppAttemptState rMAppAttemptState = (RMAppAttemptState)this.stateMachine.getCurrentState();
            return rMAppAttemptState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getHost() {
        this.readLock.lock();
        try {
            String string = this.host;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRpcPort() {
        this.readLock.lock();
        try {
            int n = this.rpcPort;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTrackingUrl() {
        this.readLock.lock();
        try {
            String string = this.getSubmissionContext().getUnmanagedAM() ? this.originalTrackingUrl : this.proxiedTrackingUrl;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOriginalTrackingUrl() {
        this.readLock.lock();
        try {
            String string = this.originalTrackingUrl;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getWebProxyBase() {
        this.readLock.lock();
        try {
            String string = ProxyUriUtils.getPath((ApplicationId)this.applicationAttemptId.getApplicationId());
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateProxyUriWithScheme(String trackingUriWithoutScheme) {
        this.readLock.lock();
        try {
            URI trackingUri = StringUtils.isEmpty((String)trackingUriWithoutScheme) ? null : ProxyUriUtils.getUriFromAMUrl((String)trackingUriWithoutScheme);
            String proxy = WebAppUtils.getProxyHostAndPort((Configuration)this.conf);
            URI proxyUri = ProxyUriUtils.getUriFromAMUrl((String)proxy);
            URI result = ProxyUriUtils.getProxyUri((URI)trackingUri, (URI)proxyUri, (ApplicationId)this.applicationAttemptId.getApplicationId());
            String string = result.toASCIIString();
            return string;
        }
        catch (URISyntaxException e) {
            LOG.warn((Object)("Could not proxify " + trackingUriWithoutScheme), (Throwable)e);
            String string = trackingUriWithoutScheme;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void setTrackingUrlToRMAppPage() {
        this.proxiedTrackingUrl = this.originalTrackingUrl = StringHelper.pjoin((Object[])new Object[]{WebAppUtils.getResolvedRMWebAppURLWithoutScheme((Configuration)this.conf), "cluster", "app", this.getAppAttemptId().getApplicationId()});
    }

    private void invalidateAMHostAndPort() {
        this.host = "N/A";
        this.rpcPort = -1;
    }

    @Override
    public SecretKey getClientTokenMasterKey() {
        return this.clientTokenMasterKey;
    }

    @Override
    public Token<AMRMTokenIdentifier> getAMRMToken() {
        return this.amrmToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token<ClientToAMTokenIdentifier> createClientToken(String client) {
        this.readLock.lock();
        try {
            Token token = null;
            ClientToAMTokenSecretManagerInRM secretMgr = this.rmContext.getClientToAMTokenSecretManager();
            if (client != null && secretMgr.getMasterKey(this.applicationAttemptId) != null) {
                token = new Token((TokenIdentifier)new ClientToAMTokenIdentifier(this.applicationAttemptId, client), (SecretManager)secretMgr);
            }
            Token token2 = token;
            return token2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDiagnostics() {
        this.readLock.lock();
        try {
            String string = this.diagnostics.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getProgress() {
        this.readLock.lock();
        try {
            float f = this.progress;
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ContainerStatus> getJustFinishedContainers() {
        this.readLock.lock();
        try {
            List<ContainerStatus> list = this.justFinishedContainers;
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ContainerStatus> pullJustFinishedContainers() {
        this.writeLock.lock();
        try {
            ArrayList<ContainerStatus> returnList = new ArrayList<ContainerStatus>(this.justFinishedContainers.size());
            returnList.addAll(this.justFinishedContainers);
            this.justFinishedContainers.clear();
            ArrayList<ContainerStatus> arrayList = returnList;
            return arrayList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Set<NodeId> getRanNodes() {
        return this.ranNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Container getMasterContainer() {
        this.readLock.lock();
        try {
            Container container = this.masterContainer;
            return container;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void setMasterContainer(Container container) {
        this.masterContainer = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RMAppAttemptEvent event) {
        this.writeLock.lock();
        try {
            ApplicationAttemptId appAttemptID = event.getApplicationAttemptId();
            LOG.debug((Object)("Processing event for " + appAttemptID + " of type " + event.getType()));
            RMAppAttemptState oldState = this.getAppAttemptState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)"Can't handle this event at current state", (Throwable)e);
            }
            if (oldState != this.getAppAttemptState()) {
                LOG.info((Object)(appAttemptID + " State change from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getAppAttemptState())));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationResourceUsageReport getApplicationResourceUsageReport() {
        this.readLock.lock();
        try {
            ApplicationResourceUsageReport report = this.scheduler.getAppResourceUsageReport(this.getAppAttemptId());
            if (report == null) {
                Resource none = Resource.newInstance((int)0, (int)0);
                report = ApplicationResourceUsageReport.newInstance((int)0, (int)0, (Resource)none, (Resource)none, (Resource)none);
            }
            ApplicationResourceUsageReport applicationResourceUsageReport = report;
            return applicationResourceUsageReport;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void recover(RMStateStore.RMState state) throws Exception {
        RMStateStore.ApplicationState appState = state.getApplicationState().get(this.getAppAttemptId().getApplicationId());
        RMStateStore.ApplicationAttemptState attemptState = appState.getAttempt(this.getAppAttemptId());
        assert (attemptState != null);
        LOG.info((Object)("Recovering attempt: " + this.getAppAttemptId() + " with final state: " + (Object)((Object)attemptState.getState())));
        this.diagnostics.append("Attempt recovered after RM restart");
        this.diagnostics.append(attemptState.getDiagnostics());
        this.setMasterContainer(attemptState.getMasterContainer());
        this.recoverAppAttemptCredentials(attemptState.getAppAttemptCredentials());
        this.recoveredFinalState = attemptState.getState();
        this.originalTrackingUrl = attemptState.getFinalTrackingUrl();
        this.proxiedTrackingUrl = this.generateProxyUriWithScheme(this.originalTrackingUrl);
        this.finalStatus = attemptState.getFinalApplicationStatus();
        this.startTime = attemptState.getStartTime();
    }

    private void recoverAppAttemptCredentials(Credentials appAttemptTokens) throws IOException {
        if (appAttemptTokens == null) {
            return;
        }
        if (UserGroupInformation.isSecurityEnabled()) {
            byte[] clientTokenMasterKeyBytes = appAttemptTokens.getSecretKey(RMStateStore.AM_CLIENT_TOKEN_MASTER_KEY_NAME);
            this.clientTokenMasterKey = this.rmContext.getClientToAMTokenSecretManager().registerMasterKey(this.applicationAttemptId, clientTokenMasterKeyBytes);
        }
        this.amrmToken = appAttemptTokens.getToken(RMStateStore.AM_RM_TOKEN_SERVICE);
        this.rmContext.getAMRMTokenSecretManager().addPersistedPassword(this.amrmToken);
    }

    private void rememberTargetTransitions(RMAppAttemptEvent event, Object transitionToDo, RMAppAttemptState targetFinalState) {
        this.transitionTodo = transitionToDo;
        this.targetedFinalState = targetFinalState;
        this.eventCausingFinalSaving = event;
    }

    private void rememberTargetTransitionsAndStoreState(RMAppAttemptEvent event, Object transitionToDo, RMAppAttemptState targetFinalState, RMAppAttemptState stateToBeStored) {
        this.rememberTargetTransitions(event, transitionToDo, targetFinalState);
        String diags = null;
        String finalTrackingUrl = null;
        FinalApplicationStatus finalStatus = null;
        switch ((RMAppAttemptEventType)event.getType()) {
            case APP_REJECTED: {
                RMAppAttemptRejectedEvent rejectedEvent = (RMAppAttemptRejectedEvent)event;
                diags = rejectedEvent.getMessage();
                break;
            }
            case LAUNCH_FAILED: {
                RMAppAttemptLaunchFailedEvent launchFaileEvent = (RMAppAttemptLaunchFailedEvent)event;
                diags = launchFaileEvent.getMessage();
                break;
            }
            case REGISTERED: {
                diags = RMAppAttemptImpl.getUnexpectedAMRegisteredDiagnostics();
                break;
            }
            case UNREGISTERED: {
                RMAppAttemptUnregistrationEvent unregisterEvent = (RMAppAttemptUnregistrationEvent)event;
                diags = unregisterEvent.getDiagnostics();
                finalTrackingUrl = RMAppAttemptImpl.sanitizeTrackingUrl(unregisterEvent.getFinalTrackingUrl());
                finalStatus = unregisterEvent.getFinalApplicationStatus();
                break;
            }
            case CONTAINER_FINISHED: {
                RMAppAttemptContainerFinishedEvent finishEvent = (RMAppAttemptContainerFinishedEvent)event;
                diags = RMAppAttemptImpl.getAMContainerCrashedDiagnostics(finishEvent);
                break;
            }
            case KILL: {
                break;
            }
            case EXPIRE: {
                diags = RMAppAttemptImpl.getAMExpiredDiagnostics(event);
                break;
            }
        }
        RMStateStore rmStore = this.rmContext.getStateStore();
        RMStateStore.ApplicationAttemptState attemptState = new RMStateStore.ApplicationAttemptState(this.applicationAttemptId, this.getMasterContainer(), rmStore.getCredentialsFromAppAttempt(this), this.startTime, stateToBeStored, finalTrackingUrl, diags, finalStatus);
        LOG.info((Object)("Updating application attempt " + this.applicationAttemptId + " with final state: " + (Object)((Object)this.targetedFinalState)));
        rmStore.updateApplicationAttemptState(attemptState);
    }

    private static String getAMContainerCrashedDiagnostics(RMAppAttemptContainerFinishedEvent finishEvent) {
        ContainerStatus status = finishEvent.getContainerStatus();
        String diagnostics = "AM Container for " + finishEvent.getApplicationAttemptId() + " exited with " + " exitCode: " + status.getExitStatus() + " due to: " + status.getDiagnostics() + "." + "Failing this attempt.";
        return diagnostics;
    }

    private static String getAMExpiredDiagnostics(RMAppAttemptEvent event) {
        String diag = "ApplicationMaster for attempt " + event.getApplicationAttemptId() + " timed out";
        return diag;
    }

    private static String getUnexpectedAMRegisteredDiagnostics() {
        return "Unmanaged AM must register after AM attempt reaches LAUNCHED state.";
    }

    private void updateInfoOnAMUnregister(RMAppAttemptEvent event) {
        this.progress = 1.0f;
        RMAppAttemptUnregistrationEvent unregisterEvent = (RMAppAttemptUnregistrationEvent)event;
        this.diagnostics.append(unregisterEvent.getDiagnostics());
        this.originalTrackingUrl = RMAppAttemptImpl.sanitizeTrackingUrl(unregisterEvent.getFinalTrackingUrl());
        this.proxiedTrackingUrl = this.generateProxyUriWithScheme(this.originalTrackingUrl);
        this.finalStatus = unregisterEvent.getFinalApplicationStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getStartTime() {
        this.readLock.lock();
        try {
            long l = this.startTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void launchAttempt() {
        this.eventHandler.handle((Event)new AMLauncherEvent(AMLauncherEventType.LAUNCH, this));
    }

    private void attemptLaunched() {
        this.rmContext.getAMLivelinessMonitor().register(this.getAppAttemptId());
    }

    private void checkAttemptStoreError(RMAppAttemptEvent event) {
        RMAppAttemptNewSavedEvent storeEvent = (RMAppAttemptNewSavedEvent)event;
        if (storeEvent.getStoredException() != null) {
            LOG.error((Object)("Failed to store attempt: " + this.getAppAttemptId()), (Throwable)storeEvent.getStoredException());
            ExitUtil.terminate((int)1, (Throwable)storeEvent.getStoredException());
        }
    }

    private void storeAttempt() {
        LOG.info((Object)("Storing attempt: AppId: " + this.getAppAttemptId().getApplicationId() + " AttemptId: " + this.getAppAttemptId() + " MasterContainer: " + this.masterContainer));
        this.rmContext.getStateStore().storeNewApplicationAttempt(this);
    }

    private void removeCredentials(RMAppAttemptImpl appAttempt) {
        if (UserGroupInformation.isSecurityEnabled()) {
            appAttempt.rmContext.getClientToAMTokenSecretManager().unRegisterApplication(appAttempt.getAppAttemptId());
        }
        appAttempt.rmContext.getAMRMTokenSecretManager().applicationMasterFinished(appAttempt.getAppAttemptId());
    }

    private static String sanitizeTrackingUrl(String url) {
        return url == null || url.trim().isEmpty() ? "N/A" : url;
    }

    static {
        AM_CONTAINER_PRIORITY.setPriority(0);
        EXPIRED_TRANSITION = new ExpiredTransition();
        stateMachineFactory = new StateMachineFactory((Enum)RMAppAttemptState.NEW).addTransition((Enum)RMAppAttemptState.NEW, (Enum)RMAppAttemptState.SUBMITTED, (Enum)RMAppAttemptEventType.START, (SingleArcTransition)new AttemptStartedTransition()).addTransition((Enum)RMAppAttemptState.NEW, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new FinalSavingTransition(new BaseFinalTransition(RMAppAttemptState.KILLED), RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.NEW, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.REGISTERED, (SingleArcTransition)new FinalSavingTransition(new UnexpectedAMRegisteredTransition(), RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.NEW, EnumSet.of(RMAppAttemptState.FINISHED, RMAppAttemptState.KILLED, RMAppAttemptState.FAILED, RMAppAttemptState.LAUNCHED), (Enum)RMAppAttemptEventType.RECOVER, (MultipleArcTransition)new AttemptRecoveredTransition()).addTransition((Enum)RMAppAttemptState.SUBMITTED, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.APP_REJECTED, (SingleArcTransition)new FinalSavingTransition(new AppRejectedTransition(), RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.SUBMITTED, EnumSet.of(RMAppAttemptState.LAUNCHED_UNMANAGED_SAVING, RMAppAttemptState.SCHEDULED), (Enum)RMAppAttemptEventType.APP_ACCEPTED, (MultipleArcTransition)new ScheduleTransition()).addTransition((Enum)RMAppAttemptState.SUBMITTED, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new FinalSavingTransition(new BaseFinalTransition(RMAppAttemptState.KILLED), RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.SUBMITTED, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.REGISTERED, (SingleArcTransition)new FinalSavingTransition(new UnexpectedAMRegisteredTransition(), RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.SCHEDULED, (Enum)RMAppAttemptState.ALLOCATED_SAVING, (Enum)RMAppAttemptEventType.CONTAINER_ALLOCATED, (SingleArcTransition)new AMContainerAllocatedTransition()).addTransition((Enum)RMAppAttemptState.SCHEDULED, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new FinalSavingTransition(new BaseFinalTransition(RMAppAttemptState.KILLED), RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.ALLOCATED_SAVING, (Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptEventType.ATTEMPT_NEW_SAVED, (SingleArcTransition)new AttemptStoredTransition()).addTransition((Enum)RMAppAttemptState.ALLOCATED_SAVING, (Enum)RMAppAttemptState.ALLOCATED_SAVING, (Enum)RMAppAttemptEventType.CONTAINER_ACQUIRED, (SingleArcTransition)new ContainerAcquiredTransition()).addTransition((Enum)RMAppAttemptState.ALLOCATED_SAVING, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new FinalSavingTransition(new BaseFinalTransition(RMAppAttemptState.KILLED), RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.LAUNCHED_UNMANAGED_SAVING, (Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptEventType.ATTEMPT_NEW_SAVED, (SingleArcTransition)new UnmanagedAMAttemptSavedTransition()).addTransition((Enum)RMAppAttemptState.LAUNCHED_UNMANAGED_SAVING, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.REGISTERED, (SingleArcTransition)new FinalSavingTransition(new UnexpectedAMRegisteredTransition(), RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.LAUNCHED_UNMANAGED_SAVING, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new FinalSavingTransition(new BaseFinalTransition(RMAppAttemptState.KILLED), RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptEventType.CONTAINER_ACQUIRED, (SingleArcTransition)new ContainerAcquiredTransition()).addTransition((Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptEventType.LAUNCHED, (SingleArcTransition)new AMLaunchedTransition()).addTransition((Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.LAUNCH_FAILED, (SingleArcTransition)new FinalSavingTransition(new LaunchFailedTransition(), RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new FinalSavingTransition(new KillAllocatedAMTransition(), RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.CONTAINER_FINISHED, (SingleArcTransition)new FinalSavingTransition(new AMContainerCrashedTransition(), RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptEventType.REGISTERED, (SingleArcTransition)new AMRegisteredTransition()).addTransition((Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.CONTAINER_FINISHED, (SingleArcTransition)new FinalSavingTransition(new AMContainerCrashedTransition(), RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.EXPIRE, (SingleArcTransition)new FinalSavingTransition(EXPIRED_TRANSITION, RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new FinalSavingTransition(new FinalTransition(RMAppAttemptState.KILLED), RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.RUNNING, EnumSet.of(RMAppAttemptState.FINAL_SAVING, RMAppAttemptState.FINISHED), (Enum)RMAppAttemptEventType.UNREGISTERED, (MultipleArcTransition)new AMUnregisteredTransition()).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptEventType.STATUS_UPDATE, (SingleArcTransition)new StatusUpdateTransition()).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptEventType.CONTAINER_ALLOCATED).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptEventType.CONTAINER_ACQUIRED, (SingleArcTransition)new ContainerAcquiredTransition()).addTransition((Enum)RMAppAttemptState.RUNNING, EnumSet.of(RMAppAttemptState.RUNNING, RMAppAttemptState.FINAL_SAVING), (Enum)RMAppAttemptEventType.CONTAINER_FINISHED, (MultipleArcTransition)new ContainerFinishedTransition()).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.EXPIRE, (SingleArcTransition)new FinalSavingTransition(EXPIRED_TRANSITION, RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new FinalSavingTransition(new FinalTransition(RMAppAttemptState.KILLED), RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.FINAL_SAVING, EnumSet.of(RMAppAttemptState.FINISHING, RMAppAttemptState.FAILED, RMAppAttemptState.KILLED, RMAppAttemptState.FINISHED), (Enum)RMAppAttemptEventType.ATTEMPT_UPDATE_SAVED, (MultipleArcTransition)new FinalStateSavedTransition()).addTransition((Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.CONTAINER_FINISHED, (SingleArcTransition)new ContainerFinishedAtFinalSavingTransition()).addTransition((Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.EXPIRE, (SingleArcTransition)new AMExpiredAtFinalSavingTransition()).addTransition((Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptState.FINAL_SAVING, EnumSet.of(RMAppAttemptEventType.UNREGISTERED, new RMAppAttemptEventType[]{RMAppAttemptEventType.STATUS_UPDATE, RMAppAttemptEventType.CONTAINER_ALLOCATED, RMAppAttemptEventType.CONTAINER_ACQUIRED, RMAppAttemptEventType.ATTEMPT_NEW_SAVED, RMAppAttemptEventType.KILL})).addTransition((Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptState.FAILED, EnumSet.of(RMAppAttemptEventType.EXPIRE, new RMAppAttemptEventType[]{RMAppAttemptEventType.KILL, RMAppAttemptEventType.UNREGISTERED, RMAppAttemptEventType.STATUS_UPDATE, RMAppAttemptEventType.CONTAINER_ALLOCATED, RMAppAttemptEventType.CONTAINER_FINISHED})).addTransition((Enum)RMAppAttemptState.FINISHING, EnumSet.of(RMAppAttemptState.FINISHING, RMAppAttemptState.FINISHED), (Enum)RMAppAttemptEventType.CONTAINER_FINISHED, (MultipleArcTransition)new AMFinishingContainerFinishedTransition()).addTransition((Enum)RMAppAttemptState.FINISHING, (Enum)RMAppAttemptState.FINISHED, (Enum)RMAppAttemptEventType.EXPIRE, (SingleArcTransition)new FinalTransition(RMAppAttemptState.FINISHED)).addTransition((Enum)RMAppAttemptState.FINISHING, (Enum)RMAppAttemptState.FINISHING, EnumSet.of(RMAppAttemptEventType.UNREGISTERED, RMAppAttemptEventType.STATUS_UPDATE, RMAppAttemptEventType.CONTAINER_ALLOCATED, RMAppAttemptEventType.KILL)).addTransition((Enum)RMAppAttemptState.FINISHED, (Enum)RMAppAttemptState.FINISHED, EnumSet.of(RMAppAttemptEventType.EXPIRE, RMAppAttemptEventType.UNREGISTERED, RMAppAttemptEventType.CONTAINER_ALLOCATED, RMAppAttemptEventType.CONTAINER_FINISHED, RMAppAttemptEventType.KILL)).addTransition((Enum)RMAppAttemptState.KILLED, (Enum)RMAppAttemptState.KILLED, EnumSet.of(RMAppAttemptEventType.APP_ACCEPTED, new RMAppAttemptEventType[]{RMAppAttemptEventType.APP_REJECTED, RMAppAttemptEventType.EXPIRE, RMAppAttemptEventType.LAUNCHED, RMAppAttemptEventType.LAUNCH_FAILED, RMAppAttemptEventType.EXPIRE, RMAppAttemptEventType.REGISTERED, RMAppAttemptEventType.CONTAINER_ALLOCATED, RMAppAttemptEventType.CONTAINER_FINISHED, RMAppAttemptEventType.UNREGISTERED, RMAppAttemptEventType.KILL, RMAppAttemptEventType.STATUS_UPDATE})).installTopology();
        EMPTY_CONTAINER_RELEASE_LIST = new ArrayList<ContainerId>();
        EMPTY_CONTAINER_REQUEST_LIST = new ArrayList<ResourceRequest>();
    }

    private static class AMExpiredAtFinalSavingTransition
    extends BaseTransition {
        private AMExpiredAtFinalSavingTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            if (appAttempt.targetedFinalState.equals((Object)RMAppAttemptState.FAILED) || appAttempt.targetedFinalState.equals((Object)RMAppAttemptState.KILLED)) {
                return;
            }
            appAttempt.rememberTargetTransitions(event, new AMFinishedAfterFinalSavingTransition(appAttempt.eventCausingFinalSaving), RMAppAttemptState.FINISHED);
        }
    }

    private static class AMFinishedAfterFinalSavingTransition
    extends BaseTransition {
        RMAppAttemptEvent amUnregisteredEvent;

        public AMFinishedAfterFinalSavingTransition(RMAppAttemptEvent amUnregisteredEvent) {
            this.amUnregisteredEvent = amUnregisteredEvent;
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            appAttempt.updateInfoOnAMUnregister(this.amUnregisteredEvent);
            new FinalTransition(RMAppAttemptState.FINISHED).transition(appAttempt, event);
        }
    }

    private static class ContainerFinishedAtFinalSavingTransition
    extends BaseTransition {
        private ContainerFinishedAtFinalSavingTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptContainerFinishedEvent containerFinishedEvent = (RMAppAttemptContainerFinishedEvent)event;
            ContainerStatus containerStatus = containerFinishedEvent.getContainerStatus();
            if (appAttempt.masterContainer.getId().equals((Object)containerStatus.getContainerId())) {
                if (appAttempt.targetedFinalState.equals((Object)RMAppAttemptState.FAILED) || appAttempt.targetedFinalState.equals((Object)RMAppAttemptState.KILLED)) {
                    return;
                }
                appAttempt.rememberTargetTransitions(event, new AMFinishedAfterFinalSavingTransition(appAttempt.eventCausingFinalSaving), RMAppAttemptState.FINISHED);
                return;
            }
            appAttempt.justFinishedContainers.add(containerStatus);
        }
    }

    private static final class AMFinishingContainerFinishedTransition
    implements MultipleArcTransition<RMAppAttemptImpl, RMAppAttemptEvent, RMAppAttemptState> {
        private AMFinishingContainerFinishedTransition() {
        }

        public RMAppAttemptState transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptContainerFinishedEvent containerFinishedEvent = (RMAppAttemptContainerFinishedEvent)event;
            ContainerStatus containerStatus = containerFinishedEvent.getContainerStatus();
            if (appAttempt.masterContainer.getId().equals((Object)containerStatus.getContainerId())) {
                new FinalTransition(RMAppAttemptState.FINISHED).transition(appAttempt, containerFinishedEvent);
                return RMAppAttemptState.FINISHED;
            }
            appAttempt.justFinishedContainers.add(containerStatus);
            return RMAppAttemptState.FINISHING;
        }
    }

    private static class ContainerFinishedFinalStateSavedTransition
    extends BaseTransition {
        private ContainerFinishedFinalStateSavedTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptContainerFinishedEvent containerFinishedEvent = (RMAppAttemptContainerFinishedEvent)event;
            assert (!appAttempt.submissionContext.getUnmanagedAM());
            appAttempt.diagnostics.append(RMAppAttemptImpl.getAMContainerCrashedDiagnostics(containerFinishedEvent));
            new FinalTransition(RMAppAttemptState.FAILED).transition(appAttempt, event);
        }
    }

    private static final class ContainerFinishedTransition
    implements MultipleArcTransition<RMAppAttemptImpl, RMAppAttemptEvent, RMAppAttemptState> {
        private ContainerFinishedTransition() {
        }

        public RMAppAttemptState transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptContainerFinishedEvent containerFinishedEvent = (RMAppAttemptContainerFinishedEvent)event;
            ContainerStatus containerStatus = containerFinishedEvent.getContainerStatus();
            if (appAttempt.masterContainer != null && appAttempt.masterContainer.getId().equals((Object)containerStatus.getContainerId())) {
                appAttempt.rememberTargetTransitionsAndStoreState(event, new ContainerFinishedFinalStateSavedTransition(), RMAppAttemptState.FAILED, RMAppAttemptState.FAILED);
                return RMAppAttemptState.FINAL_SAVING;
            }
            appAttempt.justFinishedContainers.add(containerStatus);
            return RMAppAttemptState.RUNNING;
        }
    }

    private static final class ContainerAcquiredTransition
    extends BaseTransition {
        private ContainerAcquiredTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptContainerAcquiredEvent acquiredEvent = (RMAppAttemptContainerAcquiredEvent)event;
            appAttempt.ranNodes.add(acquiredEvent.getContainer().getNodeId());
        }
    }

    private static class FinalStateSavedAfterAMUnregisterTransition
    extends BaseTransition {
        private FinalStateSavedAfterAMUnregisterTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            appAttempt.rmContext.getAMLivelinessMonitor().unregister(appAttempt.applicationAttemptId);
            appAttempt.rmContext.getAMFinishingMonitor().register(appAttempt.applicationAttemptId);
            appAttempt.updateInfoOnAMUnregister(event);
        }
    }

    private static final class AMUnregisteredTransition
    implements MultipleArcTransition<RMAppAttemptImpl, RMAppAttemptEvent, RMAppAttemptState> {
        private AMUnregisteredTransition() {
        }

        public RMAppAttemptState transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            if (appAttempt.getSubmissionContext().getUnmanagedAM()) {
                appAttempt.updateInfoOnAMUnregister(event);
                new FinalTransition(RMAppAttemptState.FINISHED).transition(appAttempt, event);
                return RMAppAttemptState.FINISHED;
            }
            appAttempt.rememberTargetTransitionsAndStoreState(event, new FinalStateSavedAfterAMUnregisterTransition(), RMAppAttemptState.FINISHING, RMAppAttemptState.FINISHED);
            ApplicationId applicationId = appAttempt.getAppAttemptId().getApplicationId();
            appAttempt.eventHandler.handle((Event)new RMAppEvent(applicationId, RMAppEventType.ATTEMPT_UNREGISTERED));
            return RMAppAttemptState.FINAL_SAVING;
        }
    }

    private static final class StatusUpdateTransition
    extends BaseTransition {
        private StatusUpdateTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptStatusupdateEvent statusUpdateEvent = (RMAppAttemptStatusupdateEvent)event;
            appAttempt.progress = statusUpdateEvent.getProgress();
            appAttempt.rmContext.getAMLivelinessMonitor().receivedPing(statusUpdateEvent.getApplicationAttemptId());
        }
    }

    private static class UnexpectedAMRegisteredTransition
    extends BaseFinalTransition {
        public UnexpectedAMRegisteredTransition() {
            super(RMAppAttemptState.FAILED);
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            assert (appAttempt.submissionContext.getUnmanagedAM());
            appAttempt.diagnostics.append(RMAppAttemptImpl.getUnexpectedAMRegisteredDiagnostics());
            super.transition(appAttempt, event);
        }
    }

    private static class ExpiredTransition
    extends FinalTransition {
        public ExpiredTransition() {
            super(RMAppAttemptState.FAILED);
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            appAttempt.diagnostics.append(RMAppAttemptImpl.getAMExpiredDiagnostics(event));
            super.transition(appAttempt, event);
        }
    }

    private static class FinalTransition
    extends BaseFinalTransition {
        public FinalTransition(RMAppAttemptState finalAttemptState) {
            super(finalAttemptState);
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            appAttempt.progress = 1.0f;
            super.transition(appAttempt, event);
            appAttempt.rmContext.getAMLivelinessMonitor().unregister(appAttempt.getAppAttemptId());
            appAttempt.rmContext.getAMFinishingMonitor().unregister(appAttempt.getAppAttemptId());
            if (!appAttempt.submissionContext.getUnmanagedAM()) {
                appAttempt.eventHandler.handle((Event)new AMLauncherEvent(AMLauncherEventType.CLEANUP, appAttempt));
            }
        }
    }

    private static final class AMContainerCrashedTransition
    extends BaseFinalTransition {
        public AMContainerCrashedTransition() {
            super(RMAppAttemptState.FAILED);
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptContainerFinishedEvent finishEvent = (RMAppAttemptContainerFinishedEvent)event;
            appAttempt.rmContext.getAMLivelinessMonitor().unregister(appAttempt.getAppAttemptId());
            appAttempt.diagnostics.append(RMAppAttemptImpl.getAMContainerCrashedDiagnostics(finishEvent));
            super.transition(appAttempt, finishEvent);
        }
    }

    private static final class AMRegisteredTransition
    extends BaseTransition {
        private AMRegisteredTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptRegistrationEvent registrationEvent = (RMAppAttemptRegistrationEvent)event;
            appAttempt.host = registrationEvent.getHost();
            appAttempt.rpcPort = registrationEvent.getRpcport();
            appAttempt.originalTrackingUrl = RMAppAttemptImpl.sanitizeTrackingUrl(registrationEvent.getTrackingurl());
            appAttempt.proxiedTrackingUrl = appAttempt.generateProxyUriWithScheme(appAttempt.originalTrackingUrl);
            appAttempt.eventHandler.handle((Event)new RMAppEvent(appAttempt.getAppAttemptId().getApplicationId(), RMAppEventType.ATTEMPT_REGISTERED));
        }
    }

    private static final class KillAllocatedAMTransition
    extends BaseFinalTransition {
        public KillAllocatedAMTransition() {
            super(RMAppAttemptState.KILLED);
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            super.transition(appAttempt, event);
            appAttempt.eventHandler.handle((Event)new AMLauncherEvent(AMLauncherEventType.CLEANUP, appAttempt));
        }
    }

    private static final class LaunchFailedTransition
    extends BaseFinalTransition {
        public LaunchFailedTransition() {
            super(RMAppAttemptState.FAILED);
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptLaunchFailedEvent launchFaileEvent = (RMAppAttemptLaunchFailedEvent)event;
            appAttempt.diagnostics.append(launchFaileEvent.getMessage());
            super.transition(appAttempt, event);
        }
    }

    private static final class UnmanagedAMAttemptSavedTransition
    extends AMLaunchedTransition {
        private UnmanagedAMAttemptSavedTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            appAttempt.checkAttemptStoreError(event);
            appAttempt.eventHandler.handle((Event)new RMAppEvent(event.getApplicationAttemptId().getApplicationId(), RMAppEventType.APP_ACCEPTED));
            super.transition(appAttempt, event);
        }
    }

    private static class AMLaunchedTransition
    extends BaseTransition {
        private AMLaunchedTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            appAttempt.attemptLaunched();
            appAttempt.rmContext.getClientToAMTokenSecretManager().registerApplication(appAttempt.getAppAttemptId(), appAttempt.getClientTokenMasterKey());
        }
    }

    private static class BaseFinalTransition
    extends BaseTransition {
        private final RMAppAttemptState finalAttemptState;

        public BaseFinalTransition(RMAppAttemptState finalAttemptState) {
            this.finalAttemptState = finalAttemptState;
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            ApplicationAttemptId appAttemptId = appAttempt.getAppAttemptId();
            appAttempt.masterService.unregisterAttempt(appAttemptId);
            ApplicationId applicationId = appAttemptId.getApplicationId();
            RMAppEvent appEvent = null;
            switch (this.finalAttemptState) {
                case FINISHED: {
                    appEvent = new RMAppFinishedAttemptEvent(applicationId, appAttempt.getDiagnostics());
                    break;
                }
                case KILLED: {
                    appAttempt.setTrackingUrlToRMAppPage();
                    appAttempt.invalidateAMHostAndPort();
                    appEvent = new RMAppFailedAttemptEvent(applicationId, RMAppEventType.ATTEMPT_KILLED, "Application killed by user.");
                    break;
                }
                case FAILED: {
                    appAttempt.setTrackingUrlToRMAppPage();
                    appAttempt.invalidateAMHostAndPort();
                    appEvent = new RMAppFailedAttemptEvent(applicationId, RMAppEventType.ATTEMPT_FAILED, appAttempt.getDiagnostics());
                    break;
                }
                default: {
                    LOG.error((Object)"Cannot get this state!! Error!!");
                }
            }
            appAttempt.eventHandler.handle((Event)appEvent);
            appAttempt.eventHandler.handle((Event)new AppAttemptRemovedSchedulerEvent(appAttemptId, this.finalAttemptState));
            appAttempt.removeCredentials(appAttempt);
        }
    }

    private static class FinalStateSavedTransition
    implements MultipleArcTransition<RMAppAttemptImpl, RMAppAttemptEvent, RMAppAttemptState> {
        private FinalStateSavedTransition() {
        }

        public RMAppAttemptState transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptUpdateSavedEvent storeEvent = (RMAppAttemptUpdateSavedEvent)event;
            if (storeEvent.getUpdatedException() != null) {
                LOG.error((Object)("Failed to update the final state of application attempt: " + storeEvent.getApplicationAttemptId()), (Throwable)storeEvent.getUpdatedException());
                ExitUtil.terminate((int)1, (Throwable)storeEvent.getUpdatedException());
            }
            RMAppAttemptEvent causeEvent = appAttempt.eventCausingFinalSaving;
            if (appAttempt.transitionTodo instanceof SingleArcTransition) {
                ((SingleArcTransition)appAttempt.transitionTodo).transition((Object)appAttempt, (Object)causeEvent);
            } else if (appAttempt.transitionTodo instanceof MultipleArcTransition) {
                ((MultipleArcTransition)appAttempt.transitionTodo).transition((Object)appAttempt, (Object)causeEvent);
            }
            return appAttempt.targetedFinalState;
        }
    }

    private static class FinalSavingTransition
    extends BaseTransition {
        Object transitionToDo;
        RMAppAttemptState targetedFinalState;

        public FinalSavingTransition(Object transitionToDo, RMAppAttemptState targetedFinalState) {
            this.transitionToDo = transitionToDo;
            this.targetedFinalState = targetedFinalState;
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            appAttempt.rememberTargetTransitionsAndStoreState(event, this.transitionToDo, this.targetedFinalState, this.targetedFinalState);
        }
    }

    private static class AttemptRecoveredTransition
    implements MultipleArcTransition<RMAppAttemptImpl, RMAppAttemptEvent, RMAppAttemptState> {
        private AttemptRecoveredTransition() {
        }

        public RMAppAttemptState transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            if (appAttempt.recoveredFinalState != null) {
                appAttempt.progress = 1.0f;
                RMApp rmApp = (RMApp)appAttempt.rmContext.getRMApps().get(appAttempt.getAppAttemptId().getApplicationId());
                if (rmApp.getCurrentAppAttempt() == appAttempt && !RMAppImpl.isAppInFinalState(rmApp)) {
                    new BaseFinalTransition(appAttempt.recoveredFinalState).transition(appAttempt, event);
                }
                return appAttempt.recoveredFinalState;
            }
            new AMLaunchedTransition().transition(appAttempt, event);
            return RMAppAttemptState.LAUNCHED;
        }
    }

    private static final class AttemptStoredTransition
    extends BaseTransition {
        private AttemptStoredTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            appAttempt.checkAttemptStoreError(event);
            appAttempt.launchAttempt();
        }
    }

    private static final class AMContainerAllocatedTransition
    extends BaseTransition {
        private AMContainerAllocatedTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            Allocation amContainerAllocation = appAttempt.scheduler.allocate(appAttempt.applicationAttemptId, EMPTY_CONTAINER_REQUEST_LIST, EMPTY_CONTAINER_RELEASE_LIST, null, null);
            assert (amContainerAllocation.getContainers().size() != 0);
            appAttempt.setMasterContainer(amContainerAllocation.getContainers().get(0));
            appAttempt.getSubmissionContext().setResource(appAttempt.getMasterContainer().getResource());
            appAttempt.storeAttempt();
        }
    }

    private static final class ScheduleTransition
    implements MultipleArcTransition<RMAppAttemptImpl, RMAppAttemptEvent, RMAppAttemptState> {
        private ScheduleTransition() {
        }

        public RMAppAttemptState transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            if (!appAttempt.submissionContext.getUnmanagedAM()) {
                appAttempt.eventHandler.handle((Event)new RMAppEvent(event.getApplicationAttemptId().getApplicationId(), RMAppEventType.APP_ACCEPTED));
                ResourceRequest request = BuilderUtils.newResourceRequest((Priority)AM_CONTAINER_PRIORITY, (String)"*", (Resource)appAttempt.getSubmissionContext().getResource(), (int)1);
                Allocation amContainerAllocation = appAttempt.scheduler.allocate(appAttempt.applicationAttemptId, Collections.singletonList(request), EMPTY_CONTAINER_RELEASE_LIST, null, null);
                if (amContainerAllocation != null && amContainerAllocation.getContainers() != null) assert (amContainerAllocation.getContainers().size() == 0);
                return RMAppAttemptState.SCHEDULED;
            }
            appAttempt.storeAttempt();
            return RMAppAttemptState.LAUNCHED_UNMANAGED_SAVING;
        }
    }

    private static final class AppRejectedTransition
    extends BaseTransition {
        private AppRejectedTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptRejectedEvent rejectedEvent = (RMAppAttemptRejectedEvent)event;
            appAttempt.masterService.unregisterAttempt(appAttempt.applicationAttemptId);
            String message = rejectedEvent.getMessage();
            appAttempt.diagnostics.append(message);
            appAttempt.eventHandler.handle((Event)new RMAppRejectedEvent(rejectedEvent.getApplicationAttemptId().getApplicationId(), message));
            appAttempt.removeCredentials(appAttempt);
        }
    }

    private static final class AttemptStartedTransition
    extends BaseTransition {
        private AttemptStartedTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            appAttempt.startTime = System.currentTimeMillis();
            appAttempt.masterService.registerAppAttempt(appAttempt.applicationAttemptId);
            if (UserGroupInformation.isSecurityEnabled()) {
                appAttempt.clientTokenMasterKey = appAttempt.rmContext.getClientToAMTokenSecretManager().createMasterKey(appAttempt.applicationAttemptId);
            }
            AMRMTokenIdentifier id = new AMRMTokenIdentifier(appAttempt.applicationAttemptId);
            appAttempt.amrmToken = new Token((TokenIdentifier)id, (SecretManager)appAttempt.rmContext.getAMRMTokenSecretManager());
            appAttempt.eventHandler.handle((Event)new AppAttemptAddedSchedulerEvent(appAttempt.applicationAttemptId, appAttempt.submissionContext.getQueue(), appAttempt.user));
        }
    }

    private static class BaseTransition
    implements SingleArcTransition<RMAppAttemptImpl, RMAppAttemptEvent> {
        private BaseTransition() {
        }

        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
        }
    }
}

