/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;

@Metrics(context="yarn")
@InterfaceAudience.Private
public class ClusterMetrics {
    private static AtomicBoolean isInitialized = new AtomicBoolean(false);
    @Metric(value={"# of active NMs"})
    MutableGaugeInt numActiveNMs;
    @Metric(value={"# of decommissioned NMs"})
    MutableGaugeInt numDecommissionedNMs;
    @Metric(value={"# of lost NMs"})
    MutableGaugeInt numLostNMs;
    @Metric(value={"# of unhealthy NMs"})
    MutableGaugeInt numUnhealthyNMs;
    @Metric(value={"# of Rebooted NMs"})
    MutableGaugeInt numRebootedNMs;
    private static final MetricsInfo RECORD_INFO = Interns.info((String)"ClusterMetrics", (String)"Metrics for the Yarn Cluster");
    private static volatile ClusterMetrics INSTANCE = null;
    private static MetricsRegistry registry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClusterMetrics getMetrics() {
        if (isInitialized.get()) return INSTANCE;
        Class<ClusterMetrics> clazz = ClusterMetrics.class;
        synchronized (ClusterMetrics.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ClusterMetrics();
            ClusterMetrics.registerMetrics();
            isInitialized.set(true);
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private static void registerMetrics() {
        registry = new MetricsRegistry(RECORD_INFO);
        registry.tag(RECORD_INFO, "ResourceManager");
        MetricsSystem ms = DefaultMetricsSystem.instance();
        if (ms != null) {
            ms.register("ClusterMetrics", "Metrics for the Yarn Cluster", (Object)INSTANCE);
        }
    }

    @VisibleForTesting
    static synchronized void destroy() {
        isInitialized.set(false);
        INSTANCE = null;
    }

    public int getNumActiveNMs() {
        return this.numActiveNMs.value();
    }

    public int getNumDecommisionedNMs() {
        return this.numDecommissionedNMs.value();
    }

    public void incrDecommisionedNMs() {
        this.numDecommissionedNMs.incr();
    }

    public void decrDecommisionedNMs() {
        this.numDecommissionedNMs.decr();
    }

    public int getNumLostNMs() {
        return this.numLostNMs.value();
    }

    public void incrNumLostNMs() {
        this.numLostNMs.incr();
    }

    public void decrNumLostNMs() {
        this.numLostNMs.decr();
    }

    public int getUnhealthyNMs() {
        return this.numUnhealthyNMs.value();
    }

    public void incrNumUnhealthyNMs() {
        this.numUnhealthyNMs.incr();
    }

    public void decrNumUnhealthyNMs() {
        this.numUnhealthyNMs.decr();
    }

    public int getNumRebootedNMs() {
        return this.numRebootedNMs.value();
    }

    public void incrNumRebootedNMs() {
        this.numRebootedNMs.incr();
    }

    public void decrNumRebootedNMs() {
        this.numRebootedNMs.decr();
    }

    public void incrNumActiveNodes() {
        this.numActiveNMs.incr();
    }

    public void decrNumActiveNodes() {
        this.numActiveNMs.decr();
    }
}

