/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.protobuf.BlockingService;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceStatus;
import org.apache.hadoop.ha.HealthCheckFailedException;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.ha.proto.HAServiceProtocolProtos;
import org.apache.hadoop.ha.protocolPB.HAServiceProtocolPB;
import org.apache.hadoop.ha.protocolPB.HAServiceProtocolServerSideTranslatorPB;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.api.ResourceManagerAdministrationProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshAdminAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshAdminAclsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshQueuesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshQueuesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshServiceAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshServiceAclsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshSuperUserGroupsConfigurationRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshSuperUserGroupsConfigurationResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshUserToGroupsMappingsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshUserToGroupsMappingsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdateNodeResourceRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdateNodeResourceResponse;
import org.apache.hadoop.yarn.server.resourcemanager.EmbeddedElectorService;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.security.authorize.RMPolicyProvider;

public class AdminService
extends CompositeService
implements HAServiceProtocol,
ResourceManagerAdministrationProtocol {
    private static final Log LOG = LogFactory.getLog(AdminService.class);
    private final RMContext rmContext;
    private final ResourceManager rm;
    private String rmId;
    private boolean autoFailoverEnabled;
    private RPC.Server server;
    private InetSocketAddress masterServiceAddress;
    private AccessControlList adminAcl;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    public AdminService(ResourceManager rm, RMContext rmContext) {
        super(AdminService.class.getName());
        this.rm = rm;
        this.rmContext = rmContext;
    }

    public synchronized void serviceInit(Configuration conf) throws Exception {
        if (this.rmContext.isHAEnabled()) {
            this.autoFailoverEnabled = HAUtil.isAutomaticFailoverEnabled((Configuration)conf);
            if (this.autoFailoverEnabled && HAUtil.isAutomaticFailoverEmbedded((Configuration)conf)) {
                this.addIfService((Object)this.createEmbeddedElectorService());
            }
        }
        this.masterServiceAddress = conf.getSocketAddr("yarn.resourcemanager.admin.address", "0.0.0.0:8033", 8033);
        this.adminAcl = new AccessControlList(conf.get("yarn.admin.acl", "*"));
        this.rmId = conf.get("yarn.resourcemanager.ha.id");
        super.serviceInit(conf);
    }

    protected synchronized void serviceStart() throws Exception {
        this.startServer();
        super.serviceStart();
    }

    protected synchronized void serviceStop() throws Exception {
        this.stopServer();
        super.serviceStop();
    }

    protected void startServer() throws Exception {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        this.server = (RPC.Server)rpc.getServer(ResourceManagerAdministrationProtocol.class, (Object)this, this.masterServiceAddress, conf, null, conf.getInt("yarn.resourcemanager.admin.client.thread-count", 1));
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.refreshServiceAcls(conf, new RMPolicyProvider());
        }
        if (this.rmContext.isHAEnabled()) {
            RPC.setProtocolEngine((Configuration)conf, HAServiceProtocolPB.class, ProtobufRpcEngine.class);
            HAServiceProtocolServerSideTranslatorPB haServiceProtocolXlator = new HAServiceProtocolServerSideTranslatorPB((HAServiceProtocol)this);
            BlockingService haPbService = HAServiceProtocolProtos.HAServiceProtocolService.newReflectiveBlockingService((HAServiceProtocolProtos.HAServiceProtocolService.BlockingInterface)haServiceProtocolXlator);
            this.server.addProtocol(RPC.RpcKind.RPC_PROTOCOL_BUFFER, HAServiceProtocol.class, (Object)haPbService);
        }
        this.server.start();
        conf.updateConnectAddr("yarn.resourcemanager.admin.address", this.server.getListenerAddress());
    }

    protected void stopServer() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    protected EmbeddedElectorService createEmbeddedElectorService() {
        return new EmbeddedElectorService(this.rmContext);
    }

    private UserGroupInformation checkAccess(String method) throws IOException {
        return RMServerUtils.verifyAccess(this.adminAcl, method, LOG);
    }

    private UserGroupInformation checkAcls(String method) throws YarnException {
        try {
            return this.checkAccess(method);
        }
        catch (IOException ioe) {
            throw RPCUtil.getRemoteException((Throwable)ioe);
        }
    }

    private void checkHaStateChange(HAServiceProtocol.StateChangeRequestInfo req) throws AccessControlException {
        switch (req.getSource()) {
            case REQUEST_BY_USER: {
                if (!this.autoFailoverEnabled) break;
                throw new AccessControlException("Manual failover for this ResourceManager is disallowed, because automatic failover is enabled.");
            }
            case REQUEST_BY_USER_FORCED: {
                if (!this.autoFailoverEnabled) break;
                LOG.warn((Object)("Allowing manual failover from " + Server.getRemoteAddress() + " even though automatic failover is enabled, because the user " + "specified the force flag"));
                break;
            }
            case REQUEST_BY_ZKFC: {
                if (this.autoFailoverEnabled) break;
                throw new AccessControlException("Request from ZK failover controller at " + Server.getRemoteAddress() + " denied " + "since automatic failover is not enabled");
            }
        }
    }

    private synchronized boolean isRMActive() {
        return HAServiceProtocol.HAServiceState.ACTIVE == this.rmContext.getHAServiceState();
    }

    private void throwStandbyException() throws StandbyException {
        throw new StandbyException("ResourceManager " + this.rmId + " is not Active!");
    }

    public synchronized void monitorHealth() throws IOException {
        this.checkAccess("monitorHealth");
        if (this.isRMActive() && !this.rm.areActiveServicesRunning()) {
            throw new HealthCheckFailedException("Active ResourceManager services are not running!");
        }
    }

    public synchronized void transitionToActive(HAServiceProtocol.StateChangeRequestInfo reqInfo) throws IOException {
        UserGroupInformation user = this.checkAccess("transitionToActive");
        this.checkHaStateChange(reqInfo);
        try {
            this.rm.transitionToActive();
            RMAuditLogger.logSuccess(user.getShortUserName(), "transitionToActive", "RMHAProtocolService");
        }
        catch (Exception e) {
            RMAuditLogger.logFailure(user.getShortUserName(), "transitionToActive", this.adminAcl.toString(), "RMHAProtocolService", "Exception transitioning to active");
            throw new ServiceFailedException("Error when transitioning to Active mode", (Throwable)e);
        }
    }

    public synchronized void transitionToStandby(HAServiceProtocol.StateChangeRequestInfo reqInfo) throws IOException {
        UserGroupInformation user = this.checkAccess("transitionToStandby");
        this.checkHaStateChange(reqInfo);
        try {
            this.rm.transitionToStandby(true);
            RMAuditLogger.logSuccess(user.getShortUserName(), "transitionToStandby", "RMHAProtocolService");
        }
        catch (Exception e) {
            RMAuditLogger.logFailure(user.getShortUserName(), "transitionToStandby", this.adminAcl.toString(), "RMHAProtocolService", "Exception transitioning to standby");
            throw new ServiceFailedException("Error when transitioning to Standby mode", (Throwable)e);
        }
    }

    public synchronized HAServiceStatus getServiceStatus() throws IOException {
        this.checkAccess("getServiceState");
        HAServiceProtocol.HAServiceState haState = this.rmContext.getHAServiceState();
        HAServiceStatus ret = new HAServiceStatus(haState);
        if (this.isRMActive() || haState == HAServiceProtocol.HAServiceState.STANDBY) {
            ret.setReadyToBecomeActive();
        } else {
            ret.setNotReadyToBecomeActive("State is " + haState);
        }
        return ret;
    }

    public RefreshQueuesResponse refreshQueues(RefreshQueuesRequest request) throws YarnException, StandbyException {
        UserGroupInformation user = this.checkAcls("refreshQueues");
        if (!this.isRMActive()) {
            RMAuditLogger.logFailure(user.getShortUserName(), "refreshQueues", this.adminAcl.toString(), "AdminService", "ResourceManager is not active. Can not refresh queues.");
            this.throwStandbyException();
        }
        try {
            this.rmContext.getScheduler().reinitialize(this.getConfig(), this.rmContext);
            RMAuditLogger.logSuccess(user.getShortUserName(), "refreshQueues", "AdminService");
            return (RefreshQueuesResponse)this.recordFactory.newRecordInstance(RefreshQueuesResponse.class);
        }
        catch (IOException ioe) {
            LOG.info((Object)"Exception refreshing queues ", (Throwable)ioe);
            RMAuditLogger.logFailure(user.getShortUserName(), "refreshQueues", this.adminAcl.toString(), "AdminService", "Exception refreshing queues");
            throw RPCUtil.getRemoteException((Throwable)ioe);
        }
    }

    public RefreshNodesResponse refreshNodes(RefreshNodesRequest request) throws YarnException, StandbyException {
        UserGroupInformation user = this.checkAcls("refreshNodes");
        if (!this.isRMActive()) {
            RMAuditLogger.logFailure(user.getShortUserName(), "refreshNodes", this.adminAcl.toString(), "AdminService", "ResourceManager is not active. Can not refresh nodes.");
            this.throwStandbyException();
        }
        try {
            this.rmContext.getNodesListManager().refreshNodes((Configuration)new YarnConfiguration());
            RMAuditLogger.logSuccess(user.getShortUserName(), "refreshNodes", "AdminService");
            return (RefreshNodesResponse)this.recordFactory.newRecordInstance(RefreshNodesResponse.class);
        }
        catch (IOException ioe) {
            LOG.info((Object)"Exception refreshing nodes ", (Throwable)ioe);
            RMAuditLogger.logFailure(user.getShortUserName(), "refreshNodes", this.adminAcl.toString(), "AdminService", "Exception refreshing nodes");
            throw RPCUtil.getRemoteException((Throwable)ioe);
        }
    }

    public RefreshSuperUserGroupsConfigurationResponse refreshSuperUserGroupsConfiguration(RefreshSuperUserGroupsConfigurationRequest request) throws YarnException, StandbyException {
        UserGroupInformation user = this.checkAcls("refreshSuperUserGroupsConfiguration");
        if (!this.isRMActive()) {
            RMAuditLogger.logFailure(user.getShortUserName(), "refreshSuperUserGroupsConfiguration", this.adminAcl.toString(), "AdminService", "ResourceManager is not active. Can not refresh super-user-groups.");
            this.throwStandbyException();
        }
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)new Configuration());
        RMAuditLogger.logSuccess(user.getShortUserName(), "refreshSuperUserGroupsConfiguration", "AdminService");
        return (RefreshSuperUserGroupsConfigurationResponse)this.recordFactory.newRecordInstance(RefreshSuperUserGroupsConfigurationResponse.class);
    }

    public RefreshUserToGroupsMappingsResponse refreshUserToGroupsMappings(RefreshUserToGroupsMappingsRequest request) throws YarnException, StandbyException {
        UserGroupInformation user = this.checkAcls("refreshUserToGroupsMappings");
        if (!this.isRMActive()) {
            RMAuditLogger.logFailure(user.getShortUserName(), "refreshUserToGroupsMapping", this.adminAcl.toString(), "AdminService", "ResourceManager is not active. Can not refresh user-groups.");
            this.throwStandbyException();
        }
        Groups.getUserToGroupsMappingService().refresh();
        RMAuditLogger.logSuccess(user.getShortUserName(), "refreshUserToGroupsMappings", "AdminService");
        return (RefreshUserToGroupsMappingsResponse)this.recordFactory.newRecordInstance(RefreshUserToGroupsMappingsResponse.class);
    }

    public RefreshAdminAclsResponse refreshAdminAcls(RefreshAdminAclsRequest request) throws YarnException {
        UserGroupInformation user = this.checkAcls("refreshAdminAcls");
        Configuration conf = new Configuration();
        this.adminAcl = new AccessControlList(conf.get("yarn.admin.acl", "*"));
        RMAuditLogger.logSuccess(user.getShortUserName(), "refreshAdminAcls", "AdminService");
        return (RefreshAdminAclsResponse)this.recordFactory.newRecordInstance(RefreshAdminAclsResponse.class);
    }

    public RefreshServiceAclsResponse refreshServiceAcls(RefreshServiceAclsRequest request) throws YarnException {
        Configuration conf = new Configuration();
        if (!conf.getBoolean("hadoop.security.authorization", false)) {
            throw RPCUtil.getRemoteException((Throwable)new IOException("Service Authorization (hadoop.security.authorization) not enabled."));
        }
        RMPolicyProvider policyProvider = new RMPolicyProvider();
        this.refreshServiceAcls(conf, policyProvider);
        if (this.isRMActive()) {
            this.rmContext.getClientRMService().refreshServiceAcls(conf, policyProvider);
            this.rmContext.getApplicationMasterService().refreshServiceAcls(conf, policyProvider);
            this.rmContext.getResourceTrackerService().refreshServiceAcls(conf, policyProvider);
        } else {
            LOG.warn((Object)"ResourceManager is not active. Not refreshing ACLs for Clients, ApplicationMasters and NodeManagers");
        }
        return (RefreshServiceAclsResponse)this.recordFactory.newRecordInstance(RefreshServiceAclsResponse.class);
    }

    void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAcl(configuration, policyProvider);
    }

    public String[] getGroupsForUser(String user) throws IOException {
        return UserGroupInformation.createRemoteUser((String)user).getGroupNames();
    }

    public UpdateNodeResourceResponse updateNodeResource(UpdateNodeResourceRequest request) throws YarnException, IOException {
        Map nodeResourceMap = request.getNodeResourceMap();
        Set nodeIds = nodeResourceMap.keySet();
        for (NodeId nodeId : nodeIds) {
            RMNode node = (RMNode)this.rmContext.getRMNodes().get(nodeId);
            if (node != null) continue;
            LOG.error((Object)("Resource update get failed on all nodes due to change resource on an unrecognized node: " + nodeId));
            throw RPCUtil.getRemoteException((String)("Resource update get failed on all nodes due to change resource on an unrecognized node: " + nodeId));
        }
        for (Map.Entry entry : nodeResourceMap.entrySet()) {
            ResourceOption newResourceOption = (ResourceOption)entry.getValue();
            NodeId nodeId = (NodeId)entry.getKey();
            RMNode node = (RMNode)this.rmContext.getRMNodes().get(nodeId);
            if (node == null) {
                LOG.warn((Object)("Resource update get failed on an unrecognized node: " + nodeId));
                continue;
            }
            node.setResourceOption(newResourceOption);
            LOG.info((Object)("Update resource successfully on node(" + node.getNodeID() + ") with resource(" + newResourceOption.toString() + ")"));
        }
        UpdateNodeResourceResponse response = (UpdateNodeResourceResponse)this.recordFactory.newRecordInstance(UpdateNodeResourceResponse.class);
        return response;
    }
}

