/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmapp;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.MockApps;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppFailedAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppFinishedAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppNewSavedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppRejectedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppUpdateSavedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptUpdateSavedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.AMRMTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class TestRMAppTransitions {
    static final Log LOG = LogFactory.getLog(TestRMAppTransitions.class);
    private boolean isSecurityEnabled;
    private Configuration conf;
    private RMContext rmContext;
    private static int maxAppAttempts = 2;
    private static int appId = 1;
    private DrainDispatcher rmDispatcher;
    private RMStateStore store;
    private YarnScheduler scheduler;

    @Parameterized.Parameters
    public static Collection<Object[]> getTestParameters() {
        return Arrays.asList({Boolean.FALSE}, {Boolean.TRUE});
    }

    public TestRMAppTransitions(boolean isSecurityEnabled) {
        this.isSecurityEnabled = isSecurityEnabled;
    }

    @Before
    public void setUp() throws Exception {
        this.conf = new YarnConfiguration();
        UserGroupInformation.AuthenticationMethod authMethod = UserGroupInformation.AuthenticationMethod.SIMPLE;
        if (this.isSecurityEnabled) {
            authMethod = UserGroupInformation.AuthenticationMethod.KERBEROS;
        }
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)authMethod, (Configuration)this.conf);
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        this.rmDispatcher = new DrainDispatcher();
        ContainerAllocationExpirer containerAllocationExpirer = (ContainerAllocationExpirer)Mockito.mock(ContainerAllocationExpirer.class);
        AMLivelinessMonitor amLivelinessMonitor = (AMLivelinessMonitor)Mockito.mock(AMLivelinessMonitor.class);
        AMLivelinessMonitor amFinishingMonitor = (AMLivelinessMonitor)Mockito.mock(AMLivelinessMonitor.class);
        this.store = (RMStateStore)Mockito.mock(RMStateStore.class);
        this.rmContext = new RMContextImpl((Dispatcher)this.rmDispatcher, containerAllocationExpirer, amLivelinessMonitor, amFinishingMonitor, null, new AMRMTokenSecretManager(this.conf), new RMContainerTokenSecretManager(this.conf), new NMTokenSecretManagerInRM(this.conf), new ClientToAMTokenSecretManagerInRM());
        ((RMContextImpl)this.rmContext).setStateStore(this.store);
        this.rmDispatcher.register(RMAppAttemptEventType.class, (EventHandler)new TestApplicationAttemptEventDispatcher(this.rmContext));
        this.rmDispatcher.register(RMAppEventType.class, (EventHandler)new TestApplicationEventDispatcher(this.rmContext));
        this.rmDispatcher.register(RMAppManagerEventType.class, (EventHandler)new TestApplicationManagerEventDispatcher());
        this.rmDispatcher.register(SchedulerEventType.class, (EventHandler)new TestSchedulerEventDispatcher());
        this.rmDispatcher.init(this.conf);
        this.rmDispatcher.start();
    }

    protected RMApp createNewTestApp(ApplicationSubmissionContext submissionContext) {
        ApplicationId applicationId = MockApps.newAppID((int)appId++);
        String user = MockApps.newUserName();
        String name = MockApps.newAppName();
        String queue = MockApps.newQueue();
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", maxAppAttempts);
        this.scheduler = (YarnScheduler)Mockito.mock(YarnScheduler.class);
        ApplicationMasterService masterService = new ApplicationMasterService(this.rmContext, this.scheduler);
        if (submissionContext == null) {
            submissionContext = new ApplicationSubmissionContextPBImpl();
        }
        submissionContext.setApplicationId(applicationId);
        RMAppImpl application = new RMAppImpl(applicationId, this.rmContext, this.conf, name, user, queue, submissionContext, this.scheduler, masterService, System.currentTimeMillis(), "YARN");
        TestRMAppTransitions.testAppStartState(applicationId, user, name, queue, (RMApp)application);
        this.rmContext.getRMApps().putIfAbsent(application.getApplicationId(), application);
        return application;
    }

    private static void testAppStartState(ApplicationId applicationId, String user, String name, String queue, RMApp application) {
        Assert.assertTrue((String)"application start time is not greater then 0", (application.getStartTime() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"application start time is before currentTime", (application.getStartTime() <= System.currentTimeMillis() ? 1 : 0) != 0);
        Assert.assertEquals((String)"application user is not correct", (String)user, (String)application.getUser());
        Assert.assertEquals((String)"application id is not correct", (Object)applicationId, (Object)application.getApplicationId());
        Assert.assertEquals((String)"application progress is not correct", (Object)Float.valueOf(0.0f), (Object)Float.valueOf(application.getProgress()));
        Assert.assertEquals((String)"application queue is not correct", (String)queue, (String)application.getQueue());
        Assert.assertEquals((String)"application name is not correct", (String)name, (String)application.getName());
        Assert.assertEquals((String)"application finish time is not 0 and should be", (long)0L, (long)application.getFinishTime());
        Assert.assertEquals((String)"application tracking url is not correct", null, (String)application.getTrackingUrl());
        StringBuilder diag = application.getDiagnostics();
        Assert.assertEquals((String)"application diagnostics is not correct", (int)0, (int)diag.length());
    }

    private static void assertStartTimeSet(RMApp application) {
        Assert.assertTrue((String)"application start time is not greater then 0", (application.getStartTime() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"application start time is before currentTime", (application.getStartTime() <= System.currentTimeMillis() ? 1 : 0) != 0);
    }

    private static void assertAppState(RMAppState state, RMApp application) {
        Assert.assertEquals((String)("application state should have been " + state), (Object)state, (Object)application.getState());
    }

    private static void assertFinalAppStatus(FinalApplicationStatus status, RMApp application) {
        Assert.assertEquals((String)("Final application status should have been " + status), (Object)status, (Object)application.getFinalApplicationStatus());
    }

    private void assertTimesAtFinish(RMApp application) {
        TestRMAppTransitions.assertStartTimeSet(application);
        Assert.assertTrue((String)"application finish time is not greater then 0", (application.getFinishTime() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"application finish time is not >= then start time", (application.getFinishTime() >= application.getStartTime() ? 1 : 0) != 0);
    }

    private void assertAppFinalStateSaved(RMApp application) {
        ((RMStateStore)Mockito.verify((Object)this.store, (VerificationMode)Mockito.times((int)1))).updateApplicationState((RMStateStore.ApplicationState)Matchers.any(RMStateStore.ApplicationState.class));
    }

    private void assertAppFinalStateNotSaved(RMApp application) {
        ((RMStateStore)Mockito.verify((Object)this.store, (VerificationMode)Mockito.times((int)0))).updateApplicationState((RMStateStore.ApplicationState)Matchers.any(RMStateStore.ApplicationState.class));
    }

    private void assertKilled(RMApp application) {
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.KILLED, application);
        TestRMAppTransitions.assertFinalAppStatus(FinalApplicationStatus.KILLED, application);
        StringBuilder diag = application.getDiagnostics();
        Assert.assertEquals((String)"application diagnostics is not correct", (String)"Application killed by user.", (String)diag.toString());
    }

    private void assertAppAndAttemptKilled(RMApp application) throws InterruptedException {
        this.sendAttemptUpdateSavedEvent(application);
        this.sendAppUpdateSavedEvent(application);
        this.assertKilled(application);
        Assert.assertEquals((Object)RMAppAttemptState.KILLED, (Object)application.getCurrentAppAttempt().getAppAttemptState());
        this.assertAppFinalStateSaved(application);
    }

    private void assertFailed(RMApp application, String regex) {
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.FAILED, application);
        TestRMAppTransitions.assertFinalAppStatus(FinalApplicationStatus.FAILED, application);
        StringBuilder diag = application.getDiagnostics();
        Assert.assertTrue((String)"application diagnostics is not correct", (boolean)diag.toString().matches(regex));
    }

    private void sendAppUpdateSavedEvent(RMApp application) {
        RMAppUpdateSavedEvent event = new RMAppUpdateSavedEvent(application.getApplicationId(), null);
        application.handle((Event)event);
        this.rmDispatcher.await();
    }

    private void sendAttemptUpdateSavedEvent(RMApp application) {
        application.getCurrentAppAttempt().handle((Event)new RMAppAttemptUpdateSavedEvent(application.getCurrentAppAttempt().getAppAttemptId(), null));
    }

    protected RMApp testCreateAppNewSaving(ApplicationSubmissionContext submissionContext) throws IOException {
        RMApp application = this.createNewTestApp(submissionContext);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.START);
        application.handle((Event)event);
        TestRMAppTransitions.assertStartTimeSet(application);
        TestRMAppTransitions.assertAppState(RMAppState.NEW_SAVING, application);
        return application;
    }

    protected RMApp testCreateAppSubmittedNoRecovery(ApplicationSubmissionContext submissionContext) throws IOException {
        RMApp application = this.testCreateAppNewSaving(submissionContext);
        RMAppNewSavedEvent event = new RMAppNewSavedEvent(application.getApplicationId(), null);
        application.handle((Event)event);
        TestRMAppTransitions.assertStartTimeSet(application);
        TestRMAppTransitions.assertAppState(RMAppState.SUBMITTED, application);
        return application;
    }

    protected RMApp testCreateAppSubmittedRecovery(ApplicationSubmissionContext submissionContext) throws IOException {
        RMApp application = this.createNewTestApp(submissionContext);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.RECOVER);
        application.handle((Event)event);
        TestRMAppTransitions.assertStartTimeSet(application);
        TestRMAppTransitions.assertAppState(RMAppState.SUBMITTED, application);
        return application;
    }

    protected RMApp testCreateAppAccepted(ApplicationSubmissionContext submissionContext) throws IOException {
        RMApp application = this.testCreateAppSubmittedNoRecovery(submissionContext);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.APP_ACCEPTED);
        application.handle((Event)event);
        TestRMAppTransitions.assertStartTimeSet(application);
        TestRMAppTransitions.assertAppState(RMAppState.ACCEPTED, application);
        return application;
    }

    protected RMApp testCreateAppRunning(ApplicationSubmissionContext submissionContext) throws IOException {
        RMApp application = this.testCreateAppAccepted(submissionContext);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_REGISTERED);
        application.handle((Event)event);
        TestRMAppTransitions.assertStartTimeSet(application);
        TestRMAppTransitions.assertAppState(RMAppState.RUNNING, application);
        TestRMAppTransitions.assertFinalAppStatus(FinalApplicationStatus.UNDEFINED, application);
        return application;
    }

    protected RMApp testCreateAppFinalSaving(ApplicationSubmissionContext submissionContext) throws IOException {
        RMApp application = this.testCreateAppRunning(submissionContext);
        RMAppEvent finishingEvent = new RMAppEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_UNREGISTERED);
        application.handle((Event)finishingEvent);
        TestRMAppTransitions.assertAppState(RMAppState.FINAL_SAVING, application);
        this.assertAppFinalStateSaved(application);
        return application;
    }

    protected RMApp testCreateAppFinishing(ApplicationSubmissionContext submissionContext) throws IOException {
        assert (submissionContext == null || !submissionContext.getUnmanagedAM());
        RMApp application = this.testCreateAppFinalSaving(submissionContext);
        RMAppUpdateSavedEvent appUpdated = new RMAppUpdateSavedEvent(application.getApplicationId(), null);
        application.handle((Event)appUpdated);
        TestRMAppTransitions.assertAppState(RMAppState.FINISHING, application);
        this.assertTimesAtFinish(application);
        return application;
    }

    protected RMApp testCreateAppFinished(ApplicationSubmissionContext submissionContext, String diagnostics) throws IOException {
        RMApp application = null;
        application = submissionContext != null && submissionContext.getUnmanagedAM() ? this.testCreateAppRunning(submissionContext) : this.testCreateAppFinishing(submissionContext);
        RMAppFinishedAttemptEvent finishedEvent = new RMAppFinishedAttemptEvent(application.getApplicationId(), diagnostics);
        application.handle((Event)finishedEvent);
        TestRMAppTransitions.assertAppState(RMAppState.FINISHED, application);
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertFinalAppStatus(FinalApplicationStatus.FAILED, application);
        Assert.assertTrue((String)"Finished app missing diagnostics", (application.getDiagnostics().indexOf(diagnostics) != -1 ? 1 : 0) != 0);
        return application;
    }

    @Test
    public void testUnmanagedApp() throws IOException {
        ApplicationSubmissionContextPBImpl subContext = new ApplicationSubmissionContextPBImpl();
        subContext.setUnmanagedAM(true);
        LOG.info((Object)"--- START: testUnmanagedAppSuccessPath ---");
        String diagMsg = "some diagnostics";
        RMApp application = this.testCreateAppFinished((ApplicationSubmissionContext)subContext, "some diagnostics");
        Assert.assertTrue((String)"Finished app missing diagnostics", (application.getDiagnostics().indexOf("some diagnostics") != -1 ? 1 : 0) != 0);
        LOG.info((Object)"--- START: testUnmanagedAppFailPath ---");
        application = this.testCreateAppRunning((ApplicationSubmissionContext)subContext);
        RMAppFailedAttemptEvent event = new RMAppFailedAttemptEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_FAILED, "");
        application.handle((Event)event);
        this.rmDispatcher.await();
        RMAppAttempt appAttempt = application.getCurrentAppAttempt();
        Assert.assertEquals((int)1, (int)appAttempt.getAppAttemptId().getAttemptId());
        this.sendAppUpdateSavedEvent(application);
        this.assertFailed(application, ".*Unmanaged application.*Failing the application.*");
        this.assertAppFinalStateSaved(application);
    }

    @Test
    public void testAppSuccessPath() throws IOException {
        LOG.info((Object)"--- START: testAppSuccessPath ---");
        String diagMsg = "some diagnostics";
        RMApp application = this.testCreateAppFinished(null, "some diagnostics");
        Assert.assertTrue((String)"Finished application missing diagnostics", (application.getDiagnostics().indexOf("some diagnostics") != -1 ? 1 : 0) != 0);
    }

    @Test(timeout=30000L)
    public void testAppRecoverPath() throws IOException {
        LOG.info((Object)"--- START: testAppRecoverPath ---");
        this.testCreateAppSubmittedRecovery(null);
    }

    @Test(timeout=30000L)
    public void testAppNewKill() throws IOException {
        LOG.info((Object)"--- START: testAppNewKill ---");
        RMApp application = this.createNewTestApp(null);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertKilled(application);
        this.assertAppFinalStateNotSaved(application);
    }

    @Test
    public void testAppNewReject() throws IOException {
        LOG.info((Object)"--- START: testAppNewReject ---");
        RMApp application = this.createNewTestApp(null);
        String rejectedText = "Test Application Rejected";
        RMAppRejectedEvent event = new RMAppRejectedEvent(application.getApplicationId(), rejectedText);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertFailed(application, rejectedText);
        this.assertAppFinalStateNotSaved(application);
    }

    @Test(timeout=30000L)
    public void testAppNewSavingKill() throws IOException {
        LOG.info((Object)"--- START: testAppNewSavingKill ---");
        RMApp application = this.testCreateAppNewSaving(null);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertKilled(application);
    }

    @Test(timeout=30000L)
    public void testAppNewSavingReject() throws IOException {
        LOG.info((Object)"--- START: testAppNewSavingReject ---");
        RMApp application = this.testCreateAppNewSaving(null);
        String rejectedText = "Test Application Rejected";
        RMAppRejectedEvent event = new RMAppRejectedEvent(application.getApplicationId(), rejectedText);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertFailed(application, rejectedText);
        this.assertAppFinalStateSaved(application);
    }

    @Test(timeout=30000L)
    public void testAppSubmittedRejected() throws IOException {
        LOG.info((Object)"--- START: testAppSubmittedRejected ---");
        RMApp application = this.testCreateAppSubmittedNoRecovery(null);
        String rejectedText = "app rejected";
        RMAppRejectedEvent event = new RMAppRejectedEvent(application.getApplicationId(), rejectedText);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertFailed(application, rejectedText);
        this.assertAppFinalStateSaved(application);
    }

    @Test
    public void testAppSubmittedKill() throws IOException, InterruptedException {
        LOG.info((Object)"--- START: testAppSubmittedKill---");
        RMApp application = this.testCreateAppSubmittedNoRecovery(null);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.assertAppAndAttemptKilled(application);
    }

    @Test
    public void testAppAcceptedFailed() throws IOException {
        RMAppFailedAttemptEvent event;
        LOG.info((Object)"--- START: testAppAcceptedFailed ---");
        RMApp application = this.testCreateAppAccepted(null);
        Assert.assertTrue((maxAppAttempts > 1 ? 1 : 0) != 0);
        for (int i = 1; i < maxAppAttempts; ++i) {
            event = new RMAppFailedAttemptEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_FAILED, "");
            application.handle((Event)event);
            TestRMAppTransitions.assertAppState(RMAppState.SUBMITTED, application);
            event = new RMAppEvent(application.getApplicationId(), RMAppEventType.APP_ACCEPTED);
            application.handle((Event)event);
            this.rmDispatcher.await();
            TestRMAppTransitions.assertAppState(RMAppState.ACCEPTED, application);
        }
        String message = "Test fail";
        event = new RMAppFailedAttemptEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_FAILED, message);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertFailed(application, ".*" + message + ".*Failing the application.*");
        this.assertAppFinalStateSaved(application);
    }

    @Test
    public void testAppAcceptedKill() throws IOException, InterruptedException {
        LOG.info((Object)"--- START: testAppAcceptedKill ---");
        RMApp application = this.testCreateAppAccepted(null);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.assertAppAndAttemptKilled(application);
    }

    @Test
    public void testAppRunningKill() throws IOException {
        LOG.info((Object)"--- START: testAppRunningKill ---");
        RMApp application = this.testCreateAppRunning(null);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL);
        application.handle((Event)event);
        this.rmDispatcher.await();
        TestRMAppTransitions.assertAppState(RMAppState.KILLING, application);
        RMAppFinishedAttemptEvent finishEvent = new RMAppFinishedAttemptEvent(application.getApplicationId(), null);
        application.handle((Event)finishEvent);
        TestRMAppTransitions.assertAppState(RMAppState.KILLING, application);
        this.sendAttemptUpdateSavedEvent(application);
        this.sendAppUpdateSavedEvent(application);
        this.assertKilled(application);
    }

    @Test
    public void testAppRunningFailed() throws IOException {
        LOG.info((Object)"--- START: testAppRunningFailed ---");
        RMApp application = this.testCreateAppRunning(null);
        RMAppAttempt appAttempt = application.getCurrentAppAttempt();
        int expectedAttemptId = 1;
        Assert.assertEquals((int)expectedAttemptId, (int)appAttempt.getAppAttemptId().getAttemptId());
        Assert.assertTrue((maxAppAttempts > 1 ? 1 : 0) != 0);
        for (int i = 1; i < maxAppAttempts; ++i) {
            RMAppFailedAttemptEvent event = new RMAppFailedAttemptEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_FAILED, "");
            application.handle((Event)event);
            this.rmDispatcher.await();
            TestRMAppTransitions.assertAppState(RMAppState.SUBMITTED, application);
            appAttempt = application.getCurrentAppAttempt();
            Assert.assertEquals((int)(++expectedAttemptId), (int)appAttempt.getAppAttemptId().getAttemptId());
            event = new RMAppEvent(application.getApplicationId(), RMAppEventType.APP_ACCEPTED);
            application.handle((Event)event);
            this.rmDispatcher.await();
            TestRMAppTransitions.assertAppState(RMAppState.ACCEPTED, application);
            event = new RMAppEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_REGISTERED);
            application.handle((Event)event);
            this.rmDispatcher.await();
            TestRMAppTransitions.assertAppState(RMAppState.RUNNING, application);
        }
        RMAppFailedAttemptEvent event = new RMAppFailedAttemptEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_FAILED, "");
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertFailed(application, ".*Failing the application.*");
        this.assertAppFinalStateSaved(application);
        event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.assertFailed(application, ".*Failing the application.*");
        this.assertAppFinalStateSaved(application);
    }

    @Test
    public void testAppAtFinishingIgnoreKill() throws IOException {
        LOG.info((Object)"--- START: testAppAtFinishingIgnoreKill ---");
        RMApp application = this.testCreateAppFinishing(null);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL);
        application.handle((Event)event);
        this.rmDispatcher.await();
        TestRMAppTransitions.assertAppState(RMAppState.FINISHING, application);
    }

    @Test
    public void testAppFinalSavingToFinished() throws IOException {
        LOG.info((Object)"--- START: testAppFinalSavingToFinished ---");
        RMApp application = this.testCreateAppFinalSaving(null);
        String diagMsg = "some diagnostics";
        RMAppFinishedAttemptEvent event = new RMAppFinishedAttemptEvent(application.getApplicationId(), "some diagnostics");
        application.handle((Event)event);
        TestRMAppTransitions.assertAppState(RMAppState.FINAL_SAVING, application);
        RMAppUpdateSavedEvent appUpdated = new RMAppUpdateSavedEvent(application.getApplicationId(), null);
        application.handle((Event)appUpdated);
        TestRMAppTransitions.assertAppState(RMAppState.FINISHED, application);
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertFinalAppStatus(FinalApplicationStatus.FAILED, application);
        Assert.assertTrue((String)"Finished app missing diagnostics", (application.getDiagnostics().indexOf("some diagnostics") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testAppFinishedFinished() throws IOException {
        LOG.info((Object)"--- START: testAppFinishedFinished ---");
        RMApp application = this.testCreateAppFinished(null, "");
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.FINISHED, application);
        StringBuilder diag = application.getDiagnostics();
        Assert.assertEquals((String)"application diagnostics is not correct", (String)"", (String)diag.toString());
    }

    @Test(timeout=30000L)
    public void testAppFailedFailed() throws IOException {
        LOG.info((Object)"--- START: testAppFailedFailed ---");
        RMApp application = this.testCreateAppNewSaving(null);
        RMAppRejectedEvent event = new RMAppRejectedEvent(application.getApplicationId(), "");
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.FAILED, application);
        event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.FAILED, application);
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.FAILED, application);
    }

    @Test(timeout=30000L)
    public void testAppKilledKilled() throws IOException {
        LOG.info((Object)"--- START: testAppKilledKilled ---");
        RMApp application = this.testCreateAppRunning(null);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAttemptUpdateSavedEvent(application);
        this.sendAppUpdateSavedEvent(application);
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.KILLED, application);
        event = new RMAppFinishedAttemptEvent(application.getApplicationId(), "");
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.KILLED, application);
        event = new RMAppFailedAttemptEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_FAILED, "");
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.KILLED, application);
        event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.KILLED, application);
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.KILLED, application);
    }

    @Test
    public void testGetAppReport() {
        RMApp app = this.createNewTestApp(null);
        TestRMAppTransitions.assertAppState(RMAppState.NEW, app);
        ApplicationReport report = app.createAndGetApplicationReport(null, true);
        Assert.assertNotNull((Object)report.getApplicationResourceUsageReport());
        report = app.createAndGetApplicationReport("clientuser", true);
        Assert.assertNotNull((Object)report.getApplicationResourceUsageReport());
    }

    private static final class TestSchedulerEventDispatcher
    implements EventHandler<SchedulerEvent> {
        private TestSchedulerEventDispatcher() {
        }

        public void handle(SchedulerEvent event) {
        }
    }

    private static final class TestApplicationManagerEventDispatcher
    implements EventHandler<RMAppManagerEvent> {
        private TestApplicationManagerEventDispatcher() {
        }

        public void handle(RMAppManagerEvent event) {
        }
    }

    private static final class TestApplicationEventDispatcher
    implements EventHandler<RMAppEvent> {
        private final RMContext rmContext;

        public TestApplicationEventDispatcher(RMContext rmContext) {
            this.rmContext = rmContext;
        }

        public void handle(RMAppEvent event) {
            ApplicationId appID = event.getApplicationId();
            RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(appID);
            if (rmApp != null) {
                try {
                    rmApp.handle((Event)event);
                }
                catch (Throwable t) {
                    LOG.error((Object)("Error in handling event type " + event.getType() + " for application " + appID), t);
                }
            }
        }
    }

    private static final class TestApplicationAttemptEventDispatcher
    implements EventHandler<RMAppAttemptEvent> {
        private final RMContext rmContext;

        public TestApplicationAttemptEventDispatcher(RMContext rmContext) {
            this.rmContext = rmContext;
        }

        public void handle(RMAppAttemptEvent event) {
            ApplicationId appId = event.getApplicationAttemptId().getApplicationId();
            RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(appId);
            if (rmApp != null) {
                try {
                    rmApp.getRMAppAttempt(event.getApplicationAttemptId()).handle((Event)event);
                }
                catch (Throwable t) {
                    LOG.error((Object)("Error in handling event type " + event.getType() + " for application " + appId), t);
                }
            }
        }
    }
}

