/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.ZKRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.RMStateVersion;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.RMStateVersionPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestZKRMStateStore
extends RMStateStoreTestBase {
    public static final Log LOG = LogFactory.getLog(TestZKRMStateStore.class);

    @Test(timeout=60000L)
    public void testZKRMStateStoreRealZK() throws Exception {
        TestZKRMStateStoreTester zkTester = new TestZKRMStateStoreTester();
        this.testRMAppStateStore(zkTester);
        this.testRMDTSecretManagerStateStore(zkTester);
        this.testCheckVersion(zkTester);
        this.testAppDeletion(zkTester);
    }

    private Configuration createHARMConf(String rmIds, String rmId, int adminPort) {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.set("yarn.resourcemanager.ha.rm-ids", rmIds);
        conf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        conf.set("yarn.resourcemanager.store.class", ZKRMStateStore.class.getName());
        conf.set("yarn.resourcemanager.zk-address", this.hostPort);
        conf.set("yarn.resourcemanager.ha.id", rmId);
        for (String rpcAddress : YarnConfiguration.RM_SERVICES_ADDRESS_CONF_KEYS) {
            for (String id : HAUtil.getRMHAIds((Configuration)conf)) {
                conf.set(HAUtil.addSuffix((String)rpcAddress, (String)id), "localhost:0");
            }
        }
        conf.set(HAUtil.addSuffix((String)"yarn.resourcemanager.admin.address", (String)rmId), "localhost:" + adminPort);
        return conf;
    }

    @Test
    public void testFencing() throws Exception {
        HAServiceProtocol.StateChangeRequestInfo req = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER);
        Configuration conf1 = this.createHARMConf("rm1,rm2", "rm1", 1234);
        ResourceManager rm1 = new ResourceManager();
        rm1.init(conf1);
        rm1.start();
        rm1.getRMContext().getRMAdminService().transitionToActive(req);
        Assert.assertEquals((String)"RM with ZKStore didn't start", (Object)Service.STATE.STARTED, (Object)rm1.getServiceState());
        Assert.assertEquals((String)"RM should be Active", (Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)rm1.getRMContext().getRMAdminService().getServiceStatus().getState());
        Configuration conf2 = this.createHARMConf("rm1,rm2", "rm2", 5678);
        ResourceManager rm2 = new ResourceManager();
        rm2.init(conf2);
        rm2.start();
        rm2.getRMContext().getRMAdminService().transitionToActive(req);
        Assert.assertEquals((String)"RM with ZKStore didn't start", (Object)Service.STATE.STARTED, (Object)rm2.getServiceState());
        Assert.assertEquals((String)"RM should be Active", (Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)rm2.getRMContext().getRMAdminService().getServiceStatus().getState());
        Map mockMap = (Map)Mockito.mock(Map.class);
        ApplicationSubmissionContext asc = ApplicationSubmissionContext.newInstance((ApplicationId)ApplicationId.newInstance((long)1000L, (int)1), (String)"testApplication", (String)"default", (Priority)Priority.newInstance((int)0), (ContainerLaunchContext)ContainerLaunchContext.newInstance((Map)mockMap, (Map)mockMap, new ArrayList(), (Map)mockMap, (ByteBuffer)((ByteBuffer)Mockito.mock(ByteBuffer.class)), (Map)mockMap), (boolean)false, (boolean)true, (int)1, (Resource)Resource.newInstance((int)1024, (int)1));
        ClientRMService rmService = rm1.getClientRMService();
        rmService.submitApplication(SubmitApplicationRequest.newInstance((ApplicationSubmissionContext)asc));
        for (int i = 0; i < 30; ++i) {
            if (HAServiceProtocol.HAServiceState.ACTIVE != rm1.getRMContext().getRMAdminService().getServiceStatus().getState()) continue;
            Thread.sleep(100L);
        }
        Assert.assertEquals((String)"RM should have been fenced", (Object)HAServiceProtocol.HAServiceState.STANDBY, (Object)rm1.getRMContext().getRMAdminService().getServiceStatus().getState());
        Assert.assertEquals((String)"RM should be Active", (Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)rm2.getRMContext().getRMAdminService().getServiceStatus().getState());
    }

    class TestZKRMStateStoreTester
    implements RMStateStoreTestBase.RMStateStoreHelper {
        ZooKeeper client;
        TestZKRMStateStoreInternal store;
        String workingZnode;

        TestZKRMStateStoreTester() {
        }

        @Override
        public RMStateStore getRMStateStore() throws Exception {
            YarnConfiguration conf = new YarnConfiguration();
            this.workingZnode = "/Test";
            conf.set("yarn.resourcemanager.zk-address", TestZKRMStateStore.this.hostPort);
            conf.set("yarn.resourcemanager.zk-state-store.parent-path", this.workingZnode);
            this.client = TestZKRMStateStore.this.createClient();
            this.store = new TestZKRMStateStoreInternal((Configuration)conf, this.workingZnode);
            return this.store;
        }

        @Override
        public boolean isFinalStateValid() throws Exception {
            List nodes = this.client.getChildren(this.store.znodeWorkingPath, false);
            return nodes.size() == 1;
        }

        @Override
        public void writeVersion(RMStateVersion version) throws Exception {
            this.client.setData(this.store.getVersionNode(), ((RMStateVersionPBImpl)version).getProto().toByteArray(), -1);
        }

        @Override
        public RMStateVersion getCurrentVersion() throws Exception {
            return this.store.getCurrentVersion();
        }

        @Override
        public boolean appExists(RMApp app) throws Exception {
            Stat node = this.client.exists(this.store.getAppNode(app.getApplicationId().toString()), false);
            return node != null;
        }

        class TestZKRMStateStoreInternal
        extends ZKRMStateStore {
            public TestZKRMStateStoreInternal(Configuration conf, String workingZnode) throws Exception {
                this.init(conf);
                this.start();
                Assert.assertTrue((boolean)this.znodeWorkingPath.equals(workingZnode));
            }

            public ZooKeeper getNewZooKeeper() throws IOException {
                return TestZKRMStateStoreTester.this.client;
            }

            public String getVersionNode() {
                return this.znodeWorkingPath + "/" + "ZKRMStateRoot" + "/" + "RMVersionNode";
            }

            public RMStateVersion getCurrentVersion() {
                return CURRENT_VERSION_INFO;
            }

            public String getAppNode(String appId) {
                return TestZKRMStateStoreTester.this.workingZnode + "/" + "ZKRMStateRoot" + "/" + "RMAppRoot" + "/" + appId;
            }
        }
    }
}

