/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.Application;
import org.apache.hadoop.yarn.server.resourcemanager.NodeManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.Task;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Priority;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestResourceManager {
    private static final Log LOG = LogFactory.getLog(TestResourceManager.class);
    private ResourceManager resourceManager = null;

    @Before
    public void setUp() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        this.resourceManager = new ResourceManager();
        this.resourceManager.init((Configuration)conf);
        this.resourceManager.getRMContainerTokenSecretManager().rollMasterKey();
        this.resourceManager.getRMNMTokenSecretManager().rollMasterKey();
    }

    @After
    public void tearDown() throws Exception {
    }

    private NodeManager registerNode(String hostName, int containerManagerPort, int httpPort, String rackName, Resource capability) throws IOException, YarnException {
        NodeManager nm = new NodeManager(hostName, containerManagerPort, httpPort, rackName, capability, this.resourceManager);
        NodeAddedSchedulerEvent nodeAddEvent1 = new NodeAddedSchedulerEvent((RMNode)this.resourceManager.getRMContext().getRMNodes().get(nm.getNodeId()));
        this.resourceManager.getResourceScheduler().handle((Event)nodeAddEvent1);
        return nm;
    }

    @Test
    public void testResourceAllocation() throws IOException, YarnException, InterruptedException {
        LOG.info((Object)"--- START: testResourceAllocation ---");
        int memory = 4096;
        int vcores = 4;
        String host1 = "host1";
        NodeManager nm1 = this.registerNode(host1, 1234, 2345, "/default-rack", Resources.createResource((int)4096, (int)4));
        String host2 = "host2";
        NodeManager nm2 = this.registerNode(host2, 1234, 2345, "/default-rack", Resources.createResource((int)2048, (int)2));
        Application application = new Application("user1", this.resourceManager);
        application.submit();
        application.addNodeManager(host1, 1234, nm1);
        application.addNodeManager(host2, 1234, nm2);
        int memory1 = 1024;
        Resource capability1 = Resources.createResource((int)1024, (int)1);
        org.apache.hadoop.yarn.api.records.Priority priority1 = Priority.create((int)1);
        application.addResourceRequestSpec(priority1, capability1);
        Task t1 = new Task(application, priority1, new String[]{host1, host2});
        application.addTask(t1);
        int memory2 = 2048;
        Resource capability2 = Resources.createResource((int)2048, (int)1);
        org.apache.hadoop.yarn.api.records.Priority priority0 = Priority.create((int)0);
        application.addResourceRequestSpec(priority0, capability2);
        application.schedule();
        this.nodeUpdate(nm1);
        application.schedule();
        this.checkResourceUsage(nm1, nm2);
        LOG.info((Object)"Adding new tasks...");
        Task t2 = new Task(application, priority1, new String[]{host1, host2});
        application.addTask(t2);
        Task t3 = new Task(application, priority0, new String[]{"*"});
        application.addTask(t3);
        application.schedule();
        this.checkResourceUsage(nm1, nm2);
        this.nodeUpdate(nm2);
        this.nodeUpdate(nm2);
        this.nodeUpdate(nm1);
        this.nodeUpdate(nm1);
        LOG.info((Object)"Trying to allocate...");
        application.schedule();
        this.checkResourceUsage(nm1, nm2);
        LOG.info((Object)"Finishing up tasks...");
        application.finishTask(t1);
        application.finishTask(t2);
        application.finishTask(t3);
        AppAttemptRemovedSchedulerEvent appRemovedEvent1 = new AppAttemptRemovedSchedulerEvent(application.getApplicationAttemptId(), RMAppAttemptState.FINISHED);
        this.resourceManager.getResourceScheduler().handle((Event)appRemovedEvent1);
        this.checkResourceUsage(nm1, nm2);
        LOG.info((Object)"--- END: testResourceAllocation ---");
    }

    private void nodeUpdate(NodeManager nm1) {
        RMNode node = (RMNode)this.resourceManager.getRMContext().getRMNodes().get(nm1.getNodeId());
        NodeUpdateSchedulerEvent nodeUpdate = new NodeUpdateSchedulerEvent(node);
        this.resourceManager.getResourceScheduler().handle((Event)nodeUpdate);
    }

    @Test
    public void testNodeHealthReportIsNotNull() throws Exception {
        String host1 = "host1";
        int memory = 4096;
        NodeManager nm1 = this.registerNode(host1, 1234, 2345, "/default-rack", Resources.createResource((int)4096, (int)1));
        nm1.heartbeat();
        nm1.heartbeat();
        Collection values = this.resourceManager.getRMContext().getRMNodes().values();
        for (RMNode ni : values) {
            Assert.assertNotNull((Object)ni.getHealthReport());
        }
    }

    private void checkResourceUsage(NodeManager ... nodes) {
        for (NodeManager nodeManager : nodes) {
            nodeManager.checkResourceUsage();
        }
    }

    @Test(timeout=30000L)
    public void testResourceManagerInitConfigValidation() throws Exception {
        block2: {
            YarnConfiguration conf = new YarnConfiguration();
            conf.setInt("yarn.resourcemanager.am.max-attempts", -1);
            this.resourceManager = new ResourceManager();
            try {
                this.resourceManager.init((Configuration)conf);
                Assert.fail((String)"Exception is expected because the global max attempts is negative.");
            }
            catch (YarnRuntimeException e) {
                if (e.getMessage().startsWith("Invalid global max attempts configuration")) break block2;
                throw e;
            }
        }
    }

    @Test
    public void testNMExpiryAndHeartbeatIntervalsValidation() throws Exception {
        block2: {
            YarnConfiguration conf = new YarnConfiguration();
            conf.setLong("yarn.nm.liveness-monitor.expiry-interval-ms", 1000L);
            conf.setLong("yarn.resourcemanager.nodemanagers.heartbeat-interval-ms", 1001L);
            this.resourceManager = new ResourceManager();
            try {
                this.resourceManager.init((Configuration)conf);
            }
            catch (YarnRuntimeException e) {
                if (e.getMessage().startsWith("Nodemanager expiry interval should be no less than heartbeat interval")) break block2;
                throw e;
            }
        }
    }
}

