/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HealthCheckFailedException;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRMHA {
    private Log LOG = LogFactory.getLog(TestRMHA.class);
    private final Configuration configuration = new YarnConfiguration();
    private MockRM rm = null;
    private static final String STATE_ERR = "ResourceManager is in wrong HA state";
    private static final String RM1_ADDRESS = "0.0.0.0:0";
    private static final String RM1_NODE_ID = "rm1";
    private static final String RM2_ADDRESS = "1.1.1.1:1";
    private static final String RM2_NODE_ID = "rm2";

    @Before
    public void setUp() throws Exception {
        this.configuration.setBoolean("yarn.resourcemanager.ha.enabled", true);
        this.configuration.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2");
        for (String confKey : YarnConfiguration.RM_SERVICES_ADDRESS_CONF_KEYS) {
            this.configuration.set(HAUtil.addSuffix((String)confKey, (String)RM1_NODE_ID), RM1_ADDRESS);
            this.configuration.set(HAUtil.addSuffix((String)confKey, (String)RM2_NODE_ID), RM2_ADDRESS);
        }
        this.configuration.set("yarn.resourcemanager.ha.id", RM1_NODE_ID);
    }

    private void checkMonitorHealth() throws IOException {
        try {
            this.rm.adminService.monitorHealth();
        }
        catch (HealthCheckFailedException e) {
            Assert.fail((String)"The RM is in bad health: it is Active, but the active services are not running");
        }
    }

    private void checkStandbyRMFunctionality() throws IOException {
        Assert.assertEquals((String)STATE_ERR, (Object)HAServiceProtocol.HAServiceState.STANDBY, (Object)this.rm.adminService.getServiceStatus().getState());
        Assert.assertFalse((String)"Active RM services are started", (boolean)this.rm.areActiveServicesRunning());
        Assert.assertTrue((String)"RM is not ready to become active", (boolean)this.rm.adminService.getServiceStatus().isReadyToBecomeActive());
    }

    private void checkActiveRMFunctionality() throws IOException {
        Assert.assertEquals((String)STATE_ERR, (Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)this.rm.adminService.getServiceStatus().getState());
        Assert.assertTrue((String)"Active RM services aren't started", (boolean)this.rm.areActiveServicesRunning());
        Assert.assertTrue((String)"RM is not ready to become active", (boolean)this.rm.adminService.getServiceStatus().isReadyToBecomeActive());
        try {
            this.rm.getNewAppId();
            this.rm.registerNode("127.0.0.1:0", 2048);
            this.rm.submitApp(1024);
        }
        catch (Exception e) {
            Assert.fail((String)"Unable to perform Active RM functions");
            this.LOG.error((Object)"ActiveRM check failed", (Throwable)e);
        }
    }

    @Test(timeout=30000L)
    public void testStartAndTransitions() throws IOException {
        YarnConfiguration conf = new YarnConfiguration(this.configuration);
        this.rm = new MockRM((Configuration)conf);
        this.rm.init((Configuration)conf);
        HAServiceProtocol.StateChangeRequestInfo requestInfo = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER);
        Assert.assertEquals((String)STATE_ERR, (Object)HAServiceProtocol.HAServiceState.INITIALIZING, (Object)this.rm.adminService.getServiceStatus().getState());
        Assert.assertFalse((String)"RM is ready to become active before being started", (boolean)this.rm.adminService.getServiceStatus().isReadyToBecomeActive());
        this.checkMonitorHealth();
        this.rm.start();
        this.checkMonitorHealth();
        this.checkStandbyRMFunctionality();
        this.rm.adminService.transitionToStandby(requestInfo);
        this.checkMonitorHealth();
        this.checkStandbyRMFunctionality();
        this.rm.adminService.transitionToActive(requestInfo);
        this.checkMonitorHealth();
        this.checkActiveRMFunctionality();
        this.rm.adminService.transitionToActive(requestInfo);
        this.checkMonitorHealth();
        this.checkActiveRMFunctionality();
        this.rm.adminService.transitionToStandby(requestInfo);
        this.checkMonitorHealth();
        this.checkStandbyRMFunctionality();
        this.rm.adminService.transitionToActive(requestInfo);
        this.checkMonitorHealth();
        this.checkActiveRMFunctionality();
        this.rm.stop();
        Assert.assertEquals((String)STATE_ERR, (Object)HAServiceProtocol.HAServiceState.STOPPING, (Object)this.rm.adminService.getServiceStatus().getState());
        Assert.assertFalse((String)"RM is ready to become active even after it is stopped", (boolean)this.rm.adminService.getServiceStatus().isReadyToBecomeActive());
        Assert.assertFalse((String)"Active RM services are started", (boolean)this.rm.areActiveServicesRunning());
        this.checkMonitorHealth();
    }

    @Test
    public void testTransitionsWhenAutomaticFailoverEnabled() throws IOException {
        String ERR_UNFORCED_REQUEST = "User request succeeded even when automatic failover is enabled";
        YarnConfiguration conf = new YarnConfiguration(this.configuration);
        conf.setBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", true);
        this.rm = new MockRM((Configuration)conf);
        this.rm.init((Configuration)conf);
        this.rm.start();
        HAServiceProtocol.StateChangeRequestInfo requestInfo = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER);
        try {
            this.rm.adminService.transitionToStandby(requestInfo);
            Assert.fail((String)"User request succeeded even when automatic failover is enabled");
        }
        catch (AccessControlException e) {
            // empty catch block
        }
        this.checkMonitorHealth();
        this.checkStandbyRMFunctionality();
        try {
            this.rm.adminService.transitionToActive(requestInfo);
            Assert.fail((String)"User request succeeded even when automatic failover is enabled");
        }
        catch (AccessControlException e) {
            // empty catch block
        }
        this.checkMonitorHealth();
        this.checkStandbyRMFunctionality();
        String ERR_FORCED_REQUEST = "Forced request by user should work even if automatic failover is enabled";
        requestInfo = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER_FORCED);
        try {
            this.rm.adminService.transitionToStandby(requestInfo);
        }
        catch (AccessControlException e) {
            Assert.fail((String)"Forced request by user should work even if automatic failover is enabled");
        }
        this.checkMonitorHealth();
        this.checkStandbyRMFunctionality();
        try {
            this.rm.adminService.transitionToActive(requestInfo);
        }
        catch (AccessControlException e) {
            Assert.fail((String)"Forced request by user should work even if automatic failover is enabled");
        }
        this.checkMonitorHealth();
        this.checkActiveRMFunctionality();
    }

    @Test
    public void testRMDispatcherForHA() throws IOException {
        String errorMessageForEventHandler = "Expect to get the same number of handlers";
        String errorMessageForService = "Expect to get the same number of services";
        YarnConfiguration conf = new YarnConfiguration(this.configuration);
        this.rm = new MockRM((Configuration)conf){

            protected Dispatcher createDispatcher() {
                return new MyCountingDispatcher();
            }
        };
        this.rm.init((Configuration)conf);
        int expectedEventHandlerCount = ((MyCountingDispatcher)this.rm.getRMContext().getDispatcher()).getEventHandlerCount();
        int expectedServiceCount = this.rm.getServices().size();
        Assert.assertTrue((expectedEventHandlerCount != 0 ? 1 : 0) != 0);
        HAServiceProtocol.StateChangeRequestInfo requestInfo = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER);
        Assert.assertEquals((String)STATE_ERR, (Object)HAServiceProtocol.HAServiceState.INITIALIZING, (Object)this.rm.adminService.getServiceStatus().getState());
        Assert.assertFalse((String)"RM is ready to become active before being started", (boolean)this.rm.adminService.getServiceStatus().isReadyToBecomeActive());
        this.rm.start();
        this.rm.adminService.transitionToStandby(requestInfo);
        this.rm.adminService.transitionToActive(requestInfo);
        this.rm.adminService.transitionToStandby(requestInfo);
        this.rm.adminService.transitionToActive(requestInfo);
        this.rm.adminService.transitionToStandby(requestInfo);
        this.rm.adminService.transitionToActive(requestInfo);
        Assert.assertEquals((String)errorMessageForEventHandler, (long)expectedEventHandlerCount, (long)((MyCountingDispatcher)this.rm.getRMContext().getDispatcher()).getEventHandlerCount());
        Assert.assertEquals((String)errorMessageForService, (long)expectedServiceCount, (long)this.rm.getServices().size());
        this.rm.adminService.transitionToStandby(requestInfo);
        Assert.assertEquals((String)errorMessageForEventHandler, (long)expectedEventHandlerCount, (long)((MyCountingDispatcher)this.rm.getRMContext().getDispatcher()).getEventHandlerCount());
        Assert.assertEquals((String)errorMessageForService, (long)expectedServiceCount, (long)this.rm.getServices().size());
        this.rm.stop();
    }

    class MyCountingDispatcher
    extends AbstractService
    implements Dispatcher {
        private int eventHandlerCount;

        public MyCountingDispatcher() {
            super("MyCountingDispatcher");
            this.eventHandlerCount = 0;
        }

        public EventHandler getEventHandler() {
            return null;
        }

        public void register(Class<? extends Enum> eventType, EventHandler handler) {
            ++this.eventHandlerCount;
        }

        public int getEventHandlerCount() {
            return this.eventHandlerCount;
        }
    }
}

