/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CyclicBarrier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.MockApps;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.NullRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.QueueACLsManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMDelegationTokenSecretManager;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestClientRMService {
    private static final Log LOG = LogFactory.getLog(TestClientRMService.class);
    private RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private String appType = "MockApp";
    private static RMDelegationTokenSecretManager dtsm;
    private static final String QUEUE_1 = "Q-1";
    private static final String QUEUE_2 = "Q-2";
    private static final UserGroupInformation owner;
    private static final UserGroupInformation other;

    @BeforeClass
    public static void setupSecretManager() throws IOException {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)new NullRMStateStore());
        dtsm = new RMDelegationTokenSecretManager(60000L, 60000L, 60000L, 60000L, rmContext);
        dtsm.startThreads();
    }

    @AfterClass
    public static void teardownSecretManager() {
        if (dtsm != null) {
            dtsm.stopThreads();
        }
    }

    @Test
    public void testGetClusterNodes() throws Exception {
        MockRM rm = new MockRM(){

            @Override
            protected ClientRMService createClientRMService() {
                return new ClientRMService((RMContext)this.rmContext, (YarnScheduler)this.scheduler, this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.getRMDTSecretManager());
            }
        };
        rm.start();
        MockNM node = rm.registerNode("host1:1234", 1024);
        rm.sendNodeStarted(node);
        node.nodeHeartbeat(true);
        MockNM lostNode = rm.registerNode("host2:1235", 1024);
        rm.sendNodeStarted(lostNode);
        lostNode.nodeHeartbeat(true);
        rm.NMwaitForState(lostNode.getNodeId(), NodeState.RUNNING);
        rm.sendNodeLost(lostNode);
        Configuration conf = new Configuration();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress rmAddress = rm.getClientRMService().getBindAddress();
        LOG.info((Object)("Connecting to ResourceManager at " + rmAddress));
        ApplicationClientProtocol client = (ApplicationClientProtocol)rpc.getProxy(ApplicationClientProtocol.class, rmAddress, conf);
        GetClusterNodesRequest request = GetClusterNodesRequest.newInstance(EnumSet.of(NodeState.RUNNING));
        List nodeReports = client.getClusterNodes(request).getNodeReports();
        junit.framework.Assert.assertEquals((int)1, (int)nodeReports.size());
        junit.framework.Assert.assertNotSame((String)"Node is expected to be healthy!", (Object)NodeState.UNHEALTHY, (Object)((NodeReport)nodeReports.get(0)).getNodeState());
        node.nodeHeartbeat(false);
        nodeReports = client.getClusterNodes(request).getNodeReports();
        junit.framework.Assert.assertEquals((String)"Unhealthy nodes should not show up by default", (int)0, (int)nodeReports.size());
        request = GetClusterNodesRequest.newInstance(EnumSet.of(NodeState.UNHEALTHY));
        nodeReports = client.getClusterNodes(request).getNodeReports();
        junit.framework.Assert.assertEquals((int)1, (int)nodeReports.size());
        junit.framework.Assert.assertEquals((String)"Node is expected to be unhealthy!", (Object)NodeState.UNHEALTHY, (Object)((NodeReport)nodeReports.get(0)).getNodeState());
        rm.registerNode("host3:1236", 1024);
        request = GetClusterNodesRequest.newInstance(EnumSet.allOf(NodeState.class));
        nodeReports = client.getClusterNodes(request).getNodeReports();
        junit.framework.Assert.assertEquals((int)3, (int)nodeReports.size());
    }

    @Test
    public void testGetApplicationReport() throws YarnException {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn(new ConcurrentHashMap());
        ClientRMService rmService = new ClientRMService(rmContext, null, null, null, null, null);
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        GetApplicationReportRequest request = (GetApplicationReportRequest)recordFactory.newRecordInstance(GetApplicationReportRequest.class);
        request.setApplicationId(ApplicationId.newInstance((long)0L, (int)0));
        try {
            rmService.getApplicationReport(request);
            junit.framework.Assert.fail();
        }
        catch (ApplicationNotFoundException ex) {
            junit.framework.Assert.assertEquals((String)ex.getMessage(), (String)("Application with id '" + request.getApplicationId() + "' doesn't exist in RM."));
        }
    }

    @Test
    public void testForceKillApplication() throws YarnException {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn(new ConcurrentHashMap());
        ClientRMService rmService = new ClientRMService(rmContext, null, null, null, null, null);
        ApplicationId applicationId = BuilderUtils.newApplicationId((long)System.currentTimeMillis(), (int)0);
        KillApplicationRequest request = KillApplicationRequest.newInstance((ApplicationId)applicationId);
        try {
            rmService.forceKillApplication(request);
            junit.framework.Assert.fail();
        }
        catch (ApplicationNotFoundException ex) {
            junit.framework.Assert.assertEquals((String)ex.getMessage(), (String)("Trying to kill an absent application " + request.getApplicationId()));
        }
    }

    @Test
    public void testGetQueueInfo() throws Exception {
        YarnScheduler yarnScheduler = (YarnScheduler)Mockito.mock(YarnScheduler.class);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(yarnScheduler, rmContext);
        ClientRMService rmService = new ClientRMService(rmContext, yarnScheduler, null, null, null, null);
        GetQueueInfoRequest request = (GetQueueInfoRequest)this.recordFactory.newRecordInstance(GetQueueInfoRequest.class);
        request.setQueueName("testqueue");
        request.setIncludeApplications(true);
        GetQueueInfoResponse queueInfo = rmService.getQueueInfo(request);
        List applications = queueInfo.getQueueInfo().getApplications();
        junit.framework.Assert.assertEquals((int)2, (int)applications.size());
        request.setQueueName("nonexistentqueue");
        request.setIncludeApplications(true);
        queueInfo = rmService.getQueueInfo(request);
    }

    @Test
    public void testTokenRenewalByOwner() throws Exception {
        owner.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TestClientRMService.this.checkTokenRenewal(owner, owner);
                return null;
            }
        });
    }

    @Test
    public void testTokenRenewalWrongUser() throws Exception {
        try {
            owner.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        TestClientRMService.this.checkTokenRenewal(owner, other);
                        return null;
                    }
                    catch (YarnException ex) {
                        junit.framework.Assert.assertTrue((boolean)ex.getMessage().contains("Client " + owner.getUserName() + " tries to renew a token with renewer specified as " + other.getUserName()));
                        throw ex;
                    }
                }
            });
        }
        catch (Exception e) {
            return;
        }
        junit.framework.Assert.fail((String)"renew should have failed");
    }

    @Test
    public void testTokenRenewalByLoginUser() throws Exception {
        UserGroupInformation.getLoginUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TestClientRMService.this.checkTokenRenewal(owner, owner);
                TestClientRMService.this.checkTokenRenewal(owner, other);
                return null;
            }
        });
    }

    private void checkTokenRenewal(UserGroupInformation owner, UserGroupInformation renewer) throws IOException, YarnException {
        RMDelegationTokenIdentifier tokenIdentifier = new RMDelegationTokenIdentifier(new Text(owner.getUserName()), new Text(renewer.getUserName()), null);
        Token token = new Token((TokenIdentifier)tokenIdentifier, (SecretManager)dtsm);
        org.apache.hadoop.yarn.api.records.Token dToken = BuilderUtils.newDelegationToken((byte[])token.getIdentifier(), (String)token.getKind().toString(), (byte[])token.getPassword(), (String)token.getService().toString());
        RenewDelegationTokenRequest request = (RenewDelegationTokenRequest)Records.newRecord(RenewDelegationTokenRequest.class);
        request.setDelegationToken(dToken);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        ClientRMService rmService = new ClientRMService(rmContext, null, null, null, null, dtsm);
        rmService.renewDelegationToken(request);
    }

    @Test(timeout=30000L)
    public void testAppSubmit() throws Exception {
        YarnScheduler yarnScheduler = TestClientRMService.mockYarnScheduler();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(yarnScheduler, rmContext);
        RMStateStore stateStore = (RMStateStore)Mockito.mock(RMStateStore.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)stateStore);
        RMAppManager appManager = new RMAppManager(rmContext, yarnScheduler, null, (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class), new Configuration());
        Mockito.when((Object)rmContext.getDispatcher().getEventHandler()).thenReturn((Object)new EventHandler<Event>(){

            public void handle(Event event) {
            }
        });
        ApplicationId appId1 = TestClientRMService.getApplicationId(100);
        ApplicationACLsManager mockAclsManager = (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class);
        Mockito.when((Object)mockAclsManager.checkAccess(UserGroupInformation.getCurrentUser(), ApplicationAccessType.VIEW_APP, null, appId1)).thenReturn((Object)true);
        QueueACLsManager mockQueueACLsManager = (QueueACLsManager)Mockito.mock(QueueACLsManager.class);
        Mockito.when((Object)mockQueueACLsManager.checkAccess((UserGroupInformation)Matchers.any(UserGroupInformation.class), (QueueACL)Matchers.any(QueueACL.class), Matchers.anyString())).thenReturn((Object)true);
        ClientRMService rmService = new ClientRMService(rmContext, yarnScheduler, appManager, mockAclsManager, mockQueueACLsManager, null);
        SubmitApplicationRequest submitRequest1 = this.mockSubmitAppRequest(appId1, null, null);
        try {
            rmService.submitApplication(submitRequest1);
        }
        catch (YarnException e) {
            junit.framework.Assert.fail((String)"Exception is not expected.");
        }
        RMApp app1 = (RMApp)rmContext.getRMApps().get(appId1);
        junit.framework.Assert.assertNotNull((String)"app doesn't exist", (Object)app1);
        junit.framework.Assert.assertEquals((String)"app name doesn't match", (String)"N/A", (String)app1.getName());
        junit.framework.Assert.assertEquals((String)"app queue doesn't match", (String)"default", (String)app1.getQueue());
        String name = MockApps.newAppName();
        String queue = MockApps.newQueue();
        ApplicationId appId2 = TestClientRMService.getApplicationId(101);
        SubmitApplicationRequest submitRequest2 = this.mockSubmitAppRequest(appId2, name, queue);
        submitRequest2.getApplicationSubmissionContext().setApplicationType("matchType");
        try {
            rmService.submitApplication(submitRequest2);
        }
        catch (YarnException e) {
            junit.framework.Assert.fail((String)"Exception is not expected.");
        }
        RMApp app2 = (RMApp)rmContext.getRMApps().get(appId2);
        junit.framework.Assert.assertNotNull((String)"app doesn't exist", (Object)app2);
        junit.framework.Assert.assertEquals((String)"app name doesn't match", (String)name, (String)app2.getName());
        junit.framework.Assert.assertEquals((String)"app queue doesn't match", (String)queue, (String)app2.getQueue());
        try {
            rmService.submitApplication(submitRequest2);
            junit.framework.Assert.fail((String)"Exception is expected.");
        }
        catch (YarnException e) {
            junit.framework.Assert.assertTrue((String)"The thrown exception is not expected.", (boolean)e.getMessage().contains("Cannot add a duplicate!"));
        }
        GetApplicationsRequest getAllAppsRequest = GetApplicationsRequest.newInstance(new HashSet());
        GetApplicationsResponse getAllApplicationsResponse = rmService.getApplications(getAllAppsRequest);
        junit.framework.Assert.assertEquals((int)5, (int)getAllApplicationsResponse.getApplicationList().size());
        HashSet<String> appTypes = new HashSet<String>();
        appTypes.add("matchType");
        getAllAppsRequest = GetApplicationsRequest.newInstance(appTypes);
        getAllApplicationsResponse = rmService.getApplications(getAllAppsRequest);
        junit.framework.Assert.assertEquals((int)1, (int)getAllApplicationsResponse.getApplicationList().size());
        junit.framework.Assert.assertEquals((Object)appId2, (Object)((ApplicationReport)getAllApplicationsResponse.getApplicationList().get(0)).getApplicationId());
    }

    @Test
    public void testGetApplications() throws IOException, YarnException {
        YarnScheduler yarnScheduler = TestClientRMService.mockYarnScheduler();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(yarnScheduler, rmContext);
        RMStateStore stateStore = (RMStateStore)Mockito.mock(RMStateStore.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)stateStore);
        RMAppManager appManager = new RMAppManager(rmContext, yarnScheduler, null, (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class), new Configuration());
        Mockito.when((Object)rmContext.getDispatcher().getEventHandler()).thenReturn((Object)new EventHandler<Event>(){

            public void handle(Event event) {
            }
        });
        ApplicationACLsManager mockAclsManager = (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class);
        QueueACLsManager mockQueueACLsManager = (QueueACLsManager)Mockito.mock(QueueACLsManager.class);
        Mockito.when((Object)mockQueueACLsManager.checkAccess((UserGroupInformation)Matchers.any(UserGroupInformation.class), (QueueACL)Matchers.any(QueueACL.class), Matchers.anyString())).thenReturn((Object)true);
        ClientRMService rmService = new ClientRMService(rmContext, yarnScheduler, appManager, mockAclsManager, mockQueueACLsManager, null);
        String[] queues = new String[]{QUEUE_1, QUEUE_2};
        String[] appNames = new String[]{MockApps.newAppName(), MockApps.newAppName(), MockApps.newAppName()};
        ApplicationId[] appIds = new ApplicationId[]{TestClientRMService.getApplicationId(101), TestClientRMService.getApplicationId(102), TestClientRMService.getApplicationId(103)};
        for (int i = 0; i < appIds.length; ++i) {
            ApplicationId appId = appIds[i];
            Mockito.when((Object)mockAclsManager.checkAccess(UserGroupInformation.getCurrentUser(), ApplicationAccessType.VIEW_APP, null, appId)).thenReturn((Object)true);
            SubmitApplicationRequest submitRequest = this.mockSubmitAppRequest(appId, appNames[i], queues[i % queues.length]);
            rmService.submitApplication(submitRequest);
        }
        GetApplicationsRequest request = GetApplicationsRequest.newInstance();
        Assert.assertEquals((String)"Incorrect total number of apps", (long)6L, (long)rmService.getApplications(request).getApplicationList().size());
        request.setLimit(1L);
        Assert.assertEquals((String)"Failed to limit applications", (long)1L, (long)rmService.getApplications(request).getApplicationList().size());
        request = GetApplicationsRequest.newInstance();
        HashSet<String> queueSet = new HashSet<String>();
        request.setQueues(queueSet);
        queueSet.add(queues[0]);
        Assert.assertEquals((String)"Incorrect number of applications in queue", (long)2L, (long)rmService.getApplications(request).getApplicationList().size());
        Assert.assertEquals((String)"Incorrect number of applications in queue", (long)2L, (long)rmService.getApplications(request, false).getApplicationList().size());
        queueSet.add(queues[1]);
        Assert.assertEquals((String)"Incorrect number of applications in queue", (long)3L, (long)rmService.getApplications(request).getApplicationList().size());
        request = GetApplicationsRequest.newInstance();
        HashSet<String> userSet = new HashSet<String>();
        request.setUsers(userSet);
        userSet.add("random-user-name");
        Assert.assertEquals((String)"Incorrect number of applications for user", (long)0L, (long)rmService.getApplications(request).getApplicationList().size());
        userSet.add(UserGroupInformation.getCurrentUser().getShortUserName());
        Assert.assertEquals((String)"Incorrect number of applications for user", (long)3L, (long)rmService.getApplications(request).getApplicationList().size());
    }

    @Test(timeout=4000L)
    public void testConcurrentAppSubmit() throws IOException, InterruptedException, BrokenBarrierException, YarnException {
        YarnScheduler yarnScheduler = TestClientRMService.mockYarnScheduler();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(yarnScheduler, rmContext);
        RMStateStore stateStore = (RMStateStore)Mockito.mock(RMStateStore.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)stateStore);
        RMAppManager appManager = new RMAppManager(rmContext, yarnScheduler, null, (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class), new Configuration());
        final ApplicationId appId1 = TestClientRMService.getApplicationId(100);
        ApplicationId appId2 = TestClientRMService.getApplicationId(101);
        final SubmitApplicationRequest submitRequest1 = this.mockSubmitAppRequest(appId1, null, null);
        SubmitApplicationRequest submitRequest2 = this.mockSubmitAppRequest(appId2, null, null);
        final CyclicBarrier startBarrier = new CyclicBarrier(2);
        final CyclicBarrier endBarrier = new CyclicBarrier(2);
        EventHandler eventHandler = new EventHandler(){

            public void handle(Event rawEvent) {
                RMAppEvent event;
                if (rawEvent instanceof RMAppEvent && (event = (RMAppEvent)rawEvent).getApplicationId().equals((Object)appId1)) {
                    try {
                        startBarrier.await();
                        endBarrier.await();
                    }
                    catch (BrokenBarrierException e) {
                        LOG.warn((Object)"Broken Barrier", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        LOG.warn((Object)"Interrupted while awaiting barriers", (Throwable)e);
                    }
                }
            }
        };
        Mockito.when((Object)rmContext.getDispatcher().getEventHandler()).thenReturn((Object)eventHandler);
        final ClientRMService rmService = new ClientRMService(rmContext, yarnScheduler, appManager, null, null, null);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    rmService.submitApplication(submitRequest1);
                }
                catch (YarnException yarnException) {
                    // empty catch block
                }
            }
        };
        t.start();
        startBarrier.await();
        rmService.submitApplication(submitRequest2);
        endBarrier.await();
        t.join();
    }

    private SubmitApplicationRequest mockSubmitAppRequest(ApplicationId appId, String name, String queue) {
        ContainerLaunchContext amContainerSpec = (ContainerLaunchContext)Mockito.mock(ContainerLaunchContext.class);
        Resource resource = Resources.createResource((int)1024);
        ApplicationSubmissionContext submissionContext = (ApplicationSubmissionContext)this.recordFactory.newRecordInstance(ApplicationSubmissionContext.class);
        submissionContext.setAMContainerSpec(amContainerSpec);
        submissionContext.setApplicationName(name);
        submissionContext.setQueue(queue);
        submissionContext.setApplicationId(appId);
        submissionContext.setResource(resource);
        submissionContext.setApplicationType(this.appType);
        SubmitApplicationRequest submitRequest = (SubmitApplicationRequest)this.recordFactory.newRecordInstance(SubmitApplicationRequest.class);
        submitRequest.setApplicationSubmissionContext(submissionContext);
        return submitRequest;
    }

    private void mockRMContext(YarnScheduler yarnScheduler, RMContext rmContext) throws IOException {
        Dispatcher dispatcher = (Dispatcher)Mockito.mock(Dispatcher.class);
        Mockito.when((Object)rmContext.getDispatcher()).thenReturn((Object)dispatcher);
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        Mockito.when((Object)dispatcher.getEventHandler()).thenReturn((Object)eventHandler);
        QueueInfo queInfo = (QueueInfo)this.recordFactory.newRecordInstance(QueueInfo.class);
        queInfo.setQueueName("testqueue");
        Mockito.when((Object)yarnScheduler.getQueueInfo((String)Matchers.eq((Object)"testqueue"), Matchers.anyBoolean(), Matchers.anyBoolean())).thenReturn((Object)queInfo);
        Mockito.when((Object)yarnScheduler.getQueueInfo((String)Matchers.eq((Object)"nonexistentqueue"), Matchers.anyBoolean(), Matchers.anyBoolean())).thenThrow(new Throwable[]{new IOException("queue does not exist")});
        ConcurrentHashMap<ApplicationId, RMApp> apps = this.getRMApps(rmContext, yarnScheduler);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn(apps);
        Mockito.when((Object)yarnScheduler.getAppsInQueue((String)Matchers.eq((Object)"testqueue"))).thenReturn(this.getSchedulerApps(apps));
    }

    private ConcurrentHashMap<ApplicationId, RMApp> getRMApps(RMContext rmContext, YarnScheduler yarnScheduler) {
        ConcurrentHashMap<ApplicationId, RMApp> apps = new ConcurrentHashMap<ApplicationId, RMApp>();
        ApplicationId applicationId1 = TestClientRMService.getApplicationId(1);
        ApplicationId applicationId2 = TestClientRMService.getApplicationId(2);
        ApplicationId applicationId3 = TestClientRMService.getApplicationId(3);
        YarnConfiguration config = new YarnConfiguration();
        apps.put(applicationId1, (RMApp)this.getRMApp(rmContext, yarnScheduler, applicationId1, config, "testqueue"));
        apps.put(applicationId2, (RMApp)this.getRMApp(rmContext, yarnScheduler, applicationId2, config, "a"));
        apps.put(applicationId3, (RMApp)this.getRMApp(rmContext, yarnScheduler, applicationId3, config, "testqueue"));
        return apps;
    }

    private List<ApplicationAttemptId> getSchedulerApps(Map<ApplicationId, RMApp> apps) {
        ArrayList<ApplicationAttemptId> schedApps = new ArrayList<ApplicationAttemptId>();
        schedApps.add(ApplicationAttemptId.newInstance((ApplicationId)TestClientRMService.getApplicationId(1), (int)0));
        schedApps.add(ApplicationAttemptId.newInstance((ApplicationId)TestClientRMService.getApplicationId(3), (int)0));
        return schedApps;
    }

    private static ApplicationId getApplicationId(int id) {
        return ApplicationId.newInstance((long)123456L, (int)id);
    }

    private static ApplicationAttemptId getApplicationAttemptId(int id) {
        return ApplicationAttemptId.newInstance((ApplicationId)TestClientRMService.getApplicationId(id), (int)1);
    }

    private RMAppImpl getRMApp(RMContext rmContext, YarnScheduler yarnScheduler, ApplicationId applicationId3, YarnConfiguration config, String queueName) {
        ApplicationSubmissionContext asContext = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        Mockito.when((Object)asContext.getMaxAppAttempts()).thenReturn((Object)1);
        RMAppImpl app = (RMAppImpl)Mockito.spy((Object)new RMAppImpl(applicationId3, rmContext, (Configuration)config, null, null, queueName, asContext, yarnScheduler, null, System.currentTimeMillis(), "YARN"));
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)applicationId3, (int)1);
        RMAppAttemptImpl rmAppAttemptImpl = new RMAppAttemptImpl(attemptId, rmContext, yarnScheduler, null, asContext, (Configuration)config, null);
        Mockito.when((Object)app.getCurrentAppAttempt()).thenReturn((Object)rmAppAttemptImpl);
        return app;
    }

    private static YarnScheduler mockYarnScheduler() {
        YarnScheduler yarnScheduler = (YarnScheduler)Mockito.mock(YarnScheduler.class);
        Mockito.when((Object)yarnScheduler.getMinimumResourceCapability()).thenReturn((Object)Resources.createResource((int)1024));
        Mockito.when((Object)yarnScheduler.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)8192));
        Mockito.when((Object)yarnScheduler.getAppsInQueue(QUEUE_1)).thenReturn(Arrays.asList(TestClientRMService.getApplicationAttemptId(101), TestClientRMService.getApplicationAttemptId(102)));
        Mockito.when((Object)yarnScheduler.getAppsInQueue(QUEUE_2)).thenReturn(Arrays.asList(TestClientRMService.getApplicationAttemptId(103)));
        return yarnScheduler;
    }

    static {
        owner = UserGroupInformation.createRemoteUser((String)"owner");
        other = UserGroupInformation.createRemoteUser((String)"other");
    }
}

