/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.util.Records;

public class MockAM {
    private volatile int responseId = 0;
    private final ApplicationAttemptId attemptId;
    private final RMContext context;
    private ApplicationMasterProtocol amRMProtocol;
    private final List<ResourceRequest> requests = new ArrayList<ResourceRequest>();
    private final List<ContainerId> releases = new ArrayList<ContainerId>();

    public MockAM(RMContext context, ApplicationMasterProtocol amRMProtocol, ApplicationAttemptId attemptId) {
        this.context = context;
        this.amRMProtocol = amRMProtocol;
        this.attemptId = attemptId;
    }

    void setAMRMProtocol(ApplicationMasterProtocol amRMProtocol) {
        this.amRMProtocol = amRMProtocol;
    }

    public void waitForState(RMAppAttemptState finalState) throws Exception {
        RMApp app = (RMApp)this.context.getRMApps().get(this.attemptId.getApplicationId());
        RMAppAttempt attempt = app.getRMAppAttempt(this.attemptId);
        int timeoutSecs = 0;
        while (!finalState.equals((Object)attempt.getAppAttemptState()) && timeoutSecs++ < 40) {
            System.out.println("AppAttempt : " + this.attemptId + " State is : " + attempt.getAppAttemptState() + " Waiting for state : " + finalState);
            Thread.sleep(1000L);
        }
        System.out.println("AppAttempt State is : " + attempt.getAppAttemptState());
        Assert.assertEquals((String)"AppAttempt state is not correct (timedout)", (Object)finalState, (Object)attempt.getAppAttemptState());
    }

    public RegisterApplicationMasterResponse registerAppAttempt() throws Exception {
        return this.registerAppAttempt(true);
    }

    public RegisterApplicationMasterResponse registerAppAttempt(boolean wait) throws Exception {
        if (wait) {
            this.waitForState(RMAppAttemptState.LAUNCHED);
        }
        this.responseId = 0;
        final RegisterApplicationMasterRequest req = (RegisterApplicationMasterRequest)Records.newRecord(RegisterApplicationMasterRequest.class);
        req.setHost("");
        req.setRpcPort(1);
        req.setTrackingUrl("");
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)this.attemptId.toString());
        Token token = ((RMApp)this.context.getRMApps().get(this.attemptId.getApplicationId())).getRMAppAttempt(this.attemptId).getAMRMToken();
        ugi.addTokenIdentifier(token.decodeIdentifier());
        try {
            return (RegisterApplicationMasterResponse)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<RegisterApplicationMasterResponse>(){

                @Override
                public RegisterApplicationMasterResponse run() throws Exception {
                    return MockAM.this.amRMProtocol.registerApplicationMaster(req);
                }
            });
        }
        catch (UndeclaredThrowableException e) {
            throw (Exception)e.getCause();
        }
    }

    public void addRequests(String[] hosts, int memory, int priority, int containers) throws Exception {
        this.requests.addAll(this.createReq(hosts, memory, priority, containers));
    }

    public AllocateResponse schedule() throws Exception {
        AllocateResponse response = this.allocate(this.requests, this.releases);
        this.requests.clear();
        this.releases.clear();
        return response;
    }

    public void addContainerToBeReleased(ContainerId containerId) {
        this.releases.add(containerId);
    }

    public AllocateResponse allocate(String host, int memory, int numContainers, List<ContainerId> releases) throws Exception {
        List<ResourceRequest> reqs = this.createReq(new String[]{host}, memory, 1, numContainers);
        return this.allocate(reqs, releases);
    }

    public List<ResourceRequest> createReq(String[] hosts, int memory, int priority, int containers) throws Exception {
        ArrayList<ResourceRequest> reqs = new ArrayList<ResourceRequest>();
        for (String host : hosts) {
            ResourceRequest hostReq = this.createResourceReq(host, memory, priority, containers);
            reqs.add(hostReq);
            ResourceRequest rackReq = this.createResourceReq("/default-rack", memory, priority, containers);
            reqs.add(rackReq);
        }
        ResourceRequest offRackReq = this.createResourceReq("*", memory, priority, containers);
        reqs.add(offRackReq);
        return reqs;
    }

    public ResourceRequest createResourceReq(String resource, int memory, int priority, int containers) throws Exception {
        ResourceRequest req = (ResourceRequest)Records.newRecord(ResourceRequest.class);
        req.setResourceName(resource);
        req.setNumContainers(containers);
        Priority pri = (Priority)Records.newRecord(Priority.class);
        pri.setPriority(priority);
        req.setPriority(pri);
        Resource capability = (Resource)Records.newRecord(Resource.class);
        capability.setMemory(memory);
        req.setCapability(capability);
        return req;
    }

    public AllocateResponse allocate(List<ResourceRequest> resourceRequest, List<ContainerId> releases) throws Exception {
        final AllocateRequest req = AllocateRequest.newInstance((int)(++this.responseId), (float)0.0f, resourceRequest, releases, null);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)this.attemptId.toString());
        Token token = ((RMApp)this.context.getRMApps().get(this.attemptId.getApplicationId())).getRMAppAttempt(this.attemptId).getAMRMToken();
        ugi.addTokenIdentifier(token.decodeIdentifier());
        try {
            return (AllocateResponse)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<AllocateResponse>(){

                @Override
                public AllocateResponse run() throws Exception {
                    return MockAM.this.amRMProtocol.allocate(req);
                }
            });
        }
        catch (UndeclaredThrowableException e) {
            throw (Exception)e.getCause();
        }
    }

    public void unregisterAppAttempt() throws Exception {
        this.waitForState(RMAppAttemptState.RUNNING);
        FinishApplicationMasterRequest req = FinishApplicationMasterRequest.newInstance((FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, (String)"", (String)"");
        this.unregisterAppAttempt(req);
    }

    public void unregisterAppAttempt(final FinishApplicationMasterRequest req) throws Exception {
        this.waitForState(RMAppAttemptState.RUNNING);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)this.attemptId.toString());
        Token token = ((RMApp)this.context.getRMApps().get(this.attemptId.getApplicationId())).getRMAppAttempt(this.attemptId).getAMRMToken();
        ugi.addTokenIdentifier(token.decodeIdentifier());
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                MockAM.this.amRMProtocol.finishApplicationMaster(req);
                return null;
            }
        });
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.attemptId;
    }
}

