/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.util.Properties;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.TestCase;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.security.authentication.KerberosTestUtils;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.KerberosAuthenticationHandler;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.junit.Ignore;
import org.mockito.Mockito;
import sun.security.jgss.GSSUtil;

@Ignore(value="requires kerberos setup")
public class TestKerberosAuthenticationHandler
extends TestCase {
    private KerberosAuthenticationHandler handler;

    protected void setUp() throws Exception {
        super.setUp();
        this.handler = new KerberosAuthenticationHandler();
        Properties props = new Properties();
        props.setProperty("kerberos.principal", KerberosTestUtils.getServerPrincipal());
        props.setProperty("kerberos.keytab", KerberosTestUtils.getKeytabFile());
        props.setProperty("kerberos.name.rules", "RULE:[1:$1@$0](.*@" + KerberosTestUtils.getRealm() + ")s/@.*//\n");
        try {
            this.handler.init(props);
        }
        catch (Exception ex) {
            this.handler = null;
            throw ex;
        }
    }

    protected void tearDown() throws Exception {
        if (this.handler != null) {
            this.handler.destroy();
            this.handler = null;
        }
        super.tearDown();
    }

    public void testInit() throws Exception {
        TestKerberosAuthenticationHandler.assertEquals((String)KerberosTestUtils.getServerPrincipal(), (String)this.handler.getPrincipal());
        TestKerberosAuthenticationHandler.assertEquals((String)KerberosTestUtils.getKeytabFile(), (String)this.handler.getKeytab());
    }

    public void testType() throws Exception {
        KerberosAuthenticationHandler handler = new KerberosAuthenticationHandler();
        TestKerberosAuthenticationHandler.assertEquals((String)"kerberos", (String)handler.getType());
    }

    public void testRequestWithoutAuthorization() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        TestKerberosAuthenticationHandler.assertNull((Object)this.handler.authenticate(request, response));
        ((HttpServletResponse)Mockito.verify((Object)response)).setHeader("WWW-Authenticate", "Negotiate");
        ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(401);
    }

    public void testRequestWithInvalidAuthorization() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getHeader("Authorization")).thenReturn((Object)"invalid");
        TestKerberosAuthenticationHandler.assertNull((Object)this.handler.authenticate(request, response));
        ((HttpServletResponse)Mockito.verify((Object)response)).setHeader("WWW-Authenticate", "Negotiate");
        ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(401);
    }

    public void testRequestWithIncompleteAuthorization() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getHeader("Authorization")).thenReturn((Object)"Negotiate");
        try {
            this.handler.authenticate(request, response);
            TestKerberosAuthenticationHandler.fail();
        }
        catch (AuthenticationException ex) {
        }
        catch (Exception ex) {
            TestKerberosAuthenticationHandler.fail();
        }
    }

    public void testRequestWithAuthorization() throws Exception {
        String token = KerberosTestUtils.doAsClient(new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() throws Exception {
                GSSManager gssManager = GSSManager.getInstance();
                GSSContext gssContext = null;
                try {
                    String servicePrincipal = KerberosTestUtils.getServerPrincipal();
                    GSSName serviceName = gssManager.createName(servicePrincipal, GSSUtil.NT_GSS_KRB5_PRINCIPAL);
                    gssContext = gssManager.createContext(serviceName, GSSUtil.GSS_KRB5_MECH_OID, null, 0);
                    gssContext.requestCredDeleg(true);
                    gssContext.requestMutualAuth(true);
                    byte[] inToken = new byte[]{};
                    byte[] outToken = gssContext.initSecContext(inToken, 0, inToken.length);
                    Base64 base64 = new Base64(0);
                    String string = base64.encodeToString(outToken);
                    return string;
                }
                finally {
                    if (gssContext != null) {
                        gssContext.dispose();
                    }
                }
            }
        });
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getHeader("Authorization")).thenReturn((Object)("Negotiate " + token));
        AuthenticationToken authToken = this.handler.authenticate(request, response);
        if (authToken != null) {
            ((HttpServletResponse)Mockito.verify((Object)response)).setHeader((String)Mockito.eq((Object)"WWW-Authenticate"), Mockito.matches((String)"Negotiate .*"));
            ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(200);
            TestKerberosAuthenticationHandler.assertEquals((String)KerberosTestUtils.getClientPrincipal(), (String)authToken.getName());
            TestKerberosAuthenticationHandler.assertTrue((boolean)KerberosTestUtils.getClientPrincipal().startsWith(authToken.getUserName()));
            TestKerberosAuthenticationHandler.assertEquals((String)"kerberos", (String)authToken.getType());
        } else {
            ((HttpServletResponse)Mockito.verify((Object)response)).setHeader((String)Mockito.eq((Object)"WWW-Authenticate"), Mockito.matches((String)"Negotiate .*"));
            ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(401);
        }
    }

    public void testRequestWithInvalidKerberosAuthorization() throws Exception {
        String token = new Base64(0).encodeToString(new byte[]{0, 1, 2});
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getHeader("Authorization")).thenReturn((Object)("Negotiate" + token));
        try {
            this.handler.authenticate(request, response);
            TestKerberosAuthenticationHandler.fail();
        }
        catch (AuthenticationException ex) {
        }
        catch (Exception ex) {
            TestKerberosAuthenticationHandler.fail();
        }
    }
}

