/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.NetUtilsTestResolver;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestNetUtils {
    static NetUtilsTestResolver resolver;
    static Configuration config;

    @Test
    public void testAvoidLoopbackTcpSockets() throws Exception {
        Configuration conf = new Configuration();
        Socket socket = NetUtils.getDefaultSocketFactory((Configuration)conf).createSocket();
        socket.bind(new InetSocketAddress("localhost", 0));
        System.err.println("local address: " + socket.getLocalAddress());
        System.err.println("local port: " + socket.getLocalPort());
        try {
            NetUtils.connect((Socket)socket, (SocketAddress)new InetSocketAddress(socket.getLocalAddress(), socket.getLocalPort()), (int)20000);
            socket.close();
            Assert.fail((String)"Should not have connected");
        }
        catch (ConnectException ce) {
            System.err.println("Got exception: " + ce);
            Assert.assertTrue((boolean)ce.getMessage().contains("resulted in a loopback"));
        }
        catch (SocketException se) {
            Assert.assertTrue((boolean)se.getMessage().contains("Invalid argument"));
        }
    }

    @BeforeClass
    public static void setupResolver() {
        resolver = NetUtilsTestResolver.install();
    }

    @Before
    public void resetResolver() {
        resolver.reset();
        config = new Configuration();
    }

    private void verifyGetByExactNameSearch(String host, String ... searches) {
        Assert.assertNull((Object)resolver.getByExactName(host));
        this.assertBetterArrayEquals(searches, resolver.getHostSearches());
    }

    @Test
    public void testResolverGetByExactNameUnqualified() {
        this.verifyGetByExactNameSearch("unknown", "unknown.");
    }

    @Test
    public void testResolverGetByExactNameUnqualifiedWithDomain() {
        this.verifyGetByExactNameSearch("unknown.domain", "unknown.domain.");
    }

    @Test
    public void testResolverGetByExactNameQualified() {
        this.verifyGetByExactNameSearch("unknown.", "unknown.");
    }

    @Test
    public void testResolverGetByExactNameQualifiedWithDomain() {
        this.verifyGetByExactNameSearch("unknown.domain.", "unknown.domain.");
    }

    private void verifyGetByNameWithSearch(String host, String ... searches) {
        Assert.assertNull((Object)resolver.getByNameWithSearch(host));
        this.assertBetterArrayEquals(searches, resolver.getHostSearches());
    }

    @Test
    public void testResolverGetByNameWithSearchUnqualified() {
        String host = "unknown";
        this.verifyGetByNameWithSearch(host, host + ".a.b.", host + ".b.", host + ".c.");
    }

    @Test
    public void testResolverGetByNameWithSearchUnqualifiedWithDomain() {
        String host = "unknown.domain";
        this.verifyGetByNameWithSearch(host, host + ".a.b.", host + ".b.", host + ".c.");
    }

    @Test
    public void testResolverGetByNameWithSearchQualified() {
        String host = "unknown.";
        this.verifyGetByNameWithSearch(host, host);
    }

    @Test
    public void testResolverGetByNameWithSearchQualifiedWithDomain() {
        String host = "unknown.domain.";
        this.verifyGetByNameWithSearch(host, host);
    }

    private void verifyGetByName(String host, String ... searches) {
        InetAddress addr = null;
        try {
            addr = resolver.getByName(host);
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        Assert.assertNull((Object)addr);
        this.assertBetterArrayEquals(searches, resolver.getHostSearches());
    }

    @Test
    public void testResolverGetByNameQualified() {
        String host = "unknown.";
        this.verifyGetByName(host, host);
    }

    @Test
    public void testResolverGetByNameQualifiedWithDomain() {
        this.verifyGetByName("unknown.domain.", "unknown.domain.");
    }

    @Test
    public void testResolverGetByNameUnqualified() {
        String host = "unknown";
        this.verifyGetByName(host, host + ".a.b.", host + ".b.", host + ".c.", host + ".");
    }

    @Test
    public void testResolverGetByNameUnqualifiedWithDomain() {
        String host = "unknown.domain";
        this.verifyGetByName(host, host + ".", host + ".a.b.", host + ".b.", host + ".c.");
    }

    private InetAddress verifyResolve(String host, String ... searches) {
        InetAddress addr = null;
        try {
            addr = resolver.getByName(host);
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        Assert.assertNotNull((Object)addr);
        this.assertBetterArrayEquals(searches, resolver.getHostSearches());
        return addr;
    }

    private void verifyInetAddress(InetAddress addr, String host, String ip) {
        Assert.assertNotNull((Object)addr);
        Assert.assertEquals((Object)host, (Object)addr.getHostName());
        Assert.assertEquals((Object)ip, (Object)addr.getHostAddress());
    }

    @Test
    public void testResolverUnqualified() {
        String host = "host";
        InetAddress addr = this.verifyResolve(host, host + ".a.b.");
        this.verifyInetAddress(addr, "host.a.b", "1.1.1.1");
    }

    @Test
    public void testResolverUnqualifiedWithDomain() {
        String host = "host.a";
        InetAddress addr = this.verifyResolve(host, host + ".", host + ".a.b.", host + ".b.");
        this.verifyInetAddress(addr, "host.a.b", "1.1.1.1");
    }

    @Test
    public void testResolverUnqualifedFull() {
        String host = "host.a.b";
        InetAddress addr = this.verifyResolve(host, host + ".");
        this.verifyInetAddress(addr, host, "1.1.1.1");
    }

    @Test
    public void testResolverQualifed() {
        String host = "host.a.b.";
        InetAddress addr = this.verifyResolve(host, host);
        this.verifyInetAddress(addr, host, "1.1.1.1");
    }

    @Test
    public void testResolverLoopback() {
        String host = "Localhost";
        InetAddress addr = this.verifyResolve(host, new String[0]);
        this.verifyInetAddress(addr, "Localhost", "127.0.0.1");
    }

    @Test
    public void testResolverIP() {
        String host = "1.1.1.1";
        InetAddress addr = this.verifyResolve(host, new String[0]);
        this.verifyInetAddress(addr, host, host);
    }

    @Test
    public void testCanonicalUriWithPort() {
        URI uri = NetUtils.getCanonicalUri((URI)URI.create("scheme://host:123"), (int)456);
        Assert.assertEquals((Object)"scheme://host.a.b:123", (Object)uri.toString());
        uri = NetUtils.getCanonicalUri((URI)URI.create("scheme://host:123/"), (int)456);
        Assert.assertEquals((Object)"scheme://host.a.b:123/", (Object)uri.toString());
        uri = NetUtils.getCanonicalUri((URI)URI.create("scheme://host:123/path"), (int)456);
        Assert.assertEquals((Object)"scheme://host.a.b:123/path", (Object)uri.toString());
        uri = NetUtils.getCanonicalUri((URI)URI.create("scheme://host:123/path?q#frag"), (int)456);
        Assert.assertEquals((Object)"scheme://host.a.b:123/path?q#frag", (Object)uri.toString());
    }

    @Test
    public void testCanonicalUriWithDefaultPort() {
        URI uri = NetUtils.getCanonicalUri((URI)URI.create("scheme://host"), (int)123);
        Assert.assertEquals((Object)"scheme://host.a.b:123", (Object)uri.toString());
        uri = NetUtils.getCanonicalUri((URI)URI.create("scheme://host/"), (int)123);
        Assert.assertEquals((Object)"scheme://host.a.b:123/", (Object)uri.toString());
        uri = NetUtils.getCanonicalUri((URI)URI.create("scheme://host/path"), (int)123);
        Assert.assertEquals((Object)"scheme://host.a.b:123/path", (Object)uri.toString());
        uri = NetUtils.getCanonicalUri((URI)URI.create("scheme://host/path?q#frag"), (int)123);
        Assert.assertEquals((Object)"scheme://host.a.b:123/path?q#frag", (Object)uri.toString());
    }

    @Test
    public void testCanonicalUriWithPath() {
        URI uri = NetUtils.getCanonicalUri((URI)URI.create("path"), (int)2);
        Assert.assertEquals((Object)"path", (Object)uri.toString());
        uri = NetUtils.getCanonicalUri((URI)URI.create("/path"), (int)2);
        Assert.assertEquals((Object)"/path", (Object)uri.toString());
    }

    @Test
    public void testCanonicalUriWithNoAuthority() {
        URI uri = NetUtils.getCanonicalUri((URI)URI.create("scheme:/"), (int)2);
        Assert.assertEquals((Object)"scheme:/", (Object)uri.toString());
        uri = NetUtils.getCanonicalUri((URI)URI.create("scheme:/path"), (int)2);
        Assert.assertEquals((Object)"scheme:/path", (Object)uri.toString());
        uri = NetUtils.getCanonicalUri((URI)URI.create("scheme:///"), (int)2);
        Assert.assertEquals((Object)"scheme:///", (Object)uri.toString());
        uri = NetUtils.getCanonicalUri((URI)URI.create("scheme:///path"), (int)2);
        Assert.assertEquals((Object)"scheme:///path", (Object)uri.toString());
    }

    @Test
    public void testCanonicalUriWithNoHost() {
        URI uri = NetUtils.getCanonicalUri((URI)URI.create("scheme://:123/path"), (int)2);
        Assert.assertEquals((Object)"scheme://:123/path", (Object)uri.toString());
    }

    @Test
    public void testCanonicalUriWithNoPortNoDefaultPort() {
        URI uri = NetUtils.getCanonicalUri((URI)URI.create("scheme://host/path"), (int)-1);
        Assert.assertEquals((Object)"scheme://host.a.b/path", (Object)uri.toString());
    }

    private <T> void assertBetterArrayEquals(T[] expect, T[] got) {
        String expectStr = StringUtils.join((Object[])expect, (String)", ");
        String gotStr = StringUtils.join((Object[])got, (String)", ");
        Assert.assertEquals((Object)expectStr, (Object)gotStr);
    }
}

