/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.ShuffleServerInstrumentation;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.Test;

public class TestShuffleExceptionCount {
    @Test
    public void testCheckException() throws IOException, InterruptedException {
        TestMapOutputServlet testServlet = new TestMapOutputServlet();
        JobConf conf = new JobConf();
        conf.setUser("testuser");
        conf.setJobName("testJob");
        conf.setSessionId("testSession");
        TaskTracker tt = new TaskTracker();
        tt.setConf(conf);
        ShuffleServerInstrumentation shuffleMetrics = ShuffleServerInstrumentation.create((TaskTracker)tt);
        String exceptionMsgRegex = "Broken pipe";
        String exceptionStackRegex = null;
        IOException ie = new IOException("EOFException");
        testServlet.checkException(ie, exceptionMsgRegex, exceptionStackRegex, shuffleMetrics);
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((MetricsSource)shuffleMetrics);
        MetricsAsserts.assertCounter("shuffle_exceptions_caught", 0, rb);
        ie = new IOException("Broken pipe");
        exceptionStackRegex = null;
        testServlet.checkException(ie, exceptionMsgRegex, exceptionStackRegex, shuffleMetrics);
        rb = MetricsAsserts.getMetrics((MetricsSource)shuffleMetrics);
        MetricsAsserts.assertCounter("shuffle_exceptions_caught", 1, rb);
        exceptionMsgRegex = null;
        exceptionStackRegex = null;
        testServlet.checkException(ie, exceptionMsgRegex, exceptionStackRegex, shuffleMetrics);
        rb = MetricsAsserts.getMetrics((MetricsSource)shuffleMetrics);
        MetricsAsserts.assertCounter("shuffle_exceptions_caught", 2, rb);
        exceptionMsgRegex = null;
        exceptionStackRegex = ".*\\.doesnt\\$SelectSet\\.wakeup.*";
        ie.setStackTrace(this.constructStackTrace());
        testServlet.checkException(ie, exceptionMsgRegex, exceptionStackRegex, shuffleMetrics);
        rb = MetricsAsserts.getMetrics((MetricsSource)shuffleMetrics);
        MetricsAsserts.assertCounter("shuffle_exceptions_caught", 2, rb);
        exceptionMsgRegex = null;
        exceptionStackRegex = ".*\\.SelectorManager\\$SelectSet\\.wakeup.*";
        testServlet.checkException(ie, exceptionMsgRegex, exceptionStackRegex, shuffleMetrics);
        rb = MetricsAsserts.getMetrics((MetricsSource)shuffleMetrics);
        MetricsAsserts.assertCounter("shuffle_exceptions_caught", 3, rb);
        exceptionMsgRegex = "Broken pipe";
        ie.setStackTrace(this.constructStackTraceTwo());
        testServlet.checkException(ie, exceptionMsgRegex, exceptionStackRegex, shuffleMetrics);
        rb = MetricsAsserts.getMetrics((MetricsSource)shuffleMetrics);
        MetricsAsserts.assertCounter("shuffle_exceptions_caught", 4, rb);
        exceptionStackRegex = ".*[1-9]+BOGUSREGEX";
        testServlet.checkException(ie, exceptionMsgRegex, exceptionStackRegex, shuffleMetrics);
        rb = MetricsAsserts.getMetrics((MetricsSource)shuffleMetrics);
        MetricsAsserts.assertCounter("shuffle_exceptions_caught", 4, rb);
        exceptionStackRegex = ".*\\.SelectorManager\\$SelectSet\\.wakeup.*";
        exceptionMsgRegex = "EOFException";
        testServlet.checkException(ie, exceptionMsgRegex, exceptionStackRegex, shuffleMetrics);
        rb = MetricsAsserts.getMetrics((MetricsSource)shuffleMetrics);
        MetricsAsserts.assertCounter("shuffle_exceptions_caught", 4, rb);
    }

    private StackTraceElement[] constructStackTrace() {
        StackTraceElement[] stack = new StackTraceElement[]{new StackTraceElement("sun.nio.ch.EPollArrayWrapper", "interrupt", "", -2), new StackTraceElement("sun.nio.ch.EPollArrayWrapper", "interrupt", "EPollArrayWrapper.java", 256), new StackTraceElement("sun.nio.ch.EPollSelectorImpl", "wakeup", "EPollSelectorImpl.java", 175), new StackTraceElement("org.mortbay.io.nio.SelectorManager$SelectSet", "wakeup", "SelectorManager.java", 831), new StackTraceElement("org.mortbay.io.nio.SelectorManager$SelectSet", "doSelect", "SelectorManager.java", 709), new StackTraceElement("org.mortbay.io.nio.SelectorManager", "doSelect", "SelectorManager.java", 192), new StackTraceElement("org.mortbay.jetty.nio.SelectChannelConnector", "accept", "SelectChannelConnector.java", 124), new StackTraceElement("org.mortbay.jetty.AbstractConnector$Acceptor", "run", "AbstractConnector.java", 708), new StackTraceElement("org.mortbay.thread.QueuedThreadPool$PoolThread", "run", "QueuedThreadPool.java", 582)};
        return stack;
    }

    private StackTraceElement[] constructStackTraceTwo() {
        StackTraceElement[] stack = new StackTraceElement[]{new StackTraceElement("sun.nio.ch.EPollArrayWrapper", "interrupt", "", -2), new StackTraceElement("sun.nio.ch.EPollArrayWrapper", "interrupt", "EPollArrayWrapper.java", 256), new StackTraceElement("sun.nio.ch.EPollSelectorImpl", "wakeup", "EPollSelectorImpl.java", 175), new StackTraceElement("org.mortbay.io.nio.SelectorManager$SelectSet", "wakeup", "SelectorManager.java", 831), new StackTraceElement("org.mortbay.io.nio.SelectChannelEndPoint", "updateKey", "SelectChannelEndPoint.java", 335), new StackTraceElement("org.mortbay.io.nio.SelectChannelEndPoint", "blockWritable", "SelectChannelEndPoint.java", 278), new StackTraceElement("org.mortbay.jetty.AbstractGenerator$Output", "blockForOutput", "AbstractGenerator.java", 545), new StackTraceElement("org.mortbay.jetty.AbstractGenerator$Output", "flush", "AbstractGenerator.java", 572), new StackTraceElement("org.mortbay.jetty.HttpConnection$Output", "flush", "HttpConnection.java", 1012), new StackTraceElement("org.mortbay.jetty.AbstractGenerator$Output", "write", "AbstractGenerator.java", 651), new StackTraceElement("org.mortbay.jetty.AbstractGenerator$Output", "write", "AbstractGenerator.java", 580)};
        return stack;
    }

    public static class TestMapOutputServlet
    extends TaskTracker.MapOutputServlet {
        public void checkException(IOException ie, String exceptionMsgRegex, String exceptionStackRegex, ShuffleServerInstrumentation shuffleMetrics) {
            super.checkException(ie, exceptionMsgRegex, exceptionStackRegex, shuffleMetrics);
        }
    }
}

