/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;

public class TestWritable
extends TestCase {
    public TestWritable(String name) {
        super(name);
    }

    public void testSimpleWritable() throws Exception {
        TestWritable.testWritable(new SimpleWritable());
    }

    public void testByteWritable() throws Exception {
        TestWritable.testWritable((Writable)new ByteWritable(-128));
    }

    public void testDoubleWritable() throws Exception {
        TestWritable.testWritable((Writable)new DoubleWritable(1.0));
    }

    public static Writable testWritable(Writable before) throws Exception {
        return TestWritable.testWritable(before, null);
    }

    public static Writable testWritable(Writable before, Configuration conf) throws Exception {
        DataOutputBuffer dob = new DataOutputBuffer();
        before.write((DataOutput)dob);
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(dob.getData(), dob.getLength());
        Writable after = (Writable)ReflectionUtils.newInstance(before.getClass(), (Configuration)conf);
        after.readFields((DataInput)dib);
        TestWritable.assertEquals((Object)before, (Object)after);
        return after;
    }

    public static class SimpleWritable
    implements Writable {
        private static final Random RANDOM = new Random();
        int state = RANDOM.nextInt();

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.state);
        }

        public void readFields(DataInput in) throws IOException {
            this.state = in.readInt();
        }

        public static SimpleWritable read(DataInput in) throws IOException {
            SimpleWritable result = new SimpleWritable();
            result.readFields(in);
            return result;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SimpleWritable)) {
                return false;
            }
            SimpleWritable other = (SimpleWritable)o;
            return this.state == other.state;
        }
    }
}

