/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.metrics;

import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeInstrumentation;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.test.MetricsAsserts;

public class TestNNMetricFilesInGetListingOps
extends TestCase {
    private static final Configuration CONF = new Configuration();
    private MiniDFSCluster cluster;
    private NameNodeInstrumentation nnMetrics;
    private DistributedFileSystem fs;
    private Random rand = new Random();

    protected void setUp() throws Exception {
        this.cluster = new MiniDFSCluster(CONF, 1, true, null);
        this.cluster.waitActive();
        this.cluster.getNameNode();
        this.nnMetrics = NameNode.getNameNodeMetrics();
        this.fs = (DistributedFileSystem)this.cluster.getFileSystem();
    }

    protected void tearDown() throws Exception {
        this.cluster.shutdown();
    }

    private void createFile(String fileName, long fileLen, short replicas) throws IOException {
        Path filePath = new Path(fileName);
        DFSTestUtil.createFile((FileSystem)this.fs, filePath, fileLen, replicas, this.rand.nextLong());
    }

    public void testFilesInGetListingOps() throws Exception {
        this.createFile("/tmp1/t1", 3200L, (short)3);
        this.createFile("/tmp1/t2", 3200L, (short)3);
        this.createFile("/tmp2/t1", 3200L, (short)3);
        this.createFile("/tmp2/t2", 3200L, (short)3);
        this.cluster.getNameNode().getListing("/tmp1", HdfsFileStatus.EMPTY_NAME);
        MetricsAsserts.assertCounter("FilesInGetListingOps", 2, (MetricsSource)this.nnMetrics);
        this.cluster.getNameNode().getListing("/tmp2", HdfsFileStatus.EMPTY_NAME);
        MetricsAsserts.assertCounter("FilesInGetListingOps", 4, (MetricsSource)this.nnMetrics);
        this.cluster.getNameNode().getListing("/tmp", HdfsFileStatus.EMPTY_NAME);
        MetricsAsserts.assertCounter("FilesInGetListingOps", 4, (MetricsSource)this.nnMetrics);
        this.cluster.getNameNode().getListing("/tmp1/t1", HdfsFileStatus.EMPTY_NAME);
        MetricsAsserts.assertCounter("FilesInGetListingOps", 5, (MetricsSource)this.nnMetrics);
    }

    static {
        CONF.setLong("dfs.block.size", 100L);
        CONF.setInt("io.bytes.per.checksum", 1);
        CONF.setLong("dfs.heartbeat.interval", 1L);
        CONF.setInt("dfs.replication.interval", 1);
    }
}

