/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.FSDataset;
import org.apache.hadoop.hdfs.server.datanode.FSDatasetTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImageAdapter;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.log4j.Level;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestFileAppend4
extends TestCase {
    static final Log LOG = LogFactory.getLog(TestFileAppend4.class);
    static final long BLOCK_SIZE = 1024L;
    static final long BBW_SIZE = 500L;
    static final Object[] NO_ARGS = new Object[0];
    Configuration conf;
    MiniDFSCluster cluster;
    Path file1;
    FSDataOutputStream stm;
    boolean simulatedStorage = false;

    public TestFileAppend4() {
        ((Log4JLogger)NameNode.stateChangeLog).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LeaseManager.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)FSNamesystem.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)DataNode.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)DFSClient.LOG).getLogger().setLevel(Level.ALL);
    }

    public void setUp() throws Exception {
        this.conf = new Configuration();
        if (this.simulatedStorage) {
            this.conf.setBoolean("dfs.datanode.simulateddatastorage", true);
        }
        this.conf.setBoolean("dfs.support.append", true);
        this.conf.setInt("heartbeat.recheck.interval", 1000);
        this.conf.setInt("dfs.heartbeat.interval", 1);
        this.conf.setInt("dfs.socket.timeout", 5000);
        this.conf.setInt("dfs.replication.pending.timeout.sec", 5);
        this.conf.setInt("dfs.replication.interval", 1);
        this.conf.setInt("ipc.client.connect.max.retries", 1);
        this.conf.setInt("dfs.client.block.recovery.retries", 1);
        this.conf.setInt("dfs.datanode.artificialBlockReceivedDelay", 10);
    }

    public void tearDown() throws Exception {
    }

    private void createFile(FileSystem whichfs, String filename, int rep, long fileSize) throws Exception {
        this.file1 = new Path(filename);
        this.stm = whichfs.create(this.file1, true, (int)fileSize + 1, (short)rep, 1024L);
        LOG.info((Object)("Created file " + filename));
        LOG.info((Object)("Writing " + fileSize + " bytes to " + this.file1));
        AppendTestUtil.write((OutputStream)this.stm, 0, (int)fileSize);
    }

    private void assertFileSize(FileSystem whichfs, long expectedSize) throws Exception {
        LOG.info((Object)("reading length of " + this.file1.getName() + " on namenode"));
        long realSize = whichfs.getFileStatus(this.file1).getLen();
        TestFileAppend4.assertTrue((String)("unexpected file size! received=" + realSize + " , expected=" + expectedSize), (realSize == expectedSize ? 1 : 0) != 0);
    }

    private void assertNumCurrentReplicas(short rep) throws Exception {
        DFSClient.DFSOutputStream hdfs_out = (DFSClient.DFSOutputStream)this.stm.getWrappedStream();
        int actualRepl = hdfs_out.getNumCurrentReplicas();
        TestFileAppend4.assertTrue((String)(this.file1 + " should be replicated to " + rep + " datanodes, not " + actualRepl + "."), (actualRepl == rep ? 1 : 0) != 0);
    }

    private void recoverFile(FileSystem fs) throws Exception {
        LOG.info((Object)"Recovering File Lease");
        AppendTestUtil.recoverFile(this.cluster, fs, this.file1);
        LOG.info((Object)"Past out lease recovery");
    }

    private void waitForBlockReplication(FileSystem whichfs, String filename, int expected, long maxWaitSec) throws IOException {
        long start = System.currentTimeMillis();
        LOG.info((Object)("Checking for block replication for " + filename));
        int iters = 0;
        while (true) {
            boolean replOk = true;
            BlockLocation[] bl = whichfs.getFileBlockLocations(whichfs.getFileStatus(this.file1), 0L, 1024L);
            if (bl.length == 0) {
                replOk = false;
            }
            for (BlockLocation b : bl) {
                int actual = b.getNames().length;
                if (actual >= expected) continue;
                LOG.info((Object)("Not enough replicas for " + b + " yet. Expecting " + expected + ", got " + actual + "."));
                replOk = false;
                break;
            }
            if (replOk) {
                return;
            }
            ++iters;
            if (maxWaitSec > 0L && System.currentTimeMillis() - start > maxWaitSec * 1000L) {
                throw new IOException("Timedout while waiting for all blocks to  be replicated for " + filename);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignored) {
            }
        }
    }

    private void checkFile(FileSystem whichfs, long fileSize) throws Exception {
        LOG.info((Object)"validating content from datanodes...");
        AppendTestUtil.check(whichfs, this.file1, fileSize);
    }

    private void corruptDataNode(int dnNumber, CorruptionType type) throws Exception {
        File data_dir = new File(System.getProperty("test.build.data"), "dfs/data/data" + Integer.toString(dnNumber * 2 + 1) + "/blocksBeingWritten");
        int corrupted = 0;
        for (File block : data_dir.listFiles()) {
            if (!block.getName().startsWith("blk_") || block.getName().endsWith("meta")) continue;
            if (type == CorruptionType.CORRUPT_LAST_CHUNK) {
                RandomAccessFile file = new RandomAccessFile(block, "rw");
                FileChannel channel = file.getChannel();
                Random r = new Random();
                long lastBlockSize = channel.size() % 512L;
                long position = channel.size() - lastBlockSize;
                int length = r.nextInt((int)(channel.size() - position + 1L));
                byte[] buffer = new byte[length];
                r.nextBytes(buffer);
                channel.write(ByteBuffer.wrap(buffer), position);
                System.out.println("Deliberately corrupting file " + block.getName() + " at offset " + position + " length " + length);
                file.close();
            } else if (type == CorruptionType.TRUNCATE_BLOCK_TO_ZERO) {
                LOG.info((Object)("Truncating block file at " + block));
                RandomAccessFile blockFile = new RandomAccessFile(block, "rw");
                blockFile.setLength(0L);
                blockFile.close();
                RandomAccessFile metaFile = new RandomAccessFile(FSDataset.findMetaFile((File)block), "rw");
                metaFile.setLength(0L);
                metaFile.close();
            } else if (type == CorruptionType.TRUNCATE_BLOCK_HALF) {
                FSDatasetTestUtil.truncateBlockFile(block, block.length() / 2L);
            } else assert (false);
            ++corrupted;
        }
        TestFileAppend4.assertTrue((String)"Should have some data in bbw to corrupt", (corrupted > 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAppendSyncBbw() throws Exception {
        LOG.info((Object)"START");
        this.cluster = new MiniDFSCluster(this.conf, 1, true, null);
        FileSystem fs1 = this.cluster.getFileSystem();
        FileSystem fs2 = AppendTestUtil.createHdfsWithDifferentUsername(fs1.getConf());
        try {
            this.createFile(fs1, "/bbw.test", 1, 500L);
            this.stm.sync();
            this.assertFileSize(fs1, 0L);
            AppendTestUtil.loseLeases(fs1);
            this.recoverFile(fs2);
            this.assertFileSize(fs2, 500L);
            this.checkFile(fs2, 500L);
        }
        finally {
            fs2.close();
            fs1.close();
            this.cluster.shutdown();
        }
        LOG.info((Object)"STOP");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAppendSyncBbwClusterRestart() throws Exception {
        LOG.info((Object)"START");
        this.cluster = new MiniDFSCluster(this.conf, 1, true, null);
        FileSystem fs1 = this.cluster.getFileSystem();
        FileSystem fs2 = null;
        try {
            this.createFile(fs1, "/bbwRestart.test", 1, 500L);
            this.stm.sync();
            this.assertFileSize(fs1, 0L);
            this.cluster.shutdown();
            fs1.close();
            LOG.info((Object)"STOPPED first instance of the cluster");
            this.cluster = new MiniDFSCluster(this.conf, 1, false, null);
            this.cluster.waitActive();
            LOG.info((Object)"START second instance.");
            fs2 = this.cluster.getFileSystem();
            this.recoverFile(fs2);
            this.assertFileSize(fs2, 500L);
            this.checkFile(fs2, 500L);
        }
        finally {
            if (fs2 != null) {
                fs2.close();
            }
            fs1.close();
            this.cluster.shutdown();
        }
        LOG.info((Object)"STOP");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAppendSync2XBbwClusterRestart() throws Exception {
        LOG.info((Object)"START");
        this.cluster = new MiniDFSCluster(this.conf, 1, true, null);
        TestFileAppend4.assertTrue((boolean)this.cluster.getDataNodes().get(0).getConf().get("dfs.data.dir").matches("[^,]+,[^,]*"));
        FileSystem fs1 = this.cluster.getFileSystem();
        FileSystem fs2 = null;
        try {
            int[] files = new int[]{0, 1, 2};
            Path[] paths = new Path[files.length];
            FSDataOutputStream[] stms = new FSDataOutputStream[files.length];
            for (int i : files) {
                this.createFile(fs1, "/bbwRestart" + i + ".test", 1, 500L);
                this.stm.sync();
                this.assertFileSize(fs1, 0L);
                paths[i] = this.file1;
                stms[i] = this.stm;
            }
            this.cluster.shutdown();
            fs1.close();
            LOG.info((Object)"STOPPED first instance of the cluster");
            this.cluster = new MiniDFSCluster(this.conf, 1, false, null);
            this.cluster.waitActive();
            LOG.info((Object)"START second instance.");
            fs2 = this.cluster.getFileSystem();
            for (int i : files) {
                this.file1 = paths[i];
                this.recoverFile(fs2);
                this.assertFileSize(fs2, 500L);
                this.checkFile(fs2, 500L);
            }
        }
        finally {
            if (fs2 != null) {
                fs2.close();
            }
            fs1.close();
            this.cluster.shutdown();
        }
        LOG.info((Object)"STOP");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAppendSyncBlockPlusBbw() throws Exception {
        LOG.info((Object)"START");
        this.cluster = new MiniDFSCluster(this.conf, 1, true, null);
        FileSystem fs1 = this.cluster.getFileSystem();
        FileSystem fs2 = AppendTestUtil.createHdfsWithDifferentUsername(fs1.getConf());
        try {
            this.createFile(fs1, "/blockPlusBbw.test", 1, 1524L);
            this.assertFileSize(fs1, 0L);
            this.stm.sync();
            this.assertFileSize(fs1, 1024L);
            AppendTestUtil.loseLeases(fs1);
            this.recoverFile(fs2);
            this.assertFileSize(fs2, 1524L);
            this.checkFile(fs2, 1524L);
        }
        finally {
            this.stm = null;
            fs2.close();
            fs1.close();
            this.cluster.shutdown();
        }
        LOG.info((Object)"STOP");
    }

    public void testAppendSyncReplication0() throws Exception {
        this.replicationTest(0);
    }

    public void testAppendSyncReplication1() throws Exception {
        this.replicationTest(1);
    }

    public void testAppendSyncReplication2() throws Exception {
        this.replicationTest(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replicationTest(int badDN) throws Exception {
        LOG.info((Object)"START");
        this.cluster = new MiniDFSCluster(this.conf, 3, true, null);
        FileSystem fs1 = this.cluster.getFileSystem();
        try {
            int halfBlock = 512;
            short rep = 3;
            TestFileAppend4.assertTrue((boolean)true);
            this.file1 = new Path("/appendWithReplication.dat");
            this.stm = fs1.create(this.file1, true, 2048, rep, 1024L);
            AppendTestUtil.write((OutputStream)this.stm, 0, halfBlock);
            this.stm.sync();
            this.assertNumCurrentReplicas(rep);
            this.cluster.stopDataNode(badDN);
            AppendTestUtil.write((OutputStream)this.stm, halfBlock, 256);
            this.stm.sync();
            this.assertNumCurrentReplicas((short)(rep - 1));
            this.cluster.getNameNode().setSafeMode(FSConstants.SafeModeAction.SAFEMODE_ENTER);
            this.cluster.shutdown();
            fs1.close();
            LOG.info((Object)"STOPPED first instance of the cluster");
            this.cluster = new MiniDFSCluster(this.conf, 3, false, null);
            this.cluster.getNameNode().getNamesystem().stallReplicationWork();
            this.cluster.waitActive();
            fs1 = this.cluster.getFileSystem();
            LOG.info((Object)"START second instance.");
            this.recoverFile(fs1);
            LOG.info((Object)"Recovered file");
            BlockLocation[] bl = fs1.getFileBlockLocations(fs1.getFileStatus(this.file1), 0L, 1024L);
            LOG.info((Object)"Checking blocks");
            TestFileAppend4.assertTrue((String)"Should have one block", (bl.length == 1 ? 1 : 0) != 0);
            TestFileAppend4.assertTrue((String)("Should have 2 replicas for that block, not " + bl[0].getNames().length), (bl[0].getNames().length == 2 ? 1 : 0) != 0);
            this.assertFileSize(fs1, 768L);
            this.checkFile(fs1, 768L);
            LOG.info((Object)"Checking replication");
            this.cluster.getNameNode().getNamesystem().restartReplicationWork();
            this.waitForBlockReplication(fs1, this.file1.toString(), 3, 20L);
        }
        finally {
            fs1.close();
            this.cluster.shutdown();
        }
    }

    public void testAppendSyncChecksum0() throws Exception {
        this.checksumTest(0);
    }

    public void testAppendSyncChecksum1() throws Exception {
        this.checksumTest(1);
    }

    public void testAppendSyncChecksum2() throws Exception {
        this.checksumTest(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checksumTest(int goodDN) throws Exception {
        int deadDN = (goodDN + 1) % 3;
        int corruptDN = (goodDN + 2) % 3;
        LOG.info((Object)"START");
        this.cluster = new MiniDFSCluster(this.conf, 3, true, null);
        FileSystem fs1 = this.cluster.getFileSystem();
        try {
            int halfBlock = 512;
            short rep = 3;
            TestFileAppend4.assertTrue((boolean)true);
            this.file1 = new Path("/appendWithReplication.dat");
            this.stm = fs1.create(this.file1, true, 2048, rep, 1024L);
            AppendTestUtil.write((OutputStream)this.stm, 0, halfBlock);
            this.stm.sync();
            this.assertNumCurrentReplicas(rep);
            this.cluster.stopDataNode(deadDN);
            AppendTestUtil.write((OutputStream)this.stm, halfBlock, 256);
            this.stm.sync();
            this.assertNumCurrentReplicas((short)(rep - 1));
            this.cluster.getNameNode().setSafeMode(FSConstants.SafeModeAction.SAFEMODE_ENTER);
            this.cluster.shutdown();
            fs1.close();
            LOG.info((Object)"STOPPED first instance of the cluster");
            this.corruptDataNode(corruptDN, CorruptionType.CORRUPT_LAST_CHUNK);
            this.cluster = new MiniDFSCluster(this.conf, 3, false, null);
            this.cluster.getNameNode().getNamesystem().stallReplicationWork();
            this.cluster.waitActive();
            fs1 = this.cluster.getFileSystem();
            LOG.info((Object)"START second instance.");
            this.recoverFile(fs1);
            BlockLocation[] bl = fs1.getFileBlockLocations(fs1.getFileStatus(this.file1), 0L, 1024L);
            TestFileAppend4.assertTrue((String)"Should have one block", (bl.length == 1 ? 1 : 0) != 0);
            TestFileAppend4.assertTrue((String)("Should have 1 replica for that block, not " + bl[0].getNames().length), (bl[0].getNames().length == 1 ? 1 : 0) != 0);
            TestFileAppend4.assertTrue((String)"The replica should be the datanode with the correct CRC", (boolean)this.cluster.getDataNodes().get(goodDN).getSelfAddr().toString().endsWith(bl[0].getNames()[0]));
            this.assertFileSize(fs1, 768L);
            this.checkFile(fs1, 768L);
            this.cluster.getNameNode().getNamesystem().restartReplicationWork();
            this.waitForBlockReplication(fs1, this.file1.toString(), 3, 20L);
        }
        finally {
            this.cluster.shutdown();
            fs1.close();
        }
    }

    public void testDnDeath0() throws Exception {
        this.dnDeathTest(0);
    }

    public void testDnDeath1() throws Exception {
        this.dnDeathTest(1);
    }

    public void testDnDeath2() throws Exception {
        this.dnDeathTest(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dnDeathTest(int badDN) throws Exception {
        LOG.info((Object)"START");
        this.cluster = new MiniDFSCluster(this.conf, 3, true, null);
        FileSystem fs1 = this.cluster.getFileSystem();
        try {
            int halfBlock = 512;
            short rep = 3;
            TestFileAppend4.assertTrue((boolean)true);
            this.file1 = new Path("/dnDeath.dat");
            this.stm = fs1.create(this.file1, true, 2048, rep, 1024L);
            AppendTestUtil.write((OutputStream)this.stm, 0, halfBlock);
            this.stm.close();
            this.cluster.stopDataNode(badDN);
            this.recoverFile(fs1);
            this.checkFile(fs1, halfBlock);
        }
        finally {
            fs1.close();
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRecoverFinalizedBlock() throws Throwable {
        this.cluster = new MiniDFSCluster(this.conf, 3, true, null);
        try {
            this.cluster.waitActive();
            NameNode preSpyNN = this.cluster.getNameNode();
            NameNode spyNN = (NameNode)Mockito.spy((Object)preSpyNN);
            DelayAnswer delayer = new DelayAnswer();
            ((NameNode)Mockito.doAnswer((Answer)delayer).when((Object)spyNN)).complete(Matchers.anyString(), Matchers.anyString());
            DFSClient client = new DFSClient(null, (ClientProtocol)spyNN, this.conf, null);
            this.file1 = new Path("/testRecoverFinalized");
            final OutputStream stm = client.create("/testRecoverFinalized", true);
            AppendTestUtil.write(stm, 0, 4096);
            final AtomicReference err = new AtomicReference();
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        stm.close();
                    }
                    catch (Throwable t) {
                        err.set(t);
                    }
                }
            };
            t.start();
            LOG.info((Object)"Waiting for close to get to latch...");
            delayer.waitForCall();
            LOG.info((Object)"Killing lease checker");
            client.leasechecker.interruptAndJoin();
            FileSystem fs1 = this.cluster.getFileSystem();
            FileSystem fs2 = AppendTestUtil.createHdfsWithDifferentUsername(fs1.getConf());
            LOG.info((Object)"Recovering file");
            this.recoverFile(fs2);
            LOG.info((Object)"Telling close to proceed.");
            delayer.proceed();
            LOG.info((Object)"Waiting for close to finish.");
            t.join();
            LOG.info((Object)"Close finished.");
            Throwable thrownByClose = (Throwable)err.get();
            TestFileAppend4.assertNotNull((Object)thrownByClose);
            TestFileAppend4.assertTrue((boolean)(thrownByClose instanceof IOException));
            if (!thrownByClose.getMessage().contains("does not have any open files")) {
                throw thrownByClose;
            }
        }
        finally {
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCompleteOtherLeaseHoldersFile() throws Throwable {
        this.cluster = new MiniDFSCluster(this.conf, 3, true, null);
        try {
            this.cluster.waitActive();
            NameNode preSpyNN = this.cluster.getNameNode();
            NameNode spyNN = (NameNode)Mockito.spy((Object)preSpyNN);
            DelayAnswer delayer = new DelayAnswer();
            ((NameNode)Mockito.doAnswer((Answer)delayer).when((Object)spyNN)).complete(Matchers.anyString(), Matchers.anyString());
            DFSClient client = new DFSClient(null, (ClientProtocol)spyNN, this.conf, null);
            this.file1 = new Path("/testRecoverFinalized");
            final OutputStream stm = client.create("/testRecoverFinalized", true);
            AppendTestUtil.write(stm, 0, 4096);
            final AtomicReference err = new AtomicReference();
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        stm.close();
                    }
                    catch (Throwable t) {
                        err.set(t);
                    }
                }
            };
            t.start();
            LOG.info((Object)"Waiting for close to get to latch...");
            delayer.waitForCall();
            LOG.info((Object)"Killing lease checker");
            client.leasechecker.interruptAndJoin();
            FileSystem fs1 = this.cluster.getFileSystem();
            FileSystem fs2 = AppendTestUtil.createHdfsWithDifferentUsername(fs1.getConf());
            LOG.info((Object)"Recovering file");
            this.recoverFile(fs2);
            LOG.info((Object)"Opening file for append from new fs");
            FSDataOutputStream appenderStream = fs2.append(this.file1);
            LOG.info((Object)"Writing some data from new appender");
            AppendTestUtil.write((OutputStream)appenderStream, 0, 4096);
            LOG.info((Object)"Telling old close to proceed.");
            delayer.proceed();
            LOG.info((Object)"Waiting for close to finish.");
            t.join();
            LOG.info((Object)"Close finished.");
            Throwable thrownByClose = (Throwable)err.get();
            TestFileAppend4.assertNotNull((Object)thrownByClose);
            TestFileAppend4.assertTrue((boolean)(thrownByClose instanceof IOException));
            if (!thrownByClose.getMessage().contains("Lease mismatch")) {
                throw thrownByClose;
            }
            appenderStream.close();
        }
        finally {
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDatanodeFailsToCommit() throws Throwable {
        LOG.info((Object)"START");
        this.cluster = new MiniDFSCluster(this.conf, 1, true, null);
        FileSystem fs1 = this.cluster.getFileSystem();
        FileSystem fs2 = AppendTestUtil.createHdfsWithDifferentUsername(fs1.getConf());
        try {
            this.createFile(fs1, "/datanodeFailsCommit.test", 1, 500L);
            this.stm.sync();
            AppendTestUtil.loseLeases(fs1);
            NameNode nn = this.cluster.getNameNode();
            nn.namesystem = (FSNamesystem)Mockito.spy((Object)nn.namesystem);
            ((FSNamesystem)Mockito.doAnswer((Answer)new ThrowNTimesAnswer(IOException.class, 1)).when((Object)nn.namesystem)).commitBlockSynchronization((Block)Matchers.anyObject(), (long)Matchers.anyInt(), (long)Matchers.anyInt(), Matchers.anyBoolean(), Matchers.anyBoolean(), (DatanodeID[])Matchers.anyObject());
            this.recoverFile(fs2);
            this.assertFileSize(fs2, 500L);
            this.checkFile(fs2, 500L);
        }
        finally {
            fs2.close();
            fs1.close();
            this.cluster.shutdown();
        }
        LOG.info((Object)"STOP");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBBWCleanupOnStartup() throws Throwable {
        LOG.info((Object)"START");
        this.cluster = new MiniDFSCluster(this.conf, 3, true, null);
        FileSystem fs1 = this.cluster.getFileSystem();
        try {
            int halfBlock = 512;
            short rep = 3;
            TestFileAppend4.assertTrue((boolean)true);
            this.file1 = new Path("/bbwCleanupOnStartup.dat");
            this.stm = fs1.create(this.file1, true, 2048, rep, 1024L);
            AppendTestUtil.write((OutputStream)this.stm, 0, halfBlock);
            this.stm.sync();
            String dataDirs = this.cluster.getDataNodes().get(0).getConf().get("dfs.data.dir");
            MiniDFSCluster.DataNodeProperties dnprops = this.cluster.stopDataNode(0);
            this.stm.close();
            List<File> bbwFilesAfterShutdown = this.getBBWFiles(dataDirs);
            TestFileAppend4.assertEquals((int)1, (int)bbwFilesAfterShutdown.size());
            TestFileAppend4.assertTrue((boolean)this.cluster.restartDataNode(dnprops));
            List<File> bbwFilesAfterRestart = null;
            for (int i = 0; i < 10; ++i) {
                LOG.info((Object)("Waiting for heartbeat #" + i + " after DN restart"));
                this.cluster.waitForDNHeartbeat(0, 10000L);
                bbwFilesAfterRestart = this.getBBWFiles(dataDirs);
                if (bbwFilesAfterRestart.size() == 0) break;
            }
            TestFileAppend4.assertEquals((int)0, (int)bbwFilesAfterRestart.size());
        }
        finally {
            fs1.close();
            this.cluster.shutdown();
        }
    }

    private List<File> getBBWFiles(String dfsDataDirs) {
        ArrayList<File> files = new ArrayList<File>();
        for (String dirString : dfsDataDirs.split(",")) {
            File dir = new File(dirString);
            TestFileAppend4.assertTrue((String)("data dir " + dir + " should exist"), (boolean)dir.exists());
            File bbwDir = new File(dir, "blocksBeingWritten");
            TestFileAppend4.assertTrue((String)("bbw dir " + bbwDir + " should eixst"), (boolean)bbwDir.exists());
            for (File blockFile : bbwDir.listFiles()) {
                if (blockFile.getName().endsWith(".meta")) continue;
                files.add(blockFile);
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRecoveryOnBlockBoundary() throws Throwable {
        LOG.info((Object)"START");
        this.cluster = new MiniDFSCluster(this.conf, 1, true, null);
        FileSystem fs1 = this.cluster.getFileSystem();
        final FileSystem fs2 = AppendTestUtil.createHdfsWithDifferentUsername(fs1.getConf());
        DelayAnswer delayer = new DelayAnswer();
        NameNode nn = this.cluster.getNameNode();
        nn.namesystem = (FSNamesystem)Mockito.spy((Object)nn.namesystem);
        ((FSNamesystem)Mockito.doAnswer((Answer)delayer).when((Object)nn.namesystem)).commitBlockSynchronization((Block)Matchers.anyObject(), (long)Matchers.anyInt(), (long)Matchers.anyInt(), Matchers.anyBoolean(), Matchers.anyBoolean(), (DatanodeID[])Matchers.anyObject());
        try {
            this.file1 = new Path("/testWritingDuringRecovery.test");
            this.stm = fs1.create(this.file1, true, 2048, (short)3, 1024L);
            AppendTestUtil.write((OutputStream)this.stm, 0, 1024);
            this.stm.sync();
            LOG.info((Object)"Losing lease");
            AppendTestUtil.loseLeases(fs1);
            LOG.info((Object)"Triggering recovery in another thread");
            final AtomicReference err = new AtomicReference();
            Thread recoverThread = new Thread(){

                @Override
                public void run() {
                    try {
                        TestFileAppend4.this.recoverFile(fs2);
                    }
                    catch (Throwable t) {
                        err.set(t);
                    }
                }
            };
            recoverThread.start();
            LOG.info((Object)"Waiting for recovery about to call commitBlockSynchronization");
            delayer.waitForCall();
            LOG.info((Object)"Continuing to write to stream");
            AppendTestUtil.write((OutputStream)this.stm, 0, 1024);
            try {
                this.stm.sync();
                TestFileAppend4.fail((String)"Sync was allowed after recovery started");
            }
            catch (IOException ioe) {
                LOG.info((Object)"Got expected IOE trying to write to a file from the writer that lost its lease", (Throwable)ioe);
            }
            LOG.info((Object)"Written more to stream, allowing commit to proceed");
            delayer.proceed();
            LOG.info((Object)"Joining on recovery thread");
            recoverThread.join();
            if (err.get() != null) {
                throw (Throwable)err.get();
            }
            LOG.info((Object)"Now that recovery has finished, still expect further writes to fail.");
            try {
                AppendTestUtil.write((OutputStream)this.stm, 0, 1024);
                this.stm.sync();
                TestFileAppend4.fail((String)"Further writes after recovery finished did not fail!");
            }
            catch (IOException ioe) {
                LOG.info((Object)"Got expected exception", (Throwable)ioe);
            }
            LOG.info((Object)"Checking that file looks good");
            this.assertFileSize(fs2, 1024L);
            this.checkFile(fs2, 1024L);
        }
        finally {
            try {
                fs2.close();
                fs1.close();
                this.cluster.shutdown();
            }
            catch (Throwable t) {
                LOG.warn((Object)"Didn't close down cleanly", t);
            }
        }
        LOG.info((Object)"STOP");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAppendFileRace() throws Throwable {
        LOG.info((Object)"START");
        this.cluster = new MiniDFSCluster(this.conf, 1, true, null);
        final FileSystem fs1 = this.cluster.getFileSystem();
        try {
            this.createFile(fs1, "/testAppendFileRace", 1, 500L);
            this.stm.close();
            NameNode nn = this.cluster.getNameNode();
            FSEditLog editLogSpy = FSImageAdapter.injectEditLogSpy(nn.getNamesystem());
            DelayAnswer delayer = new DelayAnswer();
            ((FSEditLog)Mockito.doAnswer((Answer)delayer).when((Object)editLogSpy)).logSync();
            final AtomicReference err = new AtomicReference();
            Thread appender = new Thread(){

                @Override
                public void run() {
                    try {
                        TestFileAppend4.this.stm = fs1.append(TestFileAppend4.this.file1);
                    }
                    catch (Throwable t) {
                        err.set(t);
                    }
                }
            };
            LOG.info((Object)"Triggering append in other thread");
            appender.start();
            LOG.info((Object)"Waiting for logsync");
            delayer.waitForCall();
            LOG.info((Object)"Resetting spy");
            Mockito.reset((Object[])new FSEditLog[]{editLogSpy});
            LOG.info((Object)"Deleting file");
            fs1.delete(this.file1, true);
            LOG.info((Object)"Allowing append to proceed");
            delayer.proceed();
            LOG.info((Object)"Waiting for append to finish");
            appender.join();
            if (err.get() != null) {
                if (((Throwable)err.get()).getMessage().contains("File does not exist.")) {
                    LOG.info((Object)"Got expected exception", (Throwable)err.get());
                } else {
                    throw (Throwable)err.get();
                }
            }
            LOG.info((Object)"Closing stream");
            this.stm.close();
        }
        finally {
            fs1.close();
            this.cluster.shutdown();
        }
    }

    public void testTruncatedPrimaryDN() throws Exception {
        LOG.info((Object)"START");
        this.runDNRestartCorruptType(CorruptionType.TRUNCATE_BLOCK_TO_ZERO);
    }

    public void testHalfLengthPrimaryDN() throws Exception {
        LOG.info((Object)"START");
        this.runDNRestartCorruptType(CorruptionType.TRUNCATE_BLOCK_HALF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDNRestartCorruptType(CorruptionType corrupt) throws Exception {
        this.cluster = new MiniDFSCluster(this.conf, 3, true, null);
        FileSystem fs1 = this.cluster.getFileSystem();
        try {
            short rep = 3;
            TestFileAppend4.assertTrue((boolean)true);
            this.file1 = new Path("/dnDeath.dat");
            this.stm = fs1.create(this.file1, true, 1024, rep, 4096L);
            AppendTestUtil.write((OutputStream)this.stm, 0, 1024);
            this.stm.sync();
            AppendTestUtil.loseLeases(fs1);
            DFSClient.DFSOutputStream dfso = (DFSClient.DFSOutputStream)this.stm.getWrappedStream();
            dfso.abortForTests();
            MiniDFSCluster.DataNodeProperties badDN = this.cluster.stopDataNode(0);
            this.corruptDataNode(0, corrupt);
            this.cluster.restartDataNode(badDN);
            FileSystem fs2 = AppendTestUtil.createHdfsWithDifferentUsername(fs1.getConf());
            this.recoverFile(fs2);
            this.assertFileSize(fs2, 1024L);
            this.checkFile(fs2, 1024L);
        }
        finally {
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFullClusterPowerLoss() throws Exception {
        this.cluster = new MiniDFSCluster(this.conf, 2, true, null);
        FileSystem fs1 = this.cluster.getFileSystem();
        try {
            short rep = 2;
            TestFileAppend4.assertTrue((boolean)true);
            this.file1 = new Path("/dnDeath.dat");
            this.stm = fs1.create(this.file1, true, 1024, rep, 4096L);
            AppendTestUtil.write((OutputStream)this.stm, 0, 1024);
            this.stm.sync();
            AppendTestUtil.loseLeases(fs1);
            DFSClient.DFSOutputStream dfso = (DFSClient.DFSOutputStream)this.stm.getWrappedStream();
            dfso.abortForTests();
            MiniDFSCluster.DataNodeProperties badDN = this.cluster.stopDataNode(0);
            MiniDFSCluster.DataNodeProperties badDN2 = this.cluster.stopDataNode(0);
            TestFileAppend4.assertNotNull((Object)badDN);
            TestFileAppend4.assertNotNull((Object)badDN2);
            this.corruptDataNode(0, CorruptionType.TRUNCATE_BLOCK_HALF);
            this.cluster.restartDataNode(badDN);
            this.cluster.restartDataNode(badDN2);
            this.cluster.waitForDNHeartbeat(0, 10000L);
            this.cluster.waitForDNHeartbeat(1, 10000L);
            FileSystem fs2 = AppendTestUtil.createHdfsWithDifferentUsername(fs1.getConf());
            this.recoverFile(fs2);
            this.assertFileSize(fs2, 512L);
            this.checkFile(fs2, 512L);
        }
        finally {
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNotPrematurelyComplete() throws Exception {
        LOG.info((Object)"START");
        this.cluster = new MiniDFSCluster(this.conf, 3, true, null);
        FileSystem fs1 = this.cluster.getFileSystem();
        try {
            int halfBlock = 512;
            short rep = 3;
            TestFileAppend4.assertTrue((boolean)true);
            this.file1 = new Path("/delayedReceiveBlock");
            this.stm = fs1.create(this.file1, true, 2048, rep, 1024L);
            AppendTestUtil.write((OutputStream)this.stm, 0, halfBlock);
            this.stm.close();
            NameNode nn = this.cluster.getNameNode();
            LOG.info((Object)"======== Appending");
            this.stm = fs1.append(this.file1);
            LOG.info((Object)"======== Writing");
            AppendTestUtil.write((OutputStream)this.stm, 0, halfBlock / 2);
            LOG.info((Object)"======== Checking progress");
            TestFileAppend4.assertFalse((boolean)NameNodeAdapter.checkFileProgress(nn.namesystem, "/delayedReceiveBlock", true));
            LOG.info((Object)"======== Closing");
            this.stm.close();
        }
        finally {
            LOG.info((Object)"======== Cleaning up");
            fs1.close();
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNotPrematurelyCompleteWithFailure() throws Exception {
        LOG.info((Object)"START");
        this.cluster = new MiniDFSCluster(this.conf, 3, true, null);
        FileSystem fs1 = this.cluster.getFileSystem();
        try {
            int halfBlock = 512;
            short rep = 3;
            TestFileAppend4.assertTrue((boolean)true);
            this.file1 = new Path("/delayedReceiveBlock");
            this.stm = fs1.create(this.file1, true, 2048, rep, 1024L);
            AppendTestUtil.write((OutputStream)this.stm, 0, halfBlock);
            this.stm.close();
            NameNode nn = this.cluster.getNameNode();
            LOG.info((Object)"======== Appending");
            this.stm = fs1.append(this.file1);
            LOG.info((Object)"======== Writing");
            AppendTestUtil.write((OutputStream)this.stm, 0, halfBlock / 4);
            MiniDFSCluster.DataNodeProperties dnprops = this.cluster.stopDataNode(0);
            this.stm.sync();
            TestFileAppend4.assertTrue((boolean)this.cluster.restartDataNode(dnprops));
            for (int i = 0; i < 2; ++i) {
                this.cluster.waitForDNHeartbeat(0, 3000L);
            }
            AppendTestUtil.write((OutputStream)this.stm, 0, halfBlock / 4);
            LOG.info((Object)"======== Checking progress");
            TestFileAppend4.assertFalse((boolean)NameNodeAdapter.checkFileProgress(nn.namesystem, "/delayedReceiveBlock", true));
            LOG.info((Object)"======== Closing");
            this.stm.close();
        }
        finally {
            LOG.info((Object)"======== Cleaning up");
            fs1.close();
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNotPrematurelyCompleteWithFailureNotReopened() throws Exception {
        LOG.info((Object)"START");
        this.cluster = new MiniDFSCluster(this.conf, 3, true, null);
        NameNode nn = this.cluster.getNameNode();
        FileSystem fs1 = this.cluster.getFileSystem();
        try {
            short rep = 3;
            this.file1 = new Path("/delayedReceiveBlock");
            this.stm = fs1.create(this.file1, true, 2048, rep, 0x4000000L);
            LOG.info((Object)"======== Writing");
            AppendTestUtil.write((OutputStream)this.stm, 0, 0x100000);
            LOG.info((Object)"======== Waiting for a block allocation");
            this.waitForBlockReplication(fs1, "/delayedReceiveBlock", 0, 3000L);
            LOG.info((Object)"======== Checking not complete");
            TestFileAppend4.assertFalse((boolean)NameNodeAdapter.checkFileProgress(nn.namesystem, "/delayedReceiveBlock", true));
            MiniDFSCluster.DataNodeProperties dnprops = this.cluster.stopDataNode(0);
            AppendTestUtil.write((OutputStream)this.stm, 0, 0x100000);
            LOG.info((Object)"======== Checking progress");
            TestFileAppend4.assertFalse((boolean)NameNodeAdapter.checkFileProgress(nn.namesystem, "/delayedReceiveBlock", true));
            LOG.info((Object)"======== Closing");
            this.stm.close();
        }
        finally {
            LOG.info((Object)"======== Cleaning up");
            fs1.close();
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimultaneousRecoveries() throws Exception {
        LOG.info((Object)"START");
        this.cluster = new MiniDFSCluster(this.conf, 3, true, null);
        FileSystem fs1 = this.cluster.getFileSystem();
        final FileSystem fs2 = AppendTestUtil.createHdfsWithDifferentUsername(fs1.getConf());
        try {
            this.createFile(fs1, "/testSimultaneousRecoveries", 3, 500L);
            this.stm.sync();
            AppendTestUtil.loseLeases(fs1);
            DelayAnswer delayer = new DelayAnswer(false);
            NameNode nn = this.cluster.getNameNode();
            nn.namesystem = (FSNamesystem)Mockito.spy((Object)nn.namesystem);
            NameNodeAdapter.callNextGenerationStampForBlock((FSNamesystem)Mockito.doAnswer((Answer)delayer).when((Object)nn.namesystem), (Block)Matchers.anyObject(), Matchers.anyBoolean());
            final AtomicReference err = new AtomicReference();
            Thread recoverThread = new Thread("Recovery thread"){

                @Override
                public void run() {
                    try {
                        TestFileAppend4.this.recoverFile(fs2);
                    }
                    catch (Throwable t) {
                        err.set(t);
                    }
                }
            };
            recoverThread.start();
            LOG.info((Object)"Waiting for first nextGenerationStamp to return");
            delayer.waitForCall();
            LOG.info((Object)"Allowing recovery time to try again");
            Thread.sleep(10000L);
            LOG.info((Object)"Proceeding first recovery with old GS");
            delayer.proceed();
            LOG.info((Object)"Joining on recovery thread");
            recoverThread.join();
            LOG.info((Object)"Waiting a few seconds for blocks to get corrupted");
            Thread.sleep(5000L);
            this.assertFileSize(fs2, 500L);
            this.checkFile(fs2, 500L);
        }
        finally {
            fs2.close();
            fs1.close();
            this.cluster.shutdown();
        }
        LOG.info((Object)"STOP");
    }

    private static class ThrowNTimesAnswer
    implements Answer {
        private int numTimesToThrow;
        private Class<? extends Throwable> exceptionClass;

        public ThrowNTimesAnswer(Class<? extends Throwable> exceptionClass, int numTimesToThrow) {
            this.exceptionClass = exceptionClass;
            this.numTimesToThrow = numTimesToThrow;
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            if (this.numTimesToThrow-- > 0) {
                throw this.exceptionClass.newInstance();
            }
            return invocation.callRealMethod();
        }
    }

    public static class DelayAnswer
    implements Answer {
        private final CountDownLatch fireLatch = new CountDownLatch(1);
        private final CountDownLatch waitLatch = new CountDownLatch(1);
        boolean delayBefore = true;
        int numTimes = 1;

        public DelayAnswer() {
        }

        public DelayAnswer(boolean delayBefore) {
            this.delayBefore = delayBefore;
        }

        public void waitForCall() throws InterruptedException {
            this.fireLatch.await();
        }

        public void proceed() {
            this.waitLatch.countDown();
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            if (this.delayBefore) {
                this.doDelay();
            }
            Object ret = invocation.callRealMethod();
            if (!this.delayBefore) {
                this.doDelay();
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doDelay() throws Throwable {
            DelayAnswer delayAnswer = this;
            synchronized (delayAnswer) {
                if (--this.numTimes < 0) {
                    return;
                }
            }
            LOG.info((Object)"DelayAnswer firing fireLatch");
            this.fireLatch.countDown();
            try {
                LOG.info((Object)"DelayAnswer waiting on waitLatch");
                this.waitLatch.await();
                LOG.info((Object)"DelayAnswer delay complete");
            }
            catch (InterruptedException ie) {
                throw new IOException("Interrupted waiting on latch", ie);
            }
        }
    }

    static enum CorruptionType {
        CORRUPT_LAST_CHUNK,
        TRUNCATE_BLOCK_TO_ZERO,
        TRUNCATE_BLOCK_HALF;

    }
}

