/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.util.StringUtils;

public class TestAbandonBlock
extends TestCase {
    public static final Log LOG = LogFactory.getLog(TestAbandonBlock.class);
    private static final Configuration CONF = new Configuration();
    static final String FILE_NAME_PREFIX = "/" + TestAbandonBlock.class.getSimpleName() + "_";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAbandonBlock() throws IOException {
        MiniDFSCluster cluster = new MiniDFSCluster(CONF, 2, true, null);
        FileSystem fs = cluster.getFileSystem();
        String src = FILE_NAME_PREFIX + "foo";
        FSDataOutputStream fout = null;
        try {
            fout = fs.create(new Path(src), true, 4096, (short)1, 512L);
            for (int i = 0; i < 1024; ++i) {
                fout.write(123);
            }
            fout.sync();
            DFSClient dfsclient = new DFSClient(NameNode.getAddress((Configuration)CONF), CONF);
            LocatedBlocks blocks = dfsclient.namenode.getBlockLocations(src, 0L, 1L);
            LocatedBlock b = blocks.get(0);
            try {
                dfsclient.namenode.abandonBlock(b.getBlock(), src, "someone");
                TestAbandonBlock.assertTrue((boolean)false);
            }
            catch (IOException ioe) {
                LOG.info((Object)("GREAT! " + StringUtils.stringifyException((Throwable)ioe)));
            }
        }
        finally {
            try {
                fout.close();
            }
            catch (Exception e) {}
            try {
                fs.close();
            }
            catch (Exception e) {}
            try {
                cluster.shutdown();
            }
            catch (Exception e) {}
        }
    }
}

