/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.ShellBasedUnixGroupsMapping;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.log4j.Level;

public class DFSTestUtil {
    private static Random gen = new Random();
    private static String[] dirNames = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine"};
    private int maxLevels;
    private int maxSize;
    private int nFiles;
    private MyFile[] files;

    public DFSTestUtil(String testName, int nFiles, int maxLevels, int maxSize) {
        this.nFiles = nFiles;
        this.maxLevels = maxLevels;
        this.maxSize = maxSize;
    }

    public void createFiles(FileSystem fs, String topdir) throws IOException {
        this.createFiles(fs, topdir, (short)3);
    }

    void createFiles(FileSystem fs, String topdir, short replicationFactor) throws IOException {
        this.files = new MyFile[this.nFiles];
        for (int idx = 0; idx < this.nFiles; ++idx) {
            this.files[idx] = new MyFile();
        }
        Path root = new Path(topdir);
        for (int idx = 0; idx < this.nFiles; ++idx) {
            DFSTestUtil.createFile(fs, new Path(root, this.files[idx].getName()), this.files[idx].getSize(), replicationFactor, this.files[idx].getSeed());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFile(FileSystem fs, Path fileName, long fileLen, short replFactor, long seed) throws IOException {
        if (!fs.mkdirs(fileName.getParent())) {
            throw new IOException("Mkdirs failed to create " + fileName.getParent().toString());
        }
        FSDataOutputStream out = null;
        try {
            int bytesToWriteNext;
            out = fs.create(fileName, replFactor);
            byte[] toWrite = new byte[1024];
            Random rb = new Random(seed);
            for (long bytesToWrite = fileLen; bytesToWrite > 0L; bytesToWrite -= (long)bytesToWriteNext) {
                rb.nextBytes(toWrite);
                bytesToWriteNext = 1024L < bytesToWrite ? 1024 : (int)bytesToWrite;
                out.write(toWrite, 0, bytesToWriteNext);
            }
            out.close();
            out = null;
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(out);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)out);
    }

    public boolean checkFiles(FileSystem fs, String topdir) throws IOException {
        Path root = new Path(topdir);
        for (int idx = 0; idx < this.nFiles; ++idx) {
            Path fPath = new Path(root, this.files[idx].getName());
            FSDataInputStream in = fs.open(fPath);
            byte[] toRead = new byte[this.files[idx].getSize()];
            byte[] toCompare = new byte[this.files[idx].getSize()];
            Random rb = new Random(this.files[idx].getSeed());
            rb.nextBytes(toCompare);
            in.readFully(0L, toRead);
            in.close();
            for (int i = 0; i < toRead.length; ++i) {
                if (toRead[i] == toCompare[i]) continue;
                return false;
            }
            toRead = null;
            toCompare = null;
        }
        return true;
    }

    void setReplication(FileSystem fs, String topdir, short value) throws IOException {
        Path root = new Path(topdir);
        for (int idx = 0; idx < this.nFiles; ++idx) {
            Path fPath = new Path(root, this.files[idx].getName());
            fs.setReplication(fPath, value);
        }
    }

    public void waitReplication(FileSystem fs, String topdir, short value) throws IOException {
        Path root = new Path(topdir);
        for (int idx = 0; idx < this.nFiles; ++idx) {
            DFSTestUtil.waitReplication(fs, new Path(root, this.files[idx].getName()), value);
        }
    }

    public String[] getFileNames(String topDir) {
        if (this.nFiles == 0) {
            return new String[0];
        }
        String[] fileNames = new String[this.nFiles];
        for (int idx = 0; idx < this.nFiles; ++idx) {
            fileNames[idx] = topDir + "/" + this.files[idx].getName();
        }
        return fileNames;
    }

    public static void waitReplication(FileSystem fs, Path fileName, short replFactor) throws IOException {
        boolean good;
        block2: do {
            good = true;
            BlockLocation[] locs = fs.getFileBlockLocations(fs.getFileStatus(fileName), 0L, Long.MAX_VALUE);
            for (int j = 0; j < locs.length; ++j) {
                String[] loc = locs[j].getHosts();
                if (loc.length == replFactor) continue;
                System.out.println("File " + fileName + " has replication factor " + loc.length);
                good = false;
                try {
                    System.out.println("Waiting for replication factor to drain");
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
                continue block2;
            }
        } while (!good);
    }

    public void cleanup(FileSystem fs, String topdir) throws IOException {
        Path root = new Path(topdir);
        fs.delete(root, true);
        this.files = null;
    }

    public static Block getFirstBlock(FileSystem fs, Path path) throws IOException {
        DFSClient.DFSDataInputStream in = (DFSClient.DFSDataInputStream)((DistributedFileSystem)fs).open(path);
        in.readByte();
        return in.getCurrentBlock();
    }

    public static List<LocatedBlock> getAllBlocks(FSDataInputStream in) throws IOException {
        return ((DFSClient.DFSDataInputStream)in).getAllBlocks();
    }

    public static Token<BlockTokenIdentifier> getAccessToken(FSDataOutputStream out) {
        return ((DFSClient.DFSOutputStream)out.getWrappedStream()).getAccessToken();
    }

    static void setLogLevel2All(Log log) {
        ((Log4JLogger)log).getLogger().setLevel(Level.ALL);
    }

    static String readFile(File f) throws IOException {
        int c;
        StringBuilder b = new StringBuilder();
        BufferedReader in = new BufferedReader(new FileReader(f));
        while ((c = in.read()) != -1) {
            b.append((char)c);
        }
        in.close();
        return b.toString();
    }

    public static String urlGet(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)conn.getInputStream(), (OutputStream)out, (int)4096, (boolean)true);
        return out.toString();
    }

    public static void updateConfWithFakeGroupMapping(Configuration conf, Map<String, String[]> map) {
        if (map != null) {
            MockUnixGroupsMapping.fakeUser2GroupsMap = map;
        }
        conf.setClass("hadoop.security.group.mapping", MockUnixGroupsMapping.class, ShellBasedUnixGroupsMapping.class);
    }

    public static FileSystem getFileSystemAs(UserGroupInformation ugi, final Configuration conf) throws IOException, InterruptedException {
        return (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws Exception {
                return FileSystem.get((Configuration)conf);
            }
        });
    }

    public static FileSystem.Statistics getStatistics(FileSystem fs) {
        return FileSystem.getStatistics((String)fs.getUri().getScheme(), fs.getClass());
    }

    public static byte[] generateSequentialBytes(int start, int length) {
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)((start + i) % 127);
        }
        return result;
    }

    static class MockUnixGroupsMapping
    extends ShellBasedUnixGroupsMapping {
        static Map<String, String[]> fakeUser2GroupsMap;
        private static final List<String> defaultGroups;

        MockUnixGroupsMapping() {
        }

        public List<String> getGroups(String user) throws IOException {
            boolean found = false;
            List<String> l = new ArrayList<String>();
            for (String u : fakeUser2GroupsMap.keySet()) {
                if (!user.equals(u)) continue;
                found = true;
                for (String gr : fakeUser2GroupsMap.get(u)) {
                    l.add(gr);
                }
            }
            if (!found && (l = super.getGroups(user)).size() == 0) {
                System.out.println("failed to get real group for " + user + "; using default");
                return defaultGroups;
            }
            return l;
        }

        static {
            defaultGroups = new ArrayList<String>(1);
            defaultGroups.add("supergroup");
            fakeUser2GroupsMap = new HashMap<String, String[]>();
        }
    }

    private class MyFile {
        private String name = "";
        private int size;
        private long seed;

        MyFile() {
            int nLevels = gen.nextInt(DFSTestUtil.this.maxLevels);
            if (nLevels != 0) {
                int[] levels = new int[nLevels];
                for (int idx = 0; idx < nLevels; ++idx) {
                    levels[idx] = gen.nextInt(10);
                }
                StringBuffer sb = new StringBuffer();
                for (int idx = 0; idx < nLevels; ++idx) {
                    sb.append(dirNames[levels[idx]]);
                    sb.append("/");
                }
                this.name = sb.toString();
            }
            long fidx = -1L;
            while (fidx < 0L) {
                fidx = gen.nextLong();
            }
            this.name = this.name + Long.toString(fidx);
            this.size = gen.nextInt(DFSTestUtil.this.maxSize);
            this.seed = gen.nextLong();
        }

        String getName() {
            return this.name;
        }

        int getSize() {
            return this.size;
        }

        long getSeed() {
            return this.seed;
        }
    }
}

