/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.mapreduce.ID;
import org.apache.hadoop.tools.rumen.ClusterTopologyReader;
import org.apache.hadoop.tools.rumen.JobTraceReader;
import org.apache.hadoop.tools.rumen.LoggedJob;
import org.apache.hadoop.tools.rumen.LoggedNetworkTopology;
import org.apache.hadoop.tools.rumen.datatypes.AnonymizableDataType;
import org.apache.hadoop.tools.rumen.datatypes.DataType;
import org.apache.hadoop.tools.rumen.serializers.BlockingSerializer;
import org.apache.hadoop.tools.rumen.serializers.DefaultAnonymizingRumenSerializer;
import org.apache.hadoop.tools.rumen.serializers.DefaultRumenSerializer;
import org.apache.hadoop.tools.rumen.serializers.ObjectStringSerializer;
import org.apache.hadoop.tools.rumen.state.StatePool;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.module.SimpleModule;

public class Anonymizer
extends Configured
implements Tool {
    private boolean anonymizeTrace = false;
    private Path inputTracePath = null;
    private Path outputTracePath = null;
    private boolean anonymizeTopology = false;
    private Path inputTopologyPath = null;
    private Path outputTopologyPath = null;
    private StatePool statePool;
    private ObjectMapper outMapper = null;
    private JsonFactory outFactory = null;

    private void initialize(String[] args) throws Exception {
        try {
            for (int i = 0; i < args.length; ++i) {
                if ("-trace".equals(args[i])) {
                    this.anonymizeTrace = true;
                    this.inputTracePath = new Path(args[i + 1]);
                    this.outputTracePath = new Path(args[i + 2]);
                    i += 2;
                }
                if (!"-topology".equals(args[i])) continue;
                this.anonymizeTopology = true;
                this.inputTopologyPath = new Path(args[i + 1]);
                this.outputTopologyPath = new Path(args[i + 2]);
                i += 2;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal arguments list!", e);
        }
        if (!this.anonymizeTopology && !this.anonymizeTrace) {
            throw new IllegalArgumentException("Invalid arguments list!");
        }
        this.statePool = new StatePool();
        this.statePool.initialize(this.getConf());
        this.outMapper = new ObjectMapper();
        SimpleModule module = new SimpleModule("Anonymization Serializer", new Version(0, 1, 1, "FINAL"));
        module.addSerializer(DataType.class, (JsonSerializer)new DefaultRumenSerializer());
        module.addSerializer(String.class, (JsonSerializer)new BlockingSerializer());
        module.addSerializer(ID.class, new ObjectStringSerializer());
        module.addSerializer(AnonymizableDataType.class, (JsonSerializer)new DefaultAnonymizingRumenSerializer(this.statePool, this.getConf()));
        this.outMapper.registerModule((Module)module);
        this.outFactory = this.outMapper.getJsonFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void anonymizeTrace() throws Exception {
        if (this.anonymizeTrace) {
            System.out.println("Anonymizing trace file: " + this.inputTracePath);
            JobTraceReader reader = null;
            JsonGenerator outGen = null;
            Configuration conf = this.getConf();
            try {
                outGen = this.createJsonGenerator(conf, this.outputTracePath);
                reader = new JobTraceReader(this.inputTracePath, conf);
                LoggedJob job = (LoggedJob)reader.getNext();
                while (job != null) {
                    outGen.writeObject((Object)job);
                    job = (LoggedJob)reader.getNext();
                }
                System.out.println("Anonymized trace file: " + this.outputTracePath);
            }
            finally {
                if (outGen != null) {
                    outGen.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void anonymizeTopology() throws Exception {
        if (this.anonymizeTopology) {
            System.out.println("Anonymizing topology file: " + this.inputTopologyPath);
            ClusterTopologyReader reader = null;
            JsonGenerator outGen = null;
            Configuration conf = this.getConf();
            try {
                outGen = this.createJsonGenerator(conf, this.outputTopologyPath);
                reader = new ClusterTopologyReader(this.inputTopologyPath, conf);
                LoggedNetworkTopology job = reader.get();
                outGen.writeObject((Object)job);
                System.out.println("Anonymized topology file: " + this.outputTopologyPath);
            }
            finally {
                if (outGen != null) {
                    outGen.close();
                }
            }
        }
    }

    private JsonGenerator createJsonGenerator(Configuration conf, Path path) throws IOException {
        FSDataOutputStream output;
        FileSystem outFS = path.getFileSystem(conf);
        CompressionCodec codec = new CompressionCodecFactory(conf).getCodec(path);
        Compressor compressor = null;
        if (codec != null) {
            compressor = CodecPool.getCompressor((CompressionCodec)codec);
            output = codec.createOutputStream((OutputStream)outFS.create(path), compressor);
        } else {
            output = outFS.create(path);
        }
        JsonGenerator outGen = this.outFactory.createJsonGenerator((OutputStream)output, JsonEncoding.UTF8);
        outGen.useDefaultPrettyPrinter();
        return outGen;
    }

    public int run(String[] args) throws Exception {
        try {
            this.initialize(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            Anonymizer.printUsage();
            return -1;
        }
        return this.run();
    }

    public int run() throws Exception {
        try {
            this.anonymizeTrace();
        }
        catch (IOException ioe) {
            System.err.println("Error running the trace anonymizer!");
            ioe.printStackTrace();
            System.out.println("\n\nAnonymization unsuccessful!");
            return -1;
        }
        try {
            this.anonymizeTopology();
        }
        catch (IOException ioe) {
            System.err.println("Error running the cluster topology anonymizer!");
            ioe.printStackTrace();
            System.out.println("\n\nAnonymization unsuccessful!");
            return -1;
        }
        this.statePool.persist();
        System.out.println("Anonymization completed successfully!");
        return 0;
    }

    private static void printUsage() {
        System.out.println("\nUsage:-");
        System.out.print("  Anonymizer");
        System.out.print(" [-trace <input-trace-path> <output-trace-path>]");
        System.out.println(" [-topology <input-topology-path> <output-topology-path>] ");
        System.out.print("\n");
    }

    public static void main(String[] args) {
        Anonymizer instance = new Anonymizer();
        int result = 0;
        try {
            result = ToolRunner.run((Tool)instance, (String[])args);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.exit(-1);
        }
        if (result != 0) {
            System.exit(result);
        }
    }
}

