/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.GuiceServletContextListener;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.JerseyTest;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MockAppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.webapp.AMWebServices;
import org.apache.hadoop.mapreduce.v2.app.webapp.JAXBContextResolver;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestAMWebServicesJobs
extends JerseyTest {
    private static Configuration conf = new Configuration();
    private static AppContext appContext;
    private Injector injector = Guice.createInjector((Module[])new Module[]{new ServletModule(){

        protected void configureServlets() {
            appContext = new MockAppContext(0, 1, 2, 1);
            this.bind(JAXBContextResolver.class);
            this.bind(AMWebServices.class);
            this.bind(GenericExceptionHandler.class);
            this.bind(AppContext.class).toInstance((Object)appContext);
            this.bind(Configuration.class).toInstance((Object)conf);
            this.serve("/*", new String[0]).with(GuiceContainer.class);
        }
    }});

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    public TestAMWebServicesJobs() {
        super((AppDescriptor)new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.mapreduce.v2.app.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
    }

    @Test
    public void testJobs() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject jobs = json.getJSONObject("jobs");
        JSONArray arr = jobs.getJSONArray("job");
        JSONObject info = arr.getJSONObject(0);
        Job job = appContext.getJob(MRApps.toJobID((String)info.getString("id")));
        this.verifyAMJob(info, job);
    }

    @Test
    public void testJobsSlash() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs/").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject jobs = json.getJSONObject("jobs");
        JSONArray arr = jobs.getJSONArray("job");
        JSONObject info = arr.getJSONObject(0);
        Job job = appContext.getJob(MRApps.toJobID((String)info.getString("id")));
        this.verifyAMJob(info, job);
    }

    @Test
    public void testJobsDefault() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs").get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject jobs = json.getJSONObject("jobs");
        JSONArray arr = jobs.getJSONArray("job");
        JSONObject info = arr.getJSONObject(0);
        Job job = appContext.getJob(MRApps.toJobID((String)info.getString("id")));
        this.verifyAMJob(info, job);
    }

    @Test
    public void testJobsXML() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs").accept(new String[]{"application/xml"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
        String xml = (String)response.getEntity(String.class);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList jobs = dom.getElementsByTagName("jobs");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)jobs.getLength());
        NodeList job = dom.getElementsByTagName("job");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)job.getLength());
        this.verifyAMJobXML(job, appContext);
    }

    @Test
    public void testJobId() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject info = json.getJSONObject("job");
            this.verifyAMJob(info, (Job)jobsMap.get(id));
        }
    }

    @Test
    public void testJobIdSlash() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId + "/").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject info = json.getJSONObject("job");
            this.verifyAMJob(info, (Job)jobsMap.get(id));
        }
    }

    @Test
    public void testJobIdDefault() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject info = json.getJSONObject("job");
            this.verifyAMJob(info, (Job)jobsMap.get(id));
        }
    }

    @Test
    public void testJobIdNonExist() throws JSONException, Exception {
        WebResource r = this.resource();
        try {
            r.path("ws").path("v1").path("mapreduce").path("jobs").path("job_0_1234").get(JSONObject.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            Assert.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"java.lang.Exception: job, job_0_1234, is not found", (String)message);
            WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"NotFoundException", (String)type);
            WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.NotFoundException", (String)classname);
        }
    }

    @Test
    public void testJobIdInvalid() throws JSONException, Exception {
        WebResource r = this.resource();
        try {
            r.path("ws").path("v1").path("mapreduce").path("jobs").path("job_foo").accept(new String[]{"application/json"}).get(JSONObject.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            Assert.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            this.verifyJobIdInvalid(message, type, classname);
        }
    }

    @Test
    public void testJobIdInvalidDefault() throws JSONException, Exception {
        WebResource r = this.resource();
        try {
            r.path("ws").path("v1").path("mapreduce").path("jobs").path("job_foo").get(JSONObject.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            Assert.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            this.verifyJobIdInvalid(message, type, classname);
        }
    }

    @Test
    public void testJobIdInvalidXML() throws JSONException, Exception {
        WebResource r = this.resource();
        try {
            r.path("ws").path("v1").path("mapreduce").path("jobs").path("job_foo").accept(new String[]{"application/xml"}).get(JSONObject.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            Assert.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
            Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
            String msg = (String)response.getEntity(String.class);
            System.out.println(msg);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(msg));
            Document dom = db.parse(is);
            NodeList nodes = dom.getElementsByTagName("RemoteException");
            Element element = (Element)nodes.item(0);
            String message = WebServicesTestUtils.getXmlString((Element)element, (String)"message");
            String type = WebServicesTestUtils.getXmlString((Element)element, (String)"exception");
            String classname = WebServicesTestUtils.getXmlString((Element)element, (String)"javaClassName");
            this.verifyJobIdInvalid(message, type, classname);
        }
    }

    private void verifyJobIdInvalid(String message, String type, String classname) {
        WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"java.lang.Exception: JobId string : job_foo is not properly formed", (String)message);
        WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"NotFoundException", (String)type);
        WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.NotFoundException", (String)classname);
    }

    @Test
    public void testJobIdInvalidBogus() throws JSONException, Exception {
        WebResource r = this.resource();
        try {
            r.path("ws").path("v1").path("mapreduce").path("jobs").path("bogusfoo").get(JSONObject.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            Assert.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"java.lang.Exception: JobId string : bogusfoo is not properly formed", (String)message);
            WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"NotFoundException", (String)type);
            WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.NotFoundException", (String)classname);
        }
    }

    @Test
    public void testJobIdXML() throws Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).accept(new String[]{"application/xml"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
            String xml = (String)response.getEntity(String.class);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            Document dom = db.parse(is);
            NodeList job = dom.getElementsByTagName("job");
            this.verifyAMJobXML(job, appContext);
        }
    }

    public void verifyAMJob(JSONObject info, Job job) throws JSONException {
        Assert.assertEquals((String)"incorrect number of elements", (long)30L, (long)info.length());
        this.verifyAMJobGeneric(job, info.getString("id"), info.getString("user"), info.getString("name"), info.getString("state"), info.getLong("startTime"), info.getLong("finishTime"), info.getLong("elapsedTime"), info.getInt("mapsTotal"), info.getInt("mapsCompleted"), info.getInt("reducesTotal"), info.getInt("reducesCompleted"), (float)info.getDouble("reduceProgress"), (float)info.getDouble("mapProgress"));
        String diagnostics = "";
        if (info.has("diagnostics")) {
            diagnostics = info.getString("diagnostics");
        }
        this.verifyAMJobGenericSecure(job, info.getInt("mapsPending"), info.getInt("mapsRunning"), info.getInt("reducesPending"), info.getInt("reducesRunning"), info.getBoolean("uberized"), diagnostics, info.getInt("newReduceAttempts"), info.getInt("runningReduceAttempts"), info.getInt("failedReduceAttempts"), info.getInt("killedReduceAttempts"), info.getInt("successfulReduceAttempts"), info.getInt("newMapAttempts"), info.getInt("runningMapAttempts"), info.getInt("failedMapAttempts"), info.getInt("killedMapAttempts"), info.getInt("successfulMapAttempts"));
        Map allacls = job.getJobACLs();
        if (allacls != null) {
            for (Map.Entry entry : allacls.entrySet()) {
                String expectName = ((JobACL)entry.getKey()).getAclName();
                String expectValue = ((AccessControlList)entry.getValue()).getAclString();
                Boolean found = false;
                if (info.has("acls")) {
                    JSONArray arr = info.getJSONArray("acls");
                    for (int i = 0; i < arr.length(); ++i) {
                        JSONObject aclInfo = arr.getJSONObject(i);
                        if (!expectName.matches(aclInfo.getString("name"))) continue;
                        found = true;
                        WebServicesTestUtils.checkStringMatch((String)"value", (String)expectValue, (String)aclInfo.getString("value"));
                    }
                } else {
                    Assert.fail((String)"should have acls in the web service info");
                }
                Assert.assertTrue((String)("acl: " + expectName + " not found in webservice output"), (boolean)found);
            }
        }
    }

    public void verifyAMJobXML(NodeList nodes, AppContext appContext) {
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            Job job = appContext.getJob(MRApps.toJobID((String)WebServicesTestUtils.getXmlString((Element)element, (String)"id")));
            Assert.assertNotNull((String)"Job not found - output incorrect", (Object)job);
            this.verifyAMJobGeneric(job, WebServicesTestUtils.getXmlString((Element)element, (String)"id"), WebServicesTestUtils.getXmlString((Element)element, (String)"user"), WebServicesTestUtils.getXmlString((Element)element, (String)"name"), WebServicesTestUtils.getXmlString((Element)element, (String)"state"), WebServicesTestUtils.getXmlLong((Element)element, (String)"startTime"), WebServicesTestUtils.getXmlLong((Element)element, (String)"finishTime"), WebServicesTestUtils.getXmlLong((Element)element, (String)"elapsedTime"), WebServicesTestUtils.getXmlInt((Element)element, (String)"mapsTotal"), WebServicesTestUtils.getXmlInt((Element)element, (String)"mapsCompleted"), WebServicesTestUtils.getXmlInt((Element)element, (String)"reducesTotal"), WebServicesTestUtils.getXmlInt((Element)element, (String)"reducesCompleted"), WebServicesTestUtils.getXmlFloat((Element)element, (String)"reduceProgress"), WebServicesTestUtils.getXmlFloat((Element)element, (String)"mapProgress"));
            this.verifyAMJobGenericSecure(job, WebServicesTestUtils.getXmlInt((Element)element, (String)"mapsPending"), WebServicesTestUtils.getXmlInt((Element)element, (String)"mapsRunning"), WebServicesTestUtils.getXmlInt((Element)element, (String)"reducesPending"), WebServicesTestUtils.getXmlInt((Element)element, (String)"reducesRunning"), WebServicesTestUtils.getXmlBoolean((Element)element, (String)"uberized"), WebServicesTestUtils.getXmlString((Element)element, (String)"diagnostics"), WebServicesTestUtils.getXmlInt((Element)element, (String)"newReduceAttempts"), WebServicesTestUtils.getXmlInt((Element)element, (String)"runningReduceAttempts"), WebServicesTestUtils.getXmlInt((Element)element, (String)"failedReduceAttempts"), WebServicesTestUtils.getXmlInt((Element)element, (String)"killedReduceAttempts"), WebServicesTestUtils.getXmlInt((Element)element, (String)"successfulReduceAttempts"), WebServicesTestUtils.getXmlInt((Element)element, (String)"newMapAttempts"), WebServicesTestUtils.getXmlInt((Element)element, (String)"runningMapAttempts"), WebServicesTestUtils.getXmlInt((Element)element, (String)"failedMapAttempts"), WebServicesTestUtils.getXmlInt((Element)element, (String)"killedMapAttempts"), WebServicesTestUtils.getXmlInt((Element)element, (String)"successfulMapAttempts"));
            Map allacls = job.getJobACLs();
            if (allacls == null) continue;
            for (Map.Entry entry : allacls.entrySet()) {
                String expectName = ((JobACL)entry.getKey()).getAclName();
                String expectValue = ((AccessControlList)entry.getValue()).getAclString();
                Boolean found = false;
                NodeList id = element.getElementsByTagName("acls");
                if (id != null) {
                    for (int j = 0; j < id.getLength(); ++j) {
                        Element aclElem = (Element)id.item(j);
                        if (aclElem == null) {
                            Assert.fail((String)"should have acls in the web service info");
                        }
                        if (!expectName.matches(WebServicesTestUtils.getXmlString((Element)aclElem, (String)"name"))) continue;
                        found = true;
                        WebServicesTestUtils.checkStringMatch((String)"value", (String)expectValue, (String)WebServicesTestUtils.getXmlString((Element)aclElem, (String)"value"));
                    }
                } else {
                    Assert.fail((String)"should have acls in the web service info");
                }
                Assert.assertTrue((String)("acl: " + expectName + " not found in webservice output"), (boolean)found);
            }
        }
    }

    public void verifyAMJobGeneric(Job job, String id, String user, String name, String state, long startTime, long finishTime, long elapsedTime, int mapsTotal, int mapsCompleted, int reducesTotal, int reducesCompleted, float reduceProgress, float mapProgress) {
        JobReport report = job.getReport();
        WebServicesTestUtils.checkStringMatch((String)"id", (String)MRApps.toString((JobId)job.getID()), (String)id);
        WebServicesTestUtils.checkStringMatch((String)"user", (String)job.getUserName().toString(), (String)user);
        WebServicesTestUtils.checkStringMatch((String)"name", (String)job.getName(), (String)name);
        WebServicesTestUtils.checkStringMatch((String)"state", (String)job.getState().toString(), (String)state);
        Assert.assertEquals((String)"startTime incorrect", (long)report.getStartTime(), (long)startTime);
        Assert.assertEquals((String)"finishTime incorrect", (long)report.getFinishTime(), (long)finishTime);
        Assert.assertEquals((String)"elapsedTime incorrect", (long)Times.elapsed((long)report.getStartTime(), (long)report.getFinishTime()), (long)elapsedTime);
        Assert.assertEquals((String)"mapsTotal incorrect", (long)job.getTotalMaps(), (long)mapsTotal);
        Assert.assertEquals((String)"mapsCompleted incorrect", (long)job.getCompletedMaps(), (long)mapsCompleted);
        Assert.assertEquals((String)"reducesTotal incorrect", (long)job.getTotalReduces(), (long)reducesTotal);
        Assert.assertEquals((String)"reducesCompleted incorrect", (long)job.getCompletedReduces(), (long)reducesCompleted);
        Assert.assertEquals((String)"mapProgress incorrect", (double)(report.getMapProgress() * 100.0f), (double)mapProgress, (double)0.0);
        Assert.assertEquals((String)"reduceProgress incorrect", (double)(report.getReduceProgress() * 100.0f), (double)reduceProgress, (double)0.0);
    }

    public void verifyAMJobGenericSecure(Job job, int mapsPending, int mapsRunning, int reducesPending, int reducesRunning, Boolean uberized, String diagnostics, int newReduceAttempts, int runningReduceAttempts, int failedReduceAttempts, int killedReduceAttempts, int successfulReduceAttempts, int newMapAttempts, int runningMapAttempts, int failedMapAttempts, int killedMapAttempts, int successfulMapAttempts) {
        String diagString = "";
        List diagList = job.getDiagnostics();
        if (diagList != null && !diagList.isEmpty()) {
            StringBuffer b = new StringBuffer();
            for (String diag : diagList) {
                b.append(diag);
            }
            diagString = b.toString();
        }
        WebServicesTestUtils.checkStringMatch((String)"diagnostics", (String)diagString, (String)diagnostics);
        Assert.assertEquals((String)"isUber incorrect", (Object)job.isUber(), (Object)uberized);
        Assert.assertTrue((String)"mapsPending not >= 0", (mapsPending >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"mapsRunning not >= 0", (mapsRunning >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"reducesPending not >= 0", (reducesPending >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"reducesRunning not >= 0", (reducesRunning >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"newReduceAttempts not >= 0", (newReduceAttempts >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"runningReduceAttempts not >= 0", (runningReduceAttempts >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"failedReduceAttempts not >= 0", (failedReduceAttempts >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"killedReduceAttempts not >= 0", (killedReduceAttempts >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"successfulReduceAttempts not >= 0", (successfulReduceAttempts >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"newMapAttempts not >= 0", (newMapAttempts >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"runningMapAttempts not >= 0", (runningMapAttempts >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"failedMapAttempts not >= 0", (failedMapAttempts >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"killedMapAttempts not >= 0", (killedMapAttempts >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"successfulMapAttempts not >= 0", (successfulMapAttempts >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testJobCounters() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("counters").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject info = json.getJSONObject("jobCounters");
            this.verifyAMJobCounters(info, (Job)jobsMap.get(id));
        }
    }

    @Test
    public void testJobCountersSlash() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("counters/").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject info = json.getJSONObject("jobCounters");
            this.verifyAMJobCounters(info, (Job)jobsMap.get(id));
        }
    }

    @Test
    public void testJobCountersDefault() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("counters/").get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject info = json.getJSONObject("jobCounters");
            this.verifyAMJobCounters(info, (Job)jobsMap.get(id));
        }
    }

    @Test
    public void testJobCountersXML() throws Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("counters").accept(new String[]{"application/xml"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
            String xml = (String)response.getEntity(String.class);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            Document dom = db.parse(is);
            NodeList info = dom.getElementsByTagName("jobCounters");
            this.verifyAMJobCountersXML(info, (Job)jobsMap.get(id));
        }
    }

    public void verifyAMJobCounters(JSONObject info, Job job) throws JSONException {
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)info.length());
        WebServicesTestUtils.checkStringMatch((String)"id", (String)MRApps.toString((JobId)job.getID()), (String)info.getString("id"));
        JSONArray counterGroups = info.getJSONArray("counterGroup");
        for (int i = 0; i < counterGroups.length(); ++i) {
            JSONObject counterGroup = counterGroups.getJSONObject(i);
            String name = counterGroup.getString("counterGroupName");
            Assert.assertTrue((String)"name not set", (name != null && !name.isEmpty() ? 1 : 0) != 0);
            JSONArray counters = counterGroup.getJSONArray("counter");
            for (int j = 0; j < counters.length(); ++j) {
                JSONObject counter = counters.getJSONObject(j);
                String counterName = counter.getString("name");
                Assert.assertTrue((String)"counter name not set", (counterName != null && !counterName.isEmpty() ? 1 : 0) != 0);
                long mapValue = counter.getLong("mapCounterValue");
                Assert.assertTrue((String)"mapCounterValue  >= 0", (mapValue >= 0L ? 1 : 0) != 0);
                long reduceValue = counter.getLong("reduceCounterValue");
                Assert.assertTrue((String)"reduceCounterValue  >= 0", (reduceValue >= 0L ? 1 : 0) != 0);
                long totalValue = counter.getLong("totalCounterValue");
                Assert.assertTrue((String)"totalCounterValue  >= 0", (totalValue >= 0L ? 1 : 0) != 0);
            }
        }
    }

    public void verifyAMJobCountersXML(NodeList nodes, Job job) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            Assert.assertNotNull((String)"Job not found - output incorrect", (Object)job);
            WebServicesTestUtils.checkStringMatch((String)"id", (String)MRApps.toString((JobId)job.getID()), (String)WebServicesTestUtils.getXmlString((Element)element, (String)"id"));
            NodeList groups = element.getElementsByTagName("counterGroup");
            for (int j = 0; j < groups.getLength(); ++j) {
                Element counters = (Element)groups.item(j);
                Assert.assertNotNull((String)"should have counters in the web service info", (Object)counters);
                String name = WebServicesTestUtils.getXmlString((Element)counters, (String)"counterGroupName");
                Assert.assertTrue((String)"name not set", (name != null && !name.isEmpty() ? 1 : 0) != 0);
                NodeList counterArr = counters.getElementsByTagName("counter");
                for (int z = 0; z < counterArr.getLength(); ++z) {
                    Element counter = (Element)counterArr.item(z);
                    String counterName = WebServicesTestUtils.getXmlString((Element)counter, (String)"name");
                    Assert.assertTrue((String)"counter name not set", (counterName != null && !counterName.isEmpty() ? 1 : 0) != 0);
                    long mapValue = WebServicesTestUtils.getXmlLong((Element)counter, (String)"mapCounterValue");
                    Assert.assertTrue((String)"mapCounterValue not >= 0", (mapValue >= 0L ? 1 : 0) != 0);
                    long reduceValue = WebServicesTestUtils.getXmlLong((Element)counter, (String)"reduceCounterValue");
                    Assert.assertTrue((String)"reduceCounterValue  >= 0", (reduceValue >= 0L ? 1 : 0) != 0);
                    long totalValue = WebServicesTestUtils.getXmlLong((Element)counter, (String)"totalCounterValue");
                    Assert.assertTrue((String)"totalCounterValue  >= 0", (totalValue >= 0L ? 1 : 0) != 0);
                }
            }
        }
    }

    @Test
    public void testJobAttempts() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("jobattempts").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject info = json.getJSONObject("jobAttempts");
            this.verifyJobAttempts(info, (Job)jobsMap.get(id));
        }
    }

    @Test
    public void testJobAttemptsSlash() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("jobattempts/").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject info = json.getJSONObject("jobAttempts");
            this.verifyJobAttempts(info, (Job)jobsMap.get(id));
        }
    }

    @Test
    public void testJobAttemptsDefault() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("jobattempts").get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject info = json.getJSONObject("jobAttempts");
            this.verifyJobAttempts(info, (Job)jobsMap.get(id));
        }
    }

    @Test
    public void testJobAttemptsXML() throws Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("jobattempts").accept(new String[]{"application/xml"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
            String xml = (String)response.getEntity(String.class);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            Document dom = db.parse(is);
            NodeList attempts = dom.getElementsByTagName("jobAttempts");
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)attempts.getLength());
            NodeList info = dom.getElementsByTagName("jobAttempt");
            this.verifyJobAttemptsXML(info, (Job)jobsMap.get(id));
        }
    }

    public void verifyJobAttempts(JSONObject info, Job job) throws JSONException {
        JSONArray attempts = info.getJSONArray("jobAttempt");
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)attempts.length());
        for (int i = 0; i < attempts.length(); ++i) {
            JSONObject attempt = attempts.getJSONObject(i);
            this.verifyJobAttemptsGeneric(job, attempt.getString("nodeHttpAddress"), attempt.getString("nodeId"), attempt.getInt("id"), attempt.getLong("startTime"), attempt.getString("containerId"), attempt.getString("logsLink"));
        }
    }

    public void verifyJobAttemptsXML(NodeList nodes, Job job) {
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            this.verifyJobAttemptsGeneric(job, WebServicesTestUtils.getXmlString((Element)element, (String)"nodeHttpAddress"), WebServicesTestUtils.getXmlString((Element)element, (String)"nodeId"), WebServicesTestUtils.getXmlInt((Element)element, (String)"id"), WebServicesTestUtils.getXmlLong((Element)element, (String)"startTime"), WebServicesTestUtils.getXmlString((Element)element, (String)"containerId"), WebServicesTestUtils.getXmlString((Element)element, (String)"logsLink"));
        }
    }

    public void verifyJobAttemptsGeneric(Job job, String nodeHttpAddress, String nodeId, int id, long startTime, String containerId, String logsLink) {
        boolean attemptFound = false;
        for (AMInfo amInfo : job.getAMInfos()) {
            if (amInfo.getAppAttemptId().getAttemptId() != id) continue;
            attemptFound = true;
            String nmHost = amInfo.getNodeManagerHost();
            int nmHttpPort = amInfo.getNodeManagerHttpPort();
            int nmPort = amInfo.getNodeManagerPort();
            WebServicesTestUtils.checkStringMatch((String)"nodeHttpAddress", (String)(nmHost + ":" + nmHttpPort), (String)nodeHttpAddress);
            WebServicesTestUtils.checkStringMatch((String)"nodeId", (String)NodeId.newInstance((String)nmHost, (int)nmPort).toString(), (String)nodeId);
            Assert.assertTrue((String)"startime not greater than 0", (startTime > 0L ? 1 : 0) != 0);
            WebServicesTestUtils.checkStringMatch((String)"containerId", (String)amInfo.getContainerId().toString(), (String)containerId);
            String localLogsLink = StringHelper.ujoin((String)"node", (String[])new String[]{"containerlogs", containerId, job.getUserName()});
            Assert.assertTrue((String)"logsLink", (boolean)logsLink.contains(localLogsLink));
        }
        Assert.assertTrue((String)("attempt: " + id + " was not found"), (boolean)attemptFound);
    }

    public class GuiceServletConfig
    extends GuiceServletContextListener {
        protected Injector getInjector() {
            return TestAMWebServicesJobs.this.injector;
        }
    }
}

