/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.io.IOException;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEventHandler;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MRApp;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.client.MRClientService;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.JobStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobFinishEvent;
import org.apache.hadoop.mapreduce.v2.app.job.impl.JobImpl;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.junit.Test;

public class TestMRAppComponentDependencies {
    @Test(timeout=20000L)
    public void testComponentStopOrder() throws Exception {
        TestMRApp app = new TestMRApp(1, 1, true, this.getClass().getName(), true);
        JobImpl job = (JobImpl)app.submit(new Configuration());
        app.waitForState((Job)job, JobState.SUCCEEDED);
        app.verifyCompleted();
        for (int waitTime = 20000; waitTime > 0 && app.numStops < 2; waitTime -= 100) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((int)1, (int)app.JobHistoryEventHandlerStopped);
        Assert.assertEquals((int)2, (int)app.clientServiceStopped);
    }

    private final class TestMRApp
    extends MRApp {
        int JobHistoryEventHandlerStopped;
        int clientServiceStopped;
        int numStops;

        public TestMRApp(int maps, int reduces, boolean autoComplete, String testName, boolean cleanOnStart) {
            super(maps, reduces, autoComplete, testName, cleanOnStart);
            this.JobHistoryEventHandlerStopped = 0;
            this.clientServiceStopped = 0;
            this.numStops = 0;
        }

        @Override
        protected Job createJob(Configuration conf, JobStateInternal forcedState, String diagnostic) {
            UserGroupInformation currentUser = null;
            try {
                currentUser = UserGroupInformation.getCurrentUser();
            }
            catch (IOException e) {
                throw new YarnRuntimeException((Throwable)e);
            }
            MRApp.TestJob newJob = new MRApp.TestJob(this, this.getJobId(), this.getAttemptID(), conf, this.getDispatcher().getEventHandler(), this.getTaskAttemptListener(), this.getContext().getClock(), this.getCommitter(), this.isNewApiCommitter(), currentUser.getUserName(), this.getContext(), forcedState, diagnostic);
            this.getContext().getAllJobs().put(newJob.getID(), newJob);
            this.getDispatcher().register(JobFinishEvent.Type.class, this.createJobFinishEventHandler());
            return newJob;
        }

        @Override
        protected ClientService createClientService(AppContext context) {
            return new MRClientService(context){

                public void serviceStop() throws Exception {
                    ++TestMRApp.this.numStops;
                    TestMRApp.this.clientServiceStopped = TestMRApp.this.numStops;
                    super.serviceStop();
                }
            };
        }

        @Override
        protected EventHandler<JobHistoryEvent> createJobHistoryHandler(AppContext context) {
            return new JobHistoryEventHandler(context, this.getStartCount()){

                public void serviceStop() throws Exception {
                    ++TestMRApp.this.numStops;
                    TestMRApp.this.JobHistoryEventHandlerStopped = TestMRApp.this.numStops;
                    super.serviceStop();
                }
            };
        }
    }
}

