/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.util.UUID;
import org.apache.hadoop.hdfs.StorageType;

public class DatanodeStorage {
    private final String storageID;
    private final State state;
    private final StorageType storageType;

    public DatanodeStorage(String storageID) {
        this(storageID, State.NORMAL, StorageType.DEFAULT);
    }

    public DatanodeStorage(String sid, State s, StorageType sm) {
        this.storageID = sid;
        this.state = s;
        this.storageType = sm;
    }

    public String getStorageID() {
        return this.storageID;
    }

    public State getState() {
        return this.state;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public static String generateUuid() {
        return "DS-" + UUID.randomUUID();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof DatanodeStorage)) {
            return false;
        }
        DatanodeStorage otherStorage = (DatanodeStorage)other;
        return otherStorage.getStorageID().compareTo(this.getStorageID()) == 0;
    }

    public int hashCode() {
        return this.getStorageID().hashCode();
    }

    public static enum State {
        NORMAL,
        READ_ONLY;

    }
}

