/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;

class ReplicaMap {
    private final Object mutex;
    private Map<String, Map<Long, ReplicaInfo>> map = new HashMap<String, Map<Long, ReplicaInfo>>();

    ReplicaMap(Object mutex) {
        if (mutex == null) {
            throw new HadoopIllegalArgumentException("Object to synchronize on cannot be null");
        }
        this.mutex = mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getBlockPoolList() {
        Object object = this.mutex;
        synchronized (object) {
            return this.map.keySet().toArray(new String[this.map.keySet().size()]);
        }
    }

    private void checkBlockPool(String bpid) {
        if (bpid == null) {
            throw new IllegalArgumentException("Block Pool Id is null");
        }
    }

    private void checkBlock(Block b) {
        if (b == null) {
            throw new IllegalArgumentException("Block is null");
        }
    }

    ReplicaInfo get(String bpid, Block block) {
        this.checkBlockPool(bpid);
        this.checkBlock(block);
        ReplicaInfo replicaInfo = this.get(bpid, block.getBlockId());
        if (replicaInfo != null && block.getGenerationStamp() == replicaInfo.getGenerationStamp()) {
            return replicaInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReplicaInfo get(String bpid, long blockId) {
        this.checkBlockPool(bpid);
        Object object = this.mutex;
        synchronized (object) {
            Map<Long, ReplicaInfo> m = this.map.get(bpid);
            return m != null ? m.get(blockId) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReplicaInfo add(String bpid, ReplicaInfo replicaInfo) {
        this.checkBlockPool(bpid);
        this.checkBlock(replicaInfo);
        Object object = this.mutex;
        synchronized (object) {
            Map<Long, ReplicaInfo> m = this.map.get(bpid);
            if (m == null) {
                m = new HashMap<Long, ReplicaInfo>();
                this.map.put(bpid, m);
            }
            return m.put(replicaInfo.getBlockId(), replicaInfo);
        }
    }

    void addAll(ReplicaMap other) {
        this.map.putAll(other.map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReplicaInfo remove(String bpid, Block block) {
        this.checkBlockPool(bpid);
        this.checkBlock(block);
        Object object = this.mutex;
        synchronized (object) {
            Long key;
            ReplicaInfo replicaInfo;
            Map<Long, ReplicaInfo> m = this.map.get(bpid);
            if (m != null && (replicaInfo = m.get(key = Long.valueOf(block.getBlockId()))) != null && block.getGenerationStamp() == replicaInfo.getGenerationStamp()) {
                return m.remove(key);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReplicaInfo remove(String bpid, long blockId) {
        this.checkBlockPool(bpid);
        Object object = this.mutex;
        synchronized (object) {
            Map<Long, ReplicaInfo> m = this.map.get(bpid);
            if (m != null) {
                return m.remove(blockId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int size(String bpid) {
        Map<Long, ReplicaInfo> m = null;
        Object object = this.mutex;
        synchronized (object) {
            m = this.map.get(bpid);
            return m != null ? m.size() : 0;
        }
    }

    Collection<ReplicaInfo> replicas(String bpid) {
        Map<Long, ReplicaInfo> m = null;
        m = this.map.get(bpid);
        return m != null ? m.values() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initBlockPool(String bpid) {
        this.checkBlockPool(bpid);
        Object object = this.mutex;
        synchronized (object) {
            Map<Long, ReplicaInfo> m = this.map.get(bpid);
            if (m == null) {
                m = new HashMap<Long, ReplicaInfo>();
                this.map.put(bpid, m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanUpBlockPool(String bpid) {
        this.checkBlockPool(bpid);
        Object object = this.mutex;
        synchronized (object) {
            this.map.remove(bpid);
        }
    }

    Object getMutext() {
        return this.mutex;
    }
}

