/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.IOException;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestDFSClientRetries;
import org.apache.hadoop.hdfs.server.namenode.web.resources.NamenodeWebHdfsMethods;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;

public class TestWebHDFS {
    static final Log LOG = LogFactory.getLog(TestWebHDFS.class);
    static final Random RANDOM = new Random();
    static final long systemStartTime = System.nanoTime();

    @Test(timeout=300000L)
    public void testLargeFile() throws Exception {
        TestWebHDFS.largeFileTest(0xC800000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void largeFileTest(long fileLength) throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        try {
            cluster.waitActive();
            WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
            Path dir = new Path("/test/largeFile");
            Assert.assertTrue((boolean)fs.mkdirs(dir));
            byte[] data = new byte[0x100000];
            RANDOM.nextBytes(data);
            byte[] expected = new byte[2 * data.length];
            System.arraycopy(data, 0, expected, 0, data.length);
            System.arraycopy(data, 0, expected, data.length, data.length);
            Path p = new Path(dir, "file");
            Ticker t = new Ticker("WRITE", "fileLength=" + fileLength, new Object[0]);
            FSDataOutputStream out = fs.create(p);
            try {
                int n;
                for (long remaining = fileLength; remaining > 0L; remaining -= (long)n) {
                    t.tick(fileLength - remaining, "remaining=%d", remaining);
                    n = (int)Math.min(remaining, (long)data.length);
                    out.write(data, 0, n);
                }
            }
            finally {
                out.close();
            }
            t.end(fileLength);
            Assert.assertEquals((long)fileLength, (long)fs.getFileStatus(p).getLen());
            long smallOffset = RANDOM.nextInt(0x100000) + 0x100000;
            long largeOffset = fileLength - smallOffset;
            byte[] buf = new byte[data.length];
            TestWebHDFS.verifySeek((FileSystem)fs, p, largeOffset, fileLength, buf, expected);
            TestWebHDFS.verifySeek((FileSystem)fs, p, smallOffset, fileLength, buf, expected);
            TestWebHDFS.verifyPread((FileSystem)fs, p, largeOffset, fileLength, buf, expected);
        }
        finally {
            cluster.shutdown();
        }
    }

    static void checkData(long offset, long remaining, int n, byte[] actual, byte[] expected) {
        if (RANDOM.nextInt(100) == 0) {
            int j = (int)(offset % (long)actual.length);
            for (int i = 0; i < n; ++i) {
                if (expected[j] != actual[i]) {
                    Assert.fail((String)("expected[" + j + "]=" + expected[j] + " != actual[" + i + "]=" + actual[i] + ", offset=" + offset + ", remaining=" + remaining + ", n=" + n));
                }
                ++j;
            }
        }
    }

    static void verifySeek(FileSystem fs, Path p, long offset, long length, byte[] buf, byte[] expected) throws IOException {
        long remaining = length - offset;
        long checked = 0L;
        LOG.info((Object)("XXX SEEK: offset=" + offset + ", remaining=" + remaining));
        Ticker t = new Ticker("SEEK", "offset=%d, remaining=%d", offset, remaining);
        FSDataInputStream in = fs.open(p, 65536);
        in.seek(offset);
        while (remaining > 0L) {
            t.tick(checked, "offset=%d, remaining=%d", offset, remaining);
            int n = (int)Math.min(remaining, (long)buf.length);
            in.readFully(buf, 0, n);
            TestWebHDFS.checkData(offset, remaining, n, buf, expected);
            offset += (long)n;
            remaining -= (long)n;
            checked += (long)n;
        }
        in.close();
        t.end(checked);
    }

    static void verifyPread(FileSystem fs, Path p, long offset, long length, byte[] buf, byte[] expected) throws IOException {
        long remaining = length - offset;
        long checked = 0L;
        LOG.info((Object)("XXX PREAD: offset=" + offset + ", remaining=" + remaining));
        Ticker t = new Ticker("PREAD", "offset=%d, remaining=%d", offset, remaining);
        FSDataInputStream in = fs.open(p, 65536);
        while (remaining > 0L) {
            t.tick(checked, "offset=%d, remaining=%d", offset, remaining);
            int n = (int)Math.min(remaining, (long)buf.length);
            in.readFully(offset, buf, 0, n);
            TestWebHDFS.checkData(offset, remaining, n, buf, expected);
            offset += (long)n;
            remaining -= (long)n;
            checked += (long)n;
        }
        in.close();
        t.end(checked);
    }

    @Test(timeout=300000L)
    public void testNamenodeRestart() throws Exception {
        ((Log4JLogger)NamenodeWebHdfsMethods.LOG).getLogger().setLevel(Level.ALL);
        Configuration conf = WebHdfsTestUtil.createConf();
        TestDFSClientRetries.namenodeRestartTest(conf, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testLargeDirectory() throws Exception {
        final Configuration conf = WebHdfsTestUtil.createConf();
        int listLimit = 2;
        conf.setInt("dfs.ls.limit", 2);
        FsPermission.setUMask((Configuration)conf, (FsPermission)new FsPermission(63));
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        try {
            cluster.waitActive();
            WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs").setPermission(new Path("/"), new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
            UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createUserForTesting((String)"not-superuser", (String[])new String[]{"not-supergroup"}));
            UserGroupInformation.createUserForTesting((String)"me", (String[])new String[]{"my-group"}).doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException, URISyntaxException {
                    WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
                    Path d = new Path("/my-dir");
                    Assert.assertTrue((boolean)fs.mkdirs(d));
                    for (int i = 0; i < 6; ++i) {
                        Path p = new Path(d, "file-" + i);
                        Assert.assertTrue((boolean)fs.createNewFile(p));
                    }
                    Assert.assertEquals((long)6L, (long)fs.listStatus(d).length);
                    return null;
                }
            });
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testNumericalUserName() throws Exception {
        final Configuration conf = WebHdfsTestUtil.createConf();
        conf.set("dfs.webhdfs.user.provider.user.pattern", "^[A-Za-z0-9_][A-Za-z0-9._-]*[$]?$");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        try {
            cluster.waitActive();
            WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs").setPermission(new Path("/"), new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
            UserGroupInformation.createUserForTesting((String)"123", (String[])new String[]{"my-group"}).doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException, URISyntaxException {
                    WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
                    Path d = new Path("/my-dir");
                    Assert.assertTrue((boolean)fs.mkdirs(d));
                    return null;
                }
            });
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testWebHdfsEnabledByDefault() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        Assert.assertTrue((boolean)conf.getBoolean("dfs.webhdfs.enabled", false));
    }

    static class Ticker {
        final String name;
        final long startTime;
        private long previousTick;

        Ticker(String name, String format, Object ... args) {
            this.previousTick = this.startTime = System.nanoTime();
            this.name = name;
            LOG.info((Object)String.format("\n\n%s START: %s\n", name, String.format(format, args)));
        }

        void tick(long nBytes, String format, Object ... args) {
            long now = System.nanoTime();
            if (now - this.previousTick > 10000000000L) {
                this.previousTick = now;
                double mintues = (double)(now - systemStartTime) / 6.0E10;
                LOG.info((Object)String.format("\n\n%s %.2f min) %s %s\n", this.name, mintues, String.format(format, args), this.toMpsString(nBytes, now)));
            }
        }

        void end(long nBytes) {
            long now = System.nanoTime();
            double seconds = (double)(now - this.startTime) / 1.0E9;
            LOG.info((Object)String.format("\n\n%s END: duration=%.2fs %s\n", this.name, seconds, this.toMpsString(nBytes, now)));
        }

        String toMpsString(long nBytes, long now) {
            double mb = (double)nBytes / 1048576.0;
            double mps = mb * 1.0E9 / (double)(now - this.startTime);
            return String.format("[nBytes=%.2fMB, speed=%.2fMB/s]", mb, mps);
        }
    }
}

