/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.test.MultithreadedTestUtil;

public class HAStressTestHarness {
    Configuration conf;
    private MiniDFSCluster cluster;
    static final int BLOCK_SIZE = 1024;
    MultithreadedTestUtil.TestContext testCtx = new MultithreadedTestUtil.TestContext();

    public HAStressTestHarness() {
        this.conf = new Configuration();
        this.conf.setInt("dfs.blocksize", 1024);
        this.conf.setInt("dfs.heartbeat.interval", 1);
        this.conf.setInt("dfs.ha.tail-edits.period", 1);
        this.conf.setInt("dfs.namenode.replication.max-streams", 1000);
    }

    public MiniDFSCluster startCluster() throws IOException {
        this.cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(3).build();
        return this.cluster;
    }

    public FileSystem getFailoverFs() throws IOException, URISyntaxException {
        return HATestUtil.configureFailoverFs(this.cluster, this.conf);
    }

    public void addReplicationTriggerThread(final int interval) {
        this.testCtx.addThread((MultithreadedTestUtil.TestingThread)new MultithreadedTestUtil.RepeatingTestThread(this.testCtx){

            public void doAnAction() throws Exception {
                for (DataNode dn : HAStressTestHarness.this.cluster.getDataNodes()) {
                    DataNodeTestUtils.triggerDeletionReport(dn);
                    DataNodeTestUtils.triggerHeartbeat(dn);
                }
                for (int i = 0; i < 2; ++i) {
                    NameNode nn = HAStressTestHarness.this.cluster.getNameNode(i);
                    BlockManagerTestUtil.computeAllPendingWork(nn.getNamesystem().getBlockManager());
                }
                Thread.sleep(interval);
            }
        });
    }

    public void addFailoverThread(final int msBetweenFailovers) {
        this.testCtx.addThread((MultithreadedTestUtil.TestingThread)new MultithreadedTestUtil.RepeatingTestThread(this.testCtx){

            public void doAnAction() throws Exception {
                System.err.println("==============================\nFailing over from 0->1\n==================================");
                HAStressTestHarness.this.cluster.transitionToStandby(0);
                HAStressTestHarness.this.cluster.transitionToActive(1);
                Thread.sleep(msBetweenFailovers);
                System.err.println("==============================\nFailing over from 1->0\n==================================");
                HAStressTestHarness.this.cluster.transitionToStandby(1);
                HAStressTestHarness.this.cluster.transitionToActive(0);
                Thread.sleep(msBetweenFailovers);
            }
        });
    }

    public void startThreads() {
        this.testCtx.startThreads();
    }

    public void stopThreads() throws Exception {
        this.testCtx.stop();
    }

    public void shutdown() throws Exception {
        this.testCtx.stop();
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }
}

