/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.log4j.Level;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestIncrementalBrVariations {
    public static final Log LOG = LogFactory.getLog(TestIncrementalBrVariations.class);
    private static short NUM_DATANODES = 1;
    static final int BLOCK_SIZE = 1024;
    static final int NUM_BLOCKS = 10;
    private static final long seed = 4207869677L;
    private static final String NN_METRICS = "NameNodeActivity";
    private MiniDFSCluster cluster;
    private DistributedFileSystem fs;
    private DFSClient client;
    private static Configuration conf;

    @Before
    public void startUpCluster() throws IOException {
        conf = new Configuration();
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(NUM_DATANODES).build();
        this.fs = this.cluster.getFileSystem();
        this.client = new DFSClient(new InetSocketAddress("localhost", this.cluster.getNameNodePort()), this.cluster.getConfiguration(0));
    }

    @After
    public void shutDownCluster() throws IOException {
        this.client.close();
        this.fs.close();
        this.cluster.shutdownDataNodes();
        this.cluster.shutdown();
    }

    @Test
    public void testCombinedIncrementalBlockReport() throws IOException {
        this.verifyIncrementalBlockReports(false);
    }

    @Test
    public void testSplitIncrementalBlockReport() throws IOException {
        this.verifyIncrementalBlockReports(true);
    }

    private LocatedBlocks createFileGetBlocks(String filenamePrefix) throws IOException {
        Path filePath = new Path("/" + filenamePrefix + ".dat");
        DFSTestUtil.createFile((FileSystem)this.fs, filePath, 1024, 10240L, 1024L, NUM_DATANODES, 4207869677L);
        LocatedBlocks blocks = this.client.getLocatedBlocks(filePath.toString(), 0L, 10240L);
        Assert.assertThat((Object)this.cluster.getNamesystem().getUnderReplicatedBlocks(), (Matcher)Is.is((Object)0L));
        return blocks;
    }

    public void verifyIncrementalBlockReports(boolean splitReports) throws IOException {
        LocatedBlocks blocks = this.createFileGetBlocks(GenericTestUtils.getMethodName());
        DataNode dn = this.cluster.getDataNodes().get(0);
        String poolId = this.cluster.getNamesystem().getBlockPoolId();
        DatanodeRegistration dnR = dn.getDNRegistrationForBP(poolId);
        StorageReceivedDeletedBlocks[] reports = new StorageReceivedDeletedBlocks[dn.getFSDataset().getVolumes().size()];
        for (int i = 0; i < reports.length; ++i) {
            FsVolumeSpi volume = (FsVolumeSpi)dn.getFSDataset().getVolumes().get(i);
            boolean foundBlockOnStorage = false;
            ReceivedDeletedBlockInfo[] rdbi = new ReceivedDeletedBlockInfo[1];
            for (LocatedBlock block : blocks.getLocatedBlocks()) {
                if (!block.getStorageIDs()[0].equals(volume.getStorageID())) continue;
                rdbi[0] = new ReceivedDeletedBlockInfo(block.getBlock().getLocalBlock(), ReceivedDeletedBlockInfo.BlockStatus.DELETED_BLOCK, null);
                foundBlockOnStorage = true;
                break;
            }
            Assert.assertTrue((boolean)foundBlockOnStorage);
            reports[i] = new StorageReceivedDeletedBlocks(volume.getStorageID(), rdbi);
            if (!splitReports) continue;
            StorageReceivedDeletedBlocks[] singletonReport = new StorageReceivedDeletedBlocks[]{reports[i]};
            this.cluster.getNameNodeRpc().blockReceivedAndDeleted(dnR, poolId, singletonReport);
        }
        if (!splitReports) {
            this.cluster.getNameNodeRpc().blockReceivedAndDeleted(dnR, poolId, reports);
        }
        Assert.assertThat((Object)this.cluster.getNamesystem().getMissingBlocksCount(), (Matcher)Is.is((Object)reports.length));
    }

    @Test(timeout=60000L)
    public void testDataNodeDoesNotSplitReports() throws IOException, InterruptedException {
        LocatedBlocks blocks = this.createFileGetBlocks(GenericTestUtils.getMethodName());
        Assert.assertThat((Object)this.cluster.getDataNodes().size(), (Matcher)Is.is((Object)1));
        DataNode dn = this.cluster.getDataNodes().get(0);
        for (LocatedBlock block : blocks.getLocatedBlocks()) {
            dn.notifyNamenodeDeletedBlock(block.getBlock(), block.getStorageIDs()[0]);
        }
        LOG.info((Object)"Triggering report after deleting blocks");
        long ops = MetricsAsserts.getLongCounter((String)"BlockReceivedAndDeletedOps", (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NN_METRICS));
        DataNodeTestUtils.triggerBlockReport(dn);
        Thread.sleep(5000L);
        MetricsAsserts.assertCounter((String)"BlockReceivedAndDeletedOps", (long)(ops + 1L), (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NN_METRICS));
    }

    static {
        ((Log4JLogger)NameNode.stateChangeLog).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)BlockManager.blockLog).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)NameNode.blockStateChangeLog).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LogFactory.getLog(FSNamesystem.class)).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)DataNode.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LOG).getLogger().setLevel(Level.ALL);
    }
}

