/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActor;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDataNodeMultipleRegistrations {
    private static final Log LOG = LogFactory.getLog(TestDataNodeMultipleRegistrations.class);
    Configuration conf;

    @Before
    public void setUp() throws Exception {
        this.conf = new HdfsConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test2NNRegistration() throws IOException {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(2)).build();
        try {
            cluster.waitActive();
            NameNode nn1 = cluster.getNameNode(0);
            NameNode nn2 = cluster.getNameNode(1);
            Assert.assertNotNull((String)"cannot create nn1", (Object)nn1);
            Assert.assertNotNull((String)"cannot create nn2", (Object)nn2);
            String bpid1 = FSImageTestUtil.getFSImage(nn1).getBlockPoolID();
            String bpid2 = FSImageTestUtil.getFSImage(nn2).getBlockPoolID();
            String cid1 = FSImageTestUtil.getFSImage(nn1).getClusterID();
            String cid2 = FSImageTestUtil.getFSImage(nn2).getClusterID();
            int lv1 = FSImageTestUtil.getFSImage(nn1).getLayoutVersion();
            int lv2 = FSImageTestUtil.getFSImage(nn2).getLayoutVersion();
            int ns1 = FSImageTestUtil.getFSImage(nn1).getNamespaceID();
            int ns2 = FSImageTestUtil.getFSImage(nn2).getNamespaceID();
            Assert.assertNotSame((String)"namespace ids should be different", (Object)ns1, (Object)ns2);
            LOG.info((Object)("nn1: lv=" + lv1 + ";cid=" + cid1 + ";bpid=" + bpid1 + ";uri=" + nn1.getNameNodeAddress()));
            LOG.info((Object)("nn2: lv=" + lv2 + ";cid=" + cid2 + ";bpid=" + bpid2 + ";uri=" + nn2.getNameNodeAddress()));
            DataNode dn = cluster.getDataNodes().get(0);
            Map volInfos = dn.data.getVolumeInfoMap();
            Assert.assertTrue((String)"No volumes in the fsdataset", (volInfos.size() > 0 ? 1 : 0) != 0);
            int i = 0;
            for (Map.Entry e : volInfos.entrySet()) {
                LOG.info((Object)("vol " + i++ + ") " + (String)e.getKey() + ": " + e.getValue()));
            }
            Assert.assertEquals((String)"number of volumes is wrong", (long)2L, (long)volInfos.size());
            for (BPOfferService bpos : dn.getAllBpOs()) {
                LOG.info((Object)("BP: " + bpos));
            }
            BPOfferService bpos1 = dn.getAllBpOs()[0];
            BPOfferService bpos2 = dn.getAllBpOs()[1];
            if (TestDataNodeMultipleRegistrations.getNNSocketAddress(bpos1).equals(nn2.getNameNodeAddress())) {
                BPOfferService tmp = bpos1;
                bpos1 = bpos2;
                bpos2 = tmp;
            }
            Assert.assertEquals((String)"wrong nn address", (Object)TestDataNodeMultipleRegistrations.getNNSocketAddress(bpos1), (Object)nn1.getNameNodeAddress());
            Assert.assertEquals((String)"wrong nn address", (Object)TestDataNodeMultipleRegistrations.getNNSocketAddress(bpos2), (Object)nn2.getNameNodeAddress());
            Assert.assertEquals((String)"wrong bpid", (Object)bpos1.getBlockPoolId(), (Object)bpid1);
            Assert.assertEquals((String)"wrong bpid", (Object)bpos2.getBlockPoolId(), (Object)bpid2);
            Assert.assertEquals((String)"wrong cid", (Object)dn.getClusterId(), (Object)cid1);
            Assert.assertEquals((String)"cid should be same", (Object)cid2, (Object)cid1);
            Assert.assertEquals((String)"namespace should be same", (long)bpos1.bpNSInfo.namespaceID, (long)ns1);
            Assert.assertEquals((String)"namespace should be same", (long)bpos2.bpNSInfo.namespaceID, (long)ns2);
        }
        finally {
            cluster.shutdown();
        }
    }

    private static InetSocketAddress getNNSocketAddress(BPOfferService bpos) {
        List actors = bpos.getBPServiceActors();
        Assert.assertEquals((long)1L, (long)actors.size());
        return ((BPServiceActor)actors.get(0)).getNNSocketAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFedSingleNN() throws IOException {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf).nameNodePort(9927).build();
        try {
            NameNode nn1 = cluster.getNameNode();
            Assert.assertNotNull((String)"cannot create nn1", (Object)nn1);
            String bpid1 = FSImageTestUtil.getFSImage(nn1).getBlockPoolID();
            String cid1 = FSImageTestUtil.getFSImage(nn1).getClusterID();
            int lv1 = FSImageTestUtil.getFSImage(nn1).getLayoutVersion();
            LOG.info((Object)("nn1: lv=" + lv1 + ";cid=" + cid1 + ";bpid=" + bpid1 + ";uri=" + nn1.getNameNodeAddress()));
            DataNode dn = cluster.getDataNodes().get(0);
            Map volInfos = dn.data.getVolumeInfoMap();
            Assert.assertTrue((String)"No volumes in the fsdataset", (volInfos.size() > 0 ? 1 : 0) != 0);
            int i = 0;
            for (Map.Entry e : volInfos.entrySet()) {
                LOG.info((Object)("vol " + i++ + ") " + (String)e.getKey() + ": " + e.getValue()));
            }
            Assert.assertEquals((String)"number of volumes is wrong", (long)2L, (long)volInfos.size());
            for (BPOfferService bpos : dn.getAllBpOs()) {
                LOG.info((Object)("reg: bpid=; name=" + bpos.bpRegistration + "; sid=" + bpos.bpRegistration.getDatanodeUuid() + "; nna=" + TestDataNodeMultipleRegistrations.getNNSocketAddress(bpos)));
            }
            BPOfferService bpos1 = dn.getAllBpOs()[0];
            bpos1.triggerBlockReportForTests();
            Assert.assertEquals((String)"wrong nn address", (Object)TestDataNodeMultipleRegistrations.getNNSocketAddress(bpos1), (Object)nn1.getNameNodeAddress());
            Assert.assertEquals((String)"wrong bpid", (Object)bpos1.getBlockPoolId(), (Object)bpid1);
            Assert.assertEquals((String)"wrong cid", (Object)dn.getClusterId(), (Object)cid1);
            cluster.shutdown();
            Assert.assertEquals((long)0L, (long)dn.getAllBpOs().length);
            cluster = null;
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClusterIdMismatch() throws IOException {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(2)).build();
        try {
            cluster.waitActive();
            DataNode dn = cluster.getDataNodes().get(0);
            BPOfferService[] bposs = dn.getAllBpOs();
            LOG.info((Object)("dn bpos len (should be 2):" + bposs.length));
            Assert.assertEquals((String)"should've registered with two namenodes", (long)bposs.length, (long)2L);
            cluster.addNameNode(this.conf, 9938);
            bposs = dn.getAllBpOs();
            LOG.info((Object)("dn bpos len (should be 3):" + bposs.length));
            Assert.assertEquals((String)"should've registered with three namenodes", (long)bposs.length, (long)3L);
            HdfsServerConstants.StartupOption.FORMAT.setClusterId("DifferentCID");
            cluster.addNameNode(this.conf, 9948);
            NameNode nn4 = cluster.getNameNode(3);
            Assert.assertNotNull((String)"cannot create nn4", (Object)nn4);
            bposs = dn.getAllBpOs();
            LOG.info((Object)("dn bpos len (still should be 3):" + bposs.length));
            Assert.assertEquals((String)"should've registered with three namenodes", (long)3L, (long)bposs.length);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMiniDFSClusterWithMultipleNN() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(2)).build();
        try {
            Assert.assertNotNull((Object)cluster);
            cluster.waitActive();
            Assert.assertEquals((String)"(1)Should be 2 namenodes", (long)2L, (long)cluster.getNumNameNodes());
            cluster.addNameNode((Configuration)conf, 0);
            Assert.assertEquals((String)"(1)Should be 3 namenodes", (long)3L, (long)cluster.getNumNameNodes());
        }
        catch (IOException ioe) {
            Assert.fail((String)("Failed to add NN to cluster:" + StringUtils.stringifyException((Throwable)ioe)));
        }
        finally {
            cluster.shutdown();
        }
        conf = new HdfsConfiguration();
        cluster = new MiniDFSCluster.Builder((Configuration)conf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(1)).build();
        try {
            Assert.assertNotNull((Object)cluster);
            cluster.waitActive();
            Assert.assertEquals((String)"(2)Should be 1 namenodes", (long)1L, (long)cluster.getNumNameNodes());
            cluster.addNameNode((Configuration)conf, 0);
            Assert.assertEquals((String)"(2)Should be 2 namenodes", (long)2L, (long)cluster.getNumNameNodes());
        }
        catch (IOException ioe) {
            Assert.fail((String)("Failed to add NN to cluster:" + StringUtils.stringifyException((Throwable)ioe)));
        }
        finally {
            cluster.shutdown();
        }
        conf = new HdfsConfiguration();
        cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitActive();
            Assert.assertNotNull((Object)cluster);
            Assert.assertEquals((String)"(2)Should be 1 namenodes", (long)1L, (long)cluster.getNumNameNodes());
            cluster.addNameNode((Configuration)conf, 9929);
            Assert.fail((String)"shouldn't be able to add another NN to non federated cluster");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("cannot add namenode"));
            Assert.assertEquals((String)"(3)Should be 1 namenodes", (long)1L, (long)cluster.getNumNameNodes());
        }
        finally {
            cluster.shutdown();
        }
    }
}

