/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Joiner;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsUtils;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NotReplicatedYetException;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.stubbing.answers.ThrowsException;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestDFSClientRetries {
    private static final String ADDRESS = "0.0.0.0";
    private static final int PING_INTERVAL = 1000;
    private static final int MIN_SLEEP_TIME = 1000;
    public static final Log LOG = LogFactory.getLog((String)TestDFSClientRetries.class.getName());
    private static Configuration conf = null;

    private static void writeData(OutputStream out, int len) throws IOException {
        byte[] buf = new byte[65536];
        while (len > 0) {
            int toWrite = Math.min(len, buf.length);
            out.write(buf, 0, toWrite);
            len -= toWrite;
        }
    }

    @Before
    public void setupConf() {
        conf = new HdfsConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteTimeoutAtDataNode() throws IOException, InterruptedException {
        int writeTimeout = 100;
        conf.setInt("dfs.datanode.socket.write.timeout", 100);
        int blockSize = 0xA00000;
        conf.setInt("dfs.blocksize", 0xA00000);
        conf.setInt("dfs.client.max.block.acquire.failures", 1);
        int bufferSize = 4096;
        conf.setInt("io.file.buffer.size", 4096);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        try {
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path filePath = new Path("/testWriteTimeoutAtDataNode");
            FSDataOutputStream out = fs.create(filePath, true, 4096);
            TestDFSClientRetries.writeData((OutputStream)out, 0x1400000);
            out.close();
            byte[] buf = new byte[0x100000];
            FSDataInputStream in = fs.open(filePath, 4096);
            IOUtils.readFully((InputStream)in, (byte[])buf, (int)0, (int)2048);
            for (int i = 0; i < 10; ++i) {
                Thread.sleep(200L);
                IOUtils.readFully((InputStream)in, (byte[])buf, (int)0, (int)buf.length);
            }
            in.close();
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testNotYetReplicatedErrors() throws IOException {
        String exceptionMsg = "Nope, not replicated yet...";
        boolean maxRetries = true;
        conf.setInt("dfs.client.block.write.locateFollowingBlock.retries", 1);
        NamenodeProtocols mockNN = (NamenodeProtocols)Mockito.mock(NamenodeProtocols.class);
        ThrowsException answer = new ThrowsException(new IOException()){
            int retryCount;
            {
                this.retryCount = 0;
            }

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ++this.retryCount;
                System.out.println("addBlock has been called " + this.retryCount + " times");
                if (this.retryCount > 2) {
                    throw new IOException("Retried too many times: " + this.retryCount);
                }
                throw new RemoteException(NotReplicatedYetException.class.getName(), "Nope, not replicated yet...");
            }
        };
        Mockito.when((Object)mockNN.addBlock(Matchers.anyString(), Matchers.anyString(), (ExtendedBlock)Matchers.any(ExtendedBlock.class), (DatanodeInfo[])Matchers.any(DatanodeInfo[].class), Matchers.anyLong(), (String[])Matchers.any(String[].class))).thenAnswer((Answer)answer);
        ((NamenodeProtocols)Mockito.doReturn((Object)new HdfsFileStatus(0L, false, 1, 1024L, 0L, 0L, new FsPermission(777), "owner", "group", new byte[0], new byte[0], 1010L, 0)).when((Object)mockNN)).getFileInfo(Matchers.anyString());
        ((NamenodeProtocols)Mockito.doReturn((Object)new HdfsFileStatus(0L, false, 1, 1024L, 0L, 0L, new FsPermission(777), "owner", "group", new byte[0], new byte[0], 1010L, 0)).when((Object)mockNN)).create(Matchers.anyString(), (FsPermission)Matchers.anyObject(), Matchers.anyString(), (EnumSetWritable)Matchers.anyObject(), Matchers.anyBoolean(), Matchers.anyShort(), Matchers.anyLong());
        DFSClient client = new DFSClient(null, (ClientProtocol)mockNN, conf, null);
        OutputStream os = client.create("testfile", true);
        os.write(20);
        try {
            os.close();
        }
        catch (Exception e) {
            Assert.assertTrue((String)("Retries are not being stopped correctly: " + e.getMessage()), (boolean)e.getMessage().equals("Nope, not replicated yet..."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailuresArePerOperation() throws Exception {
        long fileSize = 4096L;
        Path file = new Path("/testFile");
        conf.setInt("dfs.client.retry.window.base", 10);
        conf.setInt("dfs.client.socket-timeout", 2000);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        try {
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            NamenodeProtocols preSpyNN = cluster.getNameNodeRpc();
            NamenodeProtocols spyNN = (NamenodeProtocols)Mockito.spy((Object)preSpyNN);
            DFSClient client = new DFSClient(null, (ClientProtocol)spyNN, conf, null);
            int maxBlockAcquires = client.getMaxBlockAcquireFailures();
            Assert.assertTrue((maxBlockAcquires > 0 ? 1 : 0) != 0);
            DFSTestUtil.createFile((FileSystem)fs, file, fileSize, (short)1, 12345L);
            ((NamenodeProtocols)Mockito.doAnswer((Answer)new FailNTimesAnswer(preSpyNN, maxBlockAcquires + 1)).when((Object)spyNN)).getBlockLocations(Matchers.anyString(), Matchers.anyLong(), Matchers.anyLong());
            try {
                IOUtils.copyBytes((InputStream)client.open(file.toString()), (OutputStream)new IOUtils.NullOutputStream(), (Configuration)conf, (boolean)true);
                Assert.fail((String)"Didn't get exception");
            }
            catch (IOException ioe) {
                DFSClient.LOG.info((Object)"Got expected exception", (Throwable)ioe);
            }
            ((NamenodeProtocols)Mockito.doAnswer((Answer)new FailNTimesAnswer(preSpyNN, maxBlockAcquires)).when((Object)spyNN)).getBlockLocations(Matchers.anyString(), Matchers.anyLong(), Matchers.anyLong());
            IOUtils.copyBytes((InputStream)client.open(file.toString()), (OutputStream)new IOUtils.NullOutputStream(), (Configuration)conf, (boolean)true);
            DFSClient.LOG.info((Object)"Starting test case for failure reset");
            ((NamenodeProtocols)Mockito.doAnswer((Answer)new FailNTimesAnswer(preSpyNN, maxBlockAcquires)).when((Object)spyNN)).getBlockLocations(Matchers.anyString(), Matchers.anyLong(), Matchers.anyLong());
            DFSInputStream is = client.open(file.toString());
            byte[] buf = new byte[10];
            IOUtils.readFully((InputStream)is, (byte[])buf, (int)0, (int)buf.length);
            DFSClient.LOG.info((Object)"First read successful after some failures.");
            ((NamenodeProtocols)Mockito.doAnswer((Answer)new FailNTimesAnswer(preSpyNN, maxBlockAcquires)).when((Object)spyNN)).getBlockLocations(Matchers.anyString(), Matchers.anyLong(), Matchers.anyLong());
            is.openInfo();
            is.seek(0L);
            IOUtils.readFully((InputStream)is, (byte[])buf, (int)0, (int)buf.length);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIdempotentAllocateBlockAndClose() throws Exception {
        String src = "/testIdempotentAllocateBlock";
        Path file = new Path("/testIdempotentAllocateBlock");
        conf.setInt("dfs.blocksize", 4096);
        final MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        try {
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            NamenodeProtocols preSpyNN = cluster.getNameNodeRpc();
            NamenodeProtocols spyNN = (NamenodeProtocols)Mockito.spy((Object)preSpyNN);
            DFSClient client = new DFSClient(null, (ClientProtocol)spyNN, conf, null);
            ((NamenodeProtocols)Mockito.doAnswer((Answer)new Answer<LocatedBlock>(){

                public LocatedBlock answer(InvocationOnMock invocation) throws Throwable {
                    LocatedBlock ret = (LocatedBlock)invocation.callRealMethod();
                    LocatedBlocks lb = cluster.getNameNodeRpc().getBlockLocations("/testIdempotentAllocateBlock", 0L, Long.MAX_VALUE);
                    int blockCount = lb.getLocatedBlocks().size();
                    Assert.assertEquals((Object)lb.getLastLocatedBlock().getBlock(), (Object)ret.getBlock());
                    LocatedBlock ret2 = (LocatedBlock)invocation.callRealMethod();
                    lb = cluster.getNameNodeRpc().getBlockLocations("/testIdempotentAllocateBlock", 0L, Long.MAX_VALUE);
                    int blockCount2 = lb.getLocatedBlocks().size();
                    Assert.assertEquals((Object)lb.getLastLocatedBlock().getBlock(), (Object)ret2.getBlock());
                    Assert.assertEquals((long)blockCount, (long)blockCount2);
                    return ret2;
                }
            }).when((Object)spyNN)).addBlock(Mockito.anyString(), Mockito.anyString(), (ExtendedBlock)Mockito.any(), (DatanodeInfo[])Mockito.any(), Mockito.anyLong(), (String[])Mockito.any());
            ((NamenodeProtocols)Mockito.doAnswer((Answer)new Answer<Boolean>(){

                public Boolean answer(InvocationOnMock invocation) throws Throwable {
                    LOG.info((Object)("Called complete(: " + Joiner.on((String)",").join(invocation.getArguments()) + ")"));
                    if (!((Boolean)invocation.callRealMethod()).booleanValue()) {
                        LOG.info((Object)"Complete call returned false, not faking a retry RPC");
                        return false;
                    }
                    try {
                        boolean ret = (Boolean)invocation.callRealMethod();
                        LOG.info((Object)("Complete call returned true, faked second RPC. Returned: " + ret));
                        return ret;
                    }
                    catch (Throwable t) {
                        LOG.error((Object)"Idempotent retry threw exception", t);
                        throw t;
                    }
                }
            }).when((Object)spyNN)).complete(Mockito.anyString(), Mockito.anyString(), (ExtendedBlock)Mockito.any(), Matchers.anyLong());
            OutputStream stm = client.create(file.toString(), true);
            try {
                AppendTestUtil.write(stm, 0, 10000);
                stm.close();
                stm = null;
            }
            catch (Throwable throwable) {
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{stm});
                throw throwable;
            }
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{stm});
            ((NamenodeProtocols)Mockito.verify((Object)spyNN, (VerificationMode)Mockito.atLeastOnce())).addBlock(Mockito.anyString(), Mockito.anyString(), (ExtendedBlock)Mockito.any(), (DatanodeInfo[])Mockito.any(), Mockito.anyLong(), (String[])Mockito.any());
            ((NamenodeProtocols)Mockito.verify((Object)spyNN, (VerificationMode)Mockito.atLeastOnce())).complete(Mockito.anyString(), Mockito.anyString(), (ExtendedBlock)Mockito.any(), Matchers.anyLong());
            AppendTestUtil.check((FileSystem)fs, file, 10000L);
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testDFSClientRetriesOnBusyBlocks() throws IOException {
        System.out.println("Testing DFSClient random waiting on busy blocks.");
        int xcievers = 2;
        int fileLen = 0x600000;
        int threads = 50;
        int retries = 3;
        int timeWin = 300;
        long timestamp = Time.now();
        boolean pass = this.busyTest(xcievers, threads, fileLen, timeWin, retries);
        long timestamp2 = Time.now();
        if (pass) {
            LOG.info((Object)("Test 1 succeeded! Time spent: " + (double)(timestamp2 - timestamp) / 1000.0 + " sec."));
        } else {
            LOG.warn((Object)("Test 1 failed, but relax. Time spent: " + (double)(timestamp2 - timestamp) / 1000.0 + " sec."));
        }
        retries = 50;
        timestamp = Time.now();
        pass = this.busyTest(xcievers, threads, fileLen, timeWin, retries);
        timestamp2 = Time.now();
        Assert.assertTrue((String)"Something wrong! Test 2 got Exception with maxmum retries!", (boolean)pass);
        LOG.info((Object)("Test 2 succeeded! Time spent: " + (double)(timestamp2 - timestamp) / 1000.0 + " sec."));
        retries = 3;
        timeWin = 1000;
        timestamp = Time.now();
        pass = this.busyTest(xcievers, threads, fileLen, timeWin, retries);
        timestamp2 = Time.now();
        if (pass) {
            LOG.info((Object)("Test 3 succeeded! Time spent: " + (double)(timestamp2 - timestamp) / 1000.0 + " sec."));
        } else {
            LOG.warn((Object)("Test 3 failed, but relax. Time spent: " + (double)(timestamp2 - timestamp) / 1000.0 + " sec."));
        }
        retries = 50;
        timeWin = 1000;
        timestamp = Time.now();
        pass = this.busyTest(xcievers, threads, fileLen, timeWin, retries);
        timestamp2 = Time.now();
        Assert.assertTrue((String)"Something wrong! Test 4 got Exception with maxmum retries!", (boolean)pass);
        LOG.info((Object)("Test 4 succeeded! Time spent: " + (double)(timestamp2 - timestamp) / 1000.0 + " sec."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean busyTest(int xcievers, int threads, int fileLen, int timeWin, int retries) throws IOException {
        boolean ret = true;
        short replicationFactor = 1;
        long blockSize = 0x8000000L;
        int bufferSize = 4096;
        conf.setInt("dfs.datanode.max.transfer.threads", xcievers);
        conf.setInt("dfs.client.max.block.acquire.failures", retries);
        conf.setInt("dfs.client.retry.window.base", timeWin);
        conf.setInt("dfs.datanode.socket.reuse.keepalive", 0);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(replicationFactor).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        Path file1 = new Path("test_data.dat");
        file1 = file1.makeQualified(fs.getUri(), fs.getWorkingDirectory());
        try {
            int i;
            FSDataOutputStream stm = fs.create(file1, true, bufferSize, replicationFactor, blockSize);
            Assert.assertTrue((String)(file1 + " should be a file"), (boolean)fs.getFileStatus(file1).isFile());
            System.out.println("Path : \"" + file1 + "\"");
            LOG.info((Object)("Path : \"" + file1 + "\""));
            byte[] buffer = AppendTestUtil.randomBytes(Time.now(), fileLen);
            stm.write(buffer, 0, fileLen);
            stm.close();
            long len = fs.getFileStatus(file1).getLen();
            Assert.assertTrue((String)(file1 + " should be of size " + fileLen + " but found to be of size " + len), (len == (long)fileLen ? 1 : 0) != 0);
            byte[] read_buf = new byte[fileLen];
            FSDataInputStream in = fs.open(file1, fileLen);
            IOUtils.readFully((InputStream)in, (byte[])read_buf, (int)0, (int)fileLen);
            assert (Arrays.equals(buffer, read_buf));
            in.close();
            read_buf = null;
            MessageDigest m = MessageDigest.getInstance("SHA");
            m.update(buffer, 0, fileLen);
            byte[] hash_sha = m.digest();
            Thread[] readers = new Thread[threads];
            Counter counter = new Counter(0);
            for (i = 0; i < threads; ++i) {
                DFSClientReader reader = new DFSClientReader(file1, cluster, hash_sha, fileLen, counter);
                readers[i] = new Thread(reader);
                readers[i].start();
            }
            for (i = 0; i < threads; ++i) {
                readers[i].join();
            }
            ret = counter.get() == threads;
        }
        catch (InterruptedException e) {
            System.out.println("Thread got InterruptedException.");
            e.printStackTrace();
            ret = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            ret = false;
        }
        finally {
            fs.delete(file1, false);
            cluster.shutdown();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFileChecksum() throws Exception {
        String f = "/testGetFileChecksum";
        Path p = new Path("/testGetFileChecksum");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        try {
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, p, 0x100000L, (short)3, 20100402L);
            FileChecksum cs1 = fs.getFileChecksum(p);
            Assert.assertTrue((cs1 != null ? 1 : 0) != 0);
            List locatedblocks = DFSClient.callGetBlockLocations((ClientProtocol)cluster.getNameNodeRpc(), (String)"/testGetFileChecksum", (long)0L, (long)Long.MAX_VALUE).getLocatedBlocks();
            DatanodeInfo first = ((LocatedBlock)locatedblocks.get(0)).getLocations()[0];
            cluster.stopDataNode(first.getXferAddr());
            FileChecksum cs2 = fs.getFileChecksum(p);
            Assert.assertEquals((Object)cs1, (Object)cs2);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientDNProtocolTimeout() throws IOException {
        TestServer server;
        block5: {
            server = new TestServer(1, true);
            server.start();
            InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
            DatanodeID fakeDnId = DFSTestUtil.getLocalDatanodeID(addr.getPort());
            ExtendedBlock b = new ExtendedBlock("fake-pool", new Block(12345L));
            LocatedBlock fakeBlock = new LocatedBlock(b, new DatanodeInfo[0]);
            ClientDatanodeProtocol proxy = null;
            try {
                proxy = DFSUtil.createClientDatanodeProtocolProxy((DatanodeID)fakeDnId, (Configuration)conf, (int)500, (boolean)false, (LocatedBlock)fakeBlock);
                proxy.getReplicaVisibleLength(new ExtendedBlock("bpid", 1L));
                Assert.fail((String)"Did not get expected exception: SocketTimeoutException");
                if (proxy == null) break block5;
            }
            catch (SocketTimeoutException e) {
                block6: {
                    try {
                        LOG.info((Object)"Got the expected Exception: SocketTimeoutException");
                        if (proxy == null) break block6;
                    }
                    catch (Throwable throwable) {
                        if (proxy != null) {
                            RPC.stopProxy(proxy);
                        }
                        server.stop();
                        throw throwable;
                    }
                    RPC.stopProxy((Object)proxy);
                }
                server.stop();
            }
            RPC.stopProxy((Object)proxy);
        }
        server.stop();
    }

    @Test(timeout=300000L)
    public void testNamenodeRestart() throws Exception {
        TestDFSClientRetries.namenodeRestartTest(new Configuration(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void namenodeRestartTest(final Configuration conf, final boolean isWebHDFS) throws Exception {
        ((Log4JLogger)DFSClient.LOG).getLogger().setLevel(Level.ALL);
        final ArrayList<Exception> exceptions = new ArrayList<Exception>();
        Path dir = new Path("/testNamenodeRestart");
        if (isWebHDFS) {
            conf.setBoolean("dfs.http.client.retry.policy.enabled", true);
        } else {
            conf.setBoolean("dfs.client.retry.policy.enabled", true);
        }
        conf.setInt("dfs.namenode.safemode.min.datanodes", 1);
        conf.setInt("dfs.namenode.safemode.extension.testing", 5000);
        int numDatanodes = 3;
        final MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        try {
            int r;
            cluster.waitActive();
            final DistributedFileSystem dfs = cluster.getFileSystem();
            DistributedFileSystem fs = isWebHDFS ? WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs") : dfs;
            final URI uri = dfs.getUri();
            Assert.assertTrue((boolean)HdfsUtils.isHealthy((URI)uri));
            long length = 0x100000L;
            final Path file1 = new Path(dir, "foo");
            DFSTestUtil.createFile((FileSystem)fs, file1, 0x100000L, (short)3, 20120406L);
            final FileStatus s1 = fs.getFileStatus(file1);
            Assert.assertEquals((long)0x100000L, (long)s1.getLen());
            Path file4 = new Path(dir, "file4");
            final FSDataOutputStream out4 = fs.create(file4, false, 4096, fs.getDefaultReplication(file4), 1024L, null);
            final byte[] bytes = new byte[1000];
            new Random().nextBytes(bytes);
            out4.write(bytes);
            out4.write(bytes);
            if (isWebHDFS) {
                out4.close();
            } else {
                out4.hflush();
            }
            Assert.assertTrue((boolean)HdfsUtils.isHealthy((URI)uri));
            cluster.shutdownNameNode(0);
            Assert.assertFalse((boolean)HdfsUtils.isHealthy((URI)uri));
            Thread file4thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!isWebHDFS) {
                            out4.write(bytes);
                            out4.write(bytes);
                            out4.write(bytes);
                            out4.close();
                        }
                    }
                    catch (Exception e) {
                        exceptions.add(e);
                    }
                }
            });
            file4thread.start();
            Thread reader = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileSystem fs = TestDFSClientRetries.createFsWithDifferentUsername(conf, isWebHDFS);
                        FSDataInputStream in = fs.open(file1);
                        int count = 0;
                        while (in.read() != -1) {
                            ++count;
                        }
                        in.close();
                        Assert.assertEquals((long)s1.getLen(), (long)count);
                    }
                    catch (Exception e) {
                        exceptions.add(e);
                    }
                }
            });
            reader.start();
            final Path file3 = new Path(dir, "file");
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileSystem fs = TestDFSClientRetries.createFsWithDifferentUsername(conf, isWebHDFS);
                        DFSTestUtil.createFile(fs, file3, 0x100000L, (short)3, 20120406L);
                    }
                    catch (Exception e) {
                        exceptions.add(e);
                    }
                }
            });
            thread.start();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        TimeUnit.SECONDS.sleep(30L);
                        Assert.assertFalse((boolean)HdfsUtils.isHealthy((URI)uri));
                        cluster.restartNameNode(0, false);
                        cluster.waitActive();
                        Assert.assertTrue((boolean)HdfsUtils.isHealthy((URI)uri));
                    }
                    catch (Exception e) {
                        exceptions.add(e);
                    }
                }
            }).start();
            FileStatus s2 = fs.getFileStatus(file1);
            Assert.assertEquals((Object)s1, (Object)s2);
            thread.join();
            TestDFSClientRetries.assertEmpty(exceptions);
            Assert.assertEquals((long)s1.getLen(), (long)fs.getFileStatus(file3).getLen());
            Assert.assertEquals((Object)fs.getFileChecksum(file1), (Object)fs.getFileChecksum(file3));
            reader.join();
            TestDFSClientRetries.assertEmpty(exceptions);
            file4thread.join();
            TestDFSClientRetries.assertEmpty(exceptions);
            FSDataInputStream in = fs.open(file4);
            int count = 0;
            while ((r = in.read()) != -1) {
                Assert.assertEquals((String)String.format("count=%d", count), (long)bytes[count % bytes.length], (long)((byte)r));
                ++count;
            }
            if (!isWebHDFS) {
                Assert.assertEquals((long)(5 * bytes.length), (long)count);
            } else {
                Assert.assertEquals((long)(2 * bytes.length), (long)count);
            }
            in.close();
            Assert.assertTrue((boolean)HdfsUtils.isHealthy((URI)uri));
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            Assert.assertFalse((boolean)HdfsUtils.isHealthy((URI)uri));
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        TimeUnit.SECONDS.sleep(30L);
                        Assert.assertFalse((boolean)HdfsUtils.isHealthy((URI)uri));
                        dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
                        Assert.assertTrue((boolean)HdfsUtils.isHealthy((URI)uri));
                    }
                    catch (Exception e) {
                        exceptions.add(e);
                    }
                }
            }).start();
            Path file2 = new Path(dir, "bar");
            DFSTestUtil.createFile((FileSystem)fs, file2, 0x100000L, (short)3, 20120406L);
            Assert.assertEquals((Object)fs.getFileChecksum(file1), (Object)fs.getFileChecksum(file2));
            Assert.assertTrue((boolean)HdfsUtils.isHealthy((URI)uri));
            Path nonExisting = new Path(dir, "nonExisting");
            LOG.info((Object)("setPermission: " + nonExisting));
            try {
                fs.setPermission(nonExisting, new FsPermission(0));
                Assert.fail();
            }
            catch (FileNotFoundException fnfe) {
                LOG.info((Object)"GOOD!", (Throwable)fnfe);
            }
            TestDFSClientRetries.assertEmpty(exceptions);
        }
        finally {
            cluster.shutdown();
        }
    }

    static void assertEmpty(List<Exception> exceptions) {
        if (!exceptions.isEmpty()) {
            StringBuilder b = new StringBuilder("There are ").append(exceptions.size()).append(" exception(s):");
            for (int i = 0; i < exceptions.size(); ++i) {
                b.append("\n  Exception ").append(i).append(": ").append(StringUtils.stringifyException((Throwable)exceptions.get(i)));
            }
            Assert.fail((String)b.toString());
        }
    }

    private static FileSystem createFsWithDifferentUsername(Configuration conf, boolean isWebHDFS) throws IOException, InterruptedException {
        String username = UserGroupInformation.getCurrentUser().getShortUserName() + "_XXX";
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)username, (String[])new String[]{"supergroup"});
        return isWebHDFS ? WebHdfsTestUtil.getWebHdfsFileSystemAs(ugi, conf, "webhdfs") : DFSTestUtil.getFileSystemAs(ugi, conf);
    }

    @Test
    public void testMultipleLinearRandomRetry() {
        TestDFSClientRetries.parseMultipleLinearRandomRetry(null, "");
        TestDFSClientRetries.parseMultipleLinearRandomRetry(null, "11");
        TestDFSClientRetries.parseMultipleLinearRandomRetry(null, "11,22,33");
        TestDFSClientRetries.parseMultipleLinearRandomRetry(null, "11,22,33,44,55");
        TestDFSClientRetries.parseMultipleLinearRandomRetry(null, "AA");
        TestDFSClientRetries.parseMultipleLinearRandomRetry(null, "11,AA");
        TestDFSClientRetries.parseMultipleLinearRandomRetry(null, "11,22,33,FF");
        TestDFSClientRetries.parseMultipleLinearRandomRetry(null, "11,-22");
        TestDFSClientRetries.parseMultipleLinearRandomRetry(null, "-11,22");
        TestDFSClientRetries.parseMultipleLinearRandomRetry("[22x11ms]", "11,22");
        TestDFSClientRetries.parseMultipleLinearRandomRetry("[22x11ms, 44x33ms]", "11,22,33,44");
        TestDFSClientRetries.parseMultipleLinearRandomRetry("[22x11ms, 44x33ms, 66x55ms]", "11,22,33,44,55,66");
        TestDFSClientRetries.parseMultipleLinearRandomRetry("[22x11ms, 44x33ms, 66x55ms]", "   11,   22, 33,  44, 55,  66   ");
    }

    static void parseMultipleLinearRandomRetry(String expected, String s) {
        RetryPolicies.MultipleLinearRandomRetry r = RetryPolicies.MultipleLinearRandomRetry.parseCommaSeparatedString((String)s);
        LOG.info((Object)("input=" + s + ", parsed=" + r + ", expected=" + expected));
        if (r == null) {
            Assert.assertEquals((Object)expected, null);
        } else {
            Assert.assertEquals((Object)("MultipleLinearRandomRetry" + expected), (Object)r.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRetryOnChecksumFailure() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            boolean REPL_FACTOR = true;
            long FILE_LENGTH = 512L;
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path path = new Path("/corrupted");
            DFSTestUtil.createFile((FileSystem)fs, path, 512L, (short)1, 12345L);
            DFSTestUtil.waitReplication((FileSystem)fs, path, (short)1);
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, path);
            int blockFilesCorrupted = cluster.corruptBlockOnDataNodes(block);
            Assert.assertEquals((String)"All replicas not corrupted", (long)1L, (long)blockFilesCorrupted);
            InetSocketAddress nnAddr = new InetSocketAddress("localhost", cluster.getNameNodePort());
            DFSClient client = new DFSClient(nnAddr, (Configuration)conf);
            DFSInputStream dis = client.open(path.toString());
            byte[] arr = new byte[512];
            for (int i = 0; i < 2; ++i) {
                try {
                    dis.read(arr, 0, 512);
                    Assert.fail((String)"Expected ChecksumException not thrown");
                    continue;
                }
                catch (Exception ex) {
                    GenericTestUtils.assertExceptionContains((String)"Checksum error", (Throwable)ex);
                }
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    class Counter {
        int counter;

        Counter(int n) {
            this.counter = n;
        }

        public synchronized void inc() {
            ++this.counter;
        }

        public int get() {
            return this.counter;
        }
    }

    class DFSClientReader
    implements Runnable {
        DFSClient client;
        Configuration conf;
        byte[] expected_sha;
        FileSystem fs;
        Path filePath;
        MiniDFSCluster cluster;
        int len;
        Counter counter;

        DFSClientReader(Path file, MiniDFSCluster cluster, byte[] hash_sha, int fileLen, Counter cnt) {
            this.filePath = file;
            this.cluster = cluster;
            this.counter = cnt;
            this.len = fileLen;
            this.conf = new HdfsConfiguration();
            this.expected_sha = hash_sha;
            try {
                cluster.waitActive();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void run() {
            try {
                this.fs = this.cluster.getNewFileSystemInstance(0);
                int bufferSize = this.len;
                byte[] buf = new byte[bufferSize];
                FSDataInputStream in = this.fs.open(this.filePath, bufferSize);
                IOUtils.readFully((InputStream)in, (byte[])buf, (int)0, (int)bufferSize);
                MessageDigest m = MessageDigest.getInstance("SHA");
                m.update(buf, 0, bufferSize);
                byte[] hash_sha = m.digest();
                buf = null;
                in.close();
                this.fs.close();
                Assert.assertTrue((String)"hashed keys are not the same size", (hash_sha.length == this.expected_sha.length ? 1 : 0) != 0);
                Assert.assertTrue((String)"hashed keys are not equal", (boolean)Arrays.equals(hash_sha, this.expected_sha));
                this.counter.inc();
                LOG.info((Object)"Thread correctly read the block.");
            }
            catch (BlockMissingException e) {
                LOG.info((Object)"Bad - BlockMissingException is caught.");
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class FailNTimesAnswer
    implements Answer<LocatedBlocks> {
        private int failuresLeft;
        private NamenodeProtocols realNN;

        public FailNTimesAnswer(NamenodeProtocols preSpyNN, int timesToFail) {
            this.failuresLeft = timesToFail;
            this.realNN = preSpyNN;
        }

        public LocatedBlocks answer(InvocationOnMock invocation) throws IOException {
            Object[] args = invocation.getArguments();
            LocatedBlocks realAnswer = this.realNN.getBlockLocations((String)args[0], ((Long)args[1]).longValue(), ((Long)args[2]).longValue());
            if (this.failuresLeft-- > 0) {
                NameNode.LOG.info((Object)"FailNTimesAnswer injecting failure.");
                return this.makeBadBlockList(realAnswer);
            }
            NameNode.LOG.info((Object)"FailNTimesAnswer no longer failing.");
            return realAnswer;
        }

        private LocatedBlocks makeBadBlockList(LocatedBlocks goodBlockList) {
            LocatedBlock goodLocatedBlock = goodBlockList.get(0);
            LocatedBlock badLocatedBlock = new LocatedBlock(goodLocatedBlock.getBlock(), new DatanodeInfo[]{DFSTestUtil.getDatanodeInfo("1.2.3.4", "bogus", 1234)}, goodLocatedBlock.getStartOffset(), false);
            ArrayList<LocatedBlock> badBlocks = new ArrayList<LocatedBlock>();
            badBlocks.add(badLocatedBlock);
            return new LocatedBlocks(goodBlockList.getFileLength(), false, badBlocks, null, true);
        }
    }

    private static class TestServer
    extends Server {
        private boolean sleep;
        private Class<? extends Writable> responseClass;

        public TestServer(int handlerCount, boolean sleep) throws IOException {
            this(handlerCount, sleep, LongWritable.class, null);
        }

        public TestServer(int handlerCount, boolean sleep, Class<? extends Writable> paramClass, Class<? extends Writable> responseClass) throws IOException {
            super(TestDFSClientRetries.ADDRESS, 0, paramClass, handlerCount, conf);
            this.sleep = sleep;
            this.responseClass = responseClass;
        }

        public Writable call(RPC.RpcKind rpcKind, String protocol, Writable param, long receiveTime) throws IOException {
            if (this.sleep) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (this.responseClass != null) {
                try {
                    return this.responseClass.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return param;
        }
    }
}

