/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Random;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ByteBufferReadable;
import org.apache.hadoop.fs.ByteBufferUtil;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.ReadOption;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.ClientMmap;
import org.apache.hadoop.hdfs.client.ClientMmapManager;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.io.ByteBufferPool;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.net.unix.TemporarySocketDirectory;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestEnhancedByteBufferAccess {
    private static final Log LOG = LogFactory.getLog((String)TestEnhancedByteBufferAccess.class.getName());
    static TemporarySocketDirectory sockDir;

    @BeforeClass
    public static void init() {
        sockDir = new TemporarySocketDirectory();
        DomainSocket.disableBindPathValidation();
    }

    private static byte[] byteBufferToArray(ByteBuffer buf) {
        byte[] resultArray = new byte[buf.remaining()];
        buf.get(resultArray);
        buf.flip();
        return resultArray;
    }

    public static HdfsConfiguration initZeroCopyTest() {
        Assume.assumeTrue((boolean)NativeIO.isAvailable());
        Assume.assumeTrue((boolean)SystemUtils.IS_OS_UNIX);
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.client.read.shortcircuit", true);
        conf.setLong("dfs.blocksize", 4096L);
        conf.setInt("dfs.client.mmap.cache.size", 3);
        conf.setLong("dfs.client.mmap.cache.timeout.ms", 100L);
        conf.set("dfs.domain.socket.path", new File(sockDir.getDir(), "TestRequestMmapAccess._PORT.sock").getAbsolutePath());
        conf.setBoolean("dfs.client.read.shortcircuit.skip.checksum", true);
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZeroCopyReads() throws Exception {
        HdfsConfiguration conf = TestEnhancedByteBufferAccess.initZeroCopyTest();
        MiniDFSCluster cluster = null;
        Path TEST_PATH = new Path("/a");
        FSDataInputStream fsIn = null;
        int TEST_FILE_LENGTH = 12345;
        DistributedFileSystem fs = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, TEST_PATH, 12345L, (short)1, 7567L);
            try {
                DFSTestUtil.waitReplication((FileSystem)fs, TEST_PATH, (short)1);
            }
            catch (InterruptedException e) {
                Assert.fail((String)("unexpected InterruptedException during waitReplication: " + e));
            }
            catch (TimeoutException e) {
                Assert.fail((String)("unexpected TimeoutException during waitReplication: " + e));
            }
            fsIn = fs.open(TEST_PATH);
            byte[] original = new byte[12345];
            IOUtils.readFully((InputStream)fsIn, (byte[])original, (int)0, (int)12345);
            fsIn.close();
            fsIn = fs.open(TEST_PATH);
            ByteBuffer result = fsIn.read(null, 4096, EnumSet.of(ReadOption.SKIP_CHECKSUMS));
            Assert.assertEquals((long)4096L, (long)result.remaining());
            HdfsDataInputStream dfsIn = (HdfsDataInputStream)fsIn;
            Assert.assertEquals((long)4096L, (long)dfsIn.getReadStatistics().getTotalBytesRead());
            Assert.assertEquals((long)4096L, (long)dfsIn.getReadStatistics().getTotalZeroCopyBytesRead());
            Assert.assertArrayEquals((byte[])Arrays.copyOfRange(original, 0, 4096), (byte[])TestEnhancedByteBufferAccess.byteBufferToArray(result));
            fsIn.releaseBuffer(result);
        }
        finally {
            if (fsIn != null) {
                fsIn.close();
            }
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShortZeroCopyReads() throws Exception {
        HdfsConfiguration conf = TestEnhancedByteBufferAccess.initZeroCopyTest();
        MiniDFSCluster cluster = null;
        Path TEST_PATH = new Path("/a");
        FSDataInputStream fsIn = null;
        int TEST_FILE_LENGTH = 12345;
        DistributedFileSystem fs = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, TEST_PATH, 12345L, (short)1, 7567L);
            try {
                DFSTestUtil.waitReplication((FileSystem)fs, TEST_PATH, (short)1);
            }
            catch (InterruptedException e) {
                Assert.fail((String)("unexpected InterruptedException during waitReplication: " + e));
            }
            catch (TimeoutException e) {
                Assert.fail((String)("unexpected TimeoutException during waitReplication: " + e));
            }
            fsIn = fs.open(TEST_PATH);
            byte[] original = new byte[12345];
            IOUtils.readFully((InputStream)fsIn, (byte[])original, (int)0, (int)12345);
            fsIn.close();
            fsIn = fs.open(TEST_PATH);
            HdfsDataInputStream dfsIn = (HdfsDataInputStream)fsIn;
            ByteBuffer result = dfsIn.read(null, 8192, EnumSet.of(ReadOption.SKIP_CHECKSUMS));
            Assert.assertEquals((long)4096L, (long)result.remaining());
            Assert.assertEquals((long)4096L, (long)dfsIn.getReadStatistics().getTotalBytesRead());
            Assert.assertEquals((long)4096L, (long)dfsIn.getReadStatistics().getTotalZeroCopyBytesRead());
            Assert.assertArrayEquals((byte[])Arrays.copyOfRange(original, 0, 4096), (byte[])TestEnhancedByteBufferAccess.byteBufferToArray(result));
            dfsIn.releaseBuffer(result);
            result = dfsIn.read(null, 4097, EnumSet.of(ReadOption.SKIP_CHECKSUMS));
            Assert.assertEquals((long)4096L, (long)result.remaining());
            Assert.assertArrayEquals((byte[])Arrays.copyOfRange(original, 4096, 8192), (byte[])TestEnhancedByteBufferAccess.byteBufferToArray(result));
            dfsIn.releaseBuffer(result);
        }
        finally {
            if (fsIn != null) {
                fsIn.close();
            }
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZeroCopyReadsNoFallback() throws Exception {
        HdfsConfiguration conf = TestEnhancedByteBufferAccess.initZeroCopyTest();
        MiniDFSCluster cluster = null;
        Path TEST_PATH = new Path("/a");
        FSDataInputStream fsIn = null;
        int TEST_FILE_LENGTH = 12345;
        DistributedFileSystem fs = null;
        try {
            ByteBuffer result;
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, TEST_PATH, 12345L, (short)1, 7567L);
            try {
                DFSTestUtil.waitReplication((FileSystem)fs, TEST_PATH, (short)1);
            }
            catch (InterruptedException e) {
                Assert.fail((String)("unexpected InterruptedException during waitReplication: " + e));
            }
            catch (TimeoutException e) {
                Assert.fail((String)("unexpected TimeoutException during waitReplication: " + e));
            }
            fsIn = fs.open(TEST_PATH);
            byte[] original = new byte[12345];
            IOUtils.readFully((InputStream)fsIn, (byte[])original, (int)0, (int)12345);
            fsIn.close();
            fsIn = fs.open(TEST_PATH);
            HdfsDataInputStream dfsIn = (HdfsDataInputStream)fsIn;
            try {
                result = dfsIn.read(null, 4097, EnumSet.noneOf(ReadOption.class));
                Assert.fail((String)"expected UnsupportedOperationException");
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
            result = dfsIn.read(null, 4096, EnumSet.of(ReadOption.SKIP_CHECKSUMS));
            Assert.assertEquals((long)4096L, (long)result.remaining());
            Assert.assertEquals((long)4096L, (long)dfsIn.getReadStatistics().getTotalBytesRead());
            Assert.assertEquals((long)4096L, (long)dfsIn.getReadStatistics().getTotalZeroCopyBytesRead());
            Assert.assertArrayEquals((byte[])Arrays.copyOfRange(original, 0, 4096), (byte[])TestEnhancedByteBufferAccess.byteBufferToArray(result));
        }
        finally {
            if (fsIn != null) {
                fsIn.close();
            }
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZeroCopyMmapCache() throws Exception {
        HdfsConfiguration conf = TestEnhancedByteBufferAccess.initZeroCopyTest();
        MiniDFSCluster cluster = null;
        Path TEST_PATH = new Path("/a");
        int TEST_FILE_LENGTH = 16385;
        int RANDOM_SEED = 23453;
        FSDataInputStream fsIn = null;
        ByteBuffer[] results = new ByteBuffer[]{null, null, null, null, null};
        DistributedFileSystem fs = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, TEST_PATH, 16385L, (short)1, 23453L);
            try {
                DFSTestUtil.waitReplication((FileSystem)fs, TEST_PATH, (short)1);
            }
            catch (InterruptedException e) {
                Assert.fail((String)("unexpected InterruptedException during waitReplication: " + e));
            }
            catch (TimeoutException e) {
                Assert.fail((String)("unexpected TimeoutException during waitReplication: " + e));
            }
            fsIn = fs.open(TEST_PATH);
            byte[] original = new byte[16385];
            IOUtils.readFully((InputStream)fsIn, (byte[])original, (int)0, (int)16385);
            fsIn.close();
            fsIn = fs.open(TEST_PATH);
            final ClientMmapManager mmapManager = fs.getClient().getMmapManager();
            final CountingVisitor countingVisitor = new CountingVisitor();
            mmapManager.visitMmaps((ClientMmapManager.ClientMmapVisitor)countingVisitor);
            Assert.assertEquals((long)0L, (long)countingVisitor.count);
            mmapManager.visitEvictable((ClientMmapManager.ClientMmapVisitor)countingVisitor);
            Assert.assertEquals((long)0L, (long)countingVisitor.count);
            results[0] = fsIn.read(null, 4096, EnumSet.of(ReadOption.SKIP_CHECKSUMS));
            fsIn.seek(0L);
            results[1] = fsIn.read(null, 4096, EnumSet.of(ReadOption.SKIP_CHECKSUMS));
            mmapManager.visitMmaps((ClientMmapManager.ClientMmapVisitor)countingVisitor);
            Assert.assertEquals((long)1L, (long)countingVisitor.count);
            countingVisitor.reset();
            mmapManager.visitEvictable((ClientMmapManager.ClientMmapVisitor)countingVisitor);
            Assert.assertEquals((long)0L, (long)countingVisitor.count);
            countingVisitor.reset();
            final ExtendedBlock firstBlock = DFSTestUtil.getFirstBlock((FileSystem)fs, TEST_PATH);
            mmapManager.visitMmaps(new ClientMmapManager.ClientMmapVisitor(){

                public void accept(ClientMmap mmap) {
                    Assert.assertEquals((Object)firstBlock, (Object)mmap.getBlock());
                }
            });
            results[2] = fsIn.read(null, 4096, EnumSet.of(ReadOption.SKIP_CHECKSUMS));
            results[3] = fsIn.read(null, 4096, EnumSet.of(ReadOption.SKIP_CHECKSUMS));
            try {
                results[4] = fsIn.read(null, 4096, EnumSet.of(ReadOption.SKIP_CHECKSUMS));
                Assert.fail((String)"expected UnsupportedOperationException");
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
            mmapManager.visitMmaps((ClientMmapManager.ClientMmapVisitor)countingVisitor);
            Assert.assertEquals((long)3L, (long)countingVisitor.count);
            countingVisitor.reset();
            mmapManager.visitEvictable((ClientMmapManager.ClientMmapVisitor)countingVisitor);
            Assert.assertEquals((long)0L, (long)countingVisitor.count);
            for (ByteBuffer buffer : results) {
                if (buffer == null) continue;
                fsIn.releaseBuffer(buffer);
            }
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    countingVisitor.reset();
                    try {
                        mmapManager.visitEvictable((ClientMmapManager.ClientMmapVisitor)countingVisitor);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        return false;
                    }
                    return 0 == countingVisitor.count;
                }
            }, (int)10, (int)10000);
            countingVisitor.reset();
            mmapManager.visitMmaps((ClientMmapManager.ClientMmapVisitor)countingVisitor);
            Assert.assertEquals((long)0L, (long)countingVisitor.count);
        }
        finally {
            if (fsIn != null) {
                fsIn.close();
            }
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHdfsFallbackReads() throws Exception {
        HdfsConfiguration conf = TestEnhancedByteBufferAccess.initZeroCopyTest();
        MiniDFSCluster cluster = null;
        Path TEST_PATH = new Path("/a");
        int TEST_FILE_LENGTH = 16385;
        int RANDOM_SEED = 23453;
        FSDataInputStream fsIn = null;
        DistributedFileSystem fs = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, TEST_PATH, 16385L, (short)1, 23453L);
            try {
                DFSTestUtil.waitReplication((FileSystem)fs, TEST_PATH, (short)1);
            }
            catch (InterruptedException e) {
                Assert.fail((String)("unexpected InterruptedException during waitReplication: " + e));
            }
            catch (TimeoutException e) {
                Assert.fail((String)("unexpected TimeoutException during waitReplication: " + e));
            }
            fsIn = fs.open(TEST_PATH);
            byte[] original = new byte[16385];
            IOUtils.readFully((InputStream)fsIn, (byte[])original, (int)0, (int)16385);
            fsIn.close();
            fsIn = fs.open(TEST_PATH);
            TestEnhancedByteBufferAccess.testFallbackImpl((InputStream)fsIn, original);
        }
        finally {
            if (fsIn != null) {
                fsIn.close();
            }
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private static void testFallbackImpl(InputStream stream, byte[] original) throws Exception {
        RestrictedAllocatingByteBufferPool bufferPool = new RestrictedAllocatingByteBufferPool(stream instanceof ByteBufferReadable);
        ByteBuffer result = ByteBufferUtil.fallbackRead((InputStream)stream, (ByteBufferPool)bufferPool, (int)10);
        Assert.assertEquals((long)10L, (long)result.remaining());
        Assert.assertArrayEquals((byte[])Arrays.copyOfRange(original, 0, 10), (byte[])TestEnhancedByteBufferAccess.byteBufferToArray(result));
        result = ByteBufferUtil.fallbackRead((InputStream)stream, (ByteBufferPool)bufferPool, (int)5000);
        Assert.assertEquals((long)5000L, (long)result.remaining());
        Assert.assertArrayEquals((byte[])Arrays.copyOfRange(original, 10, 5010), (byte[])TestEnhancedByteBufferAccess.byteBufferToArray(result));
        result = ByteBufferUtil.fallbackRead((InputStream)stream, (ByteBufferPool)bufferPool, (int)9999999);
        Assert.assertEquals((long)11375L, (long)result.remaining());
        Assert.assertArrayEquals((byte[])Arrays.copyOfRange(original, 5010, 16385), (byte[])TestEnhancedByteBufferAccess.byteBufferToArray(result));
        result = ByteBufferUtil.fallbackRead((InputStream)stream, (ByteBufferPool)bufferPool, (int)10);
        Assert.assertNull((Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFallbackRead() throws Exception {
        HdfsConfiguration conf = TestEnhancedByteBufferAccess.initZeroCopyTest();
        MiniDFSCluster cluster = null;
        Path TEST_PATH = new Path("/a");
        int TEST_FILE_LENGTH = 16385;
        int RANDOM_SEED = 23453;
        FSDataInputStream fsIn = null;
        DistributedFileSystem fs = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, TEST_PATH, 16385L, (short)1, 23453L);
            try {
                DFSTestUtil.waitReplication((FileSystem)fs, TEST_PATH, (short)1);
            }
            catch (InterruptedException e) {
                Assert.fail((String)("unexpected InterruptedException during waitReplication: " + e));
            }
            catch (TimeoutException e) {
                Assert.fail((String)("unexpected TimeoutException during waitReplication: " + e));
            }
            fsIn = fs.open(TEST_PATH);
            byte[] original = new byte[16385];
            IOUtils.readFully((InputStream)fsIn, (byte[])original, (int)0, (int)16385);
            fsIn.close();
            fsIn = fs.open(TEST_PATH);
            TestEnhancedByteBufferAccess.testFallbackImpl((InputStream)fsIn, original);
        }
        finally {
            if (fsIn != null) {
                fsIn.close();
            }
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndirectFallbackReads() throws Exception {
        File TEST_DIR = new File(System.getProperty("test.build.data", "build/test/data"));
        String TEST_PATH = TEST_DIR + File.separator + "indirectFallbackTestFile";
        int TEST_FILE_LENGTH = 16385;
        int RANDOM_SEED = 23453;
        FileOutputStream fos = null;
        FileInputStream fis = null;
        try {
            fos = new FileOutputStream(TEST_PATH);
            Random random = new Random(23453L);
            byte[] original = new byte[16385];
            random.nextBytes(original);
            fos.write(original);
            fos.close();
            fos = null;
            fis = new FileInputStream(TEST_PATH);
            TestEnhancedByteBufferAccess.testFallbackImpl(fis, original);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{fos, fis});
            new File(TEST_PATH).delete();
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{fos, fis});
        new File(TEST_PATH).delete();
    }

    private static class RestrictedAllocatingByteBufferPool
    implements ByteBufferPool {
        private final boolean direct;

        RestrictedAllocatingByteBufferPool(boolean direct) {
            this.direct = direct;
        }

        public ByteBuffer getBuffer(boolean direct, int length) {
            Preconditions.checkArgument((this.direct == direct ? 1 : 0) != 0);
            return direct ? ByteBuffer.allocateDirect(length) : ByteBuffer.allocate(length);
        }

        public void putBuffer(ByteBuffer buffer) {
        }
    }

    private static class CountingVisitor
    implements ClientMmapManager.ClientMmapVisitor {
        int count = 0;

        private CountingVisitor() {
        }

        public void accept(ClientMmap mmap) {
            ++this.count;
        }

        public void reset() {
            this.count = 0;
        }
    }
}

