/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.primitives.SignedBytes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectoryWithQuota;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.hdfs.server.namenode.SerialNumberManager;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
abstract class INode
implements Comparable<byte[]> {
    static final List<INode> EMPTY_LIST = Collections.unmodifiableList(new ArrayList());
    protected byte[] name;
    protected INodeDirectory parent;
    protected long modificationTime;
    protected long accessTime;
    private long permission;
    private static final byte[] EMPTY_BYTES = new byte[0];

    INode(PermissionStatus permissions, long mTime, long atime) {
        this.name = null;
        this.parent = null;
        this.modificationTime = mTime;
        this.setAccessTime(atime);
        this.setPermissionStatus(permissions);
    }

    protected INode(String name, PermissionStatus permissions) {
        this(permissions, 0L, 0L);
        this.setLocalName(name);
    }

    INode(INode other) {
        this.setLocalName(other.getLocalName());
        this.parent = other.getParent();
        this.setPermissionStatus(other.getPermissionStatus());
        this.setModificationTime(other.getModificationTime());
        this.setAccessTime(other.getAccessTime());
    }

    boolean isRoot() {
        return this.name.length == 0;
    }

    protected void setPermissionStatus(PermissionStatus ps) {
        this.setUser(ps.getUserName());
        this.setGroup(ps.getGroupName());
        this.setPermission(ps.getPermission());
    }

    protected PermissionStatus getPermissionStatus() {
        return new PermissionStatus(this.getUserName(), this.getGroupName(), this.getFsPermission());
    }

    private void updatePermissionStatus(PermissionStatusFormat f, long n) {
        this.permission = f.combine(n, this.permission);
    }

    public String getUserName() {
        int n = (int)PermissionStatusFormat.USER.retrieve(this.permission);
        return SerialNumberManager.INSTANCE.getUser(n);
    }

    protected void setUser(String user) {
        int n = SerialNumberManager.INSTANCE.getUserSerialNumber(user);
        this.updatePermissionStatus(PermissionStatusFormat.USER, n);
    }

    public String getGroupName() {
        int n = (int)PermissionStatusFormat.GROUP.retrieve(this.permission);
        return SerialNumberManager.INSTANCE.getGroup(n);
    }

    protected void setGroup(String group) {
        int n = SerialNumberManager.INSTANCE.getGroupSerialNumber(group);
        this.updatePermissionStatus(PermissionStatusFormat.GROUP, n);
    }

    public FsPermission getFsPermission() {
        return new FsPermission((short)PermissionStatusFormat.MODE.retrieve(this.permission));
    }

    protected short getFsPermissionShort() {
        return (short)PermissionStatusFormat.MODE.retrieve(this.permission);
    }

    void setPermission(FsPermission permission) {
        this.updatePermissionStatus(PermissionStatusFormat.MODE, permission.toShort());
    }

    public boolean isDirectory() {
        return false;
    }

    abstract int collectSubtreeBlocksAndClear(List<Block> var1);

    public final ContentSummary computeContentSummary() {
        long[] a = this.computeContentSummary(new long[]{0L, 0L, 0L, 0L});
        return new ContentSummary(a[0], a[1], a[2], this.getNsQuota(), a[3], this.getDsQuota());
    }

    abstract long[] computeContentSummary(long[] var1);

    long getNsQuota() {
        return -1L;
    }

    long getDsQuota() {
        return -1L;
    }

    boolean isQuotaSet() {
        return this.getNsQuota() >= 0L || this.getDsQuota() >= 0L;
    }

    abstract DirCounts spaceConsumedInTree(DirCounts var1);

    String getLocalName() {
        return DFSUtil.bytes2String(this.name);
    }

    String getLocalParentDir() {
        INode inode = this.isRoot() ? this : this.getParent();
        String parentDir = "";
        if (inode != null) {
            parentDir = inode.getFullPathName();
        }
        return parentDir != null ? parentDir : "";
    }

    byte[] getLocalNameBytes() {
        return this.name;
    }

    void setLocalName(String name) {
        this.name = DFSUtil.string2Bytes(name);
    }

    void setLocalName(byte[] name) {
        this.name = name;
    }

    public String getFullPathName() {
        return FSDirectory.getFullPathName(this);
    }

    public String toString() {
        return "\"" + this.getFullPathName() + "\":" + this.getUserName() + ":" + this.getGroupName() + ":" + (this.isDirectory() ? "d" : "-") + this.getFsPermission();
    }

    INodeDirectory getParent() {
        return this.parent;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    void setModificationTime(long modtime) {
        assert (this.isDirectory());
        if (this.modificationTime <= modtime) {
            this.modificationTime = modtime;
        }
    }

    void setModificationTimeForce(long modtime) {
        this.modificationTime = modtime;
    }

    public long getAccessTime() {
        return this.accessTime;
    }

    void setAccessTime(long atime) {
        this.accessTime = atime;
    }

    public boolean isUnderConstruction() {
        return false;
    }

    public boolean isSymlink() {
        return false;
    }

    static byte[][] getPathComponents(String path) {
        return INode.getPathComponents(INode.getPathNames(path));
    }

    static byte[][] getPathComponents(String[] strings) {
        if (strings.length == 0) {
            return new byte[][]{null};
        }
        byte[][] bytes = new byte[strings.length][];
        for (int i = 0; i < strings.length; ++i) {
            bytes[i] = DFSUtil.string2Bytes(strings[i]);
        }
        return bytes;
    }

    static String[] getPathNames(String path) {
        if (path == null || !path.startsWith("/")) {
            throw new AssertionError((Object)"Absolute path required");
        }
        return StringUtils.split((String)path, (char)'/');
    }

    static String constructPath(byte[][] components, int start, int end) {
        StringBuilder buf = new StringBuilder();
        for (int i = start; i < end; ++i) {
            buf.append(DFSUtil.bytes2String(components[i]));
            if (i >= end - 1) continue;
            buf.append("/");
        }
        return buf.toString();
    }

    boolean removeNode() {
        if (this.parent == null) {
            return false;
        }
        this.parent.removeChild(this);
        this.parent = null;
        return true;
    }

    @Override
    public final int compareTo(byte[] bytes) {
        byte[] left = this.name == null ? EMPTY_BYTES : this.name;
        byte[] right = bytes == null ? EMPTY_BYTES : bytes;
        return SignedBytes.lexicographicalComparator().compare(left, right);
    }

    public final boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || !(that instanceof INode)) {
            return false;
        }
        return Arrays.equals(this.name, ((INode)that).name);
    }

    public final int hashCode() {
        return Arrays.hashCode(this.name);
    }

    static INode newINode(PermissionStatus permissions, BlockInfo[] blocks, String symlink, short replication, long modificationTime, long atime, long nsQuota, long dsQuota, long preferredBlockSize) {
        if (symlink.length() != 0) {
            return new INodeSymlink(symlink, modificationTime, atime, permissions);
        }
        if (blocks == null) {
            if (nsQuota >= 0L || dsQuota >= 0L) {
                return new INodeDirectoryWithQuota(permissions, modificationTime, nsQuota, dsQuota);
            }
            return new INodeDirectory(permissions, modificationTime);
        }
        return new INodeFile(permissions, blocks, replication, modificationTime, atime, preferredBlockSize);
    }

    private static enum PermissionStatusFormat {
        MODE(0, 16),
        GROUP(PermissionStatusFormat.MODE.OFFSET + PermissionStatusFormat.MODE.LENGTH, 25),
        USER(PermissionStatusFormat.GROUP.OFFSET + PermissionStatusFormat.GROUP.LENGTH, 23);

        final int OFFSET;
        final int LENGTH;
        final long MASK;

        private PermissionStatusFormat(int offset, int length) {
            this.OFFSET = offset;
            this.LENGTH = length;
            this.MASK = -1L >>> 64 - this.LENGTH << this.OFFSET;
        }

        long retrieve(long record) {
            return (record & this.MASK) >>> this.OFFSET;
        }

        long combine(long bits, long record) {
            return record & (this.MASK ^ 0xFFFFFFFFFFFFFFFFL) | bits << this.OFFSET;
        }
    }

    static class DirCounts {
        long nsCount = 0L;
        long dsCount = 0L;

        DirCounts() {
        }

        long getNsCount() {
            return this.nsCount;
        }

        long getDsCount() {
            return this.dsCount;
        }
    }
}

