/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Random;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.token.Token;
import org.junit.Assert;
import org.mockito.Mockito;

public class FileSystemTestHelper {
    private static final int DEFAULT_BLOCK_SIZE = 1024;
    private static final int DEFAULT_NUM_BLOCKS = 2;
    private static final short DEFAULT_NUM_REPL = 1;
    protected final String testRootDir;
    private String absTestRootDir = null;

    public FileSystemTestHelper() {
        this(System.getProperty("test.build.data", "target/test/data") + "/" + RandomStringUtils.randomAlphanumeric((int)10));
    }

    private FileSystemTestHelper(String testRootDir) {
        this.testRootDir = testRootDir;
    }

    public static void addFileSystemForTesting(URI uri, Configuration conf, FileSystem fs) throws IOException {
        FileSystem.addFileSystemForTesting((URI)uri, (Configuration)conf, (FileSystem)fs);
    }

    public static int getDefaultBlockSize() {
        return 1024;
    }

    public static byte[] getFileData(int numOfBlocks, long blockSize) {
        byte[] data = new byte[(int)((long)numOfBlocks * blockSize)];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(i % 10);
        }
        return data;
    }

    public String getTestRootDir() {
        return this.testRootDir;
    }

    public Path getTestRootPath(FileSystem fSys) {
        return fSys.makeQualified(new Path(this.testRootDir));
    }

    public Path getTestRootPath(FileSystem fSys, String pathString) {
        return fSys.makeQualified(new Path(this.testRootDir, pathString));
    }

    String getAbsoluteTestRootDir(FileSystem fSys) throws IOException {
        this.absTestRootDir = new Path(this.testRootDir).isAbsolute() ? this.testRootDir : fSys.getWorkingDirectory().toString() + "/" + this.testRootDir;
        return this.absTestRootDir;
    }

    public Path getAbsoluteTestRootPath(FileSystem fSys) throws IOException {
        return fSys.makeQualified(new Path(this.getAbsoluteTestRootDir(fSys)));
    }

    public Path getDefaultWorkingDirectory(FileSystem fSys) throws IOException {
        return this.getTestRootPath(fSys, "/user/" + System.getProperty("user.name")).makeQualified(fSys.getUri(), fSys.getWorkingDirectory());
    }

    public static long createFile(FileSystem fSys, Path path, int numBlocks, int blockSize, short numRepl, boolean createParent) throws IOException {
        FSDataOutputStream out = fSys.create(path, false, 4096, numRepl, (long)blockSize);
        byte[] data = FileSystemTestHelper.getFileData(numBlocks, blockSize);
        out.write(data, 0, data.length);
        out.close();
        return data.length;
    }

    public static long createFile(FileSystem fSys, Path path, int numBlocks, int blockSize, boolean createParent) throws IOException {
        return FileSystemTestHelper.createFile(fSys, path, numBlocks, blockSize, fSys.getDefaultReplication(path), true);
    }

    public static long createFile(FileSystem fSys, Path path, int numBlocks, int blockSize) throws IOException {
        return FileSystemTestHelper.createFile(fSys, path, numBlocks, blockSize, true);
    }

    public static long createFile(FileSystem fSys, Path path) throws IOException {
        return FileSystemTestHelper.createFile(fSys, path, 2, 1024, (short)1, true);
    }

    public long createFile(FileSystem fSys, String name) throws IOException {
        Path path = this.getTestRootPath(fSys, name);
        return FileSystemTestHelper.createFile(fSys, path);
    }

    public static boolean exists(FileSystem fSys, Path p) throws IOException {
        return fSys.exists(p);
    }

    public static boolean isFile(FileSystem fSys, Path p) throws IOException {
        try {
            return fSys.getFileStatus(p).isFile();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public static boolean isDir(FileSystem fSys, Path p) throws IOException {
        try {
            return fSys.getFileStatus(p).isDirectory();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    static String writeFile(FileSystem fileSys, Path name, int fileSize) throws IOException {
        long seed = 3735928559L;
        FSDataOutputStream stm = fileSys.create(name);
        byte[] buffer = new byte[fileSize];
        Random rand = new Random(3735928559L);
        rand.nextBytes(buffer);
        stm.write(buffer);
        stm.close();
        return new String(buffer);
    }

    static String readFile(FileSystem fs, Path name, int buflen) throws IOException {
        int n;
        int remaining;
        byte[] b = new byte[buflen];
        int offset = 0;
        FSDataInputStream in = fs.open(name);
        while ((remaining = b.length - offset) > 0 && (n = in.read(b, offset, remaining)) != -1) {
            offset += n;
        }
        Assert.assertEquals((long)offset, (long)Math.min((long)b.length, in.getPos()));
        in.close();
        String s = new String(b, 0, offset);
        return s;
    }

    public FileStatus containsPath(FileSystem fSys, Path path, FileStatus[] dirList) throws IOException {
        for (int i = 0; i < dirList.length; ++i) {
            if (!this.getTestRootPath(fSys, path.toString()).equals((Object)dirList[i].getPath())) continue;
            return dirList[i];
        }
        return null;
    }

    public static FileStatus containsPath(Path path, FileStatus[] dirList) throws IOException {
        for (int i = 0; i < dirList.length; ++i) {
            if (!path.equals((Object)dirList[i].getPath())) continue;
            return dirList[i];
        }
        return null;
    }

    public FileStatus containsPath(FileSystem fSys, String path, FileStatus[] dirList) throws IOException {
        return this.containsPath(fSys, new Path(path), dirList);
    }

    public static void checkFileStatus(FileSystem aFs, String path, fileType expectedType) throws IOException {
        FileStatus s = aFs.getFileStatus(new Path(path));
        Assert.assertNotNull((Object)s);
        if (expectedType == fileType.isDir) {
            Assert.assertTrue((boolean)s.isDirectory());
        } else if (expectedType == fileType.isFile) {
            Assert.assertTrue((boolean)s.isFile());
        } else if (expectedType == fileType.isSymlink) {
            Assert.assertTrue((boolean)s.isSymlink());
        }
        Assert.assertEquals((Object)aFs.makeQualified(new Path(path)), (Object)s.getPath());
    }

    public static class MockFileSystem
    extends FilterFileSystem {
        public MockFileSystem() {
            super((FileSystem)Mockito.mock(MockFileSystem.class));
        }

        public MockFileSystem getRawFileSystem() {
            return (MockFileSystem)super.getRawFileSystem();
        }

        public void initialize(URI uri, Configuration conf) throws IOException {
            this.fs.initialize(uri, conf);
        }

        public String getCanonicalServiceName() {
            return this.fs.getCanonicalServiceName();
        }

        public FileSystem[] getChildFileSystems() {
            return this.fs.getChildFileSystems();
        }

        public Token<?> getDelegationToken(String renewer) throws IOException {
            return this.fs.getDelegationToken(renewer);
        }
    }

    public static enum fileType {
        isDir,
        isFile,
        isSymlink;

    }
}

