/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.retry;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.Idempotent;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcInvocationHandler;
import org.apache.hadoop.util.ThreadUtil;

class RetryInvocationHandler
implements RpcInvocationHandler {
    public static final Log LOG = LogFactory.getLog(RetryInvocationHandler.class);
    private final FailoverProxyProvider proxyProvider;
    private long proxyProviderFailoverCount = 0L;
    private volatile boolean hasMadeASuccessfulCall = false;
    private final RetryPolicy defaultPolicy;
    private final Map<String, RetryPolicy> methodNameToPolicyMap;
    private Object currentProxy;

    public RetryInvocationHandler(FailoverProxyProvider proxyProvider, RetryPolicy retryPolicy) {
        this(proxyProvider, retryPolicy, Collections.emptyMap());
    }

    public RetryInvocationHandler(FailoverProxyProvider proxyProvider, RetryPolicy defaultPolicy, Map<String, RetryPolicy> methodNameToPolicyMap) {
        this.proxyProvider = proxyProvider;
        this.defaultPolicy = defaultPolicy;
        this.methodNameToPolicyMap = methodNameToPolicyMap;
        this.currentProxy = proxyProvider.getProxy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        RetryPolicy policy = this.methodNameToPolicyMap.get(method.getName());
        if (policy == null) {
            policy = this.defaultPolicy;
        }
        int invocationFailoverCount = 0;
        int retries = 0;
        while (true) {
            long invocationAttemptFailoverCount;
            FailoverProxyProvider failoverProxyProvider = this.proxyProvider;
            synchronized (failoverProxyProvider) {
                invocationAttemptFailoverCount = this.proxyProviderFailoverCount;
            }
            try {
                Object ret = this.invokeMethod(method, args);
                this.hasMadeASuccessfulCall = true;
                return ret;
            }
            catch (Exception e) {
                boolean isMethodIdempotent = this.proxyProvider.getInterface().getMethod(method.getName(), method.getParameterTypes()).isAnnotationPresent(Idempotent.class);
                RetryPolicy.RetryAction action = policy.shouldRetry(e, retries++, invocationFailoverCount, isMethodIdempotent);
                if (action.action == RetryPolicy.RetryAction.RetryDecision.FAIL) {
                    if (action.reason != null) {
                        LOG.warn((Object)("Exception while invoking " + this.currentProxy.getClass() + "." + method.getName() + ". Not retrying because " + action.reason), (Throwable)e);
                    }
                    throw e;
                }
                boolean worthLogging = invocationFailoverCount != 0 || this.hasMadeASuccessfulCall;
                if (action.action == RetryPolicy.RetryAction.RetryDecision.FAILOVER_AND_RETRY && (worthLogging |= LOG.isDebugEnabled())) {
                    String msg = "Exception while invoking " + method.getName() + " of class " + this.currentProxy.getClass().getSimpleName();
                    if (invocationFailoverCount > 0) {
                        msg = msg + " after " + invocationFailoverCount + " fail over attempts";
                    }
                    msg = msg + ". Trying to fail over " + RetryInvocationHandler.formatSleepMessage(action.delayMillis);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)msg, (Throwable)e);
                    } else {
                        LOG.warn((Object)msg);
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Exception while invoking " + method.getName() + " of class " + this.currentProxy.getClass().getSimpleName() + ". Retrying " + RetryInvocationHandler.formatSleepMessage(action.delayMillis)), (Throwable)e);
                }
                if (action.delayMillis > 0L) {
                    ThreadUtil.sleepAtLeastIgnoreInterrupts(action.delayMillis);
                }
                if (action.action != RetryPolicy.RetryAction.RetryDecision.FAILOVER_AND_RETRY) continue;
                FailoverProxyProvider failoverProxyProvider2 = this.proxyProvider;
                synchronized (failoverProxyProvider2) {
                    if (invocationAttemptFailoverCount == this.proxyProviderFailoverCount) {
                        this.proxyProvider.performFailover(this.currentProxy);
                        ++this.proxyProviderFailoverCount;
                        this.currentProxy = this.proxyProvider.getProxy();
                    } else {
                        LOG.warn((Object)"A failover has occurred since the start of this method invocation attempt.");
                    }
                }
                ++invocationFailoverCount;
                continue;
            }
            break;
        }
    }

    private static String formatSleepMessage(long millis) {
        if (millis > 0L) {
            return "after sleeping for " + millis + "ms.";
        }
        return "immediately.";
    }

    private Object invokeMethod(Method method, Object[] args) throws Throwable {
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(this.currentProxy, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    @Override
    public void close() throws IOException {
        this.proxyProvider.close();
    }

    @Override
    public Client.ConnectionId getConnectionId() {
        return RPC.getConnectionIdForProxy(this.currentProxy);
    }
}

