/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.replication;

import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.X509TrustManager;
import org.apache.directory.ldap.client.api.NoVerificationTrustManager;
import org.apache.directory.server.ldap.replication.ReplicationConsumerConfig;
import org.apache.directory.server.ldap.replication.ReplicationTrustManager;
import org.apache.directory.shared.ldap.model.message.AliasDerefMode;
import org.apache.directory.shared.ldap.model.message.SearchScope;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.util.Strings;

public class SyncreplConfiguration
implements ReplicationConsumerConfig {
    private String remoteHost = "localhost";
    private int remotePort = 389;
    private String replUserDn;
    private byte[] replUserPassword;
    private boolean refreshNPersist = true;
    private long refreshInterval = 60000L;
    private String baseDn;
    private String filter = "(objectClass=*)";
    private Set<String> attributes;
    private int searchSizeLimit = 0;
    private int searchTimeout = 0;
    private SearchScope searchScope = SearchScope.SUBTREE;
    private AliasDerefMode aliasDerefMode = AliasDerefMode.NEVER_DEREF_ALIASES;
    private byte[] cookie;
    private int replicaId;
    private Dn configEntryDn = null;
    private boolean chaseReferrals = false;
    private boolean useTls = true;
    private boolean strictCertVerification = true;
    private X509TrustManager trustManager = new NoVerificationTrustManager();

    public SyncreplConfiguration() {
        this.attributes = new HashSet<String>();
        this.attributes.add("*");
        this.attributes.add(Strings.toLowerCase((String)"entryUUID"));
        this.attributes.add(Strings.toLowerCase((String)"entryCSN"));
        this.attributes.add(Strings.toLowerCase((String)"ref"));
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public String getReplUserDn() {
        return this.replUserDn;
    }

    public void setReplUserDn(String replUserdDn) {
        this.replUserDn = replUserdDn;
    }

    public byte[] getReplUserPassword() {
        return this.replUserPassword;
    }

    public void setReplUserPassword(byte[] replUserPassword) {
        this.replUserPassword = replUserPassword;
    }

    public boolean isRefreshNPersist() {
        return this.refreshNPersist;
    }

    public void setRefreshNPersist(boolean refreshNPersist) {
        this.refreshNPersist = refreshNPersist;
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(long refreshInterval) {
        if (refreshInterval <= 0L) {
            throw new IllegalArgumentException("refresh interval should be more than zero");
        }
        this.refreshInterval = refreshInterval;
    }

    public String getBaseDn() {
        return this.baseDn;
    }

    public void setBaseDn(String baseDn) {
        this.baseDn = baseDn;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String[] getAttributes() {
        return this.attributes.toArray(new String[0]);
    }

    public void setAttributes(String[] attr) {
        if (attr == null) {
            throw new IllegalArgumentException("attributes to be replicated cannot be null or empty");
        }
        if (attr.length > 0) {
            this.attributes.remove("*");
        }
        for (String at : attr) {
            if (this.attributes.contains(Strings.toLowerCase((String)(at = at.trim())))) continue;
            this.attributes.add(at);
        }
    }

    public int getSearchSizeLimit() {
        return this.searchSizeLimit;
    }

    public void setSearchSizeLimit(int searchSizeLimit) {
        if (this.searchTimeout < 0) {
            throw new IllegalArgumentException("search size limit value cannot be negative " + searchSizeLimit);
        }
        this.searchSizeLimit = searchSizeLimit;
    }

    public int getSearchTimeout() {
        return this.searchTimeout;
    }

    public void setSearchTimeout(int searchTimeout) {
        if (searchTimeout < 0) {
            throw new IllegalArgumentException("search timeout value cannot be negative " + searchTimeout);
        }
        this.searchTimeout = searchTimeout;
    }

    public SearchScope getSearchScope() {
        return this.searchScope;
    }

    public void setSearchScope(SearchScope searchScope) {
        this.searchScope = searchScope;
    }

    public int getReplicaId() {
        return this.replicaId;
    }

    public void setReplicaId(int replicaId) {
        this.replicaId = replicaId;
    }

    public AliasDerefMode getAliasDerefMode() {
        return this.aliasDerefMode;
    }

    public void setAliasDerefMode(AliasDerefMode aliasDerefMode) {
        if (aliasDerefMode != AliasDerefMode.NEVER_DEREF_ALIASES && aliasDerefMode != AliasDerefMode.DEREF_FINDING_BASE_OBJ) {
            throw new IllegalArgumentException("alias deref mode should only be set to either 'NEVER_DEREF_ALIASES' or 'DEREF_FINDING_BASE_OBJ'");
        }
        this.aliasDerefMode = aliasDerefMode;
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    public void setCookie(byte[] cookie) {
        this.cookie = cookie;
    }

    public boolean isStoreCookieInFile() {
        return this.configEntryDn == null;
    }

    public boolean isChaseReferrals() {
        return this.chaseReferrals;
    }

    public void setChaseReferrals(boolean chaseReferrals) {
        if (chaseReferrals) {
            throw new UnsupportedOperationException("client-api currently doesn't support chasing referrals");
        }
        this.chaseReferrals = chaseReferrals;
    }

    public Dn getConfigEntryDn() {
        return this.configEntryDn;
    }

    public boolean isUseTls() {
        return this.useTls;
    }

    public void setUseTls(boolean useTls) {
        this.useTls = useTls;
    }

    public boolean isStrictCertVerification() {
        return this.strictCertVerification;
    }

    public void setStrictCertVerification(boolean strictCertVerification) {
        this.trustManager = strictCertVerification ? ReplicationTrustManager.getInstance() : new NoVerificationTrustManager();
        this.strictCertVerification = strictCertVerification;
    }

    public X509TrustManager getTrustManager() {
        return this.trustManager;
    }

    public void setConfigEntryDn(Dn configEntryDn) {
        this.configEntryDn = configEntryDn;
    }
}

