/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.trigger;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.core.trigger.AbstractStoredProcedureParameterInjector;
import org.apache.directory.server.core.trigger.StoredProcedureParameterInjector;
import org.apache.directory.shared.ldap.model.constants.SchemaConstants;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.trigger.StoredProcedureParameter;

public class ModifyStoredProcedureParameterInjector
extends AbstractStoredProcedureParameterInjector {
    private Dn modifiedEntryName;
    private List<Modification> modifications;
    private Entry oldEntry;
    StoredProcedureParameterInjector.MicroInjector $objectInjector = new StoredProcedureParameterInjector.MicroInjector(){

        @Override
        public Object inject(OperationContext opContext, StoredProcedureParameter param) throws LdapInvalidDnException {
            return opContext.getSession().getDirectoryService().getDnFactory().create(ModifyStoredProcedureParameterInjector.this.modifiedEntryName.getName());
        }
    };
    StoredProcedureParameterInjector.MicroInjector $modificationInjector = new StoredProcedureParameterInjector.MicroInjector(){

        @Override
        public Object inject(OperationContext opContext, StoredProcedureParameter param) throws LdapException {
            ArrayList<Modification> newMods = new ArrayList<Modification>();
            for (Modification mod : ModifyStoredProcedureParameterInjector.this.modifications) {
                newMods.add(mod.clone());
            }
            return newMods;
        }
    };
    StoredProcedureParameterInjector.MicroInjector $oldEntryInjector = new StoredProcedureParameterInjector.MicroInjector(){

        @Override
        public Object inject(OperationContext opContext, StoredProcedureParameter param) throws LdapException {
            return ModifyStoredProcedureParameterInjector.this.oldEntry;
        }
    };
    StoredProcedureParameterInjector.MicroInjector $newEntryInjector = new StoredProcedureParameterInjector.MicroInjector(){

        @Override
        public Object inject(OperationContext opContext, StoredProcedureParameter param) throws LdapException {
            return ModifyStoredProcedureParameterInjector.this.getEntry(opContext);
        }
    };

    public ModifyStoredProcedureParameterInjector(ModifyOperationContext opContext) throws LdapException {
        super((OperationContext)opContext);
        this.modifiedEntryName = opContext.getDn();
        this.modifications = opContext.getModItems();
        this.oldEntry = this.getEntry((OperationContext)opContext);
        Map<Class<?>, StoredProcedureParameterInjector.MicroInjector> injectors = super.getInjectors();
        injectors.put(StoredProcedureParameter.Modify_OBJECT.class, this.$objectInjector);
        injectors.put(StoredProcedureParameter.Modify_MODIFICATION.class, this.$modificationInjector);
        injectors.put(StoredProcedureParameter.Modify_OLD_ENTRY.class, this.$oldEntryInjector);
        injectors.put(StoredProcedureParameter.Modify_NEW_ENTRY.class, this.$newEntryInjector);
    }

    private Entry getEntry(OperationContext opContext) throws LdapException {
        CoreSession session = opContext.getSession();
        LookupOperationContext lookupContext = new LookupOperationContext(session, this.modifiedEntryName, SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY);
        return session.getDirectoryService().getPartitionNexus().lookup(lookupContext);
    }
}

