/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.processor.Traceable;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;

public class UnmarshalProcessor
extends ServiceSupport
implements Processor,
Traceable,
CamelContextAware {
    private CamelContext camelContext;
    private final DataFormat dataFormat;

    public UnmarshalProcessor(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(Exchange exchange) throws Exception {
        ObjectHelper.notNull(this.dataFormat, "dataFormat");
        InputStream stream = ExchangeHelper.getMandatoryInBody(exchange, InputStream.class);
        try {
            Message out = exchange.getOut();
            out.copyFrom(exchange.getIn());
            Object result = this.dataFormat.unmarshal(exchange, stream);
            out.setBody(result);
            Object var6_5 = null;
            if (stream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (stream == null) throw throwable;
            stream.close();
            throw throwable;
        }
        stream.close();
    }

    public String toString() {
        return "Unmarshal[" + this.dataFormat + "]";
    }

    public String getTraceLabel() {
        return "unmarshal[" + this.dataFormat + "]";
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    protected void doStart() throws Exception {
        if (this.dataFormat instanceof CamelContextAware) {
            ((CamelContextAware)((Object)this.dataFormat)).setCamelContext(this.camelContext);
        }
        ServiceHelper.startService(this.dataFormat);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.dataFormat);
    }
}

