/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.ArrayList;
import org.activiti.engine.history.HistoricVariableInstance;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.HasRevision;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.persistence.entity.ByteArrayEntity;
import org.activiti.engine.impl.persistence.entity.ByteArrayRef;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.impl.variable.ValueFields;
import org.activiti.engine.impl.variable.VariableType;
import org.apache.commons.lang3.StringUtils;

public class HistoricVariableInstanceEntity
implements ValueFields,
HistoricVariableInstance,
PersistentObject,
HasRevision,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected int revision;
    protected String name;
    protected VariableType variableType;
    protected String processInstanceId;
    protected String executionId;
    protected String taskId;
    protected Long longValue;
    protected Double doubleValue;
    protected String textValue;
    protected String textValue2;
    protected final ByteArrayRef byteArrayRef = new ByteArrayRef();
    protected Object cachedValue;

    protected HistoricVariableInstanceEntity() {
    }

    public static HistoricVariableInstanceEntity copyAndInsert(VariableInstanceEntity variableInstance) {
        HistoricVariableInstanceEntity historicVariableInstance = new HistoricVariableInstanceEntity();
        historicVariableInstance.id = variableInstance.getId();
        historicVariableInstance.processInstanceId = variableInstance.getProcessInstanceId();
        historicVariableInstance.executionId = variableInstance.getExecutionId();
        historicVariableInstance.taskId = variableInstance.getTaskId();
        historicVariableInstance.revision = variableInstance.getRevision();
        historicVariableInstance.name = variableInstance.getName();
        historicVariableInstance.variableType = variableInstance.getType();
        historicVariableInstance.copyValue(variableInstance);
        Context.getCommandContext().getDbSqlSession().insert(historicVariableInstance);
        return historicVariableInstance;
    }

    public void copyValue(VariableInstanceEntity variableInstance) {
        this.textValue = variableInstance.getTextValue();
        this.textValue2 = variableInstance.getTextValue2();
        this.doubleValue = variableInstance.getDoubleValue();
        this.longValue = variableInstance.getLongValue();
        this.variableType = variableInstance.getType();
        if (variableInstance.getByteArrayValueId() != null) {
            this.setByteArrayValue(variableInstance.getByteArrayValue().getBytes());
        }
    }

    public void delete() {
        Context.getCommandContext().getDbSqlSession().delete(this);
        this.byteArrayRef.delete();
    }

    @Override
    public Object getPersistentState() {
        ArrayList<Object> state = new ArrayList<Object>(5);
        state.add(this.textValue);
        state.add(this.textValue2);
        state.add(this.doubleValue);
        state.add(this.longValue);
        state.add(this.byteArrayRef.getId());
        return state;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    @Override
    public Object getValue() {
        if (!this.variableType.isCachable() || this.cachedValue == null) {
            this.cachedValue = this.variableType.getValue(this);
        }
        return this.cachedValue;
    }

    @Override
    public byte[] getBytes() {
        return this.byteArrayRef.getBytes();
    }

    @Override
    public void setBytes(byte[] bytes) {
        this.byteArrayRef.setValue("hist.var-" + this.name, bytes);
    }

    @Override
    @Deprecated
    public ByteArrayEntity getByteArrayValue() {
        return this.byteArrayRef.getEntity();
    }

    @Override
    @Deprecated
    public String getByteArrayValueId() {
        return this.byteArrayRef.getId();
    }

    @Override
    @Deprecated
    public void setByteArrayValue(byte[] bytes) {
        this.setBytes(bytes);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getVariableTypeName() {
        return this.variableType != null ? this.variableType.getTypeName() : null;
    }

    @Override
    public String getVariableName() {
        return this.name;
    }

    public VariableType getVariableType() {
        return this.variableType;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Long getLongValue() {
        return this.longValue;
    }

    @Override
    public void setLongValue(Long longValue) {
        this.longValue = longValue;
    }

    @Override
    public Double getDoubleValue() {
        return this.doubleValue;
    }

    @Override
    public void setDoubleValue(Double doubleValue) {
        this.doubleValue = doubleValue;
    }

    @Override
    public String getTextValue() {
        return this.textValue;
    }

    @Override
    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    @Override
    public String getTextValue2() {
        return this.textValue2;
    }

    @Override
    public void setTextValue2(String textValue2) {
        this.textValue2 = textValue2;
    }

    @Override
    public Object getCachedValue() {
        return this.cachedValue;
    }

    @Override
    public void setCachedValue(Object cachedValue) {
        this.cachedValue = cachedValue;
    }

    public void setVariableType(VariableType variableType) {
        this.variableType = variableType;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HistoricVariableInstanceEntity[");
        sb.append("id=").append(this.id);
        sb.append(", name=").append(this.name);
        sb.append(", type=").append(this.variableType != null ? this.variableType.getTypeName() : "null");
        if (this.longValue != null) {
            sb.append(", longValue=").append(this.longValue);
        }
        if (this.doubleValue != null) {
            sb.append(", doubleValue=").append(this.doubleValue);
        }
        if (this.textValue != null) {
            sb.append(", textValue=").append(StringUtils.abbreviate((String)this.textValue, (int)40));
        }
        if (this.textValue2 != null) {
            sb.append(", textValue2=").append(StringUtils.abbreviate((String)this.textValue2, (int)40));
        }
        if (this.byteArrayRef.getId() != null) {
            sb.append(", byteArrayValueId=").append(this.byteArrayRef.getId());
        }
        sb.append("]");
        return sb.toString();
    }
}

