/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import java.util.List;
import org.activiti.bpmn.model.Assignment;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.DataAssociation;
import org.activiti.bpmn.model.FieldExtension;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Task;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.impl.bpmn.data.AbstractDataAssociation;
import org.activiti.engine.impl.bpmn.data.SimpleDataInputAssociation;
import org.activiti.engine.impl.bpmn.data.TransformationDataOutputAssociation;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractActivityBpmnParseHandler;
import org.activiti.engine.impl.bpmn.webservice.MessageImplicitDataInputAssociation;
import org.activiti.engine.impl.bpmn.webservice.MessageImplicitDataOutputAssociation;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractExternalInvocationBpmnParseHandler<T extends FlowNode>
extends AbstractActivityBpmnParseHandler<T> {
    protected void validateFieldDeclarationsForEmail(BpmnParse bpmnParse, Task task, List<FieldExtension> fieldExtensions) {
        boolean toDefined = false;
        boolean textOrHtmlDefined = false;
        for (FieldExtension fieldExtension : fieldExtensions) {
            if (fieldExtension.getFieldName().equals("to")) {
                toDefined = true;
            }
            if (fieldExtension.getFieldName().equals("html")) {
                textOrHtmlDefined = true;
            }
            if (!fieldExtension.getFieldName().equals("text")) continue;
            textOrHtmlDefined = true;
        }
        if (!toDefined) {
            bpmnParse.getBpmnModel().addProblem("No recipient is defined on the mail activity", (BaseElement)task);
        }
        if (!textOrHtmlDefined) {
            bpmnParse.getBpmnModel().addProblem("Text or html field should be provided", (BaseElement)task);
        }
    }

    protected void validateFieldDeclarationsForShell(BpmnParse bpmnParse, Task task, List<FieldExtension> fieldExtensions) {
        boolean shellCommandDefined = false;
        for (FieldExtension fieldExtension : fieldExtensions) {
            String fieldName = fieldExtension.getFieldName();
            String fieldValue = fieldExtension.getStringValue();
            shellCommandDefined |= fieldName.equals("command");
            if (!fieldName.equals("wait") && !fieldName.equals("redirectError") && !fieldName.equals("cleanEnv") || fieldValue.toLowerCase().equals("true") || fieldValue.toLowerCase().equals("false")) continue;
            bpmnParse.getBpmnModel().addProblem("undefined value for shell " + fieldName + " parameter :" + fieldValue.toString() + ".", (BaseElement)task);
        }
        if (!shellCommandDefined) {
            bpmnParse.getBpmnModel().addProblem("No shell command is defined on the shell activity", (BaseElement)task);
        }
    }

    public AbstractDataAssociation createDataInputAssociation(BpmnParse bpmnParse, DataAssociation dataAssociationElement) {
        if (StringUtils.isEmpty((CharSequence)dataAssociationElement.getTargetRef())) {
            bpmnParse.getBpmnModel().addProblem("targetRef is required", (BaseElement)dataAssociationElement);
        }
        if (dataAssociationElement.getAssignments().isEmpty()) {
            return new MessageImplicitDataInputAssociation(dataAssociationElement.getSourceRef(), dataAssociationElement.getTargetRef());
        }
        SimpleDataInputAssociation dataAssociation = new SimpleDataInputAssociation(dataAssociationElement.getSourceRef(), dataAssociationElement.getTargetRef());
        for (Assignment assigmentElement : dataAssociationElement.getAssignments()) {
            if (!StringUtils.isNotEmpty((CharSequence)assigmentElement.getFrom()) || !StringUtils.isNotEmpty((CharSequence)assigmentElement.getTo())) continue;
            Expression from = bpmnParse.getExpressionManager().createExpression(assigmentElement.getFrom());
            Expression to = bpmnParse.getExpressionManager().createExpression(assigmentElement.getTo());
            org.activiti.engine.impl.bpmn.data.Assignment assignment = new org.activiti.engine.impl.bpmn.data.Assignment(from, to);
            dataAssociation.addAssignment(assignment);
        }
        return dataAssociation;
    }

    public AbstractDataAssociation createDataOutputAssociation(BpmnParse bpmnParse, DataAssociation dataAssociationElement) {
        if (StringUtils.isNotEmpty((CharSequence)dataAssociationElement.getSourceRef())) {
            return new MessageImplicitDataOutputAssociation(dataAssociationElement.getTargetRef(), dataAssociationElement.getSourceRef());
        }
        Expression transformation = bpmnParse.getExpressionManager().createExpression(dataAssociationElement.getTransformation());
        TransformationDataOutputAssociation dataOutputAssociation = new TransformationDataOutputAssociation(null, dataAssociationElement.getTargetRef(), transformation);
        return dataOutputAssociation;
    }
}

