/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.Constants;
import org.jets3t.service.utils.ServiceUtils;

public class EncryptionUtil {
    private static final Log log;
    public static final String DEFAULT_VERSION = "2";
    public static final String DEFAULT_ALGORITHM = "PBEWithMD5AndDES";
    private String algorithm = null;
    private String version = null;
    private SecretKey key = null;
    private AlgorithmParameterSpec algParamSpec = null;
    int ITERATION_COUNT = 5000;
    byte[] salt = new byte[]{-92, 11, -56, 52, -42, -107, -13, 19};

    public EncryptionUtil(String encryptionKey, String algorithm, String version) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException {
        this.algorithm = algorithm;
        this.version = version;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cryptographic properties: algorithm=" + this.algorithm + ", version=" + this.version));
        }
        if (!DEFAULT_VERSION.equals(version)) {
            throw new RuntimeException("Unrecognised crypto version setting: " + version);
        }
        PBEKeySpec keyspec = new PBEKeySpec(encryptionKey.toCharArray(), this.salt, this.ITERATION_COUNT, 32);
        SecretKeyFactory skf = SecretKeyFactory.getInstance(algorithm);
        this.key = skf.generateSecret(keyspec);
        this.algParamSpec = new PBEParameterSpec(this.salt, this.ITERATION_COUNT);
    }

    public EncryptionUtil(String encryptionKey) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException {
        this(encryptionKey, DEFAULT_ALGORITHM, DEFAULT_VERSION);
    }

    private EncryptionUtil(String encryptionKey, String encryptionScheme, String blockMode, String paddingMode) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, UnsupportedEncodingException {
        byte[] KEY_BASE_BYTES = new byte[]{-62, -85, -30, -128, -96, 14, -62, -69, -61, -90, -30, -128, -108, 114, 61, -61, -76, 24, 20, 81, -59, -110, 32, 121, -30, -124, -94, 83, 52, 67, 46, 36, 83, -61, -65, -61, -110, 116, -53, -102, -61, -96, -61, -95, 73, -61, -116, 91, -30, -120, -122, 79, -61, -117, -61, -106, -61, -124, 117, 64, -30, -128, -99, 28, -62, -87, 100, 70, 22, 84, 23, 3, -62, -76, -61, -92, -30, -127, -124, -61, -95, 78, 104, -61, -117, -61, -86, 118, -62, -85, 29, -30, -128, -108, -62, -93, 108, -61, -69, 94, 117, -30, -128, -99, -61, -125, 16, -49, -128, 43, 116, -59, -109, 58, -61, -128, 75, 55, 81, -62, -89, -30, -120, -98, 72, 62, -30, -128, -98, 58, 105, -61, -118, 117, 17, -30, -128, -80, -61, -108, -61, -68, 81, -61, -109, 35, -30, -128, -70, -62, -91, 49, -30, -128, -108, 122, 106, -62, -75, -30, -127, -124, -30, -128, -71, 41, 49, 111, -30, -128, -80, -61, -73, 77, -61, -104, 53, 68, 70, -61, -83, -62, -85, -59, -72, 46, 35, 99, 59, -62, -81, -62, -73, -17, -93, -65, -53, -122, -61, -116, 66, -50, -87, -30, -120, -122, 118, -30, -124, -94};
        this.algorithm = "DESede/CBC/PKCS5Padding";
        encryptionKey = encryptionKey + new String(KEY_BASE_BYTES, Constants.DEFAULT_ENCODING);
        int keyOffset = 0;
        byte[] spec = new byte[8];
        for (int specOffset = 0; specOffset < spec.length; ++specOffset) {
            keyOffset = (keyOffset + 7) % encryptionKey.length();
            spec[specOffset] = encryptionKey.getBytes()[keyOffset];
        }
        DESedeKeySpec keySpec = new DESedeKeySpec(encryptionKey.getBytes());
        this.algParamSpec = new IvParameterSpec(spec);
        this.key = SecretKeyFactory.getInstance(encryptionScheme).generateSecret(keySpec);
    }

    public static EncryptionUtil getObsoleteEncryptionUtil(String encryptionKey) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, UnsupportedEncodingException {
        return new EncryptionUtil(encryptionKey, "DESede", "CBC", "PKCS5Padding");
    }

    protected Cipher initEncryptModeCipher() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = Cipher.getInstance(this.algorithm);
        cipher.init(1, (Key)this.key, this.algParamSpec);
        return cipher;
    }

    protected Cipher initDecryptModeCipher() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = Cipher.getInstance(this.algorithm);
        cipher.init(2, (Key)this.key, this.algParamSpec);
        return cipher;
    }

    public byte[] encrypt(String data) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException, InvalidKeySpecException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initEncryptModeCipher();
        return cipher.doFinal(data.getBytes(Constants.DEFAULT_ENCODING));
    }

    public String decryptString(byte[] data) throws InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initEncryptModeCipher();
        return new String(cipher.doFinal(data), Constants.DEFAULT_ENCODING);
    }

    public String decryptString(byte[] data, int startIndex, int endIndex) throws InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initDecryptModeCipher();
        return new String(cipher.doFinal(data, startIndex, endIndex), Constants.DEFAULT_ENCODING);
    }

    public byte[] encrypt(byte[] data) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initEncryptModeCipher();
        return cipher.doFinal(data);
    }

    public byte[] decrypt(byte[] data) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initDecryptModeCipher();
        return cipher.doFinal(data);
    }

    public byte[] decrypt(byte[] data, int startIndex, int endIndex) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initDecryptModeCipher();
        return cipher.doFinal(data, startIndex, endIndex);
    }

    public CipherInputStream encrypt(InputStream is) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initEncryptModeCipher();
        return new CipherInputStream(is, cipher);
    }

    public CipherInputStream decrypt(InputStream is) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initDecryptModeCipher();
        return new CipherInputStream(is, cipher);
    }

    public CipherOutputStream encrypt(OutputStream os) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initEncryptModeCipher();
        return new CipherOutputStream(os, cipher);
    }

    public CipherOutputStream decrypt(OutputStream os) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initDecryptModeCipher();
        return new CipherOutputStream(os, cipher);
    }

    public long getEncryptedOutputSize(long inputSize) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initEncryptModeCipher();
        long outputSize = 0L;
        int maxChunk = 0x7FFFDFFF;
        while (inputSize >= (long)maxChunk) {
            outputSize += (long)cipher.getOutputSize(maxChunk);
            inputSize -= (long)maxChunk;
        }
        return outputSize += (long)cipher.getOutputSize((int)inputSize);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public static boolean isCipherAvailableForUse(String cipher) {
        try {
            EncryptionUtil encryptionUtil = new EncryptionUtil("Sample Key", cipher, DEFAULT_VERSION);
            encryptionUtil.encrypt("Testing encryption...");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Availability test failed for encryption cipher " + cipher));
            }
            return false;
        }
        return true;
    }

    public static String[] listAvailablePbeCiphers(boolean testAvailability) {
        Set<String> ciphers = Security.getAlgorithms("Cipher");
        HashSet<String> pbeCiphers = new HashSet<String>();
        Iterator<String> iter = ciphers.iterator();
        while (iter.hasNext()) {
            String cipher = iter.next();
            if (!cipher.toLowerCase().startsWith("pbe") || testAvailability && !EncryptionUtil.isCipherAvailableForUse(cipher)) continue;
            pbeCiphers.add(cipher);
        }
        return pbeCiphers.toArray(new String[pbeCiphers.size()]);
    }

    public static Provider[] listAvailableProviders() {
        return Security.getProviders();
    }

    public static byte[] signWithRsaSha1(byte[] derPrivateKeyBytes, byte[] dataToSign) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, InvalidKeySpecException, NoSuchProviderException {
        PKCS8EncodedKeySpec privSpec = new PKCS8EncodedKeySpec(derPrivateKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        RSAPrivateKey privateKey = (RSAPrivateKey)keyFactory.generatePrivate(privSpec);
        Signature signature = Signature.getInstance("SHA1withRSA", "BC");
        signature.initSign(privateKey, new SecureRandom());
        signature.update(dataToSign);
        byte[] signatureBytes = signature.sign();
        return signatureBytes;
    }

    public static byte[] convertRsaPemToDer(InputStream is) throws IOException {
        String pemData = ServiceUtils.readInputStreamToString(is, "UTF-8");
        int headerEndOffset = pemData.indexOf(10);
        int footerStartOffset = pemData.indexOf("-----END");
        String strippedPemData = pemData.substring(headerEndOffset + 1, footerStartOffset - 1);
        byte[] derBytes = ServiceUtils.fromBase64(strippedPemData);
        return derBytes;
    }

    public static void main(String[] args) throws Exception {
        int i;
        Provider[] providers = EncryptionUtil.listAvailableProviders();
        System.out.println("Providers:");
        for (int i2 = 0; i2 < providers.length; ++i2) {
            System.out.println(" - " + providers[i2]);
        }
        String[] ciphers = EncryptionUtil.listAvailablePbeCiphers(false);
        System.out.println("PBE Ciphers available (untested):");
        for (i = 0; i < ciphers.length; ++i) {
            System.out.println(" - " + ciphers[i]);
        }
        ciphers = EncryptionUtil.listAvailablePbeCiphers(true);
        System.out.println("PBE Ciphers available (tested):");
        for (i = 0; i < ciphers.length; ++i) {
            System.out.println(" - " + ciphers[i]);
        }
    }

    static {
        block5: {
            log = LogFactory.getLog((Class)EncryptionUtil.class);
            try {
                Class<?> bouncyCastleProviderClass = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
                if (bouncyCastleProviderClass != null) {
                    Provider bouncyCastleProvider = (Provider)bouncyCastleProviderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    Security.addProvider(bouncyCastleProvider);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Loaded security provider BouncyCastleProvider");
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)"Unable to load security provider BouncyCastleProvider");
            }
        }
    }
}

