/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.model;

import java.util.Date;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.model.BaseS3Object;
import org.jets3t.service.model.S3Owner;

public class S3Bucket
extends BaseS3Object {
    private static final long serialVersionUID = -8646831898339939580L;
    public static final String METADATA_HEADER_CREATION_DATE = "Date";
    public static final String METADATA_HEADER_OWNER = "Owner";
    public static final String LOCATION_US = null;
    public static final String LOCATION_US_STANDARD = null;
    public static final String LOCATION_US_WEST = "us-west-1";
    public static final String LOCATION_EUROPE = "EU";
    private String name = null;
    private AccessControlList acl = null;
    private String location = LOCATION_US;
    private boolean isLocationKnown = false;
    private boolean requesterPays = false;
    private boolean isRequesterPaysKnown = false;

    public S3Bucket() {
    }

    public S3Bucket(String name) {
        this.name = name;
    }

    public S3Bucket(String name, String location) {
        this.name = name;
        this.location = location;
        this.isLocationKnown = true;
    }

    public String toString() {
        return "S3Bucket [name=" + this.getName() + ",location=" + this.getLocation() + ",creationDate=" + this.getCreationDate() + ",owner=" + this.getOwner() + "] Metadata=" + this.getMetadataMap();
    }

    public S3Owner getOwner() {
        return (S3Owner)this.getMetadata(METADATA_HEADER_OWNER);
    }

    public void setOwner(S3Owner owner) {
        this.addMetadata(METADATA_HEADER_OWNER, owner);
    }

    public Date getCreationDate() {
        return (Date)this.getMetadata(METADATA_HEADER_CREATION_DATE);
    }

    public void setCreationDate(Date creationDate) {
        this.addMetadata(METADATA_HEADER_CREATION_DATE, creationDate);
    }

    public AccessControlList getAcl() {
        return this.acl;
    }

    public void setAcl(AccessControlList acl) {
        this.acl = acl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLocation(String location) {
        this.location = location;
        this.isLocationKnown = true;
    }

    public boolean isLocationKnown() {
        return this.isLocationKnown;
    }

    public String getLocation() {
        return this.location;
    }

    public void setRequesterPays(boolean requesterPays) {
        this.requesterPays = requesterPays;
        this.isRequesterPaysKnown = true;
    }

    public boolean isRequesterPaysKnown() {
        return this.isRequesterPaysKnown;
    }

    public boolean isRequesterPays() {
        return this.requesterPays;
    }
}

