/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.impl.rest;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.acl.CanonicalGrantee;
import org.jets3t.service.acl.EmailAddressGrantee;
import org.jets3t.service.acl.GrantAndPermission;
import org.jets3t.service.acl.GranteeInterface;
import org.jets3t.service.acl.GroupGrantee;
import org.jets3t.service.acl.Permission;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3BucketLoggingStatus;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.S3Owner;
import org.jets3t.service.utils.ServiceUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlResponsesSaxParser {
    private static final Log log = LogFactory.getLog((Class)XmlResponsesSaxParser.class);
    private XMLReader xr = null;
    private Jets3tProperties properties = null;

    public XmlResponsesSaxParser(Jets3tProperties properties) throws S3ServiceException {
        this.properties = properties;
        try {
            this.xr = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            System.setProperty("org.xml.sax.driver", "org.apache.crimson.parser.XMLReaderImpl");
            try {
                this.xr = XMLReaderFactory.createXMLReader();
            }
            catch (SAXException e2) {
                throw new S3ServiceException("Couldn't initialize a sax driver for the XMLReader");
            }
        }
    }

    protected void parseXmlInputStream(DefaultHandler handler, InputStream inputStream) throws S3ServiceException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parsing XML response document with handler: " + handler.getClass()));
            }
            BufferedReader breader = new BufferedReader(new InputStreamReader(inputStream, Constants.DEFAULT_ENCODING));
            this.xr.setContentHandler(handler);
            this.xr.setErrorHandler(handler);
            this.xr.parse(new InputSource(breader));
        }
        catch (Throwable t) {
            block5: {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block5;
                    log.error((Object)"Unable to close response InputStream up after XML parse failure", (Throwable)e);
                }
            }
            throw new S3ServiceException("Failed to parse XML document with handler " + handler.getClass(), t);
        }
    }

    protected InputStream sanitizeXmlDocument(DefaultHandler handler, InputStream inputStream) throws S3ServiceException {
        if (!this.properties.getBoolProperty("xmlparser.sanitize-listings", true)) {
            return inputStream;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sanitizing XML document destined for handler " + handler.getClass()));
        }
        ByteArrayInputStream sanitizedInputStream = null;
        try {
            StringBuffer listingDocBuffer = new StringBuffer();
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, Constants.DEFAULT_ENCODING));
            char[] buf = new char[8192];
            int read = -1;
            while ((read = br.read(buf)) != -1) {
                listingDocBuffer.append(buf, 0, read);
            }
            br.close();
            String listingDoc = listingDocBuffer.toString().replaceAll("\r", "&#013;");
            sanitizedInputStream = new ByteArrayInputStream(listingDoc.getBytes(Constants.DEFAULT_ENCODING));
        }
        catch (Throwable t) {
            block7: {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block7;
                    log.error((Object)"Unable to close response InputStream after failure sanitizing XML document", (Throwable)e);
                }
            }
            throw new S3ServiceException("Failed to sanitize XML document destined for handler " + handler.getClass(), t);
        }
        return sanitizedInputStream;
    }

    public ListBucketHandler parseListBucketObjectsResponse(InputStream inputStream) throws S3ServiceException {
        ListBucketHandler handler = new ListBucketHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public ListAllMyBucketsHandler parseListMyBucketsResponse(InputStream inputStream) throws S3ServiceException {
        ListAllMyBucketsHandler handler = new ListAllMyBucketsHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public AccessControlListHandler parseAccessControlListResponse(InputStream inputStream) throws S3ServiceException {
        AccessControlListHandler handler = new AccessControlListHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public BucketLoggingStatusHandler parseLoggingStatusResponse(InputStream inputStream) throws S3ServiceException {
        BucketLoggingStatusHandler handler = new BucketLoggingStatusHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public String parseBucketLocationResponse(InputStream inputStream) throws S3ServiceException {
        BucketLocationHandler handler = new BucketLocationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler.getLocation();
    }

    public CopyObjectResultHandler parseCopyObjectResponse(InputStream inputStream) throws S3ServiceException {
        CopyObjectResultHandler handler = new CopyObjectResultHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public boolean parseRequestPaymentConfigurationResponse(InputStream inputStream) throws S3ServiceException {
        RequestPaymentConfigurationHandler handler = new RequestPaymentConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler.isRequesterPays();
    }

    public class RequestPaymentConfigurationHandler
    extends DefaultHandler {
        private String payer = null;
        private StringBuffer currText = null;

        public boolean isRequesterPays() {
            return "Requester".equals(this.payer);
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("RequestPaymentConfiguration")) {
                // empty if block
            }
            this.currText = new StringBuffer();
        }

        public void endElement(String uri, String name, String qName) {
            String elementText = this.currText.toString();
            if (name.equals("Payer")) {
                this.payer = elementText;
            }
        }

        public void characters(char[] ch, int start, int length) {
            this.currText.append(ch, start, length);
        }
    }

    public class CopyObjectResultHandler
    extends DefaultHandler {
        private String etag = null;
        private Date lastModified = null;
        private String errorCode = null;
        private String errorMessage = null;
        private String errorRequestId = null;
        private String errorHostId = null;
        private boolean receivedErrorResponse = false;
        private StringBuffer currText = null;

        public Date getLastModified() {
            return this.lastModified;
        }

        public String getETag() {
            return this.etag;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public String getErrorHostId() {
            return this.errorHostId;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getErrorRequestId() {
            return this.errorRequestId;
        }

        public boolean isErrorResponse() {
            return this.receivedErrorResponse;
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("CopyObjectResult")) {
                this.receivedErrorResponse = false;
            } else if (name.equals("Error")) {
                this.receivedErrorResponse = true;
            }
            this.currText = new StringBuffer();
        }

        public void endElement(String uri, String name, String qName) {
            String elementText = this.currText.toString();
            if (name.equals("LastModified")) {
                try {
                    this.lastModified = ServiceUtils.parseIso8601Date(elementText);
                }
                catch (ParseException e) {
                    throw new RuntimeException("Non-ISO8601 date for LastModified in copy object output: " + elementText, e);
                }
            } else if (name.equals("ETag")) {
                this.etag = elementText;
            } else if (name.equals("Code")) {
                this.errorCode = elementText;
            } else if (name.equals("Message")) {
                this.errorMessage = elementText;
            } else if (name.equals("RequestId")) {
                this.errorRequestId = elementText;
            } else if (name.equals("HostId")) {
                this.errorHostId = elementText;
            }
        }

        public void characters(char[] ch, int start, int length) {
            this.currText.append(ch, start, length);
        }
    }

    public class BucketLocationHandler
    extends DefaultHandler {
        private String location = null;
        private StringBuffer currText = null;

        public String getLocation() {
            return this.location;
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("CreateBucketConfiguration")) {
                // empty if block
            }
            this.currText = new StringBuffer();
        }

        public void endElement(String uri, String name, String qName) {
            String elementText = this.currText.toString();
            if (name.equals("LocationConstraint")) {
                this.location = elementText.length() == 0 ? null : elementText;
            }
        }

        public void characters(char[] ch, int start, int length) {
            this.currText.append(ch, start, length);
        }
    }

    public class BucketLoggingStatusHandler
    extends DefaultHandler {
        private S3BucketLoggingStatus bucketLoggingStatus = null;
        private String targetBucket = null;
        private String targetPrefix = null;
        private StringBuffer currText = null;
        private GranteeInterface currentGrantee = null;
        private Permission currentPermission = null;

        public S3BucketLoggingStatus getBucketLoggingStatus() {
            return this.bucketLoggingStatus;
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("BucketLoggingStatus")) {
                this.bucketLoggingStatus = new S3BucketLoggingStatus();
            }
            this.currText = new StringBuffer();
        }

        public void endElement(String uri, String name, String qName) {
            String elementText = this.currText.toString();
            if (name.equals("TargetBucket")) {
                this.targetBucket = elementText;
            } else if (name.equals("TargetPrefix")) {
                this.targetPrefix = elementText;
            } else if (name.equals("LoggingEnabled")) {
                this.bucketLoggingStatus.setTargetBucketName(this.targetBucket);
                this.bucketLoggingStatus.setLogfilePrefix(this.targetPrefix);
            } else if (name.equals("ID")) {
                this.currentGrantee = new CanonicalGrantee();
                this.currentGrantee.setIdentifier(elementText);
            } else if (name.equals("EmailAddress")) {
                this.currentGrantee = new EmailAddressGrantee();
                this.currentGrantee.setIdentifier(elementText);
            } else if (name.equals("URI")) {
                this.currentGrantee = new GroupGrantee();
                this.currentGrantee.setIdentifier(elementText);
            } else if (name.equals("DisplayName")) {
                ((CanonicalGrantee)this.currentGrantee).setDisplayName(elementText);
            } else if (name.equals("Permission")) {
                this.currentPermission = Permission.parsePermission(elementText);
            } else if (name.equals("Grant")) {
                GrantAndPermission grantAndPermission = new GrantAndPermission(this.currentGrantee, this.currentPermission);
                this.bucketLoggingStatus.addTargetGrant(grantAndPermission);
            }
        }

        public void characters(char[] ch, int start, int length) {
            this.currText.append(ch, start, length);
        }
    }

    public class AccessControlListHandler
    extends DefaultHandler {
        private AccessControlList accessControlList = null;
        private S3Owner owner = null;
        private GranteeInterface currentGrantee = null;
        private Permission currentPermission = null;
        private StringBuffer currText = null;
        private boolean insideACL = false;

        public AccessControlList getAccessControlList() {
            return this.accessControlList;
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("Owner")) {
                this.owner = new S3Owner();
            } else if (name.equals("AccessControlList")) {
                this.accessControlList = new AccessControlList();
                this.accessControlList.setOwner(this.owner);
                this.insideACL = true;
            }
            this.currText = new StringBuffer();
        }

        public void endElement(String uri, String name, String qName) {
            String elementText = this.currText.toString();
            if (name.equals("ID") && !this.insideACL) {
                this.owner.setId(elementText);
            } else if (name.equals("DisplayName") && !this.insideACL) {
                this.owner.setDisplayName(elementText);
            } else if (name.equals("ID")) {
                this.currentGrantee = new CanonicalGrantee();
                this.currentGrantee.setIdentifier(elementText);
            } else if (name.equals("EmailAddress")) {
                this.currentGrantee = new EmailAddressGrantee();
                this.currentGrantee.setIdentifier(elementText);
            } else if (name.equals("URI")) {
                this.currentGrantee = new GroupGrantee();
                this.currentGrantee.setIdentifier(elementText);
            } else if (name.equals("DisplayName")) {
                ((CanonicalGrantee)this.currentGrantee).setDisplayName(elementText);
            } else if (name.equals("Permission")) {
                this.currentPermission = Permission.parsePermission(elementText);
            } else if (name.equals("Grant")) {
                this.accessControlList.grantPermission(this.currentGrantee, this.currentPermission);
            } else if (name.equals("AccessControlList")) {
                this.insideACL = false;
            }
        }

        public void characters(char[] ch, int start, int length) {
            this.currText.append(ch, start, length);
        }
    }

    public class ListAllMyBucketsHandler
    extends DefaultHandler {
        private S3Owner bucketsOwner = null;
        private S3Bucket currentBucket = null;
        private StringBuffer currText = null;
        private List buckets = new ArrayList();

        public S3Bucket[] getBuckets() {
            return this.buckets.toArray(new S3Bucket[this.buckets.size()]);
        }

        public S3Owner getOwner() {
            return this.bucketsOwner;
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("Bucket")) {
                this.currentBucket = new S3Bucket();
            } else if (name.equals("Owner")) {
                this.bucketsOwner = new S3Owner();
            }
            this.currText = new StringBuffer();
        }

        public void endElement(String uri, String name, String qName) {
            String elementText = this.currText.toString();
            if (name.equals("ID")) {
                this.bucketsOwner.setId(elementText);
            } else if (name.equals("DisplayName")) {
                this.bucketsOwner.setDisplayName(elementText);
            } else if (name.equals("Bucket")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Created new bucket from listing: " + this.currentBucket));
                }
                this.currentBucket.setOwner(this.bucketsOwner);
                this.buckets.add(this.currentBucket);
            } else if (name.equals("Name")) {
                this.currentBucket.setName(elementText);
            } else if (name.equals("CreationDate")) {
                elementText = elementText + ".000Z";
                try {
                    this.currentBucket.setCreationDate(ServiceUtils.parseIso8601Date(elementText));
                }
                catch (ParseException e) {
                    throw new RuntimeException("Non-ISO8601 date for CreationDate in list buckets output: " + elementText, e);
                }
            }
        }

        public void characters(char[] ch, int start, int length) {
            this.currText.append(ch, start, length);
        }
    }

    public class ListBucketHandler
    extends DefaultHandler {
        private S3Object currentObject = null;
        private S3Owner currentOwner = null;
        private StringBuffer currText = null;
        private boolean insideCommonPrefixes = false;
        private List objects = new ArrayList();
        private List commonPrefixes = new ArrayList();
        private String bucketName = null;
        private String requestPrefix = null;
        private String requestMarker = null;
        private long requestMaxKeys = 0L;
        private boolean listingTruncated = false;
        private String lastKey = null;
        private String nextMarker = null;

        public String getMarkerForNextListing() {
            if (this.listingTruncated) {
                if (this.nextMarker != null) {
                    return this.nextMarker;
                }
                if (this.lastKey != null) {
                    return this.lastKey;
                }
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Unable to find Next Marker or Last Key for truncated listing");
                }
                return null;
            }
            return null;
        }

        public boolean isListingTruncated() {
            return this.listingTruncated;
        }

        public S3Object[] getObjects() {
            return this.objects.toArray(new S3Object[this.objects.size()]);
        }

        public String[] getCommonPrefixes() {
            return this.commonPrefixes.toArray(new String[this.commonPrefixes.size()]);
        }

        public String getRequestPrefix() {
            return this.requestPrefix;
        }

        public String getRequestMarker() {
            return this.requestMarker;
        }

        public String getNextMarker() {
            return this.nextMarker;
        }

        public long getRequestMaxKeys() {
            return this.requestMaxKeys;
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("Contents")) {
                this.currentObject = new S3Object();
                this.currentObject.setBucketName(this.bucketName);
            } else if (name.equals("Owner")) {
                this.currentOwner = new S3Owner();
                this.currentObject.setOwner(this.currentOwner);
            } else if (name.equals("CommonPrefixes")) {
                this.insideCommonPrefixes = true;
            }
            this.currText = new StringBuffer();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void endElement(String uri, String name, String qName) {
            String elementText = this.currText.toString();
            if (name.equals("Name")) {
                this.bucketName = elementText;
                if (!log.isDebugEnabled()) return;
                log.debug((Object)("Examining listing for bucket: " + this.bucketName));
                return;
            } else if (!this.insideCommonPrefixes && name.equals("Prefix")) {
                this.requestPrefix = elementText;
                return;
            } else if (name.equals("Marker")) {
                this.requestMarker = elementText;
                return;
            } else if (name.equals("NextMarker")) {
                this.nextMarker = elementText;
                return;
            } else if (name.equals("MaxKeys")) {
                this.requestMaxKeys = Long.parseLong(elementText);
                return;
            } else if (name.equals("IsTruncated")) {
                String isTruncatedStr = elementText.toLowerCase(Locale.getDefault());
                if (isTruncatedStr.startsWith("false")) {
                    this.listingTruncated = false;
                    return;
                } else {
                    if (!isTruncatedStr.startsWith("true")) throw new RuntimeException("Invalid value for IsTruncated field: " + isTruncatedStr);
                    this.listingTruncated = true;
                }
                return;
            } else if (name.equals("Contents")) {
                this.objects.add(this.currentObject);
                if (!log.isDebugEnabled()) return;
                log.debug((Object)("Created new S3Object from listing: " + this.currentObject));
                return;
            } else if (name.equals("Key")) {
                this.currentObject.setKey(elementText);
                this.lastKey = elementText;
                return;
            } else if (name.equals("LastModified")) {
                try {
                    this.currentObject.setLastModifiedDate(ServiceUtils.parseIso8601Date(elementText));
                    return;
                }
                catch (ParseException e) {
                    throw new RuntimeException("Non-ISO8601 date for LastModified in bucket's object listing output: " + elementText, e);
                }
            } else if (name.equals("ETag")) {
                this.currentObject.setETag(elementText);
                return;
            } else if (name.equals("Size")) {
                this.currentObject.setContentLength(Long.parseLong(elementText));
                return;
            } else if (name.equals("StorageClass")) {
                this.currentObject.setStorageClass(elementText);
                return;
            } else if (name.equals("ID")) {
                if (this.currentOwner == null) {
                    this.currentOwner = new S3Owner();
                    this.currentObject.setOwner(this.currentOwner);
                }
                this.currentOwner.setId(elementText);
                return;
            } else if (name.equals("DisplayName")) {
                this.currentOwner.setDisplayName(elementText);
                return;
            } else if (this.insideCommonPrefixes && name.equals("Prefix")) {
                this.commonPrefixes.add(elementText);
                return;
            } else {
                if (!name.equals("CommonPrefixes")) return;
                this.insideCommonPrefixes = false;
            }
        }

        public void characters(char[] ch, int start, int length) {
            this.currText.append(ch, start, length);
        }
    }
}

