/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jets3t.service.mx.MxDelegate;

public class S3ServiceException
extends Exception {
    private static final long serialVersionUID = -410679741840406046L;
    private String xmlMessage = null;
    private String s3ErrorCode = null;
    private String s3ErrorMessage = null;
    private String s3ErrorRequestId = null;
    private String s3ErrorHostId = null;
    private Map s3Headers = null;
    private int responseCode = -1;
    private String responseStatus = null;
    private String responseDate = null;
    private String requestVerb = null;
    private String requestPath = null;
    private String requestHost = null;

    public S3ServiceException(String message, String xmlMessage) {
        super(message);
        this.parseS3XmlMessage(xmlMessage);
        MxDelegate.getInstance().registerS3ServiceExceptionEvent(this.getS3ErrorCode());
    }

    public S3ServiceException() {
    }

    public S3ServiceException(String message, Throwable cause) {
        super(message, cause);
    }

    public S3ServiceException(String message) {
        super(message);
    }

    public S3ServiceException(Throwable cause) {
        super(cause);
    }

    public String toString() {
        String myString = super.toString();
        if (this.requestVerb != null) {
            myString = myString + " " + this.requestVerb + " '" + this.requestPath + "'" + (this.requestHost != null ? " on Host '" + this.requestHost + "'" : "") + (this.responseDate != null ? " @ '" + this.responseDate + "'" : "");
        }
        if (this.responseCode != -1) {
            myString = myString + " -- ResponseCode: " + this.responseCode + ", ResponseStatus: " + this.responseStatus;
        }
        if (this.isParsedFromXmlMessage()) {
            myString = myString + ", XML Error Message: " + this.xmlMessage;
        } else if (this.s3ErrorRequestId != null) {
            myString = myString + ", RequestId: " + this.s3ErrorRequestId + ", HostId: " + this.s3ErrorHostId;
        }
        return myString;
    }

    private String findXmlElementText(String xmlMessage, String elementName) {
        Pattern pattern = Pattern.compile(".*<" + elementName + ">(.*)</" + elementName + ">.*");
        Matcher matcher = pattern.matcher(xmlMessage);
        if (matcher.matches() && matcher.groupCount() == 1) {
            return matcher.group(1);
        }
        return null;
    }

    private void parseS3XmlMessage(String xmlMessage) {
        this.xmlMessage = xmlMessage = xmlMessage.replaceAll("\n", "");
        this.s3ErrorCode = this.findXmlElementText(xmlMessage, "Code");
        this.s3ErrorMessage = this.findXmlElementText(xmlMessage, "Message");
        this.s3ErrorRequestId = this.findXmlElementText(xmlMessage, "RequestId");
        this.s3ErrorHostId = this.findXmlElementText(xmlMessage, "HostId");
    }

    public String getS3ErrorCode() {
        return this.s3ErrorCode;
    }

    public String getS3ErrorMessage() {
        return this.s3ErrorMessage;
    }

    public String getS3ErrorHostId() {
        return this.s3ErrorHostId;
    }

    public String getS3ErrorRequestId() {
        return this.s3ErrorRequestId;
    }

    public String getXmlMessage() {
        return this.xmlMessage;
    }

    public boolean isParsedFromXmlMessage() {
        return this.xmlMessage != null;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public String getResponseStatus() {
        return this.responseStatus;
    }

    public void setResponseStatus(String responseStatus) {
        this.responseStatus = responseStatus;
    }

    public String getResponseDate() {
        return this.responseDate;
    }

    public void setResponseDate(String responseDate) {
        this.responseDate = responseDate;
    }

    public String getRequestVerb() {
        return this.requestVerb;
    }

    public void setRequestVerb(String requestVerb) {
        this.requestVerb = requestVerb;
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public void setRequestPath(String requestPath) {
        this.requestPath = requestPath;
    }

    public String getRequestHost() {
        return this.requestHost;
    }

    public void setRequestHost(String requestHost) {
        this.requestHost = requestHost;
    }

    public void setS3RequestAndHostIds(String errorRequestId, String errorHostId) {
        this.s3ErrorRequestId = errorRequestId;
        this.s3ErrorHostId = errorHostId;
    }

    public Map getResponseHeaders() {
        return this.s3Headers;
    }

    public void setResponseHeaders(Map s3Headers) {
        this.s3Headers = s3Headers;
    }
}

