/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.metadata.table.executor;

import com.google.common.base.Optional;
import io.shardingsphere.core.exception.ShardingException;
import io.shardingsphere.core.executor.ShardingExecuteEngine;
import io.shardingsphere.core.metadata.datasource.DataSourceMetaData;
import io.shardingsphere.core.metadata.datasource.ShardingDataSourceMetaData;
import io.shardingsphere.core.metadata.table.TableMetaData;
import io.shardingsphere.core.metadata.table.executor.TableMetaDataConnectionManager;
import io.shardingsphere.core.metadata.table.executor.TableMetaDataLoader;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.core.rule.TableRule;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public final class TableMetaDataInitializer {
    private final ShardingDataSourceMetaData shardingDataSourceMetaData;
    private final TableMetaDataConnectionManager connectionManager;
    private final TableMetaDataLoader tableMetaDataLoader;

    public TableMetaDataInitializer(ShardingDataSourceMetaData shardingDataSourceMetaData, ShardingExecuteEngine executeEngine, TableMetaDataConnectionManager connectionManager, int maxConnectionsSizePerQuery, boolean isCheckingMetaData) {
        this.shardingDataSourceMetaData = shardingDataSourceMetaData;
        this.connectionManager = connectionManager;
        this.tableMetaDataLoader = new TableMetaDataLoader(shardingDataSourceMetaData, executeEngine, connectionManager, maxConnectionsSizePerQuery, isCheckingMetaData);
    }

    public Map<String, TableMetaData> load(ShardingRule shardingRule) {
        HashMap<String, TableMetaData> result = new HashMap<String, TableMetaData>();
        try {
            result.putAll(this.loadShardingTables(shardingRule));
            result.putAll(this.loadDefaultTables(shardingRule));
        }
        catch (SQLException ex) {
            throw new ShardingException(ex);
        }
        return result;
    }

    private Map<String, TableMetaData> loadShardingTables(ShardingRule shardingRule) throws SQLException {
        HashMap<String, TableMetaData> result = new HashMap<String, TableMetaData>(shardingRule.getTableRules().size(), 1.0f);
        for (TableRule each : shardingRule.getTableRules()) {
            result.put(each.getLogicTable(), this.tableMetaDataLoader.load(each.getLogicTable(), shardingRule));
        }
        return result;
    }

    private Map<String, TableMetaData> loadDefaultTables(ShardingRule shardingRule) throws SQLException {
        HashMap<String, TableMetaData> result = new HashMap<String, TableMetaData>(shardingRule.getTableRules().size(), 1.0f);
        Optional<String> actualDefaultDataSourceName = shardingRule.findActualDefaultDataSourceName();
        if (actualDefaultDataSourceName.isPresent()) {
            for (String each : this.getAllTableNames((String)actualDefaultDataSourceName.get())) {
                result.put(each, this.tableMetaDataLoader.load(each, shardingRule));
            }
        }
        return result;
    }

    private Collection<String> getAllTableNames(String dataSourceName) throws SQLException {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        DataSourceMetaData dataSourceMetaData = this.shardingDataSourceMetaData.getActualDataSourceMetaData(dataSourceName);
        String catalog = null == dataSourceMetaData ? null : dataSourceMetaData.getSchemeName();
        try (Connection connection = this.connectionManager.getConnection(dataSourceName);
             ResultSet resultSet = connection.getMetaData().getTables(catalog, null, null, new String[]{"TABLE"});){
            while (resultSet.next()) {
                String tableName = resultSet.getString("TABLE_NAME");
                if (tableName.contains("$")) continue;
                result.add(tableName);
            }
        }
        return result;
    }
}

