/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStorePreEventListener;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.events.PreAddPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreAlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreAlterTableEvent;
import org.apache.hadoop.hive.metastore.events.PreCreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.PreCreateTableEvent;
import org.apache.hadoop.hive.metastore.events.PreDropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.PreDropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreDropTableEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.ql.metadata.AuthorizationException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.security.HiveMetastoreAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveMetastoreAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;

public class AuthorizationPreEventListener
extends MetaStorePreEventListener {
    public static final Log LOG = LogFactory.getLog(AuthorizationPreEventListener.class);
    private static HiveConf conf;
    private static HiveMetastoreAuthorizationProvider authorizer;
    private static HiveMetastoreAuthenticationProvider authenticator;

    public AuthorizationPreEventListener(Configuration config) throws HiveException {
        super(config);
        authenticator = (HiveMetastoreAuthenticationProvider)HiveUtils.getAuthenticator(config, HiveConf.ConfVars.HIVE_METASTORE_AUTHENTICATOR_MANAGER);
        authorizer = (HiveMetastoreAuthorizationProvider)HiveUtils.getAuthorizeProviderManager(config, HiveConf.ConfVars.HIVE_METASTORE_AUTHORIZATION_MANAGER, authenticator);
    }

    public void onEvent(PreEventContext context) throws MetaException, NoSuchObjectException, InvalidOperationException {
        authenticator.setMetaStoreHandler(context.getHandler());
        authorizer.setMetaStoreHandler(context.getHandler());
        switch (context.getEventType()) {
            case CREATE_TABLE: {
                this.authorizeCreateTable((PreCreateTableEvent)context);
                break;
            }
            case DROP_TABLE: {
                this.authorizeDropTable((PreDropTableEvent)context);
                break;
            }
            case ALTER_TABLE: {
                this.authorizeAlterTable((PreAlterTableEvent)context);
                break;
            }
            case ADD_PARTITION: {
                this.authorizeAddPartition((PreAddPartitionEvent)context);
                break;
            }
            case DROP_PARTITION: {
                this.authorizeDropPartition((PreDropPartitionEvent)context);
                break;
            }
            case ALTER_PARTITION: {
                this.authorizeAlterPartition((PreAlterPartitionEvent)context);
                break;
            }
            case CREATE_DATABASE: {
                this.authorizeCreateDatabase((PreCreateDatabaseEvent)context);
                break;
            }
            case DROP_DATABASE: {
                this.authorizeDropDatabase((PreDropDatabaseEvent)context);
                break;
            }
            case LOAD_PARTITION_DONE: {
                break;
            }
        }
    }

    private void authorizeCreateDatabase(PreCreateDatabaseEvent context) throws InvalidOperationException, MetaException {
        try {
            authorizer.authorize(new Database(context.getDatabase()), HiveOperation.CREATEDATABASE.getInputRequiredPrivileges(), HiveOperation.CREATEDATABASE.getOutputRequiredPrivileges());
        }
        catch (AuthorizationException e) {
            throw this.invalidOperationException(e);
        }
        catch (HiveException e) {
            throw this.metaException(e);
        }
    }

    private void authorizeDropDatabase(PreDropDatabaseEvent context) throws InvalidOperationException, MetaException {
        try {
            authorizer.authorize(new Database(context.getDatabase()), HiveOperation.DROPDATABASE.getInputRequiredPrivileges(), HiveOperation.DROPDATABASE.getOutputRequiredPrivileges());
        }
        catch (AuthorizationException e) {
            throw this.invalidOperationException(e);
        }
        catch (HiveException e) {
            throw this.metaException(e);
        }
    }

    private void authorizeCreateTable(PreCreateTableEvent context) throws InvalidOperationException, MetaException {
        try {
            authorizer.authorize(this.getTableFromApiTable(context.getTable()), HiveOperation.CREATETABLE.getInputRequiredPrivileges(), HiveOperation.CREATETABLE.getOutputRequiredPrivileges());
        }
        catch (AuthorizationException e) {
            throw this.invalidOperationException(e);
        }
        catch (HiveException e) {
            throw this.metaException(e);
        }
    }

    private void authorizeDropTable(PreDropTableEvent context) throws InvalidOperationException, MetaException {
        try {
            authorizer.authorize(this.getTableFromApiTable(context.getTable()), HiveOperation.DROPTABLE.getInputRequiredPrivileges(), HiveOperation.DROPTABLE.getOutputRequiredPrivileges());
        }
        catch (AuthorizationException e) {
            throw this.invalidOperationException(e);
        }
        catch (HiveException e) {
            throw this.metaException(e);
        }
    }

    private void authorizeAlterTable(PreAlterTableEvent context) throws InvalidOperationException, MetaException {
        try {
            authorizer.authorize(this.getTableFromApiTable(context.getOldTable()), null, new Privilege[]{Privilege.ALTER_METADATA});
        }
        catch (AuthorizationException e) {
            throw this.invalidOperationException(e);
        }
        catch (HiveException e) {
            throw this.metaException(e);
        }
    }

    private void authorizeAddPartition(PreAddPartitionEvent context) throws InvalidOperationException, MetaException {
        try {
            org.apache.hadoop.hive.metastore.api.Partition mapiPart = context.getPartition();
            authorizer.authorize(this.getPartitionFromApiPartition(mapiPart, (PreEventContext)context), HiveOperation.ALTERTABLE_ADDPARTS.getInputRequiredPrivileges(), HiveOperation.ALTERTABLE_ADDPARTS.getOutputRequiredPrivileges());
        }
        catch (AuthorizationException e) {
            throw this.invalidOperationException(e);
        }
        catch (NoSuchObjectException e) {
            throw this.invalidOperationException((Exception)((Object)e));
        }
        catch (HiveException e) {
            throw this.metaException(e);
        }
    }

    private void authorizeDropPartition(PreDropPartitionEvent context) throws InvalidOperationException, MetaException {
        try {
            org.apache.hadoop.hive.metastore.api.Partition mapiPart = context.getPartition();
            authorizer.authorize(this.getPartitionFromApiPartition(mapiPart, (PreEventContext)context), HiveOperation.ALTERTABLE_DROPPARTS.getInputRequiredPrivileges(), HiveOperation.ALTERTABLE_DROPPARTS.getOutputRequiredPrivileges());
        }
        catch (AuthorizationException e) {
            throw this.invalidOperationException(e);
        }
        catch (NoSuchObjectException e) {
            throw this.invalidOperationException((Exception)((Object)e));
        }
        catch (HiveException e) {
            throw this.metaException(e);
        }
    }

    private void authorizeAlterPartition(PreAlterPartitionEvent context) throws InvalidOperationException, MetaException {
        try {
            org.apache.hadoop.hive.metastore.api.Partition mapiPart = context.getNewPartition();
            authorizer.authorize(this.getPartitionFromApiPartition(mapiPart, (PreEventContext)context), null, new Privilege[]{Privilege.ALTER_METADATA});
        }
        catch (AuthorizationException e) {
            throw this.invalidOperationException(e);
        }
        catch (NoSuchObjectException e) {
            throw this.invalidOperationException((Exception)((Object)e));
        }
        catch (HiveException e) {
            throw this.metaException(e);
        }
    }

    private Table getTableFromApiTable(org.apache.hadoop.hive.metastore.api.Table apiTable) {
        org.apache.hadoop.hive.metastore.api.Table tTable = apiTable.deepCopy();
        if (tTable.getTableType() == null) {
            if (MetaStoreUtils.isExternalTable((org.apache.hadoop.hive.metastore.api.Table)tTable)) {
                tTable.setTableType(TableType.EXTERNAL_TABLE.toString());
            } else if (MetaStoreUtils.isIndexTable((org.apache.hadoop.hive.metastore.api.Table)tTable)) {
                tTable.setTableType(TableType.INDEX_TABLE.toString());
            } else if (tTable.getSd() == null || tTable.getSd().getLocation() == null) {
                tTable.setTableType(TableType.VIRTUAL_VIEW.toString());
            } else {
                tTable.setTableType(TableType.MANAGED_TABLE.toString());
            }
        }
        Table tbl = new Table(tTable);
        return tbl;
    }

    private Partition getPartitionFromApiPartition(org.apache.hadoop.hive.metastore.api.Partition mapiPart, PreEventContext context) throws HiveException, NoSuchObjectException, MetaException {
        org.apache.hadoop.hive.metastore.api.Partition tPart = mapiPart.deepCopy();
        org.apache.hadoop.hive.metastore.api.Table t = context.getHandler().get_table(mapiPart.getDbName(), mapiPart.getTableName());
        if (tPart.getSd() == null) {
            tPart.setSd(t.getSd());
        }
        return new Partition(this.getTableFromApiTable(t), tPart);
    }

    private InvalidOperationException invalidOperationException(Exception e) {
        InvalidOperationException ex = new InvalidOperationException(e.getMessage());
        ex.initCause(e.getCause());
        return ex;
    }

    private MetaException metaException(HiveException e) {
        MetaException ex = new MetaException(e.getMessage());
        ex.initCause((Throwable)e);
        return ex;
    }
}

